#!/usr/bin/Rscript
#library(plotly)
library(RColorBrewer)
features=c('tss', 'h3k27ac', 'h3k4me3', 'polII', 'random')
pdf("Markers.EndDensity.pdf")
par(mar=c(5,5,5,5))
for (i in features)
{
	wt=paste("*WT.", i, "*.profile",sep='')
	ko1=paste("*DNASE1KO.", i,"*.profile",sep='')
	ko1l3=paste("*DNASE1L3KO.", i, "*.profile", sep='')
	WT=Sys.glob(wt)
	KO1=Sys.glob(ko1)
	KO1L3=Sys.glob(ko1l3)
	
	df=read.table(WT[1],header=F)
	plot(df$V2/median(df$V2)~df$V1,type='l',ylab='Normalized end density',xlab='Relative distance (bp)', col='white',main=i,lwd=2,ylim=c(0.5,4))
	m=c()
	for (k in WT)
	{
		df=read.table(k,header=F)
		#lines(df$V2/median(df$V2)~df$V1,col='#27ae60',lwd=1)
		m=cbind(m,df$V2)
	}
	med=apply(m, 1, median)
	lines(seq(-3000,3000),med/median(med),col='#27ae60',lwd=1)

	m=c()
	for (k in KO1)
	{
	        df=read.table(k,header=F)
		m=cbind(m,df$V2)
	        #lines(df$V2/median(df$V2)~df$V1,col='#F88D51',lwd=1)
	}
	med=apply(m, 1, median)
	lines(seq(-3000,3000),med/median(med),col='#3F96B7',lwd=1)
	
	m=c()
	for (k in KO1L3)
	{
		df=read.table(k,header=F)
	        #lines(df$V2/median(df$V2)~df$V1,col='#3F96B7',lwd=1)
		m=cbind(m,df$V2)
	}
	med=apply(m, 1, median)
	lines(seq(-3000,3000),med/median(med),col='#DC494C',lwd=1)

	#legend("topright",inset=c(-0.3,0),legend=c("WT","1KO","1L3KO","DFFBKO"),col=c('#27ae60','#F88D51','#DC494C','#3F96B7'),bty='n',lty=1)
	legend("topright",inset=c(-0.25,0),legend=c("WT","1KO","1L3KO"),col=c('#27ae60','#3F96B7','#DC494C'),bty='n',lty=1)
	
	df=read.table(WT[1],header=F)
	plot(df$V2/median(df$V2)~df$V1,type='l',ylab='Normalized end density (%)',xlab='Relative distance (bp)', col='white',main=i,lwd=2,xlim=c(-1000,1000),ylim=c(0.5,4))
	m=c()
	for (k in WT)
	{
		df=read.table(k,header=F)
		#lines(df$V2/median(df$V2)~df$V1,col='#27ae60',lwd=1)
		m=cbind(m,df$V2)
	}
	med=apply(m, 1, median)
	lines(seq(-3000,3000),med/median(med),col='#27ae60',lwd=1)

	m=c()
	for (k in KO1)
	{
	        df=read.table(k,header=F)
		m=cbind(m,df$V2)
	        #lines(df$V2/median(df$V2)~df$V1,col='#F88D51',lwd=1)
	}
	med=apply(m, 1, median)
	lines(seq(-3000,3000),med/median(med),col='#3F96B7',lwd=1)

	m=c()
	for (k in KO1L3)
	{
		df=read.table(k,header=F)
	        #lines(df$V2/median(df$V2)~df$V1,col='#3F96B7',lwd=1)
		m=cbind(m,df$V2)
	}
	med=apply(m, 1, median)
	lines(seq(-3000,3000),med/median(med),col='#DC494C',lwd=1)
	legend("topright",inset=c(-0.25,0),legend=c("WT","1KO","1L3KO"),col=c('#27ae60','#3F96B7','#DC494C'),bty='n',lty=1)

}
dev.off()
