#!/usr/bin/perl

############################################################
##                                                        ##
##           dS_dN_MNG_COMP.PL                            ##
##                                                        ##
##                       Programmed by MASAFUMI NOZAWA    ##
##                       Last Modified on 2010.4.24       ##
##                                                        ##
############################################################

if ($#ARGV<4)
{
	print "\n";
	print "This program estimates dS and dN for particular window size and sliding size by using modified Nei-Gojobori (Zhang et al 1998) method.\n";
	print "input file name (fasta file)\nwindow size (no of codons)\nsliding size (no of codons)\ntransition/transversion ratio (if you want to compute the values from actual data, please type n/a)\noutput file name\n";
	exit;
}

open(IN,"<$ARGV[0]")||die;
open(OUT,">$ARGV[4]")||die;

#define various parameters
$w_size=$ARGV[1];
$s_size=$ARGV[2];

print(OUT "modified Nei-Gojobori (Zhang et al 1998 PNAS) method was used for estimation\n");
print(OUT "Jukes-Cantor (1969) method was used for correction for multiple hits\n");
print(OUT "input_file\t");
print(OUT "$ARGV[0]\n");
print(OUT "window_size\t");
print(OUT "$ARGV[1]\n");
print(OUT "sliding_size\t");
print(OUT "$ARGV[2]\n");
print(OUT "transition/transversion ratio\t");
print(OUT "$ARGV[3]\n");
print(OUT "output_file\t");
print(OUT "$ARGV[4]\n");



#making codon table
@codons=(["TTT","TTC","TTA","TTG"],
		["TCT","TCC","TCA","TCG"],
		["TAT","TAC","TAA","TAG"],
		["TGT","TGC","TGA","TGG"],
		["CTT","CTC","CTA","CTG"],
		["CCT","CCC","CCA","CCG"],
		["CAT","CAC","CAA","CAG"],
		["CGT","CGC","CGA","CGG"],
		["ATT","ATC","ATA","ATG"],
		["ACT","ACC","ACA","ACG"],
		["AAT","AAC","AAA","AAG"],
		["AGT","AGC","AGA","AGG"],
		["GTT","GTC","GTA","GTG"],
		["GCT","GCC","GCA","GCG"],
		["GAT","GAC","GAA","GAG"],
		["GGT","GGC","GGA","GGG"],);

@aminos=(["Phe","Phe","Leu","Leu"],
		["Ser","Ser","Ser","Ser"],
		["Tyr","Tyr","Stop","Stop"],
		["Cys","Cys","Stop","Trp"],
		["Leu","Leu","Leu","Leu"],
		["Pro","Pro","Pro","Pro"],
		["His","His","Gln","Gln"],
		["Arg","Arg","Arg","Arg"],
		["Ile","Ile","Ile","Met"],
		["Thr","Thr","Thr","Thr"],
		["Asn","Asn","Lys","Lys"],
		["Ser","Ser","Arg","Arg"],
		["Val","Val","Val","Val"],
		["Ala","Ala","Ala","Ala"],
		["Asp","Asp","Glu","Glu"],
		["Gly","Gly","Gly","Gly"],);

$y=0;
while($line=<IN>){
	chomp($line);
	$name[$y]=substr($line,1,length($line)-1);
	
	$line=<IN>;
	chomp($line);
	$len=length($line)/3;
	$amari=length($line)%3;
	
	if($amari>0){
		print("sequence length is not a multiple of 3!\n");
		die;
	}else{
		#complete deletion option (add $temp_seq)
		$temp_seq[$y]=$line;
		for($i=0;$i<$len;$i++){
			$codon=substr($line,0,3);
			$sequence0[$y][$i]=$codon;
			$line=substr($line,3,length($line)-3);
		}
	}
	$y++;
}

#complete deletion option
$k=0;
for($i=0;$i<$len;$i++){
	$gap=0;
	for($j=0;$j<$y;$j++){
		if($sequence0[$j][$i]=~/[-BDHKMRSVWYN?]/i){
			$gap++;
		}
	}
	if($gap>0){
		$eliminate[$k]=$i;
		$k++;
	}
}
for($k=$#eliminate;$k>=0;$k--){
	for($j=0;$j<$y;$j++){
		substr($temp_seq[$j],$eliminate[$k]*3,3,'');
	}
}

$len=length($temp_seq[0])/3;
for($i=0;$i<$y;$i++){
	for($j=0;$j<$len;$j++){
		$codon=substr($temp_seq[$i],0,3);
		$sequence[$i][$j]=$codon;
		substr($temp_seq[$i],0,3,'');
	}
}

print(OUT "start\t");
print(OUT "end (R for overall)\t");
print(OUT "S\t");
print(OUT "N\t");
print(OUT "s\t");
print(OUT "n\t");
print(OUT "pS\t");
print(OUT "pN\t");
print(OUT "dS\t");
print(OUT "dN\n");

for($a=0;$a<$y;$a++){
	for($b=$a+1;$b<$y;$b++){
		#output two sequences for comparison
		@pre1=();
		@pre2=();
		for($i=0;$i<$len;$i++){
			$pre1[$i]=$sequence[$a][$i];
			$pre2[$i]=$sequence[$b][$i];
		}
		#output for entire sequence
		@seq1=@pre1;
		@seq2=@pre2;
		
		#computing Ti/Tv
		$Ti=0;
		$Tv=0;
		$num1=0;
		$num2=0;
		@comp1=();
		@comp2=();
		for($i=0;$i<$len;$i++){
			if(($seq1[$i]=~/[-BDHKMRSVWYN?]/i) or ($seq2[$i]=~/[-BDHKMRSVWYN?]/i)){
				#nothing to do
			}elsif(($seq1[$i] eq "TGA") or ($seq2[$i] eq "TGA")){
				#nothing to do
			}elsif(($seq1[$i] eq "TAG") or ($seq2[$i] eq "TAG")){
				#nothing to do
			}elsif(($seq1[$i] eq "TAA") or ($seq2[$i] eq "TAA")){
				#nothing to do
			}else{
				for($j=0;$j<16;$j++){
					for($k=0;$k<4;$k++){
						if($seq1[$i] eq $codons[$j][$k]){
							$comp1[$num1]=$codons[$j][$k];
							$amino1[$num1]=$aminos[$j][$k];
							@e_codon1=split(//,$comp1[$num1]);
							$num1++;
						}
						if($seq2[$i] eq $codons[$j][$k]){
							$comp2[$num2]=$codons[$j][$k];
							$amino2[$num2]=$aminos[$j][$k];
							@e_codon2=split(//,$comp2[$num2]);
							$num2++;
						}
					}
				}
				
				for($j=0;$j<3;$j++){
					if($e_codon1[$j] ne $e_codon2[$j]){
						if($e_codon1[$j] eq "A"){
							if($e_codon2[$j] eq "G"){
								$Ti++;
							}else{
								$Tv++;
							}
						}elsif($e_codon1[$j] eq "G"){
							if($e_codon2[$j] eq "A"){
								$Ti++;
							}else{
								$Tv++;
							}
						}elsif($e_codon1[$j] eq "T"){
							if($e_codon2[$j] eq "C"){
								$Ti++;
							}else{
								$Tv++;
							}
						}elsif($e_codon1[$j] eq "C"){
							if($e_codon2[$j] eq "T"){
								$Ti++;
							}else{
								$Tv++;
							}
						}
					}
				}
			}
		}
		
		$Ti=$Ti/(3*$num1);
		$Tv=$Tv/(3*$num1);
		
		if($ARGV[3] eq 'n/a'){
			$ratio=(-(1/2)*log(1-2*$Ti-$Tv)+(1/4)*log(1-2*$Tv))/(-(1/2)*log(1-2*$Tv));
		}else{
			$ratio=$ARGV[3];
		}
		$rTi=$ratio/(1+$ratio);
		$rspe=2*$ratio/(2*$ratio+1);
		$rTv=1/(2*(1+$ratio));
		$rspe2=1/(1+2*$ratio);
		
		#computing S and N
		$S1=0;
		$N1=0;
		$S2=0;
		$N2=0;
		for($i=0;$i<$num1;$i++){
			if($comp1[$i] eq "TTT"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "TTC"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "TTA"){
				$S1=$S1+2*$rTi;
				$N1=$N1+(3-2*$rTi);
			}elsif($comp1[$i] eq "TTG"){
				$S1=$S1+2*$rTi;
				$N1=$N1+(3-2*$rTi);
			}elsif($comp1[$i] eq "TCT"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "TCC"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "TCA"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "TCG"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "TAT"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "TAC"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "TGT"){
				$S1=$S1+$rspe;
				$N1=$N1+(3-$rspe);
			}elsif($comp1[$i] eq "TGC"){
				$S1=$S1+$rspe;
				$N1=$N1+(3-$rspe);
			}elsif($comp1[$i] eq "TGG"){
				$S1=$S1;
				$N1=$N1+3;
			}elsif($comp1[$i] eq "CTT"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "CTC"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "CTA"){
				$S1=$S1+1+$rTi;
				$N1=$N1+2-$rTi;
			}elsif($comp1[$i] eq "CTG"){
				$S1=$S1+1+$rTi;
				$N1=$N1+2-$rTi;
			}elsif($comp1[$i] eq "CCT"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "CCC"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "CCA"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "CCG"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "CAT"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "CAC"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "CAA"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "CAG"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "CGT"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "CGC"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "CGA"){
				$S1=$S1+3/2;
				$N1=$N1+3/2;
			}elsif($comp1[$i] eq "CGG"){
				$S1=$S1+1+$rTv;
				$N1=$N1+2-$rTv;
			}elsif($comp1[$i] eq "ATT"){
				$S1=$S1+$rTi+$rTv;
				$N1=$N1+(3-$rTi-$rTv);
			}elsif($comp1[$i] eq "ATC"){
				$S1=$S1+$rTi+$rTv;
				$N1=$N1+(3-$rTi-$rTv);
			}elsif($comp1[$i] eq "ATA"){
				$S1=$S1+$rTv+$rTv;
				$N1=$N1+(3-$rTv-$rTv);
			}elsif($comp1[$i] eq "ATG"){
				$S1=$S1;
				$N1=$N1+3;
			}elsif($comp1[$i] eq "ACT"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "ACC"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "ACA"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "ACG"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "AAT"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "AAC"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "AAA"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "AAG"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "AGT"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "AGC"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "AGA"){
				$S1=$S1+$rTi+$rspe2;
				$N1=$N1+(3-$rTi-$rspe2);
			}elsif($comp1[$i] eq "AGG"){
				$S1=$S1+$rTi+$rTv;
				$N1=$N1+(3-$rTi-$rTv);
			}elsif($comp1[$i] eq "GTT"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "GTC"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "GTA"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "GTG"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "GCT"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "GCC"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "GCA"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "GCG"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "GAT"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "GAC"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "GAA"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "GAG"){
				$S1=$S1+$rTi;
				$N1=$N1+(3-$rTi);
			}elsif($comp1[$i] eq "GGT"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "GGC"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "GGA"){
				$S1=$S1+1;
				$N1=$N1+2;
			}elsif($comp1[$i] eq "GGG"){
				$S1=$S1+1;
				$N1=$N1+2;
			}
			
			if($comp2[$i] eq "TTT"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "TTC"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "TTA"){
				$S2=$S2+2*$rTi;
				$N2=$N2+(3-2*$rTi);
			}elsif($comp2[$i] eq "TTG"){
				$S2=$S2+2*$rTi;
				$N2=$N2+(3-2*$rTi);
			}elsif($comp2[$i] eq "TCT"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "TCC"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "TCA"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "TCG"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "TAT"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "TAC"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "TGT"){
				$S2=$S2+$rspe;
				$N2=$N2+(3-$rspe);
			}elsif($comp2[$i] eq "TGC"){
				$S2=$S2+$rspe;
				$N2=$N2+(3-$rspe);
			}elsif($comp2[$i] eq "TGG"){
				$S2=$S2;
				$N2=$N2+3;
			}elsif($comp2[$i] eq "CTT"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "CTC"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "CTA"){
				$S2=$S2+1+$rTi;
				$N2=$N2+2-$rTi;
			}elsif($comp2[$i] eq "CTG"){
				$S2=$S2+1+$rTi;
				$N2=$N2+2-$rTi;
			}elsif($comp2[$i] eq "CCT"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "CCC"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "CCA"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "CCG"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "CAT"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "CAC"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "CAA"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "CAG"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "CGT"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "CGC"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "CGA"){
				$S2=$S2+3/2;
				$N2=$N2+3/2;
			}elsif($comp2[$i] eq "CGG"){
				$S2=$S2+1+$rTv;
				$N2=$N2+2-$rTv;
			}elsif($comp2[$i] eq "ATT"){
				$S2=$S2+$rTi+$rTv;
				$N2=$N2+(3-$rTi-$rTv);
			}elsif($comp2[$i] eq "ATC"){
				$S2=$S2+$rTi+$rTv;
				$N2=$N2+(3-$rTi-$rTv);
			}elsif($comp2[$i] eq "ATA"){
				$S2=$S2+$rTv+$rTv;
				$N2=$N2+(3-$rTv-$rTv);
			}elsif($comp2[$i] eq "ATG"){
				$S2=$S2;
				$N2=$N2+3;
			}elsif($comp2[$i] eq "ACT"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "ACC"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "ACA"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "ACG"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "AAT"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "AAC"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "AAA"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "AAG"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "AGT"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "AGC"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "AGA"){
				$S2=$S2+$rTi+$rspe2;
				$N2=$N2+(3-$rTi-$rspe2);
			}elsif($comp2[$i] eq "AGG"){
				$S2=$S2+$rTi+$rTv;
				$N2=$N2+(3-$rTi-$rTv);
			}elsif($comp2[$i] eq "GTT"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "GTC"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "GTA"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "GTG"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "GCT"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "GCC"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "GCA"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "GCG"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "GAT"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "GAC"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "GAA"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "GAG"){
				$S2=$S2+$rTi;
				$N2=$N2+(3-$rTi);
			}elsif($comp2[$i] eq "GGT"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "GGC"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "GGA"){
				$S2=$S2+1;
				$N2=$N2+2;
			}elsif($comp2[$i] eq "GGG"){
				$S2=$S2+1;
				$N2=$N2+2;
			}
		}		
		$S=($S1+$S2)/2;
		$N=($N1+$N2)/2;
		
		print("$name[$a] vs $name[$b]\n");
		print(OUT "$name[$a] vs $name[$b]\n");
		print("Overall\t");
		print(OUT "Overall\t");
		print(OUT "$ratio\t");
		print("$S\t");
		print("$N\t");
		print(OUT "$S\t");
		print(OUT "$N\t");
		
		#computing s and n
		$syn=0;
		$non=0;
		for($i=0;$i<$num1;$i++){
			if($comp1[$i] eq $comp2[$i]){
				#nothing to do
			}else{
				$counter=0;
				@site1=split(//,$comp1[$i]);
				@site2=split(//,$comp2[$i]);
				for($j=0;$j<3;$j++){
					if($site1[$j] ne $site2[$j]){
						$counter++;
					}
				}
				
				if($counter==1){
					if($amino1[$i] eq $amino2[$i]){
						$syn++;
					}else{
						$non++;
					}
				}elsif($counter==2){
					$s_path=0;
					$n_path=0;
					$path=0;
					if($site1[0] ne $site2[0]){
						$newcodon=$site2[0].$site1[1].$site1[2];
						for($j=0;$j<16;$j++){
							for($k=0;$k<4;$k++){
								if($newcodon eq $codons[$j][$k]){
									$newamino=$aminos[$j][$k];
								}
							}
						}
						if($newamino ne "Stop"){
							$path++;
							if(($amino1[$i] eq $newamino) and ($amino2[$i] eq $newamino)){
								$s_path=$s_path+2;
							}elsif(($amino1[$i] ne $newamino) and ($amino2[$i] eq $newamino)){
								$s_path++;
								$n_path++;
							}elsif(($amino1[$i] eq $newamino) and ($amino2[$i] ne $newamino)){
								$s_path++;
								$n_path++;
							}else{
								$n_path=$n_path+2;
							}
						}
					}
					if($site1[1] ne $site2[1]){
						$newcodon=$site1[0].$site2[1].$site1[2];
						for($j=0;$j<16;$j++){
							for($k=0;$k<4;$k++){
								if($newcodon eq $codons[$j][$k]){
									$newamino=$aminos[$j][$k];
								}
							}
						}
						if($newamino ne "Stop"){
							$path++;
							if(($amino1[$i] eq $newamino) and ($amino2[$i] eq $newamino)){
								$s_path=$s_path+2;
							}elsif(($amino1[$i] ne $newamino) and ($amino2[$i] eq $newamino)){
								$s_path++;
								$n_path++;
							}elsif(($amino1[$i] eq $newamino) and ($amino2[$i] ne $newamino)){
								$s_path++;
								$n_path++;
							}else{
								$n_path=$n_path+2;
							}
						}
					}
					if($site1[2] ne $site2[2]){
						$newcodon=$site1[0].$site1[1].$site2[2];
						for($j=0;$j<16;$j++){
							for($k=0;$k<4;$k++){
								if($newcodon eq $codons[$j][$k]){
									$newamino=$aminos[$j][$k];
								}
							}
						}
						if($newamino ne "Stop"){
							$path++;
							if(($amino1[$i] eq $newamino) and ($amino2[$i] eq $newamino)){
								$s_path=$s_path+2;
							}elsif(($amino1[$i] ne $newamino) and ($amino2[$i] eq $newamino)){
								$s_path++;
								$n_path++;
							}elsif(($amino1[$i] eq $newamino) and ($amino2[$i] ne $newamino)){
								$s_path++;
								$n_path++;
							}else{
								$n_path=$n_path+2;
							}
						}
					}
					$syn=$syn+$s_path/$path;
					$non=$non+$n_path/$path;
				}elsif($counter==3){
					$s_path=0;
					$n_path=0;
					$path=0;
					$newcodon1=$site1[0].$site1[1].$site2[2];
					$newcodon2=$site1[0].$site2[1].$site1[2];
					$newcodon3=$site2[0].$site1[1].$site1[2];
					$newcodon4=$site1[0].$site2[1].$site2[2];
					$newcodon5=$site2[0].$site1[1].$site2[2];
					$newcodon6=$site2[0].$site2[1].$site1[2];
					for($j=0;$j<16;$j++){
						for($k=0;$k<4;$k++){
							if($newcodon1 eq $codons[$j][$k]){
								$newamino1=$aminos[$j][$k];
							}
							if($newcodon2 eq $codons[$j][$k]){
								$newamino2=$aminos[$j][$k];
							}
							if($newcodon3 eq $codons[$j][$k]){
								$newamino3=$aminos[$j][$k];
							}
							if($newcodon4 eq $codons[$j][$k]){
								$newamino4=$aminos[$j][$k];
							}
							if($newcodon5 eq $codons[$j][$k]){
								$newamino5=$aminos[$j][$k];
							}
							if($newcodon6 eq $codons[$j][$k]){
								$newamino6=$aminos[$j][$k];
							}
						}
					}
					if($newamino1 ne "Stop"){
						if($newamino4 ne "Stop"){
							$path++;
							if($amino1[$i] eq $newamino1){
								$s_path++;
							}else{
								$n_path++;
							}
							if($newamino1 eq $newamino4){
								$s_path++;
							}else{
								$n_path++;
							}
							if($newamino4 eq $amino2[$i]){
								$s_path++;
							}else{
								$n_path++;
							}
						}
						if($newamino5 ne "Stop"){
							$path++;
							if($amino1[$i] eq $newamino1){
								$s_path++;
							}else{
								$n_path++;
							}
							if($newamino1 eq $newamino5){
								$s_path++;
							}else{
								$n_path++;
							}
							if($newamino5 eq $amino2[$i]){
								$s_path++;
							}else{
								$n_path++;
							}
						}
					}
					if($newamino2 ne "Stop"){
						if($newamino4 ne "Stop"){
							$path++;
							if($amino1[$i] eq $newamino2){
								$s_path++;
							}else{
								$n_path++;
							}
							if($newamino2 eq $newamino4){
								$s_path++;
							}else{
								$n_path++;
							}
							if($newamino4 eq $amino2[$i]){
								$s_path++;
							}else{
								$n_path++;
							}
						}
						if($newamino6 ne "Stop"){
							$path++;
							if($amino1[$i] eq $newamino2){
								$s_path++;
							}else{
								$n_path++;
							}
							if($newamino2 eq $newamino6){
								$s_path++;
							}else{
								$n_path++;
							}
							if($newamino6 eq $amino2[$i]){
								$s_path++;
							}else{
								$n_path++;
							}
						}
					}
					if($newamino3 ne "Stop"){
						if($newamino5 ne "Stop"){
							$path++;
							if($amino1[$i] eq $newamino3){
								$s_path++;
							}else{
								$n_path++;
							}
							if($newamino3 eq $newamino5){
								$s_path++;
							}else{
								$n_path++;
							}
							if($newamino5 eq $amino2[$i]){
								$s_path++;
							}else{
								$n_path++;
							}
						}
						if($newamino6 ne "Stop"){
							$path++;
							if($amino1[$i] eq $newamino3){
								$s_path++;
							}else{
								$n_path++;
							}
							if($newamino3 eq $newamino6){
								$s_path++;
							}else{
								$n_path++;
							}
							if($newamino6 eq $amino2[$i]){
								$s_path++;
							}else{
								$n_path++;
							}
						}
					}
					$syn=$syn+$s_path/$path;
					$non=$non+$n_path/$path;
				}
			}
		}
		print("$syn\t");
		print("$non\t");
		print(OUT "$syn\t");
		print(OUT "$non\t");
		
		if($S==0){
			$pS="N/A";
		}else{
			$pS=$syn/$S;
		}
		if($N==0){
			$pN="N/A";
		}else{
			$pN=$non/$N;
		}
		
		if(($pS>=0.75)||($pS eq "N/A")){
			$dS="N/A";
		}else{
			$dS=-(3/4)*log(1-(4/3)*$pS);
		}
		if(($pN>=0.75)||($pN eq "N/A")){
			$dN="N/A";
		}else{
			$dN=-(3/4)*log(1-(4/3)*$pN);
		}
		
		print("$pS\t");
		print("$pN\t");
		print("$dS\t");
		print("$dN\n");
		print(OUT "$pS\t");
		print(OUT "$pN\t");
		print(OUT "$dS\t");
		print(OUT "$dN\n");
		
		
		#repeating computation for each window and sliding size
		$repeat=0;
		for($x=0;($x<$len) and ($repeat==0);$x=$x+$s_size){
			@copy_seq1=@pre1;
			@copy_seq2=@pre2;
			@seq1=splice(@copy_seq1,$x,$w_size);
			@seq2=splice(@copy_seq2,$x,$w_size);
			
			#computing S and N
			$S1=0;
			$N1=0;
			$S2=0;
			$N2=0;
			$num1=0;
			$num2=0;
			@comp1=();
			@comp2=();
			for($i=0;$i<$w_size;$i++){
				if(($seq1[$i]=~/[-BDHKMRSVWYN?]/i) or ($seq2[$i]=~/[-BDHKMRSVWYN?]/i)){
					#nothing to do
				}elsif(($seq1[$i] eq "TGA") or ($seq2[$i] eq "TGA")){
					#nothing to do
				}elsif(($seq1[$i] eq "TAG") or ($seq2[$i] eq "TAG")){
					#nothing to do
				}elsif(($seq1[$i] eq "TAA") or ($seq2[$i] eq "TAA")){
					#nothing to do
				}else{
					for($j=0;$j<16;$j++){
						for($k=0;$k<4;$k++){
							if($seq1[$i] eq $codons[$j][$k]){
								$comp1[$num1]=$codons[$j][$k];
								$amino1[$num1]=$aminos[$j][$k];
								$num1++;
							}
							if($seq2[$i] eq $codons[$j][$k]){
								$comp2[$num2]=$codons[$j][$k];
								$amino2[$num2]=$aminos[$j][$k];
								$num2++;
							}
						}
					}
				}
			}
			
			
			for($i=0;$i<$num1;$i++){
				if($comp1[$i] eq "TTT"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "TTC"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "TTA"){
					$S1=$S1+2*$rTi;
					$N1=$N1+(3-2*$rTi);
				}elsif($comp1[$i] eq "TTG"){
					$S1=$S1+2*$rTi;
					$N1=$N1+(3-2*$rTi);
				}elsif($comp1[$i] eq "TCT"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "TCC"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "TCA"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "TCG"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "TAT"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "TAC"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "TGT"){
					$S2=$S2+$rspe;
					$N2=$N2+(3-$rspe);
				}elsif($comp1[$i] eq "TGC"){
					$S2=$S2+$rspe;
					$N2=$N2+(3-$rspe);
				}elsif($comp1[$i] eq "TGG"){
					$S1=$S1;
					$N1=$N1+3;
				}elsif($comp1[$i] eq "CTT"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "CTC"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "CTA"){
					$S1=$S1+1+$rTi;
					$N1=$N1+2-$rTi;
				}elsif($comp1[$i] eq "CTG"){
					$S1=$S1+1+$rTi;
					$N1=$N1+2-$rTi;
				}elsif($comp1[$i] eq "CCT"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "CCC"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "CCA"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "CCG"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "CAT"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "CAC"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "CAA"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "CAG"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "CGT"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "CGC"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "CGA"){
					$S1=$S1+3/2;
					$N1=$N1+3/2;
				}elsif($comp1[$i] eq "CGG"){
					$S1=$S1+1+$rTv;
					$N1=$N1+2-$rTv;
				}elsif($comp1[$i] eq "ATT"){
					$S1=$S1+$rTi+$rTv;
					$N1=$N1+(3-$rTi-$rTv);
				}elsif($comp1[$i] eq "ATC"){
					$S1=$S1+$rTi+$rTv;
					$N1=$N1+(3-$rTi-$rTv);
				}elsif($comp1[$i] eq "ATA"){
					$S1=$S1+$rTv+$rTv;
					$N1=$N1+(3-$rTv-$rTv);
				}elsif($comp1[$i] eq "ATG"){
					$S1=$S1;
					$N1=$N1+3;
				}elsif($comp1[$i] eq "ACT"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "ACC"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "ACA"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "ACG"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "AAT"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "AAC"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "AAA"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "AAG"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "AGT"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "AGC"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "AGA"){
					$S1=$S1+$rTi+$rspe2;
					$N1=$N1+(3-$rTi-$rspe2);
				}elsif($comp1[$i] eq "AGG"){
					$S1=$S1+$rTi+$rTv;
					$N1=$N1+(3-$rTi-$rTv);
				}elsif($comp1[$i] eq "GTT"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "GTC"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "GTA"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "GTG"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "GCT"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "GCC"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "GCA"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "GCG"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "GAT"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "GAC"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "GAA"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "GAG"){
					$S1=$S1+$rTi;
					$N1=$N1+(3-$rTi);
				}elsif($comp1[$i] eq "GGT"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "GGC"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "GGA"){
					$S1=$S1+1;
					$N1=$N1+2;
				}elsif($comp1[$i] eq "GGG"){
					$S1=$S1+1;
					$N1=$N1+2;
				}
				
				if($comp2[$i] eq "TTT"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "TTC"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "TTA"){
					$S2=$S2+2*$rTi;
					$N2=$N2+(3-2*$rTi);
				}elsif($comp2[$i] eq "TTG"){
					$S2=$S2+2*$rTi;
					$N2=$N2+(3-2*$rTi);
				}elsif($comp2[$i] eq "TCT"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "TCC"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "TCA"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "TCG"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "TAT"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "TAC"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "TGT"){
					$S2=$S2+$rspe;
					$N2=$N2+(3-$rspe);
				}elsif($comp2[$i] eq "TGC"){
					$S2=$S2+$rspe;
					$N2=$N2+(3-$rspe);
				}elsif($comp2[$i] eq "TGG"){
					$S2=$S2;
					$N2=$N2+3;
				}elsif($comp2[$i] eq "CTT"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "CTC"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "CTA"){
					$S2=$S2+1+$rTi;
					$N2=$N2+2-$rTi;
				}elsif($comp2[$i] eq "CTG"){
					$S2=$S2+1+$rTi;
					$N2=$N2+2-$rTi;
				}elsif($comp2[$i] eq "CCT"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "CCC"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "CCA"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "CCG"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "CAT"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "CAC"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "CAA"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "CAG"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "CGT"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "CGC"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "CGA"){
					$S2=$S2+3/2;
					$N2=$N2+3/2;
				}elsif($comp2[$i] eq "CGG"){
					$S2=$S2+1+$rTv;
					$N2=$N2+2-$rTv;
				}elsif($comp2[$i] eq "ATT"){
					$S2=$S2+$rTi+$rTv;
					$N2=$N2+(3-$rTi-$rTv);
				}elsif($comp2[$i] eq "ATC"){
					$S2=$S2+$rTi+$rTv;
					$N2=$N2+(3-$rTi-$rTv);
				}elsif($comp2[$i] eq "ATA"){
					$S2=$S2+$rTv+$rTv;
					$N2=$N2+(3-$rTv-$rTv);
				}elsif($comp2[$i] eq "ATG"){
					$S2=$S2;
					$N2=$N2+3;
				}elsif($comp2[$i] eq "ACT"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "ACC"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "ACA"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "ACG"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "AAT"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "AAC"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "AAA"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "AAG"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "AGT"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "AGC"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "AGA"){
					$S2=$S2+$rTi+$rspe2;
					$N2=$N2+(3-$rTi-$rspe2);
				}elsif($comp2[$i] eq "AGG"){
					$S2=$S2+$rTi+$rTv;
					$N2=$N2+(3-$rTi-$rTv);
				}elsif($comp2[$i] eq "GTT"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "GTC"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "GTA"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "GTG"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "GCT"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "GCC"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "GCA"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "GCG"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "GAT"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "GAC"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "GAA"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "GAG"){
					$S2=$S2+$rTi;
					$N2=$N2+(3-$rTi);
				}elsif($comp2[$i] eq "GGT"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "GGC"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "GGA"){
					$S2=$S2+1;
					$N2=$N2+2;
				}elsif($comp2[$i] eq "GGG"){
					$S2=$S2+1;
					$N2=$N2+2;
				}
			}
			
			$S=($S1+$S2)/2;
			$N=($N1+$N2)/2;
			$start=$x+1;
			$end=$x+$w_size;
			if($end>$len){
				print("$start-$len\t");
				print(OUT "$start\t");
				print(OUT "$len\t");
				$repeat++;
			}else{
				print("$start-$end\t");
				print(OUT "$start\t");
				print(OUT "$end\t");
			}
			print("$S\t");
			print("$N\t");
			print(OUT "$S\t");
			print(OUT "$N\t");
			
			#computing s and n
			$syn=0;
			$non=0;
			for($i=0;$i<$num1;$i++){
				if($comp1[$i] eq $comp2[$i]){
					#nothing to do
				}else{
					$counter=0;
					@site1=split(//,$comp1[$i]);
					@site2=split(//,$comp2[$i]);
					for($j=0;$j<3;$j++){
						if($site1[$j] ne $site2[$j]){
							$counter++;
						}
					}
					
					if($counter==1){
						if($amino1[$i] eq $amino2[$i]){
							$syn++;
						}else{
							$non++;
						}
					}elsif($counter==2){
						$s_path=0;
						$n_path=0;
						$path=0;
						if($site1[0] ne $site2[0]){
							$newcodon=$site2[0].$site1[1].$site1[2];
							for($j=0;$j<16;$j++){
								for($k=0;$k<4;$k++){
									if($newcodon eq $codons[$j][$k]){
										$newamino=$aminos[$j][$k];
									}
								}
							}
							if($newamino ne "Stop"){
								$path++;
								if(($amino1[$i] eq $newamino) and ($amino2[$i] eq $newamino)){
									$s_path=$s_path+2;
								}elsif(($amino1[$i] ne $newamino) and ($amino2[$i] eq $newamino)){
									$s_path++;
									$n_path++;
								}elsif(($amino1[$i] eq $newamino) and ($amino2[$i] ne $newamino)){
									$s_path++;
									$n_path++;
								}else{
									$n_path=$n_path+2;
								}
							}
						}
						if($site1[1] ne $site2[1]){
							$newcodon=$site1[0].$site2[1].$site1[2];
							for($j=0;$j<16;$j++){
								for($k=0;$k<4;$k++){
									if($newcodon eq $codons[$j][$k]){
										$newamino=$aminos[$j][$k];
									}
								}
							}
							if($newamino ne "Stop"){
								$path++;
								if(($amino1[$i] eq $newamino) and ($amino2[$i] eq $newamino)){
									$s_path=$s_path+2;
								}elsif(($amino1[$i] ne $newamino) and ($amino2[$i] eq $newamino)){
									$s_path++;
									$n_path++;
								}elsif(($amino1[$i] eq $newamino) and ($amino2[$i] ne $newamino)){
									$s_path++;
									$n_path++;
								}else{
									$n_path=$n_path+2;
								}
							}
						}
						if($site1[2] ne $site2[2]){
							$newcodon=$site1[0].$site1[1].$site2[2];
							for($j=0;$j<16;$j++){
								for($k=0;$k<4;$k++){
									if($newcodon eq $codons[$j][$k]){
										$newamino=$aminos[$j][$k];
									}
								}
							}
							if($newamino ne "Stop"){
								$path++;
								if(($amino1[$i] eq $newamino) and ($amino2[$i] eq $newamino)){
									$s_path=$s_path+2;
								}elsif(($amino1[$i] ne $newamino) and ($amino2[$i] eq $newamino)){
									$s_path++;
									$n_path++;
								}elsif(($amino1[$i] eq $newamino) and ($amino2[$i] ne $newamino)){
									$s_path++;
									$n_path++;
								}else{
									$n_path=$n_path+2;
								}
							}
						}
						$syn=$syn+$s_path/$path;
						$non=$non+$n_path/$path;
					}elsif($counter==3){
						$s_path=0;
						$n_path=0;
						$path=0;
						$newcodon1=$site1[0].$site1[1].$site2[2];
						$newcodon2=$site1[0].$site2[1].$site1[2];
						$newcodon3=$site2[0].$site1[1].$site1[2];
						$newcodon4=$site1[0].$site2[1].$site2[2];
						$newcodon5=$site2[0].$site1[1].$site2[2];
						$newcodon6=$site2[0].$site2[1].$site1[2];
						for($j=0;$j<16;$j++){
							for($k=0;$k<4;$k++){
								if($newcodon1 eq $codons[$j][$k]){
									$newamino1=$aminos[$j][$k];
								}
								if($newcodon2 eq $codons[$j][$k]){
									$newamino2=$aminos[$j][$k];
								}
								if($newcodon3 eq $codons[$j][$k]){
									$newamino3=$aminos[$j][$k];
								}
								if($newcodon4 eq $codons[$j][$k]){
									$newamino4=$aminos[$j][$k];
								}
								if($newcodon5 eq $codons[$j][$k]){
									$newamino5=$aminos[$j][$k];
								}
								if($newcodon6 eq $codons[$j][$k]){
									$newamino6=$aminos[$j][$k];
								}
							}
						}
						if($newamino1 ne "Stop"){
							if($newamino4 ne "Stop"){
								$path++;
								if($amino1[$i] eq $newamino1){
									$s_path++;
								}else{
									$n_path++;
								}
								if($newamino1 eq $newamino4){
									$s_path++;
								}else{
									$n_path++;
								}
								if($newamino4 eq $amino2[$i]){
									$s_path++;
								}else{
									$n_path++;
								}
							}
							if($newamino5 ne "Stop"){
								$path++;
								if($amino1[$i] eq $newamino1){
									$s_path++;
								}else{
									$n_path++;
								}
								if($newamino1 eq $newamino5){
									$s_path++;
								}else{
									$n_path++;
								}
								if($newamino5 eq $amino2[$i]){
									$s_path++;
								}else{
									$n_path++;
								}
							}
						}
						if($newamino2 ne "Stop"){
							if($newamino4 ne "Stop"){
								$path++;
								if($amino1[$i] eq $newamino2){
									$s_path++;
								}else{
									$n_path++;
								}
								if($newamino2 eq $newamino4){
									$s_path++;
								}else{
									$n_path++;
								}
								if($newamino4 eq $amino2[$i]){
									$s_path++;
								}else{
									$n_path++;
								}
							}
							if($newamino6 ne "Stop"){
								$path++;
								if($amino1[$i] eq $newamino2){
									$s_path++;
								}else{
									$n_path++;
								}
								if($newamino2 eq $newamino6){
									$s_path++;
								}else{
									$n_path++;
								}
								if($newamino6 eq $amino2[$i]){
									$s_path++;
								}else{
									$n_path++;
								}
							}
						}
						if($newamino3 ne "Stop"){
							if($newamino5 ne "Stop"){
								$path++;
								if($amino1[$i] eq $newamino3){
									$s_path++;
								}else{
									$n_path++;
								}
								if($newamino3 eq $newamino5){
									$s_path++;
								}else{
									$n_path++;
								}
								if($newamino5 eq $amino2[$i]){
									$s_path++;
								}else{
									$n_path++;
								}
							}
							if($newamino6 ne "Stop"){
								$path++;
								if($amino1[$i] eq $newamino3){
									$s_path++;
								}else{
									$n_path++;
								}
								if($newamino3 eq $newamino6){
									$s_path++;
								}else{
									$n_path++;
								}
								if($newamino6 eq $amino2[$i]){
									$s_path++;
								}else{
									$n_path++;
								}
							}
						}
						$syn=$syn+$s_path/$path;
						$non=$non+$n_path/$path;
					}
				}
			}
			print("$syn\t");
			print("$non\t");
			print(OUT "$syn\t");
			print(OUT "$non\t");
			
			if($S==0){
				$pS="N/A";
			}else{
				$pS=$syn/$S;
			}
			if($N==0){
				$pN="N/A";
			}else{
				$pN=$non/$N;
			}
			
			if(($pS>=0.75)||($pS eq "N/A")){
				$dS="N/A";
			}else{
				$dS=-(3/4)*log(1-(4/3)*$pS);
			}
			if(($pN>=0.75)||($pN eq "N/A")){
				$dN="N/A";
			}else{
				$dN=-(3/4)*log(1-(4/3)*$pN);
			}
			
			print("$pS\t");
			print("$pN\t");
			print("$dS\t");
			print("$dN\n");
			print(OUT "$pS\t");
			print(OUT "$pN\t");
			print(OUT "$dS\t");
			print(OUT "$dN\n");
		}
	}
}


close(IN);
close(OUT);
