(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[  11540125,     265011]
NotebookOptionsPosition[  11475848,     264109]
NotebookOutlinePosition[  11476244,     264125]
CellTagsIndexPosition[  11476201,     264122]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"CloseKernels", "[", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"LaunchKernels", "[", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ParallelEvaluate", "[", 
   RowBox[{"$HistoryLength", "=", "0"}], "]"}], ";"}]}], "Code",
 CellOpen->False,
 CellChangeTimes->{{3.79907324162568*^9, 3.7990732636734743`*^9}},
 CellLabel->
  "In[980]:=",ExpressionUUID->"a9bd7e64-082b-445e-b022-7fc38ce228f8"],

Cell[CellGroupData[{

Cell["Deconvolution via Approximate Maximum Likelihood", "Title",
 CellChangeTimes->{{3.778685207477799*^9, 
  3.778685218212371*^9}},ExpressionUUID->"0b2dc98d-10bd-424d-9c1a-\
bb6a2ddb3f23"],

Cell[CellGroupData[{

Cell["Notation", "Section",
 CellChangeTimes->{{3.778680501557022*^9, 3.778680508916416*^9}, {
  3.778680550887125*^9, 
  3.7786805519508553`*^9}},ExpressionUUID->"5b303b7c-2d5b-4463-9506-\
86e77fd5514c"],

Cell[TextData[{
 "G, K \[Element] \[DoubleStruckCapitalN]        \t\[LongDash] Number of \
genes/cell types\n\[CapitalPhi], \[Sigma] \[Element] ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[DoubleStruckCapitalR]", "+", 
    RowBox[{"G", "\[Cross]", "K"}]], TraditionalForm]],ExpressionUUID->
  "513f83c8-8f48-444a-8472-3d788754a1d4"],
 "  \t\[LongDash] Matrix of single cell means/variances\n\[CapitalPsi] \
\[Element] ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[DoubleStruckCapitalR]", "+", "G"], TraditionalForm]],
  ExpressionUUID->"232d57e1-cb23-4acf-9ff0-d1589ede3247"],
 " \t\t\[LongDash] Bulk means\n\[Alpha] \[Element] ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[CapitalDelta]", 
    RowBox[{"K", "-", "1"}]], TraditionalForm]],ExpressionUUID->
  "c20b94bd-a976-4bd5-94b0-b8a95874e136"],
 " \t\t\[LongDash] Convex weights\nn \[Element] \[DoubleStruckCapitalN] \t\t\
\[LongDash] Number of cells in the bulk sample\nm \[Element] ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalN]", "K"], TraditionalForm]],
  ExpressionUUID->"09ab4344-0e5c-4fde-854c-5249d1bfb9a5"],
 " \t\t\[LongDash] Number of cells  for each cell type in the single cell \
reference"
}], "Text",
 CellChangeTimes->{{3.778680556094595*^9, 3.778681044160285*^9}, {
   3.778681129821177*^9, 3.778681150469039*^9}, 3.799071819436206*^9},
 FontSize->24,ExpressionUUID->"5e5fa437-d041-4cab-a13c-4b714862ede0"]
}, Closed]],

Cell[CellGroupData[{

Cell["General Functions", "Section",
 CellChangeTimes->{{3.778680522307151*^9, 
  3.778680527066062*^9}},ExpressionUUID->"db10e38f-8df0-4d38-a53c-\
e154b70df6d4"],

Cell["\<\
mixture\[Sigma] \t\t\[LongDash] Variances of an \[Alpha]-mixture of \
distributions with means \[CapitalPhi] and variances \[Sigma]
\[CapitalPhi]Vars, \[Alpha]Vars \t\[LongDash] Dummy variables used for \
optimization
row\[ScriptCapitalL]\t\t\[LongDash] Contribution to likelihood of a single \
row
\[ScriptCapitalL] \t\t\t\[LongDash] Full Likelihood\
\>", "Text",
 CellChangeTimes->{{3.778681117949567*^9, 3.778681125053982*^9}, {
  3.778681159828272*^9, 3.778681222343514*^9}, {3.778681352316319*^9, 
  3.778681375308099*^9}, {3.778687116413371*^9, 3.778687125212599*^9}, {
  3.778687163246545*^9, 3.778687189957816*^9}, {3.7786959090176697`*^9, 
  3.778695912639902*^9}, {3.799071833563279*^9, 3.799071835715159*^9}},
 FontSize->24,ExpressionUUID->"6e87390c-03b9-42a2-b875-d9666563a9c7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mixture\[Sigma]", "[", 
   RowBox[{"\[Alpha]List_", ",", "\[Sigma]Row_", ",", "\[CapitalPhi]Row_"}], 
   "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[CapitalPhi]Row", "^", "2"}], "+", "\[Sigma]Row"}], ")"}], 
    ".", "\[Alpha]List"}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[CapitalPhi]Row", ".", "\[Alpha]List"}], ")"}], "^", 
    "2"}]}]}]], "Input",
 CellChangeTimes->{{3.774292419301866*^9, 3.774292467134284*^9}, {
  3.774292503507938*^9, 3.7742925171999903`*^9}, {3.774882741763587*^9, 
  3.7748827497351227`*^9}},
 CellLabel->
  "In[332]:=",ExpressionUUID->"b058d031-fbf8-4e72-aef7-febad349f378"],

Cell[BoxData[
 RowBox[{
  RowBox[{"weightedNorm", "[", 
   RowBox[{"vector_", ",", "weights_", ",", 
    RowBox[{"p_", ":", "2"}]}], "]"}], ":=", 
  RowBox[{"Total", "[", 
   RowBox[{
    RowBox[{"vector", "^", "p"}], "*", "weights"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.774895753299765*^9, 3.774895827020718*^9}},
 CellLabel->
  "In[333]:=",ExpressionUUID->"077e9691-77af-46ac-b425-7587f814ed71"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mMatrix", "[", 
   RowBox[{"mList_", ",", "G_"}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"G", ">", "1"}], ",", 
    RowBox[{"ConstantArray", "[", 
     RowBox[{"mList", ",", "G"}], "]"}], ",", "mList"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7763550052682247`*^9, 3.776355033362445*^9}, {
  3.776355069358244*^9, 3.77635507543067*^9}, {3.7763551232359343`*^9, 
  3.7763551306359587`*^9}, {3.776355166876595*^9, 3.7763551767378798`*^9}},
 CellLabel->
  "In[334]:=",ExpressionUUID->"06edb1f7-21c8-4fa3-804a-b85c9bafec1d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalL]", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[CapitalPhi]Observed_", ",", 
    "\[CapitalPsi]Observed_", ",", "\[Alpha]_", ",", "\[Sigma]_", ",", "n_", 
    ",", "mList_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"mMatrix", "[", 
        RowBox[{"mList", ",", 
         RowBox[{"Length", "@", "\[CapitalPhi]"}]}], "]"}], "/", "\[Sigma]"}],
       "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[CapitalPhi]", "-", "\[CapitalPhi]Observed"}], ")"}], "^", 
       "2"}]}], ",", "2"}], "]"}], "+", 
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{"n", "/", 
      RowBox[{"(", 
       RowBox[{"mixture\[Sigma]", "[", 
        RowBox[{"\[Alpha]", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], "]"}], 
       ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[CapitalPhi]", ".", "\[Alpha]"}], "-", 
        RowBox[{"\[CapitalPsi]Observed", "/", "n"}]}], ")"}], "^", "2"}]}], 
    "]"}], "+", 
   RowBox[{"Total", "@", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"mixture\[Sigma]", "[", 
       RowBox[{"\[Alpha]", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], "]"}], 
      "*", "n"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.774358976720429*^9, 3.7743592320312233`*^9}, {
  3.774359348227819*^9, 3.774359353600545*^9}, {3.774364796737521*^9, 
  3.774364830636157*^9}, {3.774794189698153*^9, 3.774794190178678*^9}, {
  3.77479423483923*^9, 3.774794248583542*^9}, {3.774837351090826*^9, 
  3.774837373413278*^9}, {3.7748779715796223`*^9, 3.77487797328189*^9}, {
  3.774897213114142*^9, 3.774897213557425*^9}, {3.775058630941451*^9, 
  3.775058644713599*^9}, {3.7750749628163643`*^9, 3.775074963150375*^9}, {
  3.775075020215116*^9, 3.7750750317485647`*^9}, {3.776355495262821*^9, 
  3.776355519325243*^9}, {3.778686294019061*^9, 3.778686295000313*^9}, {
  3.7786863270836*^9, 3.778686334024538*^9}, {3.796482877686385*^9, 
  3.796482877940153*^9}},
 CellLabel->
  "In[335]:=",ExpressionUUID->"0f957c1a-f97f-4518-bf45-5b652caaf137"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalL]Joint", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[CapitalPhi]Observed_", ",", 
    "\[CapitalPsi]sObserved_", ",", "\[Alpha]s_", ",", "\[Sigma]_", ",", 
    "ns_", ",", "mList_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"mMatrix", "[", 
        RowBox[{"mList", ",", 
         RowBox[{"Length", "@", "\[CapitalPhi]"}]}], "]"}], "/", "\[Sigma]"}],
       "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[CapitalPhi]", "-", "\[CapitalPhi]Observed"}], ")"}], "^", 
       "2"}]}], ",", "2"}], "]"}], "+", 
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{"MapThread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#1", "/", 
           RowBox[{"(", 
            RowBox[{"mixture\[Sigma]", "[", 
             RowBox[{"#2", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], "]"}], 
            ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[CapitalPhi]", ".", "#2"}], "-", 
             RowBox[{"#3", "/", "#1"}]}], ")"}], "^", "2"}]}], ")"}], "&"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"ns", ",", 
         RowBox[{"Transpose", "@", "\[Alpha]s"}], ",", 
         RowBox[{"Transpose", "@", "\[CapitalPsi]sObserved"}]}], "}"}]}], 
      "]"}], ",", "2"}], "]"}], "+", 
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{"MapThread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"mixture\[Sigma]", "[", 
           RowBox[{"#2", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], "]"}], "*", 
          "#1"}], "]"}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"ns", ",", 
         RowBox[{"Transpose", "@", "\[Alpha]s"}], ",", 
         RowBox[{"Transpose", "@", "\[CapitalPsi]sObserved"}]}], "}"}]}], 
      "]"}], ",", "2"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.774358976720429*^9, 3.7743592320312233`*^9}, {
  3.774359348227819*^9, 3.774359353600545*^9}, {3.774364796737521*^9, 
  3.774364830636157*^9}, {3.774794189698153*^9, 3.774794190178678*^9}, {
  3.77479423483923*^9, 3.774794248583542*^9}, {3.774837351090826*^9, 
  3.774837373413278*^9}, {3.7748779715796223`*^9, 3.77487797328189*^9}, {
  3.774897213114142*^9, 3.774897213557425*^9}, {3.775058630941451*^9, 
  3.775058644713599*^9}, {3.7750749628163643`*^9, 3.775074963150375*^9}, {
  3.775075020215116*^9, 3.7750750317485647`*^9}, {3.776355495262821*^9, 
  3.776355519325243*^9}, {3.778686294019061*^9, 3.778686295000313*^9}, {
  3.7786863270836*^9, 3.778686334024538*^9}, {3.796482877686385*^9, 
  3.796482877940153*^9}, {3.825893500328381*^9, 3.825893511752383*^9}, {
  3.825893559517289*^9, 3.825893673838806*^9}, {3.825939710832714*^9, 
  3.825939763990089*^9}},
 CellLabel->
  "In[336]:=",ExpressionUUID->"c4a62f6a-3855-4939-9efc-9a9f3f7841cd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"row\[ScriptCapitalL]", "[", 
   RowBox[{
   "\[CapitalPhi]Row_", ",", "\[CapitalPhi]ObservedRow_", ",", 
    "\[CapitalPsi]ObservedScalar_", ",", "\[Alpha]_", ",", "\[Sigma]Row_", 
    ",", "n_", ",", "mList_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{"mList", "/", "\[Sigma]Row"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[CapitalPhi]Row", "-", "\[CapitalPhi]ObservedRow"}], ")"}], 
      "^", "2"}]}], "]"}], "+", 
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{"n", "/", 
      RowBox[{"(", 
       RowBox[{"mixture\[Sigma]", "[", 
        RowBox[{"\[Alpha]", ",", "\[Sigma]Row", ",", "\[CapitalPhi]Row"}], 
        "]"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[CapitalPhi]Row", ".", "\[Alpha]"}], "-", 
        RowBox[{"\[CapitalPsi]ObservedScalar", "/", "n"}]}], ")"}], "^", 
      "2"}]}], "]"}], "+", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"mixture\[Sigma]", "[", 
      RowBox[{"\[Alpha]", ",", "\[Sigma]Row", ",", "\[CapitalPhi]Row"}], 
      "]"}], "*", "n"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7743617531094027`*^9, 3.774361776276017*^9}, {
  3.774361978468546*^9, 3.774362028469179*^9}, {3.774364901550743*^9, 
  3.774364920316621*^9}, {3.774837778172319*^9, 3.7748377783705597`*^9}, {
  3.774877995450655*^9, 3.7748779971966667`*^9}, {3.774897440668819*^9, 
  3.774897441028846*^9}, {3.776356135887683*^9, 3.7763561623507*^9}, {
  3.778686446442306*^9, 3.778686450829138*^9}, {3.796482950502595*^9, 
  3.796482950949131*^9}},
 CellLabel->
  "In[337]:=",ExpressionUUID->"78388c9a-94c0-4120-acbb-a4110177dfa7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"row\[ScriptCapitalL]Joint", "[", 
   RowBox[{
   "\[CapitalPhi]Row_", ",", "\[CapitalPhi]ObservedRow_", ",", 
    "\[CapitalPsi]ObservedScalars_", ",", "\[Alpha]s_", ",", "\[Sigma]Row_", 
    ",", "ns_", ",", "mList_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{"mList", "/", "\[Sigma]Row"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[CapitalPhi]Row", "-", "\[CapitalPhi]ObservedRow"}], ")"}], 
      "^", "2"}]}], "]"}], "+", 
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{"MapThread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#1", "/", 
          RowBox[{"(", 
           RowBox[{"mixture\[Sigma]", "[", 
            RowBox[{"#2", ",", "\[Sigma]Row", ",", "\[CapitalPhi]Row"}], 
            "]"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[CapitalPhi]Row", ".", "#2"}], "-", 
            RowBox[{"#3", "/", "#1"}]}], ")"}], "^", "2"}]}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"ns", ",", 
         RowBox[{"Transpose", "@", "\[Alpha]s"}], ",", 
         "\[CapitalPsi]ObservedScalars"}], "}"}]}], "]"}], ",", "2"}], "]"}], 
   "+", 
   RowBox[{"Total", "[", 
    RowBox[{"MapThread", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{
         RowBox[{"mixture\[Sigma]", "[", 
          RowBox[{"#2", ",", "\[Sigma]Row", ",", "\[CapitalPhi]Row"}], "]"}], 
         "*", "#1"}], "]"}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"ns", ",", 
        RowBox[{"Transpose", "@", "\[Alpha]s"}]}], "}"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7743617531094027`*^9, 3.774361776276017*^9}, {
  3.774361978468546*^9, 3.774362028469179*^9}, {3.774364901550743*^9, 
  3.774364920316621*^9}, {3.774837778172319*^9, 3.7748377783705597`*^9}, {
  3.774877995450655*^9, 3.7748779971966667`*^9}, {3.774897440668819*^9, 
  3.774897441028846*^9}, {3.776356135887683*^9, 3.7763561623507*^9}, {
  3.778686446442306*^9, 3.778686450829138*^9}, {3.796482950502595*^9, 
  3.796482950949131*^9}, {3.825939419772642*^9, 3.825939489871299*^9}, {
  3.8259395390088453`*^9, 3.825939634370461*^9}},
 CellLabel->
  "In[338]:=",ExpressionUUID->"7e11a3df-8922-4df1-b1a6-754aace4cc13"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalPhi]Vars", "[", "k_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[Phi]", "}"}], ",", 
    RowBox[{"Array", "[", 
     RowBox[{"\[Phi]", ",", "k"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7742916903547277`*^9, 3.774291724321458*^9}, {
  3.774292782559822*^9, 3.774292787084351*^9}, {3.7786997704704657`*^9, 
  3.778699789715942*^9}, {3.77869988919011*^9, 3.778699892171031*^9}},
 CellLabel->
  "In[339]:=",ExpressionUUID->"71b2d437-07f7-4fcc-8685-d96b448a52f9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]Vars", "[", "k_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[Alpha]", "}"}], ",", 
    RowBox[{"Array", "[", 
     RowBox[{"\[Alpha]", ",", "k"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.774883391259046*^9, 3.774883397425707*^9}, {
  3.774903182093865*^9, 3.7749031837397747`*^9}, {3.778699636004582*^9, 
  3.778699738373247*^9}, {3.778699897845487*^9, 3.7786999006189127`*^9}},
 CellLabel->
  "In[340]:=",ExpressionUUID->"553a7ccd-3cdf-4604-b1dc-287754f1ce69"]
}, Closed]],

Cell[CellGroupData[{

Cell["Updates (1)", "Section",
 CellChangeTimes->{{3.778681405579625*^9, 3.778681408514648*^9}, {
  3.7786825565564003`*^9, 
  3.77868255724652*^9}},ExpressionUUID->"043ce3a2-d0e7-452e-b5a6-\
7fa2be093095"],

Cell["\<\
min\[CapitalPhi]Row \t\[LongDash] Optimize one row of \[CapitalPhi] for fixed \
\[Alpha], mixture\[Sigma]
min\[CapitalPhi] \t\t\[LongDash] Iterate min\[CapitalPhi]Row over rows
min\[Alpha] \t\t\[LongDash] W-NNLS for fixed \[CapitalPhi], mixture\[Sigma]
min\[Alpha]Helper \t\[LongDash] Iterate min\[Alpha] until convergence (\
\[CurlyEpsilon]) or maxIter times
alternate \t\t\[LongDash] Alternate min\[CapitalPhi] and min\[Alpha] until \
convergence (\[Delta]) or maxIter times\
\>", "Text",
 CellChangeTimes->{{3.778681412817276*^9, 3.778681416756061*^9}, {
   3.778681571552198*^9, 3.778681613370295*^9}, {3.778682351431459*^9, 
   3.778682482316618*^9}, {3.7786830245344276`*^9, 3.778683117751337*^9}, 
   3.799071852131011*^9},
 FontSize->24,ExpressionUUID->"01580cd0-5fdc-42bc-acbb-6e2b1d9b0d5d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"nUpdate", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[Alpha]_", ",", "\[CapitalPsi]_", ",", 
    "\[Sigma]_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"G", "=", 
       RowBox[{"Length", "@", "\[CapitalPsi]"}]}], ",", 
      RowBox[{"A", "=", 
       RowBox[{"weightedNorm", "[", 
        RowBox[{
         RowBox[{"\[CapitalPhi]", ".", "\[Alpha]"}], ",", 
         RowBox[{"1", "/", 
          RowBox[{"mixture\[Sigma]", "[", 
           RowBox[{"\[Alpha]", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], 
           "]"}]}]}], "]"}]}], ",", 
      RowBox[{"C", "=", 
       RowBox[{"weightedNorm", "[", 
        RowBox[{"\[CapitalPsi]", ",", 
         RowBox[{"1", "/", 
          RowBox[{"mixture\[Sigma]", "[", 
           RowBox[{"\[Alpha]", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], 
           "]"}]}]}], "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "G"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "A"}], ")"}]}], "+", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"G", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", 
          RowBox[{"A", "^", "2"}]}], ")"}]}], "+", 
       RowBox[{"C", "/", "A"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.774896551027577*^9, 3.774896670734481*^9}, {
  3.774899574496557*^9, 3.774899587453405*^9}, {3.796484175735936*^9, 
  3.796484258958723*^9}, {3.7964843123866653`*^9, 3.796484333280261*^9}, {
  3.796484370199829*^9, 3.796484415990046*^9}, {3.7964874343360977`*^9, 
  3.796487439183584*^9}, {3.796487552457458*^9, 3.7964875553450947`*^9}, {
  3.796493436247794*^9, 3.7964934467816153`*^9}},
 CellLabel->
  "In[341]:=",ExpressionUUID->"a9a0cb24-d1bc-4944-bced-81589847b64a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"min\[CapitalPhi]Row", "[", 
   RowBox[{
   "\[CapitalPhi]Vars_", ",", "\[CapitalPhi]Pre_", ",", 
    "\[CapitalPsi]Scalar_", ",", "\[CapitalPhi]observedRow_", ",", 
    "\[Sigma]Row_", ",", "\[Alpha]List_", ",", "n_", ",", "mList_"}], "]"}], ":=", 
  RowBox[{"QuadraticOptimization", "[", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"mList", "/", "\[Sigma]Row"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[CapitalPhi]observedRow", "-", "\[CapitalPhi]Vars"}], 
         ")"}], "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"mixture\[Sigma]", "[", 
          RowBox[{
          "\[Alpha]List", ",", "\[Sigma]Row", ",", "\[CapitalPhi]Pre"}], 
          "]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[CapitalPhi]Vars", ".", "\[Alpha]List"}], "-", 
          RowBox[{"\[CapitalPsi]Scalar", "/", "n"}]}], ")"}], "^", "2"}]}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"Thread", "[", 
      RowBox[{"\[CapitalPhi]Vars", "\[GreaterEqual]", "0"}], "]"}], "}"}], 
    ",", "\[CapitalPhi]Vars"}], "]"}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAGIQ3cN4dcljuTeObC9/g2kzlaI1IFrL8g2YPlPA/hhE
uxlnvALR7nLTPoNoJRXfbyDa6Y/eHxC9IfkQ0xMg7We2QRxEu7W8kwLRS/o8
FUH0smMJaiB6wrNqLRD9uEBZF0SL5eQZg+i+J4VmIHqTkpk9iC553OwKovfd
sPAG0eaXTgWB9assjwfRf1Q4k0H0IvekdBBdcK8uC0THyPrngehPtzLBdKjI
l3oQvXl5ajOI7tr0qAtEB7/m7gfRbOWLp4Hoaeofp4Po/FVzJjwF0t+9304G
0RGafwPfyb9xfFTOGwSiWYq8JJgUgP583ACmd3LF+XMDafHrWWD6EfOGVl4g
vd10N5g+qM3ZBaJv7RYH09ek5v24rAQMn+TXP0E0AHh3v7Y=
  "],
 CellLabel->
  "In[342]:=",ExpressionUUID->"a19d3f11-06e2-482a-bbee-25e6c9e30885"],

Cell[BoxData[
 RowBox[{
  RowBox[{"min\[CapitalPhi]", "[", 
   RowBox[{
   "\[CapitalPhi]Vars_", ",", "\[CapitalPhi]Pre_", ",", "\[CapitalPsi]Vec_", 
    ",", "\[CapitalPhi]MatrixObserved_", ",", "\[Sigma]Matrix_", ",", 
    "\[Alpha]List_", ",", "n_", ",", "mList_"}], "]"}], ":=", 
  RowBox[{"Parallelize", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"\[CapitalPhi]Vars", "/.", 
        RowBox[{"min\[CapitalPhi]Row", "[", 
         RowBox[{"\[CapitalPhi]Vars", ",", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", 
          RowBox[{"#2", "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", 
          RowBox[{"#3", "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", 
          RowBox[{"#4", "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "\[Alpha]List", ",", "n", ",",
           "mList"}], "]"}]}], "&"}], "@@", 
      RowBox[{"{", 
       RowBox[{
       "\[CapitalPhi]Pre", ",", "\[CapitalPsi]Vec", ",", 
        "\[CapitalPhi]MatrixObserved", ",", "\[Sigma]Matrix"}], "}"}]}], ",", 
     
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", 
       RowBox[{"Length", "@", "\[CapitalPsi]Vec"}]}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7748374816574*^9, 3.774837521244328*^9}, {
  3.77483762918524*^9, 3.7748376335358047`*^9}, {3.774896844802033*^9, 
  3.774896845167614*^9}, {3.774897291984787*^9, 3.774897292173604*^9}, {
  3.7763563280472813`*^9, 3.776356332564581*^9}, {3.7965020907292013`*^9, 
  3.7965020955196943`*^9}},
 CellLabel->
  "In[343]:=",ExpressionUUID->"3b0ce731-238f-40b6-a0fa-212dd0a92938"],

Cell[BoxData[
 RowBox[{
  RowBox[{"min\[Alpha]", "[", 
   RowBox[{
   "\[Alpha]Vars_", ",", "\[Alpha]Pre_", ",", "\[Sigma]Matrix_", ",", 
    "\[CapitalPhi]Matrix_", ",", "\[CapitalPsi]Vector_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"\[Alpha]Vars", "/.", 
   RowBox[{"QuadraticOptimization", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "/", 
        RowBox[{"mixture\[Sigma]", "[", 
         RowBox[{
         "\[Alpha]Pre", ",", "\[Sigma]Matrix", ",", "\[CapitalPhi]Matrix"}], 
         "]"}]}], ")"}], ".", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[CapitalPhi]Matrix", ".", "\[Alpha]Vars"}], "-", 
         RowBox[{"\[CapitalPsi]Vector", "/", "n"}]}], ")"}], "^", "2"}]}], 
     ",", 
     RowBox[{
      RowBox[{"Thread", "[", 
       RowBox[{"\[Alpha]Vars", "\[GreaterEqual]", "0"}], "]"}], "~", "Join", 
      "~", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Total", "[", "\[Alpha]Vars", "]"}], "\[Equal]", "1"}], 
       "}"}]}], ",", "\[Alpha]Vars"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.777225289794664*^9, 3.777225469083433*^9}, {
   3.777225508932805*^9, 3.777225543786137*^9}, 3.7786957244421053`*^9, {
   3.796484526987924*^9, 3.796484529634119*^9}, {3.796484564656518*^9, 
   3.79648456485669*^9}, {3.7964847107418756`*^9, 3.796484722204586*^9}},
 CellLabel->
  "In[344]:=",ExpressionUUID->"ceee1672-b68b-4f4c-b516-4a193dd4c135"],

Cell[BoxData[
 RowBox[{
  RowBox[{"min\[Alpha]LSHelper", "[", 
   RowBox[{
   "\[Alpha]Vars_", ",", "\[Alpha]Pre_", ",", "\[Sigma]Matrix_", ",", 
    "\[CapitalPhi]Matrix_", ",", "\[CapitalPsi]Vector_", ",", "n_", ",", 
    "\[CurlyEpsilon]_", ",", "maxIter_"}], "]"}], ":=", 
  RowBox[{"NestWhile", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"min\[Alpha]", "[", 
      RowBox[{
      "\[Alpha]Vars", ",", "#", ",", "\[Sigma]Matrix", ",", 
       "\[CapitalPhi]Matrix", ",", "\[CapitalPsi]Vector", ",", "n"}], "]"}], 
     "&"}], ",", "\[Alpha]Pre", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{
        RowBox[{"#1", "-", "#2"}], ",", "2"}], "]"}], ">", 
      "\[CurlyEpsilon]"}], "&"}], ",", "2", ",", "maxIter"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.774294857589836*^9, 3.774294864098996*^9}, {
   3.77429509991539*^9, 3.77429511588262*^9}, {3.774295213424584*^9, 
   3.7742953189660273`*^9}, {3.774295419892336*^9, 3.774295421417144*^9}, {
   3.774295466702552*^9, 3.774295607727091*^9}, {3.77429564709407*^9, 
   3.774295652801567*^9}, {3.774295755657164*^9, 3.774295781823442*^9}, {
   3.774296201516027*^9, 3.774296229237475*^9}, {3.774837415981896*^9, 
   3.7748374163881617`*^9}, {3.774877920364835*^9, 3.774877923626841*^9}, {
   3.774896854889585*^9, 3.774896855263582*^9}, {3.7753177532437277`*^9, 
   3.775317856588174*^9}, 3.775322480101653*^9, {3.777235684330975*^9, 
   3.777235684638644*^9}, {3.777253708904933*^9, 3.777253709006507*^9}, {
   3.777256126736528*^9, 3.777256127494803*^9}, {3.777323411349327*^9, 
   3.777323411507218*^9}, {3.777332602701811*^9, 3.777332603051189*^9}, {
   3.777839158895421*^9, 3.7778391589895077`*^9}, {3.777839604746818*^9, 
   3.7778396050806713`*^9}, 3.778695727849609*^9},
 CellLabel->
  "In[345]:=",ExpressionUUID->"0484b74b-b3db-4a2a-b0c1-e8476724dc3e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"alternate", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[CapitalPsi]_", ",", "\[Sigma]_", ",", 
    "\[CurlyEpsilon]_", ",", "maxIter_", ",", "\[Delta]_", ",", "mList_"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Alpha]Next", ",", "\[Alpha]Past", ",", "\[CapitalPhi]Past", ",", 
      "\[CapitalPhi]Next", ",", "nPast", ",", "nNext", ",", "\[Alpha]List", 
      ",", "\[ScriptCapitalL]Past", ",", "\[ScriptCapitalL]Next", ",", 
      "\[ScriptCapitalL]List", ",", "nList", ",", 
      RowBox[{"iter", "=", "1"}], ",", 
      RowBox[{"k", "=", 
       RowBox[{"Length", "[", 
        RowBox[{"First", "@", "\[CapitalPhi]"}], "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[CapitalPhi]Past", "=", "\[CapitalPhi]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]Past", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"#", "/", 
         RowBox[{"Total", "[", "#", "]"}]}], "&"}], "@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "*", 
           RowBox[{"UnitStep", "[", "#", "]"}]}], "&"}], "/@", 
         RowBox[{"LeastSquares", "[", 
          RowBox[{"\[CapitalPhi]", ",", "\[CapitalPsi]"}], "]"}]}], ")"}]}]}],
      ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Initialise", " ", "with", " ", "naive", " ", "least", " ", "squares", 
       " ", "solution"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"nPast", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Norm", "[", 
         RowBox[{"#", ",", "1"}], "]"}], "&"}], "@", 
       RowBox[{"LeastSquares", "[", 
        RowBox[{"\[CapitalPhi]", ",", "\[CapitalPsi]"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]Past", "=", 
      RowBox[{"\[ScriptCapitalL]", "[", 
       RowBox[{
       "\[CapitalPhi]Past", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]", ",", 
        "\[Alpha]Past", ",", "\[Sigma]", ",", "nPast", ",", "mList"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalPhi]Next", "=", 
      RowBox[{"min\[CapitalPhi]", "[", 
       RowBox[{
        RowBox[{"\[CapitalPhi]Vars", "[", "k", "]"}], ",", 
        "\[CapitalPhi]Past", ",", "\[CapitalPsi]", ",", "\[CapitalPhi]", ",", 
        "\[Sigma]", ",", "\[Alpha]Past", ",", "nPast", ",", "mList"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]Next", "=", 
      RowBox[{"min\[Alpha]LSHelper", "[", 
       RowBox[{
        RowBox[{"\[Alpha]Vars", "[", "k", "]"}], ",", "\[Alpha]Past", ",", 
        "\[Sigma]", ",", "\[CapitalPhi]Next", ",", "\[CapitalPsi]", ",", 
        "nPast", ",", 
        RowBox[{"10", "^", 
         RowBox[{"(", 
          RowBox[{"-", "4"}], ")"}]}], ",", "1"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"nNext", "=", 
      RowBox[{"nUpdate", "[", 
       RowBox[{
       "\[CapitalPhi]Next", ",", "\[Alpha]Next", ",", "\[CapitalPsi]", ",", 
        "\[Sigma]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]Next", "=", 
      RowBox[{"\[ScriptCapitalL]", "[", 
       RowBox[{
       "\[CapitalPhi]Next", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]", ",", 
        "\[Alpha]Next", ",", "\[Sigma]", ",", "nNext", ",", "mList"}], 
       "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]List", "=", 
      RowBox[{"{", "\[Alpha]Past", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]List", "=", 
      RowBox[{"{", "\[ScriptCapitalL]Past", "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"nList", "=", 
      RowBox[{"{", "nPast", "}"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(0\)]\) = \>\"", ",", 
       "\[Alpha]Past", ",", 
       "\"\<, \!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(0\)]\) = \>\"", ",",
        "\[ScriptCapitalL]Past", ",", 
       "\"\<, \!\(\*SubscriptBox[\(n\), \(0\)]\) = \>\"", ",", "nPast"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[Alpha] = \>\"", ",", "\[Alpha]Next", ",", 
       "\"\<, \[ScriptCapitalL] = \>\"", ",", "\[ScriptCapitalL]Next", ",", 
       "\"\<, n = \>\"", ",", "nNext"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"\[ScriptCapitalL]Next", "+", "\[Delta]"}], ">", 
        "\[ScriptCapitalL]Past"}], ",", 
       RowBox[{"\[Alpha]Next", "=", "\[Alpha]Past"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Monitor", "[", 
      RowBox[{
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Norm", "[", 
            RowBox[{
             RowBox[{"\[Alpha]Next", "-", "\[Alpha]Past"}], ",", "Infinity"}],
             "]"}], ">", "\[CurlyEpsilon]"}], "&&", 
          RowBox[{"iter", "<", "maxIter"}], "&&", 
          RowBox[{
           RowBox[{"\[ScriptCapitalL]Next", "+", "\[Delta]"}], "<", 
           "\[ScriptCapitalL]Past"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[CapitalPhi]Past", "=", "\[CapitalPhi]Next"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]Past", "=", "\[Alpha]Next"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"nPast", "=", "nNext"}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[ScriptCapitalL]Past", "=", "\[ScriptCapitalL]Next"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"\[Alpha]List", ",", "\[Alpha]Next"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"\[ScriptCapitalL]List", ",", "\[ScriptCapitalL]Next"}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"nList", ",", "nNext"}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[CapitalPhi]Next", "=", 
           RowBox[{"min\[CapitalPhi]", "[", 
            RowBox[{
             RowBox[{"\[CapitalPhi]Vars", "[", "k", "]"}], ",", 
             "\[CapitalPhi]Past", ",", "\[CapitalPsi]", ",", "\[CapitalPhi]", 
             ",", "\[Sigma]", ",", "\[Alpha]Past", ",", "nNext", ",", 
             "mList"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]Next", "=", 
           RowBox[{"min\[Alpha]LSHelper", "[", 
            RowBox[{
             RowBox[{"\[Alpha]Vars", "[", "k", "]"}], ",", "\[Alpha]Past", 
             ",", "\[Sigma]", ",", "\[CapitalPhi]Next", ",", "\[CapitalPsi]", 
             ",", "nPast", ",", 
             RowBox[{"10", "^", 
              RowBox[{"(", 
               RowBox[{"-", "4"}], ")"}]}], ",", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"nNext", "=", 
           RowBox[{"nUpdate", "[", 
            RowBox[{
            "\[CapitalPhi]Next", ",", "\[Alpha]Next", ",", "\[CapitalPsi]", 
             ",", "\[Sigma]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[ScriptCapitalL]Next", "=", 
           RowBox[{"\[ScriptCapitalL]", "[", 
            RowBox[{
            "\[CapitalPhi]Next", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]", 
             ",", "\[Alpha]Next", ",", "\[Sigma]", ",", "nNext", ",", 
             "mList"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"iter", "+=", "1"}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<\[Alpha] = \>\"", ",", "\[Alpha]Next", ",", 
            "\"\<, \[ScriptCapitalL] = \>\"", ",", "\[ScriptCapitalL]Next", 
            ",", "\"\<, n = \>\"", ",", "nNext"}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ",", "iter"}], 
      "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "\[Alpha]List", ",", "\[ScriptCapitalL]List", ",", "nList", ",", 
       "\[CapitalPhi]Next"}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.77429870637696*^9, 3.7742987204827747`*^9}, {
   3.774298760295568*^9, 3.774298923990714*^9}, {3.774298957690098*^9, 
   3.774299066140527*^9}, {3.7742991758146467`*^9, 3.774299206570909*^9}, {
   3.774299680221148*^9, 3.7742999740273046`*^9}, 3.774300007781999*^9, {
   3.7743582594551086`*^9, 3.774358267144931*^9}, {3.774358328027855*^9, 
   3.7743584582044773`*^9}, {3.77435851304951*^9, 3.7743585628453417`*^9}, {
   3.7743587360638857`*^9, 3.774358742168228*^9}, {3.774358786255465*^9, 
   3.7743587962458553`*^9}, 3.774358826643354*^9, {3.774358907818781*^9, 
   3.77435891985165*^9}, {3.774359240336988*^9, 3.774359255094759*^9}, {
   3.774360427066442*^9, 3.774360456551087*^9}, {3.774896874887125*^9, 
   3.7748969180382767`*^9}, {3.7748969579496202`*^9, 3.77489710216425*^9}, {
   3.774897305647846*^9, 3.774897315413795*^9}, {3.77489735305832*^9, 
   3.774897390944536*^9}, {3.774897526401923*^9, 3.774897530455949*^9}, {
   3.774897605814534*^9, 3.774897611404758*^9}, {3.7749702263714867`*^9, 
   3.774970340667818*^9}, {3.775058539686062*^9, 3.775058545604138*^9}, {
   3.775058772351252*^9, 3.775058787480699*^9}, 3.775058820330624*^9, {
   3.7750604247268343`*^9, 3.775060429676545*^9}, {3.7750758831225777`*^9, 
   3.775075936591035*^9}, {3.7751401506900797`*^9, 3.775140215668302*^9}, {
   3.775177929184081*^9, 3.775178074275915*^9}, {3.7751781207413797`*^9, 
   3.775178134445157*^9}, {3.775178370659503*^9, 3.775178394051222*^9}, {
   3.775179914399838*^9, 3.775179927749538*^9}, {3.775227290905459*^9, 
   3.775227307126845*^9}, {3.7752274444766617`*^9, 3.775227451576708*^9}, {
   3.775317914018866*^9, 3.775317963944353*^9}, {3.775319528411553*^9, 
   3.7753195533483467`*^9}, {3.775322373177081*^9, 3.775322382998479*^9}, {
   3.776352545754581*^9, 3.776352566402062*^9}, {3.77635264831774*^9, 
   3.7763526575404053`*^9}, {3.776356545590167*^9, 3.776356583038669*^9}, {
   3.776370517645204*^9, 3.776370521581126*^9}, {3.776385085801597*^9, 
   3.7763850899592333`*^9}, {3.7763857630733023`*^9, 
   3.7763857658117943`*^9}, {3.777225729707836*^9, 3.777225729843329*^9}, 
   3.777236378714038*^9, {3.777238278028502*^9, 3.7772383432667*^9}, {
   3.777238418488332*^9, 3.777238451318429*^9}, {3.777239740989325*^9, 
   3.777239756990803*^9}, {3.77725687391457*^9, 3.777256882873083*^9}, {
   3.778686307998983*^9, 3.778686366112814*^9}, {3.778687029941115*^9, 
   3.7786870515748873`*^9}, {3.7786957873605833`*^9, 3.778695815678261*^9}, {
   3.778696028878319*^9, 3.778696109907826*^9}, {3.796494524391808*^9, 
   3.796494583436695*^9}, {3.796503701249442*^9, 3.796503735634924*^9}, {
   3.796503881026404*^9, 3.796503939142275*^9}, {3.796504049867738*^9, 
   3.796504052642004*^9}, {3.7966586004623423`*^9, 3.796658608948687*^9}, {
   3.796658929348702*^9, 3.796658945893496*^9}},
 CellLabel->
  "In[346]:=",ExpressionUUID->"f2dcc874-941b-491f-8f74-0012490dfb35"]
}, Closed]],

Cell[CellGroupData[{

Cell["Joint Updates (1)", "Section",
 CellChangeTimes->{{3.778681405579625*^9, 3.778681408514648*^9}, {
  3.7786825565564003`*^9, 3.77868255724652*^9}, {3.825870897070467*^9, 
  3.825870897526697*^9}},ExpressionUUID->"987d1db0-dff1-4771-9718-\
16acae31ae85"],

Cell["\<\
min\[CapitalPhi]Row \t\[LongDash] Optimize one row of \[CapitalPhi] for fixed \
\[Alpha], mixture\[Sigma]
min\[CapitalPhi] \t\t\[LongDash] Iterate min\[CapitalPhi]Row over rows
min\[Alpha] \t\t\[LongDash] W-NNLS for fixed \[CapitalPhi], mixture\[Sigma]
min\[Alpha]Helper \t\[LongDash] Iterate min\[Alpha] until convergence (\
\[CurlyEpsilon]) or maxIter times
alternate \t\t\[LongDash] Alternate min\[CapitalPhi] and min\[Alpha] until \
convergence (\[Delta]) or maxIter times\
\>", "Text",
 CellChangeTimes->{{3.778681412817276*^9, 3.778681416756061*^9}, {
   3.778681571552198*^9, 3.778681613370295*^9}, {3.778682351431459*^9, 
   3.778682482316618*^9}, {3.7786830245344276`*^9, 3.778683117751337*^9}, 
   3.799071852131011*^9},
 FontSize->24,ExpressionUUID->"ad48f06b-2fe8-4742-862c-591349313f48"],

Cell[BoxData[
 RowBox[{
  RowBox[{"nUpdateJoint", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[Alpha]s_", ",", "\[CapitalPsi]s_", ",", 
    "\[Sigma]_"}], "]"}], ":=", 
  RowBox[{"MapThread", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"nUpdate", "[", 
      RowBox[{"\[CapitalPhi]", ",", "#1", ",", "#2", ",", "\[Sigma]"}], "]"}],
      "&"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Transpose", "@", "\[Alpha]s"}], ",", 
      RowBox[{"Transpose", "@", "\[CapitalPsi]s"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.774896551027577*^9, 3.774896670734481*^9}, {
  3.774899574496557*^9, 3.774899587453405*^9}, {3.796484175735936*^9, 
  3.796484258958723*^9}, {3.7964843123866653`*^9, 3.796484333280261*^9}, {
  3.796484370199829*^9, 3.796484415990046*^9}, {3.7964874343360977`*^9, 
  3.796487439183584*^9}, {3.796487552457458*^9, 3.7964875553450947`*^9}, {
  3.796493436247794*^9, 3.7964934467816153`*^9}, {3.825870901439973*^9, 
  3.825870974616157*^9}, {3.825871089708131*^9, 3.825871128938326*^9}},
 CellLabel->
  "In[347]:=",ExpressionUUID->"4d3bc4d1-e5c5-453c-b4af-a3b65109d2c5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"min\[CapitalPhi]RowJoint", "[", 
   RowBox[{
   "\[CapitalPhi]Vars_", ",", "\[CapitalPhi]Pre_", ",", 
    "\[CapitalPsi]Scalars_", ",", "\[CapitalPhi]observedRow_", ",", 
    "\[Sigma]Row_", ",", "\[Alpha]Lists_", ",", "ns_", ",", "mList_"}], "]"}],
   ":=", 
  RowBox[{"QuadraticOptimization", "[", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"mList", "/", "\[Sigma]Row"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[CapitalPhi]observedRow", "-", "\[CapitalPhi]Vars"}], 
         ")"}], "^", "2"}]}], "+", 
      RowBox[{"Total", "[", 
       RowBox[{"MapThread", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"#3", "/", 
            RowBox[{"(", 
             RowBox[{"mixture\[Sigma]", "[", 
              RowBox[{"#1", ",", "\[Sigma]Row", ",", "\[CapitalPhi]Pre"}], 
              "]"}], ")"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[CapitalPhi]Vars", ".", "#1"}], "-", 
              RowBox[{"#2", "/", "#3"}]}], ")"}], "^", "2"}]}], "&"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Transpose", "@", "\[Alpha]Lists"}], ",", 
           "\[CapitalPsi]Scalars", ",", "ns"}], "}"}]}], "]"}], "]"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"Thread", "[", 
      RowBox[{"\[CapitalPhi]Vars", "\[GreaterEqual]", "0"}], "]"}], "}"}], 
    ",", "\[CapitalPhi]Vars"}], "]"}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwd0E0og3EABvAZ0SwHS8bY2CyfjcPazElbNiGWSTkIbS0faZuldlCbNUpL
rGguOCCTdlgcpJUiOUgO5KMpau8o9lI+8jnyPv/D0+/0HJ5HbLQazGwWiyVk
AieTzlYoEa1Ovf8hKqX2ICyvoYlHtjQK6uR9D7Be5H+FEmnzO9QkKhMwZNpj
xxhblCE+1I09CeDKVIMYrh70FEPf3Ug5pGxFMpg9aJHDqdiQEm5IlLVwmPJo
4c6lqglWnxwaSF8a6IYJKccEl+qNvdB27RyAnUK9Bb5E+ontWW8uuBkwe6B3
I+qFbXHuNEx1LPuhv+R5DlrX5323jB9NjzOwo+y39amAVkcdGQaYYm/MYRcy
O6lR4nZ6l57LyL8YIEaTQ+MZjFuKMHG3guOFkTCfeC5Y/DyVMP+Y4l/wr2Mi
U+um1Qr+LJFHvxfDoDu/FB7f5MngGE9YBb9zD+Vw3eVUQfWCZlXPWLd/tQb/
ARxK5M8=
  "],
 CellLabel->
  "In[348]:=",ExpressionUUID->"ba66ce7d-2c8e-461e-80dc-b60982a7224b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"min\[CapitalPhi]Joint", "[", 
   RowBox[{
   "\[CapitalPhi]Vars_", ",", "\[CapitalPhi]Pre_", ",", "\[CapitalPsi]Vecs_", 
    ",", "\[CapitalPhi]MatrixObserved_", ",", "\[Sigma]Matrix_", ",", 
    "\[Alpha]Lists_", ",", "ns_", ",", "mList_"}], "]"}], ":=", 
  RowBox[{"Parallelize", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"\[CapitalPhi]Vars", "/.", 
        RowBox[{"min\[CapitalPhi]RowJoint", "[", 
         RowBox[{"\[CapitalPhi]Vars", ",", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", 
          RowBox[{"#2", "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", 
          RowBox[{"#3", "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", 
          RowBox[{"#4", "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", "\[Alpha]Lists", ",", "ns", 
          ",", "mList"}], "]"}]}], "&"}], "@@", 
      RowBox[{"{", 
       RowBox[{
       "\[CapitalPhi]Pre", ",", "\[CapitalPsi]Vecs", ",", 
        "\[CapitalPhi]MatrixObserved", ",", "\[Sigma]Matrix"}], "}"}]}], ",", 
     
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", 
       RowBox[{"Length", "@", "\[CapitalPsi]Vecs"}]}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7748374816574*^9, 3.774837521244328*^9}, {
  3.77483762918524*^9, 3.7748376335358047`*^9}, {3.774896844802033*^9, 
  3.774896845167614*^9}, {3.774897291984787*^9, 3.774897292173604*^9}, {
  3.7763563280472813`*^9, 3.776356332564581*^9}, {3.7965020907292013`*^9, 
  3.7965020955196943`*^9}, {3.8258928470491037`*^9, 3.8258929314039507`*^9}},
 CellLabel->
  "In[349]:=",ExpressionUUID->"4899b5ac-8d19-43ea-9bb8-892faed6abdd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"min\[Alpha]Joint", "[", 
   RowBox[{
   "\[Alpha]Vars_", ",", "\[Alpha]sPre_", ",", "\[Sigma]Matrix_", ",", 
    "\[CapitalPhi]Matrix_", ",", "\[CapitalPsi]Vectors_", ",", "ns_"}], "]"}],
   ":=", 
  RowBox[{"Transpose", "@", 
   RowBox[{"MapThread", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"min\[Alpha]", "[", 
       RowBox[{
       "\[Alpha]Vars", ",", "#1", ",", "\[Sigma]Matrix", ",", 
        "\[CapitalPhi]Matrix", ",", "#2", ",", "#3"}], "]"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Transpose", "@", "\[Alpha]sPre"}], ",", 
       RowBox[{"Transpose", "@", "\[CapitalPsi]Vectors"}], ",", "ns"}], 
      "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.777225289794664*^9, 3.777225469083433*^9}, {
   3.777225508932805*^9, 3.777225543786137*^9}, 3.7786957244421053`*^9, {
   3.796484526987924*^9, 3.796484529634119*^9}, {3.796484564656518*^9, 
   3.79648456485669*^9}, {3.7964847107418756`*^9, 3.796484722204586*^9}, {
   3.8258929709767942`*^9, 3.825893062880447*^9}, {3.825893095409487*^9, 
   3.8258930960434437`*^9}},
 CellLabel->
  "In[350]:=",ExpressionUUID->"59003f19-fb01-450c-8ca3-482f68d7afc6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"min\[Alpha]LSHelperJoint", "[", 
   RowBox[{
   "\[Alpha]Vars_", ",", "\[Alpha]sPre_", ",", "\[Sigma]Matrix_", ",", 
    "\[CapitalPhi]Matrix_", ",", "\[CapitalPsi]Vectors_", ",", "ns_", ",", 
    "\[CurlyEpsilon]_", ",", "maxIter_"}], "]"}], ":=", 
  RowBox[{"NestWhile", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"min\[Alpha]Joint", "[", 
      RowBox[{
      "\[Alpha]Vars", ",", "#", ",", "\[Sigma]Matrix", ",", 
       "\[CapitalPhi]Matrix", ",", "\[CapitalPsi]Vectors", ",", "ns"}], "]"}],
      "&"}], ",", "\[Alpha]sPre", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"#1", "-", "#2"}], "]"}], ",", "2"}], "]"}], ">", 
      "\[CurlyEpsilon]"}], "&"}], ",", "2", ",", "maxIter"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.774294857589836*^9, 3.774294864098996*^9}, {
   3.77429509991539*^9, 3.77429511588262*^9}, {3.774295213424584*^9, 
   3.7742953189660273`*^9}, {3.774295419892336*^9, 3.774295421417144*^9}, {
   3.774295466702552*^9, 3.774295607727091*^9}, {3.77429564709407*^9, 
   3.774295652801567*^9}, {3.774295755657164*^9, 3.774295781823442*^9}, {
   3.774296201516027*^9, 3.774296229237475*^9}, {3.774837415981896*^9, 
   3.7748374163881617`*^9}, {3.774877920364835*^9, 3.774877923626841*^9}, {
   3.774896854889585*^9, 3.774896855263582*^9}, {3.7753177532437277`*^9, 
   3.775317856588174*^9}, 3.775322480101653*^9, {3.777235684330975*^9, 
   3.777235684638644*^9}, {3.777253708904933*^9, 3.777253709006507*^9}, {
   3.777256126736528*^9, 3.777256127494803*^9}, {3.777323411349327*^9, 
   3.777323411507218*^9}, {3.777332602701811*^9, 3.777332603051189*^9}, {
   3.777839158895421*^9, 3.7778391589895077`*^9}, {3.777839604746818*^9, 
   3.7778396050806713`*^9}, 3.778695727849609*^9, {3.825893157153742*^9, 
   3.825893169663525*^9}, {3.825893223508664*^9, 3.8258932342094517`*^9}, {
   3.8258932927054377`*^9, 3.825893295135561*^9}},
 CellLabel->
  "In[351]:=",ExpressionUUID->"dcc968a3-1a13-4e68-8a67-e14404c379bd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"alternateJoint", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[CapitalPsi]s_", ",", "\[Sigma]_", ",", 
    "\[CurlyEpsilon]_", ",", "maxIter_", ",", "\[Delta]_", ",", "mList_"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Alpha]Next", ",", "\[Alpha]Past", ",", "\[CapitalPhi]Past", ",", 
      "\[CapitalPhi]Next", ",", "nPast", ",", "nNext", ",", "\[Alpha]List", 
      ",", "\[ScriptCapitalL]Past", ",", "\[ScriptCapitalL]Next", ",", 
      "\[ScriptCapitalL]List", ",", "nList", ",", 
      RowBox[{"iter", "=", "1"}], ",", 
      RowBox[{"k", "=", 
       RowBox[{"Length", "[", 
        RowBox[{"First", "@", "\[CapitalPhi]"}], "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[CapitalPhi]Past", "=", "\[CapitalPhi]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]Past", "=", 
      RowBox[{"Transpose", "@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"#", "/", 
            RowBox[{"Total", "[", "#", "]"}]}], "&"}], "@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "*", 
              RowBox[{"UnitStep", "[", "#", "]"}]}], "&"}], "/@", 
            RowBox[{"LeastSquares", "[", 
             RowBox[{"\[CapitalPhi]", ",", "\[CapitalPsi]"}], "]"}]}], 
           ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"\[CapitalPsi]", ",", 
           RowBox[{"Transpose", "@", "\[CapitalPsi]s"}]}], "}"}]}], "]"}]}]}],
      ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Initialise", " ", "with", " ", "naive", " ", "least", " ", "squares", 
       " ", "solution"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"nPast", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"#", ",", "1"}], "]"}], "&"}], "@", 
         RowBox[{"LeastSquares", "[", 
          RowBox[{"\[CapitalPhi]", ",", "\[CapitalPsi]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"\[CapitalPsi]", ",", 
          RowBox[{"Transpose", "@", "\[CapitalPsi]s"}]}], "}"}]}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]Past", "=", 
      RowBox[{"\[ScriptCapitalL]Joint", "[", 
       RowBox[{
       "\[CapitalPhi]Past", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]s", ",", 
        "\[Alpha]Past", ",", "\[Sigma]", ",", "nPast", ",", "mList"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalPhi]Next", "=", 
      RowBox[{"min\[CapitalPhi]Joint", "[", 
       RowBox[{
        RowBox[{"\[CapitalPhi]Vars", "[", "k", "]"}], ",", 
        "\[CapitalPhi]Past", ",", "\[CapitalPsi]s", ",", "\[CapitalPhi]", ",",
         "\[Sigma]", ",", "\[Alpha]Past", ",", "nPast", ",", "mList"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]Next", "=", 
      RowBox[{"min\[Alpha]LSHelperJoint", "[", 
       RowBox[{
        RowBox[{"\[Alpha]Vars", "[", "k", "]"}], ",", "\[Alpha]Past", ",", 
        "\[Sigma]", ",", "\[CapitalPhi]Next", ",", "\[CapitalPsi]s", ",", 
        "nPast", ",", 
        RowBox[{"10", "^", 
         RowBox[{"(", 
          RowBox[{"-", "4"}], ")"}]}], ",", "1"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"nNext", "=", 
      RowBox[{"nUpdateJoint", "[", 
       RowBox[{
       "\[CapitalPhi]Next", ",", "\[Alpha]Next", ",", "\[CapitalPsi]s", ",", 
        "\[Sigma]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]Next", "=", 
      RowBox[{"\[ScriptCapitalL]Joint", "[", 
       RowBox[{
       "\[CapitalPhi]Next", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]s", ",", 
        "\[Alpha]Next", ",", "\[Sigma]", ",", "nNext", ",", "mList"}], 
       "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]List", "=", 
      RowBox[{"{", "\[Alpha]Past", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]List", "=", 
      RowBox[{"{", "\[ScriptCapitalL]Past", "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"nList", "=", 
      RowBox[{"{", "nPast", "}"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(0\)]\) = \>\"", ",", 
       RowBox[{"Transpose", "@", "\[Alpha]Past"}], ",", 
       "\"\<, \!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(0\)]\) = \>\"", ",",
        "\[ScriptCapitalL]Past", ",", 
       "\"\<, \!\(\*SubscriptBox[\(n\), \(0\)]\) = \>\"", ",", "nPast"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<\[Alpha] = \>\"", ",", 
       RowBox[{"Transpose", "@", "\[Alpha]Next"}], ",", 
       "\"\<, \[ScriptCapitalL] = \>\"", ",", "\[ScriptCapitalL]Next", ",", 
       "\"\<, n = \>\"", ",", "nNext"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"\[ScriptCapitalL]Next", "+", "\[Delta]"}], ">", 
        "\[ScriptCapitalL]Past"}], ",", 
       RowBox[{"\[Alpha]Next", "=", "\[Alpha]Past"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Monitor", "[", 
      RowBox[{
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Norm", "[", 
            RowBox[{
             RowBox[{"Flatten", "[", 
              RowBox[{"\[Alpha]Next", "-", "\[Alpha]Past"}], "]"}], ",", 
             "Infinity"}], "]"}], ">", "\[CurlyEpsilon]"}], "&&", 
          RowBox[{"iter", "<", "maxIter"}], "&&", 
          RowBox[{
           RowBox[{"\[ScriptCapitalL]Next", "+", "\[Delta]"}], "<", 
           "\[ScriptCapitalL]Past"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[CapitalPhi]Past", "=", "\[CapitalPhi]Next"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]Past", "=", "\[Alpha]Next"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"nPast", "=", "nNext"}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[ScriptCapitalL]Past", "=", "\[ScriptCapitalL]Next"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"\[Alpha]List", ",", "\[Alpha]Next"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"\[ScriptCapitalL]List", ",", "\[ScriptCapitalL]Next"}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"nList", ",", "nNext"}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[CapitalPhi]Next", "=", 
           RowBox[{"min\[CapitalPhi]Joint", "[", 
            RowBox[{
             RowBox[{"\[CapitalPhi]Vars", "[", "k", "]"}], ",", 
             "\[CapitalPhi]Past", ",", "\[CapitalPsi]s", ",", "\[CapitalPhi]",
              ",", "\[Sigma]", ",", "\[Alpha]Past", ",", "nNext", ",", 
             "mList"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]Next", "=", 
           RowBox[{"min\[Alpha]LSHelperJoint", "[", 
            RowBox[{
             RowBox[{"\[Alpha]Vars", "[", "k", "]"}], ",", "\[Alpha]Past", 
             ",", "\[Sigma]", ",", "\[CapitalPhi]Next", ",", "\[CapitalPsi]s",
              ",", "nPast", ",", 
             RowBox[{"10", "^", 
              RowBox[{"(", 
               RowBox[{"-", "4"}], ")"}]}], ",", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"nNext", "=", 
           RowBox[{"nUpdateJoint", "[", 
            RowBox[{
            "\[CapitalPhi]Next", ",", "\[Alpha]Next", ",", "\[CapitalPsi]s", 
             ",", "\[Sigma]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[ScriptCapitalL]Next", "=", 
           RowBox[{"\[ScriptCapitalL]Joint", "[", 
            RowBox[{
            "\[CapitalPhi]Next", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]s", 
             ",", "\[Alpha]Next", ",", "\[Sigma]", ",", "nNext", ",", 
             "mList"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"iter", "+=", "1"}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<\[Alpha] = \>\"", ",", 
            RowBox[{"Transpose", "@", "\[Alpha]Next"}], ",", 
            "\"\<, \[ScriptCapitalL] = \>\"", ",", "\[ScriptCapitalL]Next", 
            ",", "\"\<, n = \>\"", ",", "nNext"}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ",", "iter"}], 
      "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "\[Alpha]List", ",", "\[ScriptCapitalL]List", ",", "nList", ",", 
       "\[CapitalPhi]Next"}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.77429870637696*^9, 3.7742987204827747`*^9}, {
   3.774298760295568*^9, 3.774298923990714*^9}, {3.774298957690098*^9, 
   3.774299066140527*^9}, {3.7742991758146467`*^9, 3.774299206570909*^9}, {
   3.774299680221148*^9, 3.7742999740273046`*^9}, 3.774300007781999*^9, {
   3.7743582594551086`*^9, 3.774358267144931*^9}, {3.774358328027855*^9, 
   3.7743584582044773`*^9}, {3.77435851304951*^9, 3.7743585628453417`*^9}, {
   3.7743587360638857`*^9, 3.774358742168228*^9}, {3.774358786255465*^9, 
   3.7743587962458553`*^9}, 3.774358826643354*^9, {3.774358907818781*^9, 
   3.77435891985165*^9}, {3.774359240336988*^9, 3.774359255094759*^9}, {
   3.774360427066442*^9, 3.774360456551087*^9}, {3.774896874887125*^9, 
   3.7748969180382767`*^9}, {3.7748969579496202`*^9, 3.77489710216425*^9}, {
   3.774897305647846*^9, 3.774897315413795*^9}, {3.77489735305832*^9, 
   3.774897390944536*^9}, {3.774897526401923*^9, 3.774897530455949*^9}, {
   3.774897605814534*^9, 3.774897611404758*^9}, {3.7749702263714867`*^9, 
   3.774970340667818*^9}, {3.775058539686062*^9, 3.775058545604138*^9}, {
   3.775058772351252*^9, 3.775058787480699*^9}, 3.775058820330624*^9, {
   3.7750604247268343`*^9, 3.775060429676545*^9}, {3.7750758831225777`*^9, 
   3.775075936591035*^9}, {3.7751401506900797`*^9, 3.775140215668302*^9}, {
   3.775177929184081*^9, 3.775178074275915*^9}, {3.7751781207413797`*^9, 
   3.775178134445157*^9}, {3.775178370659503*^9, 3.775178394051222*^9}, {
   3.775179914399838*^9, 3.775179927749538*^9}, {3.775227290905459*^9, 
   3.775227307126845*^9}, {3.7752274444766617`*^9, 3.775227451576708*^9}, {
   3.775317914018866*^9, 3.775317963944353*^9}, {3.775319528411553*^9, 
   3.7753195533483467`*^9}, {3.775322373177081*^9, 3.775322382998479*^9}, {
   3.776352545754581*^9, 3.776352566402062*^9}, {3.77635264831774*^9, 
   3.7763526575404053`*^9}, {3.776356545590167*^9, 3.776356583038669*^9}, {
   3.776370517645204*^9, 3.776370521581126*^9}, {3.776385085801597*^9, 
   3.7763850899592333`*^9}, {3.7763857630733023`*^9, 
   3.7763857658117943`*^9}, {3.777225729707836*^9, 3.777225729843329*^9}, 
   3.777236378714038*^9, {3.777238278028502*^9, 3.7772383432667*^9}, {
   3.777238418488332*^9, 3.777238451318429*^9}, {3.777239740989325*^9, 
   3.777239756990803*^9}, {3.77725687391457*^9, 3.777256882873083*^9}, {
   3.778686307998983*^9, 3.778686366112814*^9}, {3.778687029941115*^9, 
   3.7786870515748873`*^9}, {3.7786957873605833`*^9, 3.778695815678261*^9}, {
   3.778696028878319*^9, 3.778696109907826*^9}, {3.796494524391808*^9, 
   3.796494583436695*^9}, {3.796503701249442*^9, 3.796503735634924*^9}, {
   3.796503881026404*^9, 3.796503939142275*^9}, {3.796504049867738*^9, 
   3.796504052642004*^9}, {3.7966586004623423`*^9, 3.796658608948687*^9}, {
   3.796658929348702*^9, 3.796658945893496*^9}, {3.825893371123736*^9, 
   3.825893373314777*^9}, {3.825893406167995*^9, 3.825893473698635*^9}, {
   3.8258937083501053`*^9, 3.825893808957881*^9}, {3.8258938753765717`*^9, 
   3.82589388524517*^9}, {3.825894007468411*^9, 3.825894011605349*^9}, {
   3.825894078061673*^9, 3.825894085320052*^9}, 3.825894170633625*^9, 
   3.825938701116933*^9},
 CellLabel->
  "In[352]:=",ExpressionUUID->"efd94f30-1bdc-46cc-a8f3-8b33992c9079"]
}, Closed]],

Cell[CellGroupData[{

Cell["Updates (2)", "Section",
 CellChangeTimes->{{3.7786832086678753`*^9, 
  3.778683210461135*^9}},ExpressionUUID->"68868295-9477-4c9f-a6b4-\
e2829530ba40"],

Cell["\<\
gradient\[CapitalPhi]Row \t\t\[LongDash] Like min\[CapitalPhi]Row, but not \
ignoring \[CapitalPhi]-dependence of mixture\[Sigma]
gradient\[CapitalPhi] \t\t\t\[LongDash] Iterate gradient\[CapitalPhi]Row over \
rows of \[CapitalPhi]
gradientIteration \t\t\[LongDash] Alternate min\[Alpha] and gradient\
\[CapitalPhi] until convergence (\[Delta]) or maxIter iterations\
\>", "Text",
 CellChangeTimes->{{3.7786832321627207`*^9, 3.778683294265987*^9}, {
  3.778685526982717*^9, 3.77868557075358*^9}, {3.799071866393326*^9, 
  3.799071867754058*^9}},
 FontSize->24,ExpressionUUID->"2e7d925a-6e42-42bc-9be9-dca8afbfafb9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gradient\[CapitalPhi]Row", "[", 
   RowBox[{
   "\[CapitalPhi]Row_", ",", "\[CapitalPhi]ObservedRow_", ",", 
    "\[CapitalPsi]ObservedScalar_", ",", "\[Alpha]_", ",", "\[Sigma]Row_", 
    ",", "\[CapitalPhi]Past_", ",", "n_", ",", "mList_"}], "]"}], ":=", 
  RowBox[{"\[CapitalPhi]Row", "/.", 
   RowBox[{
    RowBox[{"FindMinimum", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"row\[ScriptCapitalL]", "[", 
         RowBox[{
         "\[CapitalPhi]Row", ",", "\[CapitalPhi]ObservedRow", ",", 
          "\[CapitalPsi]ObservedScalar", ",", "\[Alpha]", ",", "\[Sigma]Row", 
          ",", "n", ",", "mList"}], "]"}], ",", 
        RowBox[{"Thread", "[", 
         RowBox[{"\[CapitalPhi]Row", "\[GreaterEqual]", "0"}], "]"}]}], "}"}],
       ",", 
      RowBox[{"Transpose", "@", 
       RowBox[{"{", 
        RowBox[{"\[CapitalPhi]Row", ",", "\[CapitalPhi]Past"}], "}"}]}]}], 
     "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.774361497082693*^9, 3.774361616055196*^9}, {
  3.774361702597275*^9, 3.7743617406844873`*^9}, {3.774362179424971*^9, 
  3.774362233404628*^9}, {3.774362284135203*^9, 3.774362308743329*^9}, {
  3.774362466029748*^9, 3.774362474114393*^9}, {3.774897449543213*^9, 
  3.774897456796185*^9}, {3.776370530341823*^9, 3.77637054077886*^9}, {
  3.778686465246634*^9, 3.778686466952742*^9}},
 CellLabel->
  "In[353]:=",ExpressionUUID->"6f7d0c28-dfed-4e62-8b2e-5a9252df702d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gradient\[CapitalPhi]", "[", 
   RowBox[{
   "\[CapitalPhi]Vars_", ",", "\[CapitalPhi]Observed_", ",", 
    "\[CapitalPsi]Observed_", ",", "\[Alpha]_", ",", "\[Sigma]_", ",", 
    "\[CapitalPhi]Past_", ",", "n_", ",", "mList_"}], "]"}], ":=", 
  RowBox[{"Parallelize", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"gradient\[CapitalPhi]Row", "[", 
        RowBox[{"\[CapitalPhi]Vars", ",", 
         RowBox[{"#1", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{"#2", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", "\[Alpha]", ",", 
         RowBox[{"#3", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{"#4", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", "n", ",", "mList"}], "]"}], 
       "&"}], "@@", 
      RowBox[{"{", 
       RowBox[{
       "\[CapitalPhi]Observed", ",", "\[CapitalPsi]Observed", ",", "\[Sigma]",
         ",", "\[CapitalPhi]Past"}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", 
       RowBox[{"Length", "@", "\[Sigma]"}]}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.774819115309149*^9, 3.774819115694709*^9}, {
  3.7748191617948503`*^9, 3.774819215054565*^9}, {3.774819308094904*^9, 
  3.774819313844857*^9}, {3.774897461230081*^9, 3.774897467604109*^9}, {
  3.776370589524487*^9, 3.7763705969856787`*^9}, {3.796502138281185*^9, 
  3.796502140961135*^9}},
 CellLabel->
  "In[354]:=",ExpressionUUID->"37677d28-bb31-47ee-b017-ef6e5d116afd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gradientIteration", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[CapitalPsi]_", ",", "\[CapitalPhi]Init_", ",", 
    "\[Alpha]Init_", ",", "nInit_", ",", "\[Sigma]_", ",", "\[CurlyEpsilon]_",
     ",", "maxIter_", ",", "\[Delta]_", ",", "mList_"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Alpha]Next", ",", "\[Alpha]Past", ",", "\[CapitalPhi]Past", ",", 
      "\[CapitalPhi]Next", ",", "nPast", ",", "nNext", ",", 
      "\[ScriptCapitalL]Past", ",", "\[ScriptCapitalL]Next", ",", 
      "\[Alpha]List", ",", "\[ScriptCapitalL]List", ",", "nList", ",", 
      RowBox[{"iter", "=", "1"}], ",", 
      RowBox[{"k", "=", 
       RowBox[{"Length", "[", 
        RowBox[{"First", "@", "\[CapitalPhi]"}], "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[CapitalPhi]Past", "=", "\[CapitalPhi]Init"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]Past", "=", "\[Alpha]Init"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"nPast", "=", "nInit"}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]Past", "=", 
      RowBox[{"\[ScriptCapitalL]", "[", 
       RowBox[{
       "\[CapitalPhi]Past", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]", ",", 
        "\[Alpha]Past", ",", "\[Sigma]", ",", "nPast", ",", "mList"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalPhi]Next", "=", 
      RowBox[{"gradient\[CapitalPhi]", "[", 
       RowBox[{
        RowBox[{"\[CapitalPhi]Vars", "[", "k", "]"}], ",", "\[CapitalPhi]", 
        ",", "\[CapitalPsi]", ",", "\[Alpha]Past", ",", "\[Sigma]", ",", 
        "\[CapitalPhi]Past", ",", "nPast", ",", "mList"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]Next", "=", 
      RowBox[{"min\[Alpha]LSHelper", "[", 
       RowBox[{
        RowBox[{"\[Alpha]Vars", "[", "k", "]"}], ",", "\[Alpha]Past", ",", 
        "\[Sigma]", ",", "\[CapitalPhi]Next", ",", "\[CapitalPsi]", ",", 
        "nPast", ",", 
        RowBox[{"10", "^", 
         RowBox[{"(", 
          RowBox[{"-", "4"}], ")"}]}], ",", "1"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"nNext", "=", 
      RowBox[{"nUpdate", "[", 
       RowBox[{
       "\[CapitalPhi]Next", ",", "\[Alpha]Next", ",", "\[CapitalPsi]", ",", 
        "\[Sigma]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]Next", "=", 
      RowBox[{"\[ScriptCapitalL]", "[", 
       RowBox[{
       "\[CapitalPhi]Next", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]", ",", 
        "\[Alpha]Next", ",", "\[Sigma]", ",", "nNext", ",", "mList"}], 
       "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]List", "=", 
      RowBox[{"{", "\[Alpha]Past", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]List", "=", 
      RowBox[{"{", "\[ScriptCapitalL]Past", "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"nList", "=", 
      RowBox[{"{", "nPast", "}"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"\[ScriptCapitalL]Next", "+", "\[Delta]"}], ">", 
        "\[ScriptCapitalL]Past"}], ",", 
       RowBox[{"\[Alpha]Next", "=", "\[Alpha]Past"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\[Alpha] = \>\"", ",", "\[Alpha]Next", ",", 
       "\"\<, \[ScriptCapitalL] = \>\"", ",", "\[ScriptCapitalL]Next", ",", 
       "\"\<, n = \>\"", ",", "nNext"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Monitor", "[", 
      RowBox[{
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Norm", "[", 
            RowBox[{
             RowBox[{"\[Alpha]Next", "-", "\[Alpha]Past"}], ",", "Infinity"}],
             "]"}], ">", "\[CurlyEpsilon]"}], "&&", 
          RowBox[{"iter", "<", "maxIter"}], "&&", 
          RowBox[{
           RowBox[{"\[ScriptCapitalL]Next", "+", "\[Delta]"}], "<", 
           "\[ScriptCapitalL]Past"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[CapitalPhi]Past", "=", "\[CapitalPhi]Next"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]Past", "=", "\[Alpha]Next"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"nPast", "=", "nNext"}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[ScriptCapitalL]Past", "=", "\[ScriptCapitalL]Next"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"\[Alpha]List", ",", "\[Alpha]Next"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"\[ScriptCapitalL]List", ",", "\[ScriptCapitalL]Next"}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"nList", ",", "nNext"}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[CapitalPhi]Next", "=", 
           RowBox[{"gradient\[CapitalPhi]", "[", 
            RowBox[{
             RowBox[{"\[CapitalPhi]Vars", "[", "k", "]"}], ",", 
             "\[CapitalPhi]", ",", "\[CapitalPsi]", ",", "\[Alpha]Past", ",", 
             "\[Sigma]", ",", "\[CapitalPhi]Past", ",", "nPast", ",", 
             "mList"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]Next", "=", 
           RowBox[{"min\[Alpha]LSHelper", "[", 
            RowBox[{
             RowBox[{"\[Alpha]Vars", "[", "k", "]"}], ",", "\[Alpha]Past", 
             ",", "\[Sigma]", ",", "\[CapitalPhi]Next", ",", "\[CapitalPsi]", 
             ",", "nPast", ",", 
             RowBox[{"10", "^", 
              RowBox[{"(", 
               RowBox[{"-", "4"}], ")"}]}], ",", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"nNext", "=", 
           RowBox[{"nUpdate", "[", 
            RowBox[{
            "\[CapitalPhi]Next", ",", "\[Alpha]Next", ",", "\[CapitalPsi]", 
             ",", "\[Sigma]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[ScriptCapitalL]Next", "=", 
           RowBox[{"\[ScriptCapitalL]", "[", 
            RowBox[{
            "\[CapitalPhi]Next", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]", 
             ",", "\[Alpha]Next", ",", "\[Sigma]", ",", "nNext", ",", 
             "mList"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"iter", "+=", "1"}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<\[Alpha] = \>\"", ",", "\[Alpha]Next", ",", 
            "\"\<, \[ScriptCapitalL] = \>\"", ",", "\[ScriptCapitalL]Next", 
            ",", "\"\<, n = \>\"", ",", "nNext"}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ",", "iter"}], 
      "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "\[Alpha]List", ",", "\[ScriptCapitalL]List", ",", "nList", ",", 
       "\[CapitalPhi]Next"}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.77487640796835*^9, 3.774876492302144*^9}, {
   3.77487661028008*^9, 3.774876616840803*^9}, {3.774876656466764*^9, 
   3.7748768380114098`*^9}, {3.7748975081898623`*^9, 3.774897521463773*^9}, {
   3.7748979237733927`*^9, 3.774898058421171*^9}, {3.7749775514351683`*^9, 
   3.7749776254058447`*^9}, {3.7750597302638493`*^9, 3.775059744495611*^9}, {
   3.775139035021021*^9, 3.7751390411093388`*^9}, {3.775141696699012*^9, 
   3.7751417159878387`*^9}, 3.7751421785908003`*^9, {3.77517877928596*^9, 
   3.775178817236621*^9}, {3.7751788683653507`*^9, 3.77517891294199*^9}, {
   3.775180242376234*^9, 3.7751802459924803`*^9}, {3.775183009065284*^9, 
   3.775183011542665*^9}, {3.775223584800199*^9, 3.7752236302552643`*^9}, {
   3.775228905972238*^9, 3.7752289205208397`*^9}, {3.776352689413967*^9, 
   3.77635269009527*^9}, {3.7763706607082577`*^9, 3.7763706824894857`*^9}, {
   3.7763851301597767`*^9, 3.776385133093951*^9}, {3.776385815635585*^9, 
   3.7763858181541157`*^9}, {3.777239011174349*^9, 3.777239011580696*^9}, {
   3.7772390547642307`*^9, 3.77723908466671*^9}, {3.777239777248233*^9, 
   3.7772397791420527`*^9}, {3.7772568599709387`*^9, 3.777256860391979*^9}, {
   3.777256891721416*^9, 3.777256892304723*^9}, {3.7786864042065563`*^9, 
   3.778686420504717*^9}, {3.778687066191596*^9, 3.778687085869882*^9}, {
   3.7786894958568163`*^9, 3.778689508943679*^9}, {3.778696161666416*^9, 
   3.778696204983697*^9}, 3.77869677426993*^9, {3.796503777558888*^9, 
   3.79650379203583*^9}, {3.79650394557614*^9, 3.796503948461301*^9}, {
   3.7965040270508747`*^9, 3.7965040425616627`*^9}},
 CellLabel->
  "In[355]:=",ExpressionUUID->"ef844229-92fe-497c-930b-f3af5dac8c7e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Joint Updates (2)", "Section",
 CellChangeTimes->{{3.7786832086678753`*^9, 3.778683210461135*^9}, {
  3.8259388040851107`*^9, 
  3.825938804637536*^9}},ExpressionUUID->"af35da3e-0a79-40f7-9536-\
db51140f4965"],

Cell["\<\
gradient\[CapitalPhi]Row \t\t\[LongDash] Like min\[CapitalPhi]Row, but not \
ignoring \[CapitalPhi]-dependence of mixture\[Sigma]
gradient\[CapitalPhi] \t\t\t\[LongDash] Iterate gradient\[CapitalPhi]Row over \
rows of \[CapitalPhi]
gradientIteration \t\t\[LongDash] Alternate min\[Alpha] and gradient\
\[CapitalPhi] until convergence (\[Delta]) or maxIter iterations\
\>", "Text",
 CellChangeTimes->{{3.7786832321627207`*^9, 3.778683294265987*^9}, {
  3.778685526982717*^9, 3.77868557075358*^9}, {3.799071866393326*^9, 
  3.799071867754058*^9}},
 FontSize->24,ExpressionUUID->"376cde2a-2f6c-49a5-82f5-5344f0870fe7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gradient\[CapitalPhi]RowJoint", "[", 
   RowBox[{
   "\[CapitalPhi]Row_", ",", "\[CapitalPhi]ObservedRow_", ",", 
    "\[CapitalPsi]ObservedScalars_", ",", "\[Alpha]s_", ",", "\[Sigma]Row_", 
    ",", "\[CapitalPhi]Past_", ",", "ns_", ",", "mList_"}], "]"}], ":=", 
  RowBox[{"\[CapitalPhi]Row", "/.", 
   RowBox[{
    RowBox[{"FindMinimum", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"row\[ScriptCapitalL]Joint", "[", 
         RowBox[{
         "\[CapitalPhi]Row", ",", "\[CapitalPhi]ObservedRow", ",", 
          "\[CapitalPsi]ObservedScalars", ",", "\[Alpha]s", ",", 
          "\[Sigma]Row", ",", "ns", ",", "mList"}], "]"}], ",", 
        RowBox[{"Thread", "[", 
         RowBox[{"\[CapitalPhi]Row", "\[GreaterEqual]", "0"}], "]"}]}], "}"}],
       ",", 
      RowBox[{"Transpose", "@", 
       RowBox[{"{", 
        RowBox[{"\[CapitalPhi]Row", ",", "\[CapitalPhi]Past"}], "}"}]}]}], 
     "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.774361497082693*^9, 3.774361616055196*^9}, {
   3.774361702597275*^9, 3.7743617406844873`*^9}, {3.774362179424971*^9, 
   3.774362233404628*^9}, {3.774362284135203*^9, 3.774362308743329*^9}, {
   3.774362466029748*^9, 3.774362474114393*^9}, {3.774897449543213*^9, 
   3.774897456796185*^9}, {3.776370530341823*^9, 3.77637054077886*^9}, {
   3.778686465246634*^9, 3.778686466952742*^9}, {3.825938809278429*^9, 
   3.825938809638307*^9}, {3.8259397952384863`*^9, 3.825939809318942*^9}, 
   3.8259398937207336`*^9, 3.8259400104549837`*^9},
 CellLabel->
  "In[356]:=",ExpressionUUID->"951944dd-b0ea-4a96-b068-3e93352ee585"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gradient\[CapitalPhi]Joint", "[", 
   RowBox[{
   "\[CapitalPhi]Vars_", ",", "\[CapitalPhi]Observed_", ",", 
    "\[CapitalPsi]sObserved_", ",", "\[Alpha]s_", ",", "\[Sigma]_", ",", 
    "\[CapitalPhi]Past_", ",", "ns_", ",", "mList_"}], "]"}], ":=", 
  RowBox[{"Parallelize", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"gradient\[CapitalPhi]RowJoint", "[", 
        RowBox[{"\[CapitalPhi]Vars", ",", 
         RowBox[{"#1", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{"#2", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", "\[Alpha]s", ",", 
         RowBox[{"#3", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{"#4", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", "ns", ",", "mList"}], "]"}], 
       "&"}], "@@", 
      RowBox[{"{", 
       RowBox[{
       "\[CapitalPhi]Observed", ",", "\[CapitalPsi]sObserved", ",", 
        "\[Sigma]", ",", "\[CapitalPhi]Past"}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", 
       RowBox[{"Length", "@", "\[Sigma]"}]}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.774819115309149*^9, 3.774819115694709*^9}, {
  3.7748191617948503`*^9, 3.774819215054565*^9}, {3.774819308094904*^9, 
  3.774819313844857*^9}, {3.774897461230081*^9, 3.774897467604109*^9}, {
  3.776370589524487*^9, 3.7763705969856787`*^9}, {3.796502138281185*^9, 
  3.796502140961135*^9}, {3.8259401451458683`*^9, 3.825940198719849*^9}},
 CellLabel->
  "In[357]:=",ExpressionUUID->"5b0b2fcb-a955-49f9-9f2d-e3550689283a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gradientIterationJoint", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[CapitalPsi]s_", ",", "\[CapitalPhi]Init_", ",", 
    "\[Alpha]sInit_", ",", "nsInit_", ",", "\[Sigma]_", ",", 
    "\[CurlyEpsilon]_", ",", "maxIter_", ",", "\[Delta]_", ",", "mList_"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Alpha]Next", ",", "\[Alpha]Past", ",", "\[CapitalPhi]Past", ",", 
      "\[CapitalPhi]Next", ",", "nPast", ",", "nNext", ",", 
      "\[ScriptCapitalL]Past", ",", "\[ScriptCapitalL]Next", ",", 
      "\[Alpha]List", ",", "\[ScriptCapitalL]List", ",", "nList", ",", 
      RowBox[{"iter", "=", "1"}], ",", 
      RowBox[{"k", "=", 
       RowBox[{"Length", "[", 
        RowBox[{"First", "@", "\[CapitalPhi]"}], "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[CapitalPhi]Past", "=", "\[CapitalPhi]Init"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]Past", "=", "\[Alpha]sInit"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"nPast", "=", "nsInit"}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]Past", "=", 
      RowBox[{"\[ScriptCapitalL]Joint", "[", 
       RowBox[{
       "\[CapitalPhi]Past", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]s", ",", 
        "\[Alpha]Past", ",", "\[Sigma]", ",", "nPast", ",", "mList"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalPhi]Next", "=", 
      RowBox[{"gradient\[CapitalPhi]Joint", "[", 
       RowBox[{
        RowBox[{"\[CapitalPhi]Vars", "[", "k", "]"}], ",", "\[CapitalPhi]", 
        ",", "\[CapitalPsi]s", ",", "\[Alpha]Past", ",", "\[Sigma]", ",", 
        "\[CapitalPhi]Past", ",", "nPast", ",", "mList"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]Next", "=", 
      RowBox[{"min\[Alpha]LSHelperJoint", "[", 
       RowBox[{
        RowBox[{"\[Alpha]Vars", "[", "k", "]"}], ",", "\[Alpha]Past", ",", 
        "\[Sigma]", ",", "\[CapitalPhi]Next", ",", "\[CapitalPsi]s", ",", 
        "nPast", ",", 
        RowBox[{"10", "^", 
         RowBox[{"(", 
          RowBox[{"-", "4"}], ")"}]}], ",", "1"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"nNext", "=", 
      RowBox[{"nUpdateJoint", "[", 
       RowBox[{
       "\[CapitalPhi]Next", ",", "\[Alpha]Next", ",", "\[CapitalPsi]s", ",", 
        "\[Sigma]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]Next", "=", 
      RowBox[{"\[ScriptCapitalL]Joint", "[", 
       RowBox[{
       "\[CapitalPhi]Next", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]s", ",", 
        "\[Alpha]Next", ",", "\[Sigma]", ",", "nNext", ",", "mList"}], 
       "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]List", "=", 
      RowBox[{"{", "\[Alpha]Past", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]List", "=", 
      RowBox[{"{", "\[ScriptCapitalL]Past", "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"nList", "=", 
      RowBox[{"{", "nPast", "}"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"\[ScriptCapitalL]Next", "+", "\[Delta]"}], ">", 
        "\[ScriptCapitalL]Past"}], ",", 
       RowBox[{"\[Alpha]Next", "=", "\[Alpha]Past"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<\[Alpha] = \>\"", ",", 
       RowBox[{"Transpose", "@", "\[Alpha]Next"}], ",", 
       "\"\<, \[ScriptCapitalL] = \>\"", ",", "\[ScriptCapitalL]Next", ",", 
       "\"\<, n = \>\"", ",", "nNext"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Monitor", "[", 
      RowBox[{
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Norm", "[", 
            RowBox[{
             RowBox[{"Flatten", "[", 
              RowBox[{"\[Alpha]Next", "-", "\[Alpha]Past"}], "]"}], ",", 
             "Infinity"}], "]"}], ">", "\[CurlyEpsilon]"}], "&&", 
          RowBox[{"iter", "<", "maxIter"}], "&&", 
          RowBox[{
           RowBox[{"\[ScriptCapitalL]Next", "+", "\[Delta]"}], "<", 
           "\[ScriptCapitalL]Past"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[CapitalPhi]Past", "=", "\[CapitalPhi]Next"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]Past", "=", "\[Alpha]Next"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"nPast", "=", "nNext"}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[ScriptCapitalL]Past", "=", "\[ScriptCapitalL]Next"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"\[Alpha]List", ",", "\[Alpha]Next"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"\[ScriptCapitalL]List", ",", "\[ScriptCapitalL]Next"}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"nList", ",", "nNext"}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[CapitalPhi]Next", "=", 
           RowBox[{"gradient\[CapitalPhi]Joint", "[", 
            RowBox[{
             RowBox[{"\[CapitalPhi]Vars", "[", "k", "]"}], ",", 
             "\[CapitalPhi]", ",", "\[CapitalPsi]s", ",", "\[Alpha]Past", ",",
              "\[Sigma]", ",", "\[CapitalPhi]Past", ",", "nPast", ",", 
             "mList"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]Next", "=", 
           RowBox[{"min\[Alpha]LSHelperJoint", "[", 
            RowBox[{
             RowBox[{"\[Alpha]Vars", "[", "k", "]"}], ",", "\[Alpha]Past", 
             ",", "\[Sigma]", ",", "\[CapitalPhi]Next", ",", "\[CapitalPsi]s",
              ",", "nPast", ",", 
             RowBox[{"10", "^", 
              RowBox[{"(", 
               RowBox[{"-", "4"}], ")"}]}], ",", "1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"nNext", "=", 
           RowBox[{"nUpdateJoint", "[", 
            RowBox[{
            "\[CapitalPhi]Next", ",", "\[Alpha]Next", ",", "\[CapitalPsi]s", 
             ",", "\[Sigma]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[ScriptCapitalL]Next", "=", 
           RowBox[{"\[ScriptCapitalL]Joint", "[", 
            RowBox[{
            "\[CapitalPhi]Next", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]s", 
             ",", "\[Alpha]Next", ",", "\[Sigma]", ",", "nNext", ",", 
             "mList"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"iter", "+=", "1"}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<\[Alpha] = \>\"", ",", 
            RowBox[{"Transpose", "@", "\[Alpha]Next"}], ",", 
            "\"\<, \[ScriptCapitalL] = \>\"", ",", "\[ScriptCapitalL]Next", 
            ",", "\"\<, n = \>\"", ",", "nNext"}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ",", "iter"}], 
      "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "\[Alpha]List", ",", "\[ScriptCapitalL]List", ",", "nList", ",", 
       "\[CapitalPhi]Next"}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.77487640796835*^9, 3.774876492302144*^9}, {
   3.77487661028008*^9, 3.774876616840803*^9}, {3.774876656466764*^9, 
   3.7748768380114098`*^9}, {3.7748975081898623`*^9, 3.774897521463773*^9}, {
   3.7748979237733927`*^9, 3.774898058421171*^9}, {3.7749775514351683`*^9, 
   3.7749776254058447`*^9}, {3.7750597302638493`*^9, 3.775059744495611*^9}, {
   3.775139035021021*^9, 3.7751390411093388`*^9}, {3.775141696699012*^9, 
   3.7751417159878387`*^9}, 3.7751421785908003`*^9, {3.77517877928596*^9, 
   3.775178817236621*^9}, {3.7751788683653507`*^9, 3.77517891294199*^9}, {
   3.775180242376234*^9, 3.7751802459924803`*^9}, {3.775183009065284*^9, 
   3.775183011542665*^9}, {3.775223584800199*^9, 3.7752236302552643`*^9}, {
   3.775228905972238*^9, 3.7752289205208397`*^9}, {3.776352689413967*^9, 
   3.77635269009527*^9}, {3.7763706607082577`*^9, 3.7763706824894857`*^9}, {
   3.7763851301597767`*^9, 3.776385133093951*^9}, {3.776385815635585*^9, 
   3.7763858181541157`*^9}, {3.777239011174349*^9, 3.777239011580696*^9}, {
   3.7772390547642307`*^9, 3.77723908466671*^9}, {3.777239777248233*^9, 
   3.7772397791420527`*^9}, {3.7772568599709387`*^9, 3.777256860391979*^9}, {
   3.777256891721416*^9, 3.777256892304723*^9}, {3.7786864042065563`*^9, 
   3.778686420504717*^9}, {3.778687066191596*^9, 3.778687085869882*^9}, {
   3.7786894958568163`*^9, 3.778689508943679*^9}, {3.778696161666416*^9, 
   3.778696204983697*^9}, 3.77869677426993*^9, {3.796503777558888*^9, 
   3.79650379203583*^9}, {3.79650394557614*^9, 3.796503948461301*^9}, {
   3.7965040270508747`*^9, 3.7965040425616627`*^9}, {3.825940231636464*^9, 
   3.8259402875516853`*^9}, {3.825940886223151*^9, 3.825940905390328*^9}},
 CellLabel->
  "In[358]:=",ExpressionUUID->"f3ae4d1d-cef5-4b7f-968a-74a8d41343da"]
}, Closed]],

Cell[CellGroupData[{

Cell["Hypothesis Tests", "Section",
 CellChangeTimes->{{3.778685597788603*^9, 3.778685600661172*^9}, {
  3.778686175399231*^9, 
  3.778686178142605*^9}},ExpressionUUID->"a0fade6e-3370-4f6e-a0dd-\
adea3346e12e"],

Cell["\<\
\[CapitalPsi]Testing \t\t\t\[LongDash] Hypothesis testing based on residual
\[CapitalPhi]Testing \t\t\t\[LongDash] Hypothesis testing based on \
\[CapitalPhi]
doubleTesting \t\[LongDash] Combine both statistics\
\>", "Text",
 CellChangeTimes->{{3.77868561054069*^9, 3.7786856598432207`*^9}, {
  3.778685755436219*^9, 3.778685768454035*^9}, {3.7990718815282583`*^9, 
  3.799071884529839*^9}},
 FontSize->24,ExpressionUUID->"51cd7a6f-78bf-4d37-be38-9607ca54fb7d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalPsi]Testing", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[Alpha]_", ",", "\[CapitalPsi]_", ",", 
    "\[Sigma]_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"GammaRegularized", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", "\[CapitalPsi]", "]"}], "/", "2"}], ",", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[CapitalPhi]", ".", "\[Alpha]"}], "-", 
          RowBox[{"\[CapitalPsi]", "/", "n"}]}], ")"}], "^", "2"}], "*", 
       RowBox[{"n", "/", 
        RowBox[{"mixture\[Sigma]", "[", 
         RowBox[{"\[Alpha]", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], 
         "]"}]}]}], "]"}], "/", "2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.774878395322035*^9, 3.774878511018073*^9}, {
  3.774878566524468*^9, 3.774878579264615*^9}, {3.774878774297778*^9, 
  3.774878804614952*^9}, {3.77487885966726*^9, 3.7748788598116417`*^9}, {
  3.7748789016662197`*^9, 3.774878907699295*^9}, {3.774881753671904*^9, 
  3.7748817538783617`*^9}, {3.774881865731639*^9, 3.774881872478693*^9}, {
  3.774898090936763*^9, 3.774898093685526*^9}},
 CellLabel->
  "In[359]:=",ExpressionUUID->"3822edb4-72b1-41ce-9fc7-4a1c2b4a1b17"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalPhi]Testing", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[CapitalPhi]Observed_", ",", "\[Sigma]_", ",", 
    "mList_"}], "]"}], ":=", 
  RowBox[{"GammaRegularized", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Times", "@@", 
      RowBox[{"Dimensions", "[", "\[CapitalPhi]", "]"}]}], "/", "2"}], ",", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"mMatrix", "[", 
         RowBox[{"mList", ",", 
          RowBox[{"Length", "@", "\[CapitalPhi]"}]}], "]"}], 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"\[CapitalPhi]", "-", "\[CapitalPhi]Observed"}], ")"}], 
          "^", "2"}], "/", "\[Sigma]"}]}], ",", "2"}], "]"}], "/", "2"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.77487887832514*^9, 3.774878929457782*^9}, {
   3.7748789662018538`*^9, 3.774879015832139*^9}, {3.774879065235358*^9, 
   3.774879068548335*^9}, {3.774879651963264*^9, 3.774879656608797*^9}, 
   3.774894196963204*^9, {3.774898118998145*^9, 3.7748981269614353`*^9}, {
   3.774900821347251*^9, 3.7749008222177677`*^9}, {3.777239159527809*^9, 
   3.777239163101372*^9}, 3.777239210049328*^9},
 CellLabel->
  "In[360]:=",ExpressionUUID->"48e904ec-756f-46b2-928c-149d132d085e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"doubleTesting", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[CapitalPhi]Observed_", ",", "\[Alpha]_", ",", 
    "\[CapitalPsi]_", ",", "\[Sigma]_", ",", "n_", ",", "mList_"}], "]"}], ":=", 
  RowBox[{"GammaRegularized", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Times", "@@", 
        RowBox[{"Dimensions", "[", "\[CapitalPhi]", "]"}]}], "+", 
       RowBox[{"Length", "[", "\[CapitalPsi]", "]"}]}], ")"}], "/", "2"}], 
    ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Total", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[CapitalPhi]", ".", "\[Alpha]"}], "-", 
            RowBox[{"\[CapitalPsi]", "/", "n"}]}], ")"}], "^", "2"}], "*", 
         RowBox[{"n", "/", 
          RowBox[{"mixture\[Sigma]", "[", 
           RowBox[{"\[Alpha]", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], 
           "]"}]}]}], "]"}], "+", 
       RowBox[{"Total", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"mMatrix", "[", 
           RowBox[{"mList", ",", 
            RowBox[{"Length", "@", "\[CapitalPhi]"}]}], "]"}], 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"\[CapitalPhi]", "-", "\[CapitalPhi]Observed"}], ")"}], 
            "^", "2"}], "/", "\[Sigma]"}]}], ",", "2"}], "]"}]}], ")"}], "/", 
     "2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7748790180341063`*^9, 3.7748790192405987`*^9}, {
   3.774879599337557*^9, 3.774879683575985*^9}, {3.774881769409905*^9, 
   3.77488176959979*^9}, {3.774881892807103*^9, 3.774881896068693*^9}, 
   3.774894201380991*^9, {3.774898129891116*^9, 3.774898130241316*^9}, {
   3.777239267737282*^9, 3.7772392678826723`*^9}, {3.7774888377014503`*^9, 
   3.777488838738619*^9}},
 CellLabel->
  "In[361]:=",ExpressionUUID->"23d2d698-2e54-41cd-a661-fad80a9bc262"]
}, Closed]],

Cell[CellGroupData[{

Cell["Main Function", "Section",
 CellChangeTimes->{{3.778685774200539*^9, 
  3.778685791472452*^9}},ExpressionUUID->"d249fee4-1ac8-4e5e-8071-\
d7b3e14bef78"],

Cell["\<\
Arguments:
\t\[CapitalPhi], \[Sigma] \t\t\t\[LongDash] Sample means and variances for \
observed single cell data
\t\[CapitalPsi]\t\t\t\[LongDash] Bulk sample to deconvolve
\t\[CurlyEpsilon], \[Delta]\t\t\t\[LongDash] Convergence criteria for \
\[Alpha] and likelihood
\tmaxIter\t\t\[LongDash] (Half the) Maximum number of iterations to be \
performed
\tmList \t\t\[LongDash] Number of cells for each cell type in single cell \
reference
Outputs:
\t\[Alpha]List\t\t\[LongDash] List of mixture weights obtained at each \
iteration
\t\[ScriptCapitalL]List\t\t\[LongDash] List of likelihoods attained at each \
iteration
\tnList\t\t\t\[LongDash] List of inferred n values at each iteration
     powerScores\t\[LongDash] Outcome of the three hypothesis tests
{\[Alpha]LS, \[ScriptCapitalL]LS, \t\t\[LongDash] Statistics as above after \
applying one final NNLS with updated parameters
LSpowerScores}\
\>", "Text",
 CellChangeTimes->{{3.7786858080693197`*^9, 3.778685820146988*^9}, {
  3.778685850855496*^9, 3.7786861285068274`*^9}, {3.778686168656569*^9, 
  3.7786862458157597`*^9}, {3.778696263194089*^9, 3.7786962662635937`*^9}, {
  3.7990719040417223`*^9, 3.799071922617078*^9}},
 FontSize->24,ExpressionUUID->"4ecaa339-64ad-4498-8ae2-5fdf4124de76"],

Cell[BoxData[
 RowBox[{
  RowBox[{"findMixtures", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[CapitalPsi]_", ",", "\[Sigma]_", ",", 
    "\[CurlyEpsilon]_", ",", "\[Delta]_", ",", "maxIter_", ",", "mList_"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Alpha]ListFirst", ",", "\[ScriptCapitalL]ListFirst", ",", 
      "nListFirst", ",", "\[CapitalPhi]First", ",", "\[Alpha]ListSecond", ",",
       "\[ScriptCapitalL]ListSecond", ",", "nListSecond", ",", 
      "\[CapitalPhi]Second", ",", "\[Alpha]LS", ",", "\[ScriptCapitalL]LS", 
      ",", "\[ScriptCapitalL]Final", ",", "\[IndentingNewLine]", 
      "\[Alpha]ListThird", ",", "\[ScriptCapitalL]ListThird", ",", 
      "nListThird", ",", "\[CapitalPhi]Third", ",", 
      RowBox[{"iter", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\[Alpha]ListFirst", ",", "\[ScriptCapitalL]ListFirst", ",", 
        "nListFirst", ",", "\[CapitalPhi]First"}], "}"}], "=", 
      RowBox[{"alternate", "[", 
       RowBox[{
       "\[CapitalPhi]", ",", "\[CapitalPsi]", ",", "\[Sigma]", ",", 
        "\[CurlyEpsilon]", ",", "maxIter", ",", "0.", ",", "mList"}], "]"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\[Alpha]ListSecond", ",", "\[ScriptCapitalL]ListSecond", ",", 
        "nListSecond", ",", "\[CapitalPhi]Second"}], "}"}], "=", 
      RowBox[{"gradientIteration", "[", 
       RowBox[{
       "\[CapitalPhi]", ",", "\[CapitalPsi]", ",", "\[CapitalPhi]First", ",", 
        
        RowBox[{"\[Alpha]ListFirst", "[", 
         RowBox[{"[", 
          RowBox[{"-", "1"}], "]"}], "]"}], ",", 
        RowBox[{"nListFirst", "[", 
         RowBox[{"[", 
          RowBox[{"-", "1"}], "]"}], "]"}], ",", "\[Sigma]", ",", 
        "\[CurlyEpsilon]", ",", "maxIter", ",", "\[Delta]", ",", "mList"}], 
       "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]LS", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Normalize", "[", 
         RowBox[{
          RowBox[{"Clip", "[", 
           RowBox[{"#", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}], ",", "Total"}], 
         "]"}], "&"}], "@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"LeastSquares", "[", 
           RowBox[{
            RowBox[{"#", ".", "\[CapitalPhi]"}], ",", 
            RowBox[{"#", ".", "\[CapitalPsi]"}]}], "]"}], "&"}], "@", 
         RowBox[{"DiagonalMatrix", "[", 
          RowBox[{"1", "/", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"mixture\[Sigma]", "[", 
             RowBox[{
              RowBox[{"\[Alpha]ListSecond", "[", 
               RowBox[{"[", 
                RowBox[{"-", "1"}], "]"}], "]"}], ",", "\[Sigma]", ",", 
              "\[CapitalPhi]Second"}], "]"}], "]"}]}], "]"}]}], ")"}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]LS", "=", 
      RowBox[{"\[ScriptCapitalL]", "[", 
       RowBox[{
       "\[CapitalPhi]Second", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]", ",",
         "\[Alpha]LS", ",", "\[Sigma]", ",", 
        RowBox[{"nListSecond", "[", 
         RowBox[{"[", 
          RowBox[{"-", "1"}], "]"}], "]"}], ",", "mList"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]Final", "=", 
      RowBox[{"\[ScriptCapitalL]", "[", 
       RowBox[{
       "\[CapitalPhi]Second", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]", ",", 
        RowBox[{"\[Alpha]ListSecond", "[", 
         RowBox[{"[", 
          RowBox[{"-", "1"}], "]"}], "]"}], ",", "\[Sigma]", ",", 
        RowBox[{"nListSecond", "[", 
         RowBox[{"[", 
          RowBox[{"-", "1"}], "]"}], "]"}], ",", "mList"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(Final\)]\) = \>\"", ",", 
       RowBox[{"\[Alpha]ListSecond", "[", 
        RowBox[{"[", 
         RowBox[{"-", "1"}], "]"}], "]"}], ",", 
       "\"\<, \!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(Final\)]\) = \>\"", 
       ",", "\[ScriptCapitalL]Final", ",", 
       "\"\<, \!\(\*SubscriptBox[\(n\), \(Final\)]\) = \>\"", ",", 
       RowBox[{"nListSecond", "[", 
        RowBox[{"[", 
         RowBox[{"-", "1"}], "]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(LS\)]\) = \>\"", ",", 
       "\[Alpha]LS", ",", 
       "\"\<, \!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(LS\)]\) = \>\"", 
       ",", "\[ScriptCapitalL]LS"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"\[ScriptCapitalL]LS", "<", "\[ScriptCapitalL]Final"}], "&&", 
        
        RowBox[{"iter", "\[LessEqual]", "maxIter"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\[Alpha]ListSecond", "=", 
         RowBox[{
         "\[Alpha]ListSecond", "~", "Join", "~", "\[Alpha]ListThird"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\[Alpha]ListThird", ",", "\[ScriptCapitalL]ListThird", ",", 
           "nListThird", ",", "\[CapitalPhi]Third"}], "}"}], "=", 
         RowBox[{"gradientIteration", "[", 
          RowBox[{
          "\[CapitalPhi]", ",", "\[CapitalPsi]", ",", "\[CapitalPhi]Second", 
           ",", "\[Alpha]LS", ",", 
           RowBox[{"nListSecond", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", "\[Sigma]", ",", 
           "\[CurlyEpsilon]", ",", "maxIter", ",", "\[Delta]", ",", "mList"}],
           "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Alpha]LS", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Normalize", "[", 
            RowBox[{
             RowBox[{"Clip", "[", 
              RowBox[{"#", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}], ",", 
             "Total"}], "]"}], "&"}], "@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"LeastSquares", "[", 
              RowBox[{
               RowBox[{"#", ".", "\[CapitalPhi]"}], ",", 
               RowBox[{"#", ".", "\[CapitalPsi]"}]}], "]"}], "&"}], "@", 
            RowBox[{"DiagonalMatrix", "[", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"mixture\[Sigma]", "[", 
                RowBox[{
                 RowBox[{"\[Alpha]ListThird", "[", 
                  RowBox[{"[", 
                   RowBox[{"-", "1"}], "]"}], "]"}], ",", "\[Sigma]", ",", 
                 "\[CapitalPhi]Third"}], "]"}], "]"}]}], "]"}]}], ")"}]}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"\[ScriptCapitalL]LS", "=", 
         RowBox[{"\[ScriptCapitalL]", "[", 
          RowBox[{
          "\[CapitalPhi]Third", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]", 
           ",", "\[Alpha]LS", ",", "\[Sigma]", ",", 
           RowBox[{"nListThird", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", "mList"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[ScriptCapitalL]Final", "=", 
         RowBox[{"\[ScriptCapitalL]", "[", 
          RowBox[{
          "\[CapitalPhi]Third", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]", 
           ",", 
           RowBox[{"\[Alpha]ListThird", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", "\[Sigma]", ",", 
           RowBox[{"nListThird", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", "mList"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"iter", "+=", "1"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(Final\)]\) = \>\"", ",", 
          RowBox[{"\[Alpha]ListThird", "[", 
           RowBox[{"[", 
            RowBox[{"-", "1"}], "]"}], "]"}], ",", 
          "\"\<, \!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(Final\)]\) = \
\>\"", ",", "\[ScriptCapitalL]Final", ",", 
          "\"\<, \!\(\*SubscriptBox[\(n\), \(Final\)]\) = \>\"", ",", 
          RowBox[{"nListThird", "[", 
           RowBox[{"[", 
            RowBox[{"-", "1"}], "]"}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(LS\)]\) = \>\"", ",", 
          "\[Alpha]LS", ",", 
          "\"\<, \!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(LS\)]\) = \>\"", 
          ",", "\[ScriptCapitalL]LS"}], "]"}], ";"}]}], "\[IndentingNewLine]",
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Alpha]ListFirst", "~", "Join", "~", "\[Alpha]ListSecond"}], 
       ",", "\[CapitalPhi]Second", ",", 
       RowBox[{
       "\[ScriptCapitalL]ListFirst", "~", "Join", "~", 
        "\[ScriptCapitalL]ListSecond", "~", "Join", "~", 
        RowBox[{"{", "\[ScriptCapitalL]Final", "}"}]}], ",", 
       RowBox[{"nListFirst", "~", "Join", "~", "nListSecond"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]LS", ",", "\[ScriptCapitalL]LS"}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.7752225175097322`*^9, 3.775222520048005*^9}, {
   3.775222665301331*^9, 3.775222696198453*^9}, {3.7752228670668173`*^9, 
   3.7752228951055*^9}, {3.775223159128278*^9, 3.7752232204991207`*^9}, {
   3.7752234697425117`*^9, 3.7752235398669653`*^9}, {3.775223873349244*^9, 
   3.7752238746817904`*^9}, {3.7752239053156643`*^9, 3.775223931269751*^9}, {
   3.775224029113491*^9, 3.775224093368367*^9}, {3.775224127026877*^9, 
   3.775224159310719*^9}, 3.775224882149024*^9, {3.775224970340469*^9, 
   3.775224995331471*^9}, {3.7752253435742397`*^9, 3.775225344364582*^9}, {
   3.775230307205728*^9, 3.7752303142895613`*^9}, {3.7763496674049187`*^9, 
   3.7763496769940434`*^9}, {3.776370688859001*^9, 3.776370699598443*^9}, 
   3.7763728473079767`*^9, {3.776389674931355*^9, 3.776389678087442*^9}, {
   3.777239784814455*^9, 3.777239886484811*^9}, {3.7773020869680643`*^9, 
   3.7773024460722437`*^9}, {3.7773025873569117`*^9, 3.777302654386381*^9}, {
   3.777488855629154*^9, 3.777488856442831*^9}, {3.778095246039728*^9, 
   3.778095280436934*^9}, {3.778686429019601*^9, 3.778686434558785*^9}, {
   3.778694522395554*^9, 3.7786945298406553`*^9}, {3.7786962228052673`*^9, 
   3.778696286315947*^9}, 3.7786967802126417`*^9, {3.796566033952148*^9, 
   3.7965660545515537`*^9}, {3.796566112526325*^9, 3.79656612949926*^9}, {
   3.796566166192045*^9, 3.796566171231772*^9}, {3.796566209309064*^9, 
   3.796566210767169*^9}, {3.7966677451650057`*^9, 3.796667763917782*^9}, {
   3.796667814417218*^9, 3.796667875844572*^9}, {3.796669326656425*^9, 
   3.79666934093953*^9}, {3.797281619162051*^9, 3.7972816956337423`*^9}, {
   3.7972818037529573`*^9, 3.7972818358186693`*^9}, 3.797517064875121*^9, {
   3.797948055443959*^9, 3.7979481172518063`*^9}, {3.7989187830691137`*^9, 
   3.7989187954338207`*^9}, {3.799337594295493*^9, 3.799337594964522*^9}, {
   3.799338318477042*^9, 3.7993383549780807`*^9}, {3.7994342422439117`*^9, 
   3.799434266215452*^9}, {3.799434304875379*^9, 3.7994343450494947`*^9}, {
   3.799434391621014*^9, 3.79943444997919*^9}, {3.799438859209008*^9, 
   3.7994388800865307`*^9}, {3.799505577878145*^9, 3.799505585740831*^9}, {
   3.799612184859579*^9, 3.799612187242199*^9}, {3.803568479934071*^9, 
   3.8035684837032347`*^9}},
 CellLabel->
  "In[362]:=",ExpressionUUID->"3d353d69-1f26-4f6e-aa7e-c8f6fed4e840"],

Cell[BoxData[
 RowBox[{
  RowBox[{"findMixturesJoint", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[CapitalPsi]s_", ",", "\[Sigma]_", ",", 
    "\[CurlyEpsilon]_", ",", "\[Delta]_", ",", "maxIter_", ",", "mList_"}], 
   "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Alpha]ListFirst", ",", "\[ScriptCapitalL]ListFirst", ",", 
      "nListFirst", ",", "\[CapitalPhi]First", ",", "\[Alpha]ListSecond", ",",
       "\[ScriptCapitalL]ListSecond", ",", "nListSecond", ",", 
      "\[CapitalPhi]Second", ",", "\[Alpha]LS", ",", "\[ScriptCapitalL]LS", 
      ",", "\[ScriptCapitalL]Final", ",", "\[IndentingNewLine]", 
      "\[Alpha]ListThird", ",", "\[ScriptCapitalL]ListThird", ",", 
      "nListThird", ",", "\[CapitalPhi]Third", ",", 
      RowBox[{"iter", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\[Alpha]ListFirst", ",", "\[ScriptCapitalL]ListFirst", ",", 
        "nListFirst", ",", "\[CapitalPhi]First"}], "}"}], "=", 
      RowBox[{"alternateJoint", "[", 
       RowBox[{
       "\[CapitalPhi]", ",", "\[CapitalPsi]s", ",", "\[Sigma]", ",", 
        "\[CurlyEpsilon]", ",", "maxIter", ",", "0.", ",", "mList"}], "]"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\[Alpha]ListSecond", ",", "\[ScriptCapitalL]ListSecond", ",", 
        "nListSecond", ",", "\[CapitalPhi]Second"}], "}"}], "=", 
      RowBox[{"gradientIterationJoint", "[", 
       RowBox[{
       "\[CapitalPhi]", ",", "\[CapitalPsi]s", ",", "\[CapitalPhi]First", ",", 
        RowBox[{"\[Alpha]ListFirst", "[", 
         RowBox[{"[", 
          RowBox[{"-", "1"}], "]"}], "]"}], ",", 
        RowBox[{"nListFirst", "[", 
         RowBox[{"[", 
          RowBox[{"-", "1"}], "]"}], "]"}], ",", "\[Sigma]", ",", 
        "\[CurlyEpsilon]", ",", "maxIter", ",", "\[Delta]", ",", "mList"}], 
       "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]LS", "=", 
      RowBox[{"Transpose", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Normalize", "[", 
              RowBox[{
               RowBox[{"Clip", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}], ",", 
               "Total"}], "]"}], "&"}], "@", 
            RowBox[{"LeastSquares", "[", 
             RowBox[{
              RowBox[{"#", ".", "\[CapitalPhi]"}], ",", 
              RowBox[{"#", ".", 
               RowBox[{"\[CapitalPsi]s", "\[LeftDoubleBracket]", 
                RowBox[{";;", ",", "i"}], "\[RightDoubleBracket]"}]}]}], 
             "]"}]}], "&"}], "@", 
          RowBox[{"DiagonalMatrix", "[", 
           RowBox[{"1", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"mixture\[Sigma]", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"\[Alpha]ListSecond", "[", 
                 RowBox[{"[", 
                  RowBox[{"-", "1"}], "]"}], "]"}], "\[LeftDoubleBracket]", 
                RowBox[{";;", ",", "i"}], "\[RightDoubleBracket]"}], ",", 
               "\[Sigma]", ",", "\[CapitalPhi]Second"}], "]"}], "]"}]}], 
           "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Range", "[", 
            RowBox[{"Length", "@", 
             RowBox[{
             "\[CapitalPsi]s", "\[LeftDoubleBracket]", "1", 
              "\[RightDoubleBracket]"}]}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]LS", "=", 
      RowBox[{"\[ScriptCapitalL]Joint", "[", 
       RowBox[{
       "\[CapitalPhi]Second", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]s", 
        ",", "\[Alpha]LS", ",", "\[Sigma]", ",", 
        RowBox[{"nListSecond", "[", 
         RowBox[{"[", 
          RowBox[{"-", "1"}], "]"}], "]"}], ",", "mList"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"\[ScriptCapitalL]Final", "=", 
      RowBox[{"\[ScriptCapitalL]Joint", "[", 
       RowBox[{
       "\[CapitalPhi]Second", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]s", 
        ",", 
        RowBox[{"\[Alpha]ListSecond", "[", 
         RowBox[{"[", 
          RowBox[{"-", "1"}], "]"}], "]"}], ",", "\[Sigma]", ",", 
        RowBox[{"nListSecond", "[", 
         RowBox[{"[", 
          RowBox[{"-", "1"}], "]"}], "]"}], ",", "mList"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(Final\)]\) = \>\"", ",", 
       RowBox[{"Transpose", "@", 
        RowBox[{"\[Alpha]ListSecond", "[", 
         RowBox[{"[", 
          RowBox[{"-", "1"}], "]"}], "]"}]}], ",", 
       "\"\<, \!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(Final\)]\) = \>\"", 
       ",", "\[ScriptCapitalL]Final", ",", 
       "\"\<, \!\(\*SubscriptBox[\(n\), \(Final\)]\) = \>\"", ",", 
       RowBox[{"nListSecond", "[", 
        RowBox[{"[", 
         RowBox[{"-", "1"}], "]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(LS\)]\) = \>\"", ",", 
       RowBox[{"Transpose", "@", "\[Alpha]LS"}], ",", 
       "\"\<, \!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(LS\)]\) = \>\"", 
       ",", "\[ScriptCapitalL]LS"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"\[ScriptCapitalL]LS", "<", "\[ScriptCapitalL]Final"}], "&&", 
        
        RowBox[{"iter", "\[LessEqual]", "maxIter"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\[Alpha]ListSecond", "=", 
         RowBox[{
         "\[Alpha]ListSecond", "~", "Join", "~", "\[Alpha]ListThird"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\[Alpha]ListThird", ",", "\[ScriptCapitalL]ListThird", ",", 
           "nListThird", ",", "\[CapitalPhi]Third"}], "}"}], "=", 
         RowBox[{"gradientIterationJoint", "[", 
          RowBox[{
          "\[CapitalPhi]", ",", "\[CapitalPsi]s", ",", "\[CapitalPhi]Second", 
           ",", "\[Alpha]LS", ",", 
           RowBox[{"nListSecond", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", "\[Sigma]", ",", 
           "\[CurlyEpsilon]", ",", "maxIter", ",", "\[Delta]", ",", "mList"}],
           "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Alpha]LS", "=", 
         RowBox[{"Transpose", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Normalize", "[", 
                 RowBox[{
                  RowBox[{"Clip", "[", 
                   RowBox[{"#", ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}], ",", 
                  "Total"}], "]"}], "&"}], "@", 
               RowBox[{"LeastSquares", "[", 
                RowBox[{
                 RowBox[{"#", ".", "\[CapitalPhi]"}], ",", 
                 RowBox[{"#", ".", 
                  RowBox[{"\[CapitalPsi]s", "\[LeftDoubleBracket]", 
                   RowBox[{";;", ",", "i"}], "\[RightDoubleBracket]"}]}]}], 
                "]"}]}], "&"}], "@", 
             RowBox[{"DiagonalMatrix", "[", 
              RowBox[{"1", "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"mixture\[Sigma]", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"\[Alpha]ListThird", "[", 
                    RowBox[{"[", 
                    RowBox[{"-", "1"}], "]"}], "]"}], "\[LeftDoubleBracket]", 
                   
                   RowBox[{";;", ",", "1"}], "\[RightDoubleBracket]"}], ",", 
                  "\[Sigma]", ",", "\[CapitalPhi]Third"}], "]"}], "]"}]}], 
              "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Range", "[", 
               RowBox[{"Length", "@", 
                RowBox[{
                "\[CapitalPsi]s", "\[LeftDoubleBracket]", "1", 
                 "\[RightDoubleBracket]"}]}], "]"}]}], "}"}]}], "]"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[ScriptCapitalL]LS", "=", 
         RowBox[{"\[ScriptCapitalL]Joint", "[", 
          RowBox[{
          "\[CapitalPhi]Third", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]s", 
           ",", "\[Alpha]LS", ",", "\[Sigma]", ",", 
           RowBox[{"nListThird", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", "mList"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[ScriptCapitalL]Final", "=", 
         RowBox[{"\[ScriptCapitalL]Joint", "[", 
          RowBox[{
          "\[CapitalPhi]Third", ",", "\[CapitalPhi]", ",", "\[CapitalPsi]s", 
           ",", 
           RowBox[{"\[Alpha]ListThird", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", "\[Sigma]", ",", 
           RowBox[{"nListThird", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}], ",", "mList"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"iter", "+=", "1"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(Final\)]\) = \>\"", ",", 
          RowBox[{"Transpose", "@", 
           RowBox[{"\[Alpha]ListThird", "[", 
            RowBox[{"[", 
             RowBox[{"-", "1"}], "]"}], "]"}]}], ",", 
          "\"\<, \!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(Final\)]\) = \
\>\"", ",", "\[ScriptCapitalL]Final", ",", 
          "\"\<, \!\(\*SubscriptBox[\(n\), \(Final\)]\) = \>\"", ",", 
          RowBox[{"nListThird", "[", 
           RowBox[{"[", 
            RowBox[{"-", "1"}], "]"}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(LS\)]\) = \>\"", ",", 
          RowBox[{"Transpose", "@", "\[Alpha]LS"}], ",", 
          "\"\<, \!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(LS\)]\) = \>\"", 
          ",", "\[ScriptCapitalL]LS"}], "]"}], ";"}]}], "\[IndentingNewLine]",
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Alpha]ListFirst", "~", "Join", "~", "\[Alpha]ListSecond"}], 
       ",", "\[CapitalPhi]Second", ",", 
       RowBox[{
       "\[ScriptCapitalL]ListFirst", "~", "Join", "~", 
        "\[ScriptCapitalL]ListSecond", "~", "Join", "~", 
        RowBox[{"{", "\[ScriptCapitalL]Final", "}"}]}], ",", 
       RowBox[{"nListFirst", "~", "Join", "~", "nListSecond"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]LS", ",", "\[ScriptCapitalL]LS"}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.7752225175097322`*^9, 3.775222520048005*^9}, {
   3.775222665301331*^9, 3.775222696198453*^9}, {3.7752228670668173`*^9, 
   3.7752228951055*^9}, {3.775223159128278*^9, 3.7752232204991207`*^9}, {
   3.7752234697425117`*^9, 3.7752235398669653`*^9}, {3.775223873349244*^9, 
   3.7752238746817904`*^9}, {3.7752239053156643`*^9, 3.775223931269751*^9}, {
   3.775224029113491*^9, 3.775224093368367*^9}, {3.775224127026877*^9, 
   3.775224159310719*^9}, 3.775224882149024*^9, {3.775224970340469*^9, 
   3.775224995331471*^9}, {3.7752253435742397`*^9, 3.775225344364582*^9}, {
   3.775230307205728*^9, 3.7752303142895613`*^9}, {3.7763496674049187`*^9, 
   3.7763496769940434`*^9}, {3.776370688859001*^9, 3.776370699598443*^9}, 
   3.7763728473079767`*^9, {3.776389674931355*^9, 3.776389678087442*^9}, {
   3.777239784814455*^9, 3.777239886484811*^9}, {3.7773020869680643`*^9, 
   3.7773024460722437`*^9}, {3.7773025873569117`*^9, 3.777302654386381*^9}, {
   3.777488855629154*^9, 3.777488856442831*^9}, {3.778095246039728*^9, 
   3.778095280436934*^9}, {3.778686429019601*^9, 3.778686434558785*^9}, {
   3.778694522395554*^9, 3.7786945298406553`*^9}, {3.7786962228052673`*^9, 
   3.778696286315947*^9}, 3.7786967802126417`*^9, {3.796566033952148*^9, 
   3.7965660545515537`*^9}, {3.796566112526325*^9, 3.79656612949926*^9}, {
   3.796566166192045*^9, 3.796566171231772*^9}, {3.796566209309064*^9, 
   3.796566210767169*^9}, {3.7966677451650057`*^9, 3.796667763917782*^9}, {
   3.796667814417218*^9, 3.796667875844572*^9}, {3.796669326656425*^9, 
   3.79666934093953*^9}, {3.797281619162051*^9, 3.7972816956337423`*^9}, {
   3.7972818037529573`*^9, 3.7972818358186693`*^9}, 3.797517064875121*^9, {
   3.797948055443959*^9, 3.7979481172518063`*^9}, {3.7989187830691137`*^9, 
   3.7989187954338207`*^9}, {3.799337594295493*^9, 3.799337594964522*^9}, {
   3.799338318477042*^9, 3.7993383549780807`*^9}, {3.7994342422439117`*^9, 
   3.799434266215452*^9}, {3.799434304875379*^9, 3.7994343450494947`*^9}, {
   3.799434391621014*^9, 3.79943444997919*^9}, {3.799438859209008*^9, 
   3.7994388800865307`*^9}, {3.799505577878145*^9, 3.799505585740831*^9}, {
   3.799612184859579*^9, 3.799612187242199*^9}, {3.803568479934071*^9, 
   3.8035684837032347`*^9}, {3.825870760516468*^9, 3.825870760917453*^9}, 
   3.8259410691564693`*^9, {3.8259417575423393`*^9, 3.82594176598274*^9}, {
   3.825959020087297*^9, 3.825959168402911*^9}, {3.825959511865575*^9, 
   3.825959530207944*^9}, {3.825959580816516*^9, 3.8259596731827602`*^9}},
 CellLabel->
  "In[363]:=",ExpressionUUID->"0d63b45c-9ded-4cd3-936a-82b946b7b9e6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Confidence Region", "Section",
 CellChangeTimes->{{3.798828434950047*^9, 3.7988284360374413`*^9}, {
  3.798829064066778*^9, 
  3.798829066033246*^9}},ExpressionUUID->"1143734f-cc9d-4315-96b8-\
d59532eacd55"],

Cell[CellGroupData[{

Cell["Exact Fisher", "Subsection",
 CellChangeTimes->{{3.824989105953154*^9, 
  3.824989107386003*^9}},ExpressionUUID->"4f289dea-65a0-49ee-bacb-\
e3ebf0c9bd84"],

Cell["\<\
Disregard this section of the code\[LongDash]it is not used in our final \
algorithm.\
\>", "Text",
 CellChangeTimes->{{3.831919625130333*^9, 3.831919644253488*^9}},
 FontSize->36,
 FontColor->RGBColor[
  1, 0, 0],ExpressionUUID->"11a1fbc2-988d-410e-b7b5-4bb7a5417185"],

Cell[TextData[{
 StyleBox["partial\[Sigma]\[Dash]\t\t\[LongDash] ",
  FontSize->24],
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     SubscriptBox["\[PartialD]", "x"],
     FontSize->24], 
    RowBox[{
     SubsuperscriptBox[
      StyleBox["\[Sigma]",
       FontSize->24], 
      StyleBox["g",
       FontSize->12], 
      StyleBox["2",
       FontSize->12]], 
     StyleBox["(",
      FontSize->24], 
     StyleBox["\[Alpha]",
      FontSize->24], 
     StyleBox[")",
      FontSize->24]}]}], TraditionalForm]],ExpressionUUID->
  "ec1815e5-0403-4ad7-8110-9bd155341100"],
 StyleBox["\npartial\[Dash]\[Dash]\t\t\[LongDash] ",
  FontSize->24],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[PartialD]", 
     RowBox[{"x", ",", "y"}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "log"}], " ", "\[DoubleStruckCapitalP]"}], ")"}]}], 
   TraditionalForm]],
  FontSize->24,ExpressionUUID->"b670d305-6853-427a-b541-7f5ff502a220"],
 "\n",
 StyleBox["blockMatrix\t\[LongDash] form block-diagonal matrix with input \
matrices on diagonal\n\[Dash]MapGK\t\t\[LongDash] translate indices of GK \
\[Cross] GK matrix and its flattening",
  FontSize->24]
}], "Text",
 CellChangeTimes->{{3.79907193445783*^9, 3.7990721608647547`*^9}, {
  3.799072210378235*^9, 
  3.799072257048251*^9}},ExpressionUUID->"935217b1-7cad-4749-a4ef-\
37896d8083b6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"blockMatrix", "[", "mat_", "]"}], ":=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Tuples", "[", 
        RowBox[{
         RowBox[{"Range", "@", "#"}], "-", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Rest", "@", "#"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "&"}], "@", 
     RowBox[{"Dimensions", "@", "mat"}]}], "\[Rule]", 
    RowBox[{"Flatten", "@", "mat"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.798987870783559*^9, 3.7989878780078*^9}},
 CellLabel->
  "In[365]:=",ExpressionUUID->"90a4d7d7-6ad2-4cb4-b9d3-21163919db2a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"partial\[Sigma]\[Alpha]", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[Alpha]_"}], "]"}], ":=", 
  RowBox[{"\[Sigma]", "+", 
   RowBox[{"\[CapitalPhi]", "^", "2"}], "-", 
   RowBox[{"2", "\[CapitalPhi]", "*", 
    RowBox[{"(", 
     RowBox[{"\[CapitalPhi]", ".", "\[Alpha]"}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.798829193913884*^9, 3.7988292368408318`*^9}, {
  3.79883031136558*^9, 3.798830328838314*^9}, {3.798831543609947*^9, 
  3.7988315447218657`*^9}},
 CellLabel->
  "In[366]:=",ExpressionUUID->"841d2559-e72e-49aa-9265-2f91a4cc7d5a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"partial\[Sigma]\[CapitalPhi]", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Alpha]_"}], "]"}], ":=", 
  RowBox[{"2", 
   RowBox[{"mMatrix", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"Length", "@", "\[CapitalPhi]"}]}], "]"}], 
   RowBox[{"(", 
    RowBox[{"\[CapitalPhi]", "-", 
     RowBox[{"\[CapitalPhi]", ".", "\[Alpha]"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.798832671590423*^9, 3.798832699380527*^9}, {
  3.798832749199134*^9, 3.798832778960606*^9}, {3.798832814823482*^9, 
  3.798832820152535*^9}, {3.7988329147998123`*^9, 3.7988329658839808`*^9}},
 CellLabel->
  "In[367]:=",ExpressionUUID->"803b4390-363a-4659-91a3-4b95cb552098"],

Cell[BoxData[
 RowBox[{
  RowBox[{"partial\[Alpha]\[Alpha]", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[Alpha]_", ",", "n_"}], 
   "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Sigma]\[Alpha]", "=", 
      RowBox[{"mixture\[Sigma]", "[", 
       RowBox[{"\[Alpha]", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], "]"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"n", "*", 
      RowBox[{
       RowBox[{"Transpose", "[", "\[CapitalPhi]", "]"}], ".", 
       RowBox[{"DiagonalMatrix", "[", 
        RowBox[{"1", "/", "\[Sigma]\[Alpha]"}], "]"}], ".", 
       "\[CapitalPhi]"}]}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"partial\[Sigma]\[Alpha]", "[", 
         RowBox[{"\[CapitalPhi]", ",", "\[Sigma]", ",", "\[Alpha]"}], "]"}], 
        "]"}], ".", 
       RowBox[{"DiagonalMatrix", "[", 
        RowBox[{"1", "/", 
         RowBox[{"\[Sigma]\[Alpha]", "^", "2"}]}], "]"}], ".", 
       RowBox[{"partial\[Sigma]\[Alpha]", "[", 
        RowBox[{"\[CapitalPhi]", ",", "\[Sigma]", ",", "\[Alpha]"}], "]"}]}], 
      "/", "2"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.798829078462881*^9, 3.798829183938402*^9}, {
   3.798830834205619*^9, 3.7988308374536324`*^9}, {3.798831191269661*^9, 
   3.79883120627129*^9}, {3.798831262132221*^9, 3.798831271450918*^9}, {
   3.7988313691062603`*^9, 3.798831370002643*^9}, {3.7988314185197973`*^9, 
   3.79883147273313*^9}, {3.798831523418845*^9, 3.798831540116845*^9}, {
   3.79883165737497*^9, 3.7988317076237907`*^9}, 3.798831930510302*^9, 
   3.7988319730485983`*^9, {3.7988320202070227`*^9, 3.7988320419179564`*^9}},
 CellLabel->
  "In[368]:=",ExpressionUUID->"21e91e0b-7a71-4e20-96e4-b1b14a99b119"],

Cell[BoxData[
 RowBox[{
  RowBox[{"partial\[CapitalPhi]\[CapitalPhi]", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[Alpha]_", ",", "n_", ",", 
    "mList_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"m", "=", 
       RowBox[{"mMatrix", "[", 
        RowBox[{"mList", ",", 
         RowBox[{"Length", "@", "\[CapitalPhi]"}]}], "]"}]}], ",", 
      RowBox[{"\[Sigma]\[Alpha]", "=", 
       RowBox[{"mixture\[Sigma]", "[", 
        RowBox[{"\[Alpha]", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], "]"}]}], 
      ",", 
      RowBox[{"\[Alpha]Matrix", "=", 
       RowBox[{"mMatrix", "[", 
        RowBox[{"\[Alpha]", ",", 
         RowBox[{"Length", "@", "\[CapitalPhi]"}]}], "]"}]}], ",", 
      RowBox[{"G", "=", 
       RowBox[{"Length", "@", "\[CapitalPhi]"}]}], ",", 
      RowBox[{"K", "=", 
       RowBox[{"Length", "@", 
        RowBox[{"\[CapitalPhi]", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"blockMatrix", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ConstantArray", "[", 
         RowBox[{
          RowBox[{"n", "*", 
           RowBox[{"KroneckerProduct", "[", 
            RowBox[{"\[Alpha]", ",", "\[Alpha]"}], "]"}]}], ",", "G"}], "]"}],
         "/", "\[Sigma]\[Alpha]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"KroneckerProduct", "[", 
            RowBox[{"#", ",", "#"}], "]"}], "&"}], "/@", 
          RowBox[{"partial\[Sigma]\[CapitalPhi]", "[", 
           RowBox[{"\[CapitalPhi]", ",", "\[Alpha]"}], "]"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", 
          RowBox[{"\[Sigma]\[Alpha]", "^", "2"}]}], ")"}]}]}], "]"}], "+", 
     RowBox[{"DiagonalMatrix", "[", 
      RowBox[{"Flatten", "[", 
       RowBox[{"m", "/", "\[Sigma]"}], "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.7988317300275927`*^9, 3.798831749692173*^9}, {
   3.79883240555506*^9, 3.798832478711072*^9}, {3.798832512558052*^9, 
   3.798832514301694*^9}, {3.798832553690693*^9, 3.7988325547076406`*^9}, {
   3.7988326496501713`*^9, 3.79883265756136*^9}, {3.7988331305335083`*^9, 
   3.798833189847597*^9}, {3.79883336930616*^9, 3.798833423784378*^9}, {
   3.7988335066069508`*^9, 3.798833595762347*^9}, {3.7988336313449907`*^9, 
   3.798833677529364*^9}, 3.7988364962737007`*^9, {3.798987435791937*^9, 
   3.798987439952531*^9}, {3.7989876363650427`*^9, 3.798987715883211*^9}, {
   3.798988637209771*^9, 3.798988698734614*^9}, {3.7989887466499767`*^9, 
   3.798988869005928*^9}, {3.803521435966614*^9, 3.8035214378460712`*^9}},
 CellLabel->
  "In[369]:=",ExpressionUUID->"02162bfc-f029-48db-9318-af30bb4b380a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"partial\[Alpha]\[CapitalPhi]", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[Alpha]_", ",", "n_"}], 
   "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Sigma]\[Alpha]", "=", 
       RowBox[{"mixture\[Sigma]", "[", 
        RowBox[{"\[Alpha]", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], "]"}]}], 
      ",", 
      RowBox[{"G", "=", 
       RowBox[{"Length", "@", "\[CapitalPhi]"}]}], ",", 
      RowBox[{"K", "=", 
       RowBox[{"Length", "@", "\[Alpha]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"n", "*", 
           RowBox[{"\[Alpha]", "[", 
            RowBox[{"[", 
             RowBox[{"Last", "@", "#"}], "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{"\[CapitalPhi]", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"First", "@", "#"}], ",", "k"}], "]"}], "]"}], "/", 
            RowBox[{"\[Sigma]\[Alpha]", "[", 
             RowBox[{"[", 
              RowBox[{"First", "@", "#"}], "]"}], "]"}]}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"partial\[Sigma]\[Alpha]", "[", 
               RowBox[{"\[CapitalPhi]", ",", "\[Sigma]", ",", "\[Alpha]"}], 
               "]"}], "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"First", "@", "#"}], ",", "k"}], "]"}], "]"}], "*", 
             RowBox[{
              RowBox[{
               RowBox[{"partial\[Sigma]\[CapitalPhi]", "[", 
                RowBox[{"\[CapitalPhi]", ",", "\[Alpha]"}], "]"}], "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"First", "@", "#"}], ",", 
                 RowBox[{"Last", "@", "#"}]}], "]"}], "]"}], "/", 
              RowBox[{
               RowBox[{"\[Sigma]\[Alpha]", "[", 
                RowBox[{"[", 
                 RowBox[{"First", "@", "#"}], "]"}], "]"}], "^", "2"}]}]}], 
            ")"}], "/", "2"}]}], ")"}], "&"}], "@", 
       RowBox[{"backwardMapGK", "[", 
        RowBox[{"index", ",", "G", ",", "K"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "K"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"index", ",", "1", ",", 
        RowBox[{"G", "*", "K"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7988341484003468`*^9, 3.7988341756604643`*^9}, {
  3.798834369284651*^9, 3.798834369348592*^9}, {3.798834627686905*^9, 
  3.798834632497694*^9}, {3.7988351193815536`*^9, 3.7988351351323013`*^9}, {
  3.79883518856638*^9, 3.798835195018734*^9}, {3.798835254416993*^9, 
  3.798835291877914*^9}, {3.798835352912558*^9, 3.7988354014690323`*^9}, {
  3.798835879175235*^9, 3.798835886639168*^9}, {3.798836023440653*^9, 
  3.798836276003113*^9}, {3.798836319788126*^9, 3.798836331888406*^9}, {
  3.798836384630797*^9, 3.7988363847450733`*^9}, {3.803521443521522*^9, 
  3.803521445206154*^9}},
 CellLabel->
  "In[370]:=",ExpressionUUID->"ab23326e-6352-486d-9b03-5e6e6b1e96cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"partialnn", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[Alpha]_", ",", "n_"}], 
   "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"G", "=", 
       RowBox[{"Length", "@", "\[CapitalPhi]"}]}], ",", 
      RowBox[{"\[Sigma]\[Alpha]", "=", 
       RowBox[{"mixture\[Sigma]", "[", 
        RowBox[{"\[Alpha]", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], 
        "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"G", "/", "2"}]}], ")"}], "/", 
      RowBox[{"n", "^", "2"}]}], "+", 
     RowBox[{
      RowBox[{"Total", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[CapitalPhi]", ".", "\[Alpha]"}], ")"}], "^", "2"}], "/", 
        "\[Sigma]\[Alpha]"}], "]"}], "/", "n"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.798860467922905*^9, 3.798860487300171*^9}, {
  3.798897419826577*^9, 3.798897485841333*^9}, {3.799439831902767*^9, 
  3.7994398321340227`*^9}, {3.803521451197709*^9, 3.8035214534933147`*^9}},
 CellLabel->
  "In[371]:=",ExpressionUUID->"8a0c915f-7f28-4715-94e8-afa01d8f3aad"],

Cell[BoxData[
 RowBox[{
  RowBox[{"partialn\[Alpha]", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[Alpha]_", ",", "n_"}], 
   "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Sigma]\[Alpha]", "=", 
      RowBox[{"mixture\[Sigma]", "[", 
       RowBox[{"\[Alpha]", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], "]"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"\[CapitalPhi]", "/", "\[Sigma]\[Alpha]"}], "]"}], ".", 
      RowBox[{"(", 
       RowBox[{"\[CapitalPhi]", ".", "\[Alpha]"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"Total", "[", 
       RowBox[{
        RowBox[{"partial\[Sigma]\[Alpha]", "[", 
         RowBox[{"\[CapitalPhi]", ",", "\[Sigma]", ",", "\[Alpha]"}], "]"}], 
        "/", "\[Sigma]\[Alpha]"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "n"}], ")"}]}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.798897785625033*^9, 3.798897828142468*^9}, {
  3.798897888773345*^9, 3.798897952004299*^9}, {3.7988987405974407`*^9, 
  3.798898748324875*^9}, {3.80352146030229*^9, 3.803521462269177*^9}},
 CellLabel->
  "In[372]:=",ExpressionUUID->"ef61c8ab-def8-4a43-8494-6999d9e4ce45"],

Cell[BoxData[
 RowBox[{
  RowBox[{"partialn\[CapitalPhi]", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[Alpha]_", ",", "n_"}], 
   "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Sigma]\[Alpha]", "=", 
      RowBox[{"mixture\[Sigma]", "[", 
       RowBox[{"\[Alpha]", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], "]"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"KroneckerProduct", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[CapitalPhi]", ".", "\[Alpha]"}], ")"}], "/", 
         "\[Sigma]\[Alpha]"}], ",", "\[Alpha]"}], "]"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"partial\[Sigma]\[CapitalPhi]", "[", 
          RowBox[{"\[CapitalPhi]", ",", "\[Alpha]"}], "]"}], "/", 
         "\[Sigma]\[Alpha]"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "n"}], ")"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.79889875129321*^9, 3.798898774974999*^9}, {
  3.798898831466734*^9, 3.798898864259454*^9}, {3.798898950934779*^9, 
  3.798898983551957*^9}, {3.798899319972291*^9, 3.798899321753853*^9}, {
  3.80352146640623*^9, 3.80352146838046*^9}},
 CellLabel->
  "In[373]:=",ExpressionUUID->"a2518651-91b3-4460-a988-4f984a550a42"],

Cell[BoxData[
 RowBox[{
  RowBox[{"forwardMapGK", "[", 
   RowBox[{"g_", ",", "k_", ",", "K_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"g", "-", "1"}], ")"}], "*", "K"}], "+", "k"}]}]], "Input",
 CellChangeTimes->{{3.798835550402689*^9, 3.7988355665921164`*^9}, {
  3.7988356709708033`*^9, 3.798835709959159*^9}},
 CellLabel->
  "In[374]:=",ExpressionUUID->"1ff8a8ce-d881-4359-a205-4ec138217b8d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"backwardMapGK", "[", 
   RowBox[{"index_", ",", "G_", ",", "K_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Floor", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"index", "-", "1"}], ")"}], "/", "K"}], "]"}], "+", "1"}], 
    ",", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"index", "-", "1"}], ",", "K"}], "]"}], "+", "1"}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.798835727497355*^9, 3.798835765568118*^9}, {
  3.798835812586624*^9, 3.798835865476348*^9}, {3.7988359724171133`*^9, 
  3.798835973774198*^9}},
 CellLabel->
  "In[375]:=",ExpressionUUID->"2ba5ef51-8f0e-49b5-b1bc-f05ed3af265d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"inverseFisher", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[Alpha]_", ",", "n_", ",", 
    "mList_"}], "]"}], ":=", 
  RowBox[{"With", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"on11", "=", 
       RowBox[{"partial\[Alpha]\[Alpha]", "[", 
        RowBox[{"\[CapitalPhi]", ",", "\[Sigma]", ",", "\[Alpha]", ",", "n"}],
         "]"}]}], ",", 
      RowBox[{"on22", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"partialnn", "[", 
          RowBox[{
          "\[CapitalPhi]", ",", "\[Sigma]", ",", "\[Alpha]", ",", "n"}], 
          "]"}], "}"}], "}"}]}], ",", 
      RowBox[{"on33", "=", 
       RowBox[{"partial\[CapitalPhi]\[CapitalPhi]", "[", 
        RowBox[{
        "\[CapitalPhi]", ",", "\[Sigma]", ",", "\[Alpha]", ",", "n", ",", 
         "mList"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"off12", "=", 
       RowBox[{"Transpose", "@", 
        RowBox[{"{", 
         RowBox[{"partialn\[Alpha]", "[", 
          RowBox[{
          "\[CapitalPhi]", ",", "\[Sigma]", ",", "\[Alpha]", ",", "n"}], 
          "]"}], "}"}]}]}], ",", 
      RowBox[{"off13", "=", 
       RowBox[{"partial\[Alpha]\[CapitalPhi]", "[", 
        RowBox[{"\[CapitalPhi]", ",", "\[Sigma]", ",", "\[Alpha]", ",", "n"}],
         "]"}]}], ",", 
      RowBox[{"off23", "=", 
       RowBox[{"{", 
        RowBox[{"partialn\[CapitalPhi]", "[", 
         RowBox[{
         "\[CapitalPhi]", ",", "\[Sigma]", ",", "\[Alpha]", ",", "n"}], "]"}],
         "}"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Part", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"#", "+", 
           RowBox[{"Transpose", "[", "#", "]"}]}], ")"}], "/", "2"}], "&"}], 
       "@", 
       RowBox[{"Inverse", "[", 
        RowBox[{"ArrayFlatten", "[", 
         RowBox[{"(", "\[NoBreak]", GridBox[{
            {"on11", "off12", "off13"},
            {
             RowBox[{"Transpose", "[", "off12", "]"}], "on22", "off23"},
            {
             RowBox[{"Transpose", "[", "off13", "]"}], 
             RowBox[{"Transpose", "[", "off23", "]"}], "on33"}
           }], "\[NoBreak]", ")"}], "]"}], "]"}]}], ",", 
      RowBox[{";;", 
       RowBox[{
        RowBox[{"Length", "[", "\[Alpha]", "]"}], "+", "1"}]}], ",", 
      RowBox[{";;", 
       RowBox[{
        RowBox[{"Length", "[", "\[Alpha]", "]"}], "+", "1"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.798984378575254*^9, 3.798984498250423*^9}, {
  3.798989165941985*^9, 3.798989204092794*^9}, {3.798989247609078*^9, 
  3.798989326768261*^9}, {3.798989365104703*^9, 3.7989894240084457`*^9}, {
  3.79898946462446*^9, 3.7989895122093287`*^9}, {3.7989895863264427`*^9, 
  3.798989602108164*^9}, {3.798989647124687*^9, 3.798989675201201*^9}, {
  3.7989922669271517`*^9, 3.798992283609317*^9}, {3.798992323548151*^9, 
  3.7989923418677273`*^9}, {3.79899240534022*^9, 3.798992515486136*^9}, {
  3.798992578064859*^9, 3.798992579563142*^9}, {3.798992649457757*^9, 
  3.79899268552344*^9}, {3.798992784414838*^9, 3.798992784847994*^9}, {
  3.803501790478194*^9, 3.803501813895537*^9}},
 CellLabel->
  "In[376]:=",ExpressionUUID->"a0e59459-8ce2-4125-8246-494d3db09fc5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"crossProtocolFisherInformation", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[Alpha]_", ",", "\[CapitalPsi]_", ",", "n_", ",", 
    "\[Sigma]_", ",", "mlist_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"zScores", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[CapitalPhi]", ".", "\[Alpha]"}], "-", 
          RowBox[{"\[CapitalPsi]", "/", "n"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"mixture\[Sigma]", "[", 
            RowBox[{"\[Alpha]", ",", "\[Sigma]", ",", "\[CapitalPhi]"}], 
            "]"}], "/", "n"}], "]"}], ")"}]}]}], ",", "zTail", ",", 
      "filterLength", ",", "filter", ",", 
      RowBox[{"G", "=", 
       RowBox[{"Length", "@", "\[CapitalPsi]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"zTail", "=", 
      RowBox[{
       RowBox[{"Total", "[", 
        RowBox[{"zScores", "^", "2"}], "]"}], "-", "G"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"filterLength", "=", 
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"Ceiling", "[", 
         RowBox[{"500", "-", 
          RowBox[{"400", 
           RowBox[{
            RowBox[{"Max", "[", 
             RowBox[{"zTail", ",", "0"}], "]"}], "/", "50000"}]}]}], "]"}], 
        ",", "100"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"filter", "=", 
      RowBox[{"RandomSample", "[", 
       RowBox[{
        RowBox[{"Thread", "[", 
         RowBox[{"{", 
          RowBox[{"Range", "[", "G", "]"}], "}"}], "]"}], ",", 
        "filterLength"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"G", "<", "500"}], ",", 
       RowBox[{"filter", "=", 
        RowBox[{"Thread", "[", 
         RowBox[{"{", 
          RowBox[{"Range", "[", "G", "]"}], "}"}], "]"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Quiet", "@", 
      RowBox[{"inverseFisher", "[", 
       RowBox[{
        RowBox[{"Extract", "[", 
         RowBox[{"\[CapitalPhi]", ",", "filter"}], "]"}], ",", 
        RowBox[{
         RowBox[{"Extract", "[", 
          RowBox[{"\[Sigma]", ",", "filter"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"0", "|", "0."}], "\[Rule]", "1."}], "}"}]}], ",", 
        "\[Alpha]", ",", "n", ",", "mlist"}], "]"}]}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.8101640875596437`*^9, 3.810164095029632*^9}, {
  3.81016802701052*^9, 3.8101681605317793`*^9}, {3.810168230298622*^9, 
  3.81016827478564*^9}, {3.810168340241686*^9, 3.8101683940160017`*^9}, {
  3.810168566224972*^9, 3.810168566614192*^9}, {3.81016861128207*^9, 
  3.810168618964891*^9}, {3.810168690907851*^9, 3.8101686915427628`*^9}, {
  3.8101689259555483`*^9, 3.810168942459856*^9}},
 CellLabel->
  "In[377]:=",ExpressionUUID->"6f5bddc0-7576-435b-8375-ac3421198a61"]
}, Closed]],

Cell[CellGroupData[{

Cell["Empirical Fisher", "Subsection",
 CellChangeTimes->{{3.824951769658861*^9, 
  3.8249517734304028`*^9}},ExpressionUUID->"45a08b4a-c407-45c1-b774-\
902aea07aa95"],

Cell["\<\
Disregard this section of the code\[LongDash]it is not used in our final \
algorithm.\
\>", "Text",
 CellChangeTimes->{{3.831919625130333*^9, 3.831919644253488*^9}},
 FontSize->36,
 FontColor->RGBColor[
  1, 0, 0],ExpressionUUID->"36f10217-51c3-45ca-ab98-1ee4db54d15e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sampleFisher", "[", 
   RowBox[{
   "\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_", ",", 
    "n_", ",", "subsetSize_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"subset", "=", 
       RowBox[{"RandomSample", "[", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{"Length", "@", "y"}], "]"}], ",", "subsetSize"}], "]"}]}], 
      ",", 
      RowBox[{"K", "=", 
       RowBox[{"Length", "@", "\[Alpha]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Sqrt", "[", "subsetSize", "]"}], "*", 
     RowBox[{
      RowBox[{"Inverse", "[", 
       RowBox[{"\[Delta]\[Delta]\[ScriptL]xy", "[", 
        RowBox[{"\[Alpha]", ",", 
         RowBox[{
         "\[CapitalPhi]", "\[LeftDoubleBracket]", "subset", 
          "\[RightDoubleBracket]"}], ",", 
         RowBox[{
         "\[Sigma]2", "\[LeftDoubleBracket]", "subset", 
          "\[RightDoubleBracket]"}], ",", 
         RowBox[{
         "y", "\[LeftDoubleBracket]", "subset", "\[RightDoubleBracket]"}], 
         ",", "n"}], "]"}], "]"}], ".", 
      RowBox[{"\[Delta]\[ScriptL]xy", "[", 
       RowBox[{"\[Alpha]", ",", 
        RowBox[{
        "\[CapitalPhi]", "\[LeftDoubleBracket]", "subset", 
         "\[RightDoubleBracket]"}], ",", 
        RowBox[{
        "\[Sigma]2", "\[LeftDoubleBracket]", "subset", 
         "\[RightDoubleBracket]"}], ",", 
        RowBox[{
        "y", "\[LeftDoubleBracket]", "subset", "\[RightDoubleBracket]"}], ",",
         "n"}], "]"}]}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.824954185734478*^9, 3.824954294207768*^9}, {
   3.824954355433855*^9, 3.824954362336267*^9}, {3.8249544535720263`*^9, 
   3.824954456576972*^9}, {3.824954505607036*^9, 3.8249545070786867`*^9}, {
   3.8249879252310467`*^9, 3.824987969975069*^9}, {3.825013938183572*^9, 
   3.82501394035178*^9}, {3.8250282487876177`*^9, 3.825028353184141*^9}, 
   3.825028396939392*^9, {3.8250300070606537`*^9, 3.825030020485634*^9}},
 CellLabel->
  "In[378]:=",ExpressionUUID->"d9b5af77-bd42-43b6-b7da-0d675c7ecc48"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sampleFisherInvertible", "[", 
   RowBox[{
   "\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_", ",", 
    "n_", ",", "subsetSize_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"subset", "=", 
       RowBox[{"RandomSample", "[", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{"Length", "@", "y"}], "]"}], ",", "subsetSize"}], "]"}]}], 
      ",", 
      RowBox[{"K", "=", 
       RowBox[{"Length", "@", "\[Alpha]"}]}], ",", "\[CurlyEpsilon]", ",", 
      "tempMat", ",", "tempVec"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[CurlyEpsilon]", "=", 
      RowBox[{"Mean", "[", 
       RowBox[{"Flatten", "@", 
        RowBox[{
        "\[Sigma]2", "\[LeftDoubleBracket]", "subset", 
         "\[RightDoubleBracket]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"tempMat", "=", 
      RowBox[{"Inverse", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MemberQ", "[", 
            RowBox[{
             RowBox[{"Flatten", "@", "#"}], ",", "Indeterminate"}], "]"}], 
           ",", 
           RowBox[{"\[Delta]\[Delta]\[ScriptL]xy", "[", 
            RowBox[{"\[Alpha]", ",", 
             RowBox[{
              RowBox[{
              "\[CapitalPhi]", "\[LeftDoubleBracket]", "subset", 
               "\[RightDoubleBracket]"}], "+", 
              RowBox[{"RandomReal", "[", 
               RowBox[{
                RowBox[{"\[CurlyEpsilon]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Length", "@", "subset"}], ",", "K"}], "}"}]}], 
               "]"}]}], ",", 
             RowBox[{
             "\[Sigma]2", "\[LeftDoubleBracket]", "subset", 
              "\[RightDoubleBracket]"}], ",", 
             RowBox[{
             "y", "\[LeftDoubleBracket]", "subset", "\[RightDoubleBracket]"}],
              ",", "n"}], "]"}], ",", "#"}], "]"}], "&"}], "@", 
        RowBox[{"\[Delta]\[Delta]\[ScriptL]xy", "[", 
         RowBox[{"\[Alpha]", ",", 
          RowBox[{
          "\[CapitalPhi]", "\[LeftDoubleBracket]", "subset", 
           "\[RightDoubleBracket]"}], ",", 
          RowBox[{
          "\[Sigma]2", "\[LeftDoubleBracket]", "subset", 
           "\[RightDoubleBracket]"}], ",", 
          RowBox[{
          "y", "\[LeftDoubleBracket]", "subset", "\[RightDoubleBracket]"}], 
          ",", "n"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"tempVec", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{"#", ",", "Indeterminate"}], "]"}], ",", 
          RowBox[{"\[Delta]\[ScriptL]xy", "[", 
           RowBox[{"\[Alpha]", ",", 
            RowBox[{
             RowBox[{
             "\[CapitalPhi]", "\[LeftDoubleBracket]", "subset", 
              "\[RightDoubleBracket]"}], "+", 
             RowBox[{"RandomReal", "[", 
              RowBox[{
               RowBox[{"\[CurlyEpsilon]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Length", "@", "subset"}], ",", "K"}], "}"}]}], 
              "]"}]}], ",", 
            RowBox[{
            "\[Sigma]2", "\[LeftDoubleBracket]", "subset", 
             "\[RightDoubleBracket]"}], ",", 
            RowBox[{
            "y", "\[LeftDoubleBracket]", "subset", "\[RightDoubleBracket]"}], 
            ",", "n"}], "]"}], ",", "#"}], "]"}], "&"}], "@", 
       RowBox[{"\[Delta]\[ScriptL]xy", "[", 
        RowBox[{"\[Alpha]", ",", 
         RowBox[{
         "\[CapitalPhi]", "\[LeftDoubleBracket]", "subset", 
          "\[RightDoubleBracket]"}], ",", 
         RowBox[{
         "\[Sigma]2", "\[LeftDoubleBracket]", "subset", 
          "\[RightDoubleBracket]"}], ",", 
         RowBox[{
         "y", "\[LeftDoubleBracket]", "subset", "\[RightDoubleBracket]"}], 
         ",", "n"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Sqrt", "[", "subsetSize", "]"}], "*", 
      RowBox[{"tempMat", ".", "tempVec"}]}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.824954185734478*^9, 3.824954294207768*^9}, {
   3.824954355433855*^9, 3.824954362336267*^9}, {3.8249544535720263`*^9, 
   3.824954456576972*^9}, {3.824954505607036*^9, 3.8249545070786867`*^9}, {
   3.8249879252310467`*^9, 3.824987969975069*^9}, {3.825013938183572*^9, 
   3.82501394035178*^9}, {3.8250282487876177`*^9, 3.825028353184141*^9}, 
   3.825028396939392*^9, {3.8250300070606537`*^9, 3.8250301199141808`*^9}, {
   3.82503017709727*^9, 3.825030300201562*^9}, {3.8250303375112133`*^9, 
   3.82503034064504*^9}, {3.825030381374793*^9, 3.8250305006675367`*^9}, {
   3.8250305500847063`*^9, 3.825030552903743*^9}, {3.825030723852297*^9, 
   3.825031007106797*^9}, {3.825031911349455*^9, 3.825032067214829*^9}, {
   3.825032135251458*^9, 3.825032152615427*^9}, {3.825032228856411*^9, 
   3.825032236591525*^9}, {3.8250323463328447`*^9, 3.825032346886984*^9}, {
   3.8250324516679792`*^9, 3.825032462703977*^9}},
 CellLabel->
  "In[379]:=",ExpressionUUID->"c07b9096-a332-4bc1-a42c-62ccc450f3d7"],

Cell[CellGroupData[{

Cell["Primitives", "Subsubsection",
 CellChangeTimes->{{3.824952218802865*^9, 
  3.824952229074501*^9}},ExpressionUUID->"7ff3980e-10dd-4910-9bc2-\
b853f78c089d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]g2", "[", 
   RowBox[{"\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"\[Alpha]", ".", 
    RowBox[{"(", 
     RowBox[{"\[Sigma]2", "+", 
      RowBox[{"\[CapitalPhi]", "^", "2"}]}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Alpha]", ".", "\[CapitalPhi]"}], ")"}], "^", 
    "2"}]}]}]], "Input",
 CellChangeTimes->{{3.824951780270493*^9, 3.824951939652974*^9}},
 CellLabel->
  "In[380]:=",ExpressionUUID->"f2c19d27-973f-4189-9ff5-bde9d97d2665"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ryg2", "[", 
   RowBox[{"\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_"}],
    "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", ".", "\[CapitalPhi]"}], "-", "y"}], ")"}], "^", 
    "2"}], "/", 
   RowBox[{"\[Sigma]g2", "[", 
    RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.824951975337399*^9, 3.824952049597621*^9}},
 CellLabel->
  "In[381]:=",ExpressionUUID->"28f6ecfc-d183-49bd-9e30-1757f9af2b39"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptL]xy", "[", 
   RowBox[{
   "\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_", ",", 
    "n_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", "y", "]"}], "/", "2"}], "*", 
    RowBox[{"Log", "[", "n", "]"}]}], "+", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{"MapThread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ryg2", "[", 
          RowBox[{"\[Alpha]", ",", "#1", ",", "#2", ",", "#3"}], "]"}], "+", 
         RowBox[{"Log", "[", 
          RowBox[{"\[Sigma]g2", "[", 
           RowBox[{"\[Alpha]", ",", "#1", ",", "#2"}], "]"}], "]"}]}], "&"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "}"}]}], "]"}],
      "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "n"}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8249520744035587`*^9, 3.824952183556863*^9}, {
  3.824986842527278*^9, 3.824986906316201*^9}, {3.8249869924674883`*^9, 
  3.824987033031096*^9}, {3.824987141172998*^9, 3.8249871476578712`*^9}, {
  3.824987225767475*^9, 3.824987229352293*^9}},
 CellLabel->
  "In[382]:=",ExpressionUUID->"41a59fb3-3d05-4ec9-9387-6360163654f0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  SubscriptBox["\[Del]", "\[Alpha]"], TraditionalForm]],
 FormatType->
  TraditionalForm,ExpressionUUID->"146f579b-5e3d-47a5-ac47-ed7584821e0b"]], \
"Subsubsection",
 CellChangeTimes->{{3.824952235233971*^9, 
  3.824952240150926*^9}},ExpressionUUID->"92c4e22c-5d93-4cfb-b98f-\
76888935a3b8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]\[Sigma]g2", "[", 
   RowBox[{"\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_"}], "]"}], ":=", 
  RowBox[{"\[Sigma]2", "+", 
   RowBox[{"\[CapitalPhi]", "^", "2"}], "-", 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{"\[Alpha]", ".", "\[CapitalPhi]"}], ")"}], 
    "\[CapitalPhi]"}]}]}]], "Input",
 CellChangeTimes->{{3.8249529374615517`*^9, 3.824952946224794*^9}, {
  3.8249530964664*^9, 3.824953117657138*^9}},
 CellLabel->
  "In[383]:=",ExpressionUUID->"07f89cb4-86ce-4b44-afdd-68ef95eed46f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]ryg2", "[", 
   RowBox[{"\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_"}],
    "]"}], ":=", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Alpha]", ".", "\[CapitalPhi]"}], "-", "y"}], ")"}], "/", 
     RowBox[{"\[Sigma]g2", "[", 
      RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], "]"}]}], 
    "*", "\[CapitalPhi]"}], "-", 
   RowBox[{
    RowBox[{
     RowBox[{"ryg2", "[", 
      RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], 
      "]"}], "/", 
     RowBox[{"\[Sigma]g2", "[", 
      RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], "]"}]}], 
    "*", 
    RowBox[{"\[Delta]\[Sigma]g2", "[", 
     RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.824953446633917*^9, 3.824953536869417*^9}},
 CellLabel->
  "In[384]:=",ExpressionUUID->"fc77c83a-e31f-4f95-986b-d2e9c46583b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]\[ScriptL]xy", "[", 
   RowBox[{
   "\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_", ",", 
    "n_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{"MapThread", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"\[Delta]ryg2", "[", 
          RowBox[{"\[Alpha]", ",", "#1", ",", "#2", ",", "#3"}], "]"}], "/", 
         "n"}], "+", 
        RowBox[{
         RowBox[{"\[Delta]\[Sigma]g2", "[", 
          RowBox[{"\[Alpha]", ",", "#1", ",", "#2"}], "]"}], "/", 
         RowBox[{"\[Sigma]g2", "[", 
          RowBox[{"\[Alpha]", ",", "#1", ",", "#2"}], "]"}]}]}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "}"}]}], "]"}], 
    "]"}], "/", "2"}]}]], "Input",
 CellChangeTimes->{{3.8249537975601673`*^9, 3.824953893685485*^9}, {
  3.824987218642892*^9, 3.824987298059539*^9}},
 CellLabel->
  "In[385]:=",ExpressionUUID->"ba68bd77-830f-4720-9398-32ad714632dd"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["\[Del]", "\[Alpha]"], 
   RowBox[{"\[CircleTimes]", " ", 
    SubscriptBox["\[Del]", "\[Alpha]"]}]}], TraditionalForm]],
 FormatType->
  TraditionalForm,ExpressionUUID->"6f7fd10d-c3c3-4f2c-9ed0-ddced2670ab7"]], \
"Subsubsection",
 CellChangeTimes->{{3.8249526699774027`*^9, 3.824952679425359*^9}, {
  3.8249527306303988`*^9, 
  3.824952738173307*^9}},ExpressionUUID->"fc42b599-fe14-449e-a261-\
d45026219e6f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]\[Delta]\[Sigma]g2", "[", 
   RowBox[{"\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"-", "2"}], 
   RowBox[{"KroneckerProduct", "[", 
    RowBox[{"\[CapitalPhi]", ",", "\[CapitalPhi]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.824952244440214*^9, 3.824952257632311*^9}, {
  3.8249524613910418`*^9, 3.824952497216357*^9}, {3.8249530874989433`*^9, 
  3.824953087706654*^9}},
 CellLabel->
  "In[386]:=",ExpressionUUID->"9b7efb92-2e61-4d3c-a3c1-80706161d047"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]\[Delta]ryg2", "[", 
   RowBox[{"\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_"}],
    "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"\[Sigma]g2", "[", 
      RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], "]"}]}], 
    "*", 
    RowBox[{"KroneckerProduct", "[", 
     RowBox[{
      RowBox[{"\[CapitalPhi]", "-", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Alpha]", ".", "\[CapitalPhi]"}], "-", "y"}], ")"}], "/", 
         RowBox[{"\[Sigma]g2", "[", 
          RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
          "]"}]}], "*", 
        RowBox[{"\[Delta]\[Sigma]g2", "[", 
         RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
         "]"}]}]}], ",", "\[CapitalPhi]"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"\[Sigma]g2", "[", 
      RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], "]"}]}], 
    "*", 
    RowBox[{"KroneckerProduct", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Delta]ryg2", "[", 
        RowBox[{
        "\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "]"}],
        "-", 
       RowBox[{
        RowBox[{
         RowBox[{"ryg2", "[", 
          RowBox[{
          "\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], 
          "]"}], "/", 
         RowBox[{"\[Sigma]g2", "[", 
          RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
          "]"}]}], "*", 
        RowBox[{"\[Delta]\[Sigma]g2", "[", 
         RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
         "]"}]}]}], ",", 
      RowBox[{"\[Delta]\[Sigma]g2", "[", 
       RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], "]"}]}], 
     "]"}]}], "-", 
   RowBox[{
    RowBox[{
     RowBox[{"ryg2", "[", 
      RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], 
      "]"}], "/", 
     RowBox[{"\[Sigma]g2", "[", 
      RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], "]"}]}], 
    "*", 
    RowBox[{"\[Delta]\[Delta]\[Sigma]g2", "[", 
     RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8249525267179403`*^9, 3.8249526550098743`*^9}, {
  3.8249530530145807`*^9, 3.8249530904411297`*^9}, {3.82495359183899*^9, 
  3.824953592758421*^9}, {3.8249536408381023`*^9, 3.824953734808577*^9}, {
  3.8249537779572353`*^9, 3.824953778363873*^9}},
 CellLabel->
  "In[387]:=",ExpressionUUID->"a56338bc-7258-4d0c-9255-91cbeebf20e4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]\[Delta]\[ScriptL]xy", "[", 
   RowBox[{
   "\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_", ",", 
    "n_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{"MapThread", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"\[Delta]\[Delta]ryg2", "[", 
          RowBox[{"\[Alpha]", ",", "#1", ",", "#2", ",", "#3"}], "]"}], "/", 
         "n"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Delta]\[Delta]\[Sigma]g2", "[", 
           RowBox[{"\[Alpha]", ",", "#1", ",", "#2"}], "]"}], "/", 
          RowBox[{"\[Sigma]g2", "[", 
           RowBox[{"\[Alpha]", ",", "#1", ",", "#2"}], "]"}]}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"1", "/", 
            RowBox[{"\[Sigma]g2", "[", 
             RowBox[{"\[Alpha]", ",", "#1", ",", "#2"}], "]"}]}]}], ")"}]}]}],
        "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "}"}]}], "]"}], 
    "]"}], "/", "2"}]}]], "Input",
 CellChangeTimes->{{3.824953919928616*^9, 3.824953962904152*^9}, {
  3.824987807912941*^9, 3.824987878038625*^9}},
 CellLabel->
  "In[388]:=",ExpressionUUID->"1a4319e3-a49d-4f4f-afb0-1c682106bd3a"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Constrained Empirical Fisher", "Subsection",
 CellChangeTimes->{{3.8249891209772263`*^9, 3.824989122658031*^9}, {
  3.824989878023389*^9, 
  3.824989882124984*^9}},ExpressionUUID->"94d53c8a-05c9-42a4-8bf9-\
604707be2f12"],

Cell[CellGroupData[{

Cell["Primitives", "Subsubsection",
 CellChangeTimes->{{3.824952218802865*^9, 
  3.824952229074501*^9}},ExpressionUUID->"c35fd9e4-4f71-491a-874e-\
a9c7cba2b628"],

Cell["\<\
\[Sigma]g2\t\t\[LongDash]\t\tmixture variance (defined row-wise; that is, for \
each gene g at a time)
ryg2\t\t\[LongDash]\t\tsquared residual (defined row-wise too)
y\t\t\[LongDash]\t\tRHS (bulk vector; previously called \[CapitalPsi])
\[ScriptL]xy\t\t\[LongDash]\t\tlog-likelihood \[ScriptCapitalL] (don\
\[CloseCurlyQuote]t worry about the xy notation, it was supposed to help me \
organise individual terms in the final Godambe computation)\
\>", "Text",
 CellChangeTimes->{{3.8277737173946457`*^9, 3.827773774755725*^9}, {
  3.831920245842922*^9, 3.831920320277638*^9}, {3.8319205710699368`*^9, 
  3.831920624317855*^9}, {3.831920688143792*^9, 3.831920771158695*^9}, {
  3.831921445238886*^9, 
  3.831921446558646*^9}},ExpressionUUID->"9c6c8ee8-52a0-4cac-bd19-\
965602d9fde5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]g2", "[", 
   RowBox[{"\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"\[Alpha]", ".", 
    RowBox[{"(", 
     RowBox[{"\[Sigma]2", "+", 
      RowBox[{"\[CapitalPhi]", "^", "2"}]}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Alpha]", ".", "\[CapitalPhi]"}], ")"}], "^", 
    "2"}]}]}]], "Input",
 CellChangeTimes->{{3.824951780270493*^9, 3.824951939652974*^9}},
 CellLabel->
  "In[392]:=",ExpressionUUID->"b4650a71-770a-4fc3-8210-99974dcb5e46"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ryg2", "[", 
   RowBox[{"\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_"}],
    "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", ".", "\[CapitalPhi]"}], "-", "y"}], ")"}], "^", 
    "2"}], "/", 
   RowBox[{"\[Sigma]g2", "[", 
    RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.824951975337399*^9, 3.824952049597621*^9}},
 CellLabel->
  "In[393]:=",ExpressionUUID->"1247e2d3-7a13-4d8f-a6cf-f1f15ed4eee2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptL]xy", "[", 
   RowBox[{
   "\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_", ",", 
    "n_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", "y", "]"}], "/", "2"}], "*", 
    RowBox[{"Log", "[", "n", "]"}]}], "+", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{"MapThread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ryg2", "[", 
          RowBox[{"\[Alpha]", ",", "#1", ",", "#2", ",", "#3"}], "]"}], "+", 
         RowBox[{"Log", "[", 
          RowBox[{"\[Sigma]g2", "[", 
           RowBox[{"\[Alpha]", ",", "#1", ",", "#2"}], "]"}], "]"}]}], "&"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "}"}]}], "]"}],
      "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "n"}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8249520744035587`*^9, 3.824952183556863*^9}, {
  3.824986842527278*^9, 3.824986906316201*^9}, {3.8249869924674883`*^9, 
  3.824987033031096*^9}, {3.824987141172998*^9, 3.8249871476578712`*^9}, {
  3.824987225767475*^9, 3.824987229352293*^9}},
 CellLabel->
  "In[394]:=",ExpressionUUID->"46e29281-74d6-48ca-947e-fdaec325b0e6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  SubscriptBox["\[Del]", "\[Alpha]"], 
  TraditionalForm]],ExpressionUUID->"c9eb2053-d553-45e2-bacb-20d345c0e223"]], \
"Subsubsection",
 CellChangeTimes->{{3.824952235233971*^9, 
  3.824952240150926*^9}},ExpressionUUID->"f55a9972-47ce-4a26-9779-\
58858b91bee9"],

Cell[TextData[{
 "\[Alpha]-gradients of the quantities in the ",
 StyleBox["Primitives",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.5, 0.5]],
 " section (taking into account the simplex-constraint; i.e., gradients live \
in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", 
    RowBox[{"K", "-", "1"}]], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "319636ba-de8a-440c-abcd-f5c2bc32083d"],
 ")"
}], "Text",
 CellChangeTimes->{{3.8277737173946457`*^9, 3.827773774755725*^9}, {
  3.831920245842922*^9, 3.831920320277638*^9}, {3.831920406522241*^9, 
  3.831920448145237*^9}, {3.831922471579287*^9, 
  3.8319224941151943`*^9}},ExpressionUUID->"f9c22e47-ea4d-423d-8961-\
6997bedc3000"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]\[Sigma]g2", "[", 
   RowBox[{"\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"K", "=", 
      RowBox[{"Length", "@", "\[Alpha]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"Most", "[", "\[Sigma]2", "]"}], "+", 
     RowBox[{"Most", "[", 
      RowBox[{"\[CapitalPhi]", "^", "2"}], "]"}], "-", 
     RowBox[{"ConstantArray", "[", 
      RowBox[{
       RowBox[{"Last", "[", 
        RowBox[{"\[Sigma]2", "+", 
         RowBox[{"\[CapitalPhi]", "^", "2"}]}], "]"}], ",", 
       RowBox[{"K", "-", "1"}]}], "]"}], "-", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", ".", "\[CapitalPhi]"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Most", "[", "\[CapitalPhi]", "]"}], "-", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{
          RowBox[{"Last", "[", "\[CapitalPhi]", "]"}], ",", 
          RowBox[{"K", "-", "1"}]}], "]"}]}], ")"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8249529374615517`*^9, 3.824952946224794*^9}, {
  3.8249530964664*^9, 3.824953117657138*^9}, {3.824989909565195*^9, 
  3.824989991469665*^9}},
 CellLabel->
  "In[395]:=",ExpressionUUID->"5f746c88-9611-4372-86d7-cdb4cfec0770"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]ryg2", "[", 
   RowBox[{"\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_"}],
    "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"K", "=", 
      RowBox[{"Length", "@", "\[Alpha]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"2", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[Alpha]", ".", "\[CapitalPhi]"}], "-", "y"}], ")"}], "/", 
       RowBox[{"\[Sigma]g2", "[", 
        RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], "]"}]}],
       "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Most", "[", "\[CapitalPhi]", "]"}], "-", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{
          RowBox[{"Last", "@", "\[CapitalPhi]"}], ",", 
          RowBox[{"K", "-", "1"}]}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{
       RowBox[{"ryg2", "[", 
        RowBox[{
        "\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "]"}],
        "/", 
       RowBox[{"\[Sigma]g2", "[", 
        RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], "]"}]}],
       "*", 
      RowBox[{"\[Delta]\[Sigma]g2", "[", 
       RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
       "]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.824953446633917*^9, 3.824953536869417*^9}, {
  3.824990290354012*^9, 3.824990312022437*^9}},
 CellLabel->
  "In[396]:=",ExpressionUUID->"76f0661f-fe84-4eea-8303-53c2596835b7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]\[ScriptL]xy", "[", 
   RowBox[{
   "\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_", ",", 
    "n_"}], "]"}], ":=", 
  RowBox[{"Append", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"MapThread", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"\[Delta]ryg2", "[", 
            RowBox[{"\[Alpha]", ",", "#1", ",", "#2", ",", "#3"}], "]"}], "/",
            "n"}], "+", 
          RowBox[{
           RowBox[{"\[Delta]\[Sigma]g2", "[", 
            RowBox[{"\[Alpha]", ",", "#1", ",", "#2"}], "]"}], "/", 
           RowBox[{"\[Sigma]g2", "[", 
            RowBox[{"\[Alpha]", ",", "#1", ",", "#2"}], "]"}]}]}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "}"}]}], 
       "]"}], "]"}], "/", "2"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "y", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "n"}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"Total", "[", 
       RowBox[{"MapThread", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ryg2", "[", 
           RowBox[{"\[Alpha]", ",", "#1", ",", "#2", ",", "#3"}], "]"}], 
          "&"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "}"}]}], 
        "]"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", 
        RowBox[{"n", "^", "2"}]}], ")"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8249537975601673`*^9, 3.824953893685485*^9}, {
  3.824987218642892*^9, 3.824987298059539*^9}, {3.8249922441300583`*^9, 
  3.8249923299648333`*^9}, {3.824992362872621*^9, 3.8249923661991043`*^9}},
 CellLabel->
  "In[397]:=",ExpressionUUID->"8d024ab5-9690-4e67-8aa9-31203a124b99"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["\[Del]", "\[Alpha]"], 
   RowBox[{"\[CircleTimes]", " ", 
    SubscriptBox["\[Del]", "\[Alpha]"]}]}], 
  TraditionalForm]],ExpressionUUID->"0f8dbc28-ef6b-4c91-8b68-bd8cffc7ab16"]], \
"Subsubsection",
 CellChangeTimes->{{3.8249526699774027`*^9, 3.824952679425359*^9}, {
  3.8249527306303988`*^9, 
  3.824952738173307*^9}},ExpressionUUID->"be58c618-893d-4079-a3fc-\
7289921e8543"],

Cell[TextData[{
 "\[Alpha]-Hessians of the quantities in the ",
 StyleBox["Primitives",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.5, 0.5]],
 " section (taking into account the simplex-constraint; i.e., gradients live \
in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", 
    RowBox[{"K", "-", "1"}]], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "e8c4fbbc-a5ec-4b05-88c3-fda6f6908366"],
 ")"
}], "Text",
 CellChangeTimes->{{3.831920494160451*^9, 3.831920506486321*^9}, {
  3.831922498186613*^9, 
  3.831922498360093*^9}},ExpressionUUID->"ea831c3a-bcf6-45ca-8c8e-\
1c34473c2651"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]\[Delta]\[Sigma]g2", "[", 
   RowBox[{"\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"K", "=", 
      RowBox[{"Length", "@", "\[Alpha]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"KroneckerProduct", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Most", "[", "\[CapitalPhi]", "]"}], "-", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{
          RowBox[{"Last", "[", "\[CapitalPhi]", "]"}], ",", 
          RowBox[{"K", "-", "1"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Most", "[", "\[CapitalPhi]", "]"}], "-", 
        RowBox[{"ConstantArray", "[", 
         RowBox[{
          RowBox[{"Last", "[", "\[CapitalPhi]", "]"}], ",", 
          RowBox[{"K", "-", "1"}]}], "]"}]}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.824952244440214*^9, 3.824952257632311*^9}, {
  3.8249524613910418`*^9, 3.824952497216357*^9}, {3.8249530874989433`*^9, 
  3.824953087706654*^9}, {3.824990573147341*^9, 3.824990597414342*^9}},
 CellLabel->
  "In[398]:=",ExpressionUUID->"2c7d0b98-7ed5-4663-91ef-80e6503e71cd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]\[Delta]ryg2", "[", 
   RowBox[{"\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_"}],
    "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"K", "=", 
      RowBox[{"Length", "@", "\[Alpha]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "/", 
       RowBox[{"\[Sigma]g2", "[", 
        RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], "]"}]}],
       "*", 
      RowBox[{"KroneckerProduct", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Most", "[", "\[CapitalPhi]", "]"}], "-", 
         RowBox[{"ConstantArray", "[", 
          RowBox[{
           RowBox[{"Last", "@", "\[CapitalPhi]"}], ",", 
           RowBox[{"K", "-", "1"}]}], "]"}], "-", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Alpha]", ".", "\[CapitalPhi]"}], "-", "y"}], ")"}], 
           "/", 
           RowBox[{"\[Sigma]g2", "[", 
            RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
            "]"}]}], "*", 
          RowBox[{"\[Delta]\[Sigma]g2", "[", 
           RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
           "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"Most", "[", "\[CapitalPhi]", "]"}], "-", 
         RowBox[{"ConstantArray", "[", 
          RowBox[{
           RowBox[{"Last", "@", "\[CapitalPhi]"}], ",", 
           RowBox[{"K", "-", "1"}]}], "]"}]}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"\[Sigma]g2", "[", 
        RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], "]"}]}],
       "*", 
      RowBox[{"KroneckerProduct", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Delta]ryg2", "[", 
          RowBox[{
          "\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], 
          "]"}], "-", 
         RowBox[{
          RowBox[{
           RowBox[{"ryg2", "[", 
            RowBox[{
            "\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], 
            "]"}], "/", 
           RowBox[{"\[Sigma]g2", "[", 
            RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
            "]"}]}], "*", 
          RowBox[{"\[Delta]\[Sigma]g2", "[", 
           RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
           "]"}]}]}], ",", 
        RowBox[{"\[Delta]\[Sigma]g2", "[", 
         RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
         "]"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{
       RowBox[{"ryg2", "[", 
        RowBox[{
        "\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "]"}],
        "/", 
       RowBox[{"\[Sigma]g2", "[", 
        RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], "]"}]}],
       "*", 
      RowBox[{"\[Delta]\[Delta]\[Sigma]g2", "[", 
       RowBox[{"\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2"}], 
       "]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8249525267179403`*^9, 3.8249526550098743`*^9}, {
  3.8249530530145807`*^9, 3.8249530904411297`*^9}, {3.82495359183899*^9, 
  3.824953592758421*^9}, {3.8249536408381023`*^9, 3.824953734808577*^9}, {
  3.8249537779572353`*^9, 3.824953778363873*^9}, {3.824990887188272*^9, 
  3.824990889045027*^9}, {3.824991168842267*^9, 3.82499119473559*^9}},
 CellLabel->
  "In[399]:=",ExpressionUUID->"820ed86d-9d7e-48f4-9c58-78990c55a411"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]\[Delta]\[ScriptL]xy", "[", 
   RowBox[{
   "\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_", ",", 
    "n_"}], "]"}], ":=", 
  RowBox[{"With", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"finalRow", "=", 
       RowBox[{"Append", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Total", "[", 
            RowBox[{"MapThread", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"\[Delta]ryg2", "[", 
                RowBox[{"\[Alpha]", ",", "#1", ",", "#2", ",", "#3"}], "]"}], 
               "&"}], ",", 
              RowBox[{"{", 
               RowBox[{"\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "}"}]}],
              "]"}], "]"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"2", 
            RowBox[{"n", "^", "2"}]}], ")"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Length", "[", "y", "]"}]}], "/", 
           RowBox[{"(", 
            RowBox[{"2", 
             RowBox[{"n", "^", "2"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"Total", "[", 
            RowBox[{"MapThread", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"ryg2", "[", 
                RowBox[{"\[Alpha]", ",", "#1", ",", "#2", ",", "#3"}], "]"}], 
               "&"}], ",", 
              RowBox[{"{", 
               RowBox[{"\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "}"}]}],
              "]"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"n", "^", "3"}], ")"}]}]}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Alpha]Matrix", "=", 
       RowBox[{
        RowBox[{"Total", "[", 
         RowBox[{"MapThread", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"\[Delta]\[Delta]ryg2", "[", 
               RowBox[{"\[Alpha]", ",", "#1", ",", "#2", ",", "#3"}], "]"}], 
              "/", "n"}], "+", 
             RowBox[{
              RowBox[{
               RowBox[{"\[Delta]\[Delta]\[Sigma]g2", "[", 
                RowBox[{"\[Alpha]", ",", "#1", ",", "#2"}], "]"}], "/", 
               RowBox[{"\[Sigma]g2", "[", 
                RowBox[{"\[Alpha]", ",", "#1", ",", "#2"}], "]"}]}], "*", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"1", "/", 
                 RowBox[{"\[Sigma]g2", "[", 
                  RowBox[{"\[Alpha]", ",", "#1", ",", "#2"}], "]"}]}]}], 
               ")"}]}]}], "&"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "}"}]}], 
          "]"}], "]"}], "/", "2"}]}]}], "\[IndentingNewLine]", "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ArrayFlatten", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Alpha]Matrix", ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Most", "[", "finalRow", "]"}], "}"}], "\[Transpose]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Most", "[", "finalRow", "]"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"Last", "@", "finalRow"}], "}"}], "}"}]}], "}"}]}], "}"}], 
     "]"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.824953919928616*^9, 3.824953962904152*^9}, {
  3.824987807912941*^9, 3.824987878038625*^9}, {3.824992432922268*^9, 
  3.8249926542400637`*^9}, {3.8249928871072073`*^9, 3.8249929644928093`*^9}},
 CellLabel->
  "In[400]:=",ExpressionUUID->"7bd4db3e-fc5c-4828-9ff8-38eea6395f06"]
}, Closed]],

Cell[CellGroupData[{

Cell["Final Godambe Matrix", "Subsubsection",
 CellChangeTimes->{{3.831920187797299*^9, 
  3.8319201981053762`*^9}},ExpressionUUID->"a8b0cc82-2b04-4077-ae21-\
c3d6624ee6ce"],

Cell[TextData[{
 StyleBox["Remember that the general Fisher information \[ScriptCapitalI] is \
given by ",
  FontColor->GrayLevel[0.5]],
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalI]", "=", 
    SuperscriptBox[
     RowBox[{"[", 
      RowBox[{"\[DoubleStruckCapitalE]", 
       RowBox[{
        SubscriptBox["\[Del]", "\[Theta]"], 
        RowBox[{"\[CircleTimes]", 
         RowBox[{
          SubscriptBox["\[Del]", "\[Theta]"], "\[ScriptCapitalL]"}]}]}]}], 
      "]"}], 
     RowBox[{"-", "1"}]]}], TraditionalForm]],
  FormatType->TraditionalForm,
  FontColor->GrayLevel[0.5],ExpressionUUID->
  "ce389d7e-fd54-4360-92a4-4a48f1f670ef"],
 StyleBox[", where ",
  FontColor->GrayLevel[0.5]],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"[", 
     RowBox[{"\[DoubleStruckCapitalE]", 
      RowBox[{
       SubscriptBox["\[Del]", "\[Theta]"], 
       RowBox[{"\[CircleTimes]", 
        RowBox[{
         SubscriptBox["\[Del]", "\[Theta]"], "\[ScriptCapitalL]"}]}]}]}], 
     "]"}], 
    RowBox[{"-", "1"}]], TraditionalForm]],
  FontColor->GrayLevel[0.5],ExpressionUUID->
  "e3264f72-0968-454c-b0e0-6832edaeb3f9"],
 StyleBox[" is really just ",
  FontColor->GrayLevel[0.5]],
 Cell[BoxData[
  FormBox[
   RowBox[{"G", "=", " ", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"[", 
       RowBox[{"\[DoubleStruckCapitalE]", 
        RowBox[{
         SubscriptBox["\[Del]", "\[Theta]"], 
         RowBox[{"\[CircleTimes]", 
          RowBox[{
           SubscriptBox["\[Del]", "\[Theta]"], " ", 
           "\[ScriptCapitalL]"}]}]}]}], "]"}], 
      RowBox[{"-", "1"}]], "\[CenterDot]", 
     RowBox[{"Cov", "[", 
      RowBox[{"\[DoubleStruckCapitalE]", 
       RowBox[{
        SubscriptBox["\[Del]", "\[Theta]"], "\[ScriptCapitalL]"}]}], "]"}], 
     "\[CenterDot]", 
     SuperscriptBox[
      RowBox[{"[", 
       RowBox[{"\[DoubleStruckCapitalE]", 
        RowBox[{
         SubscriptBox["\[Del]", "\[Theta]"], 
         RowBox[{"\[CircleTimes]", 
          RowBox[{
           SubscriptBox["\[Del]", "\[Theta]"], " ", 
           "\[ScriptCapitalL]"}]}]}]}], "]"}], 
      RowBox[{"-", "t"}]]}]}], TraditionalForm]],
  FontColor->GrayLevel[0.5],ExpressionUUID->
  "d73e5fd2-1601-48e6-85fa-ad23ab892507"],
 StyleBox[", with the middle covariance simplifying to the Hessian. This \
simplification of ",
  FontColor->GrayLevel[0.5]],
 Cell[BoxData[
  FormBox["G", TraditionalForm]],
  FormatType->TraditionalForm,
  FontColor->GrayLevel[0.5],ExpressionUUID->
  "2b5edc82-8441-4192-9f34-d9d54dd2c13c"],
 StyleBox[" crucially depends on the assumption of correct model \
specification when performing MLE, which we may not necessarily have access \
to when deconvolving. However, ",
  FontColor->GrayLevel[0.5]],
 Cell[BoxData[
  FormBox["G", TraditionalForm]],
  FormatType->TraditionalForm,
  FontColor->GrayLevel[0.5],ExpressionUUID->
  "f9f03dea-4d89-42b7-acf5-52b1495cbe3e"],
 StyleBox[" itself is derived from a Taylor Expansion argument and therefore \
surprisingly robust\[LongDash]in particular, it holds under general model \
misspecification. Of course, if the model is misspecified, then obtaining \
closed-form expressions for the constituent matrices is difficult, with the \
next best resort being empirical approximations. The Godambe Matrix ",
  FontColor->GrayLevel[0.5]],
 Cell[BoxData[
  FormBox[
   OverscriptBox["G", "^"], TraditionalForm]],
  FormatType->TraditionalForm,
  FontColor->GrayLevel[0.5],ExpressionUUID->
  "03982e98-3807-440c-929a-8e4cbf4182f3"],
 StyleBox[" is exactly that: the empirical version of ",
  FontColor->GrayLevel[0.5]],
 Cell[BoxData[
  FormBox["G", TraditionalForm]],
  FormatType->TraditionalForm,
  FontColor->GrayLevel[0.5],ExpressionUUID->
  "811bd391-efdd-4903-b7a4-ba0f400bf4c6"],
 " ",
 StyleBox["(with the Hessian called the denominator and the Covariance matrix \
in the middle the enumerator).",
  FontColor->GrayLevel[0.5]],
 "\n\nsubsampledGodambe\t\t\[LongDash]\t\tGodambe matrix computed from only \
the gene indices given in the argument ",
 StyleBox["subsample ",
  FontSlant->"Italic"],
 "(in order to avoid numerical instabilities)",
 StyleBox["\n",
  FontSlant->"Italic"],
 "godambeInformation\t\t\[LongDash]\t\tFull Godambe Computation that defaults \
to sub-sampling the 300 worst offenders in case the resulting matrix is \
barely invertible\nsingleConfidences\t\t\t\[LongDash]\t\tExtract marginal \
confidence intervals from the diagonal entries of a covariance matrix"
}], "Text",
 CellChangeTimes->{{3.831920806815257*^9, 3.8319208265253687`*^9}, {
  3.83192114053608*^9, 3.8319211565548277`*^9}, {3.831921226860941*^9, 
  3.83192126760667*^9}, {3.831921351713645*^9, 3.831921417824807*^9}, {
  3.83192153937619*^9, 3.831921590170519*^9}, {3.831921620457348*^9, 
  3.8319216549364233`*^9}, {3.831921694310651*^9, 3.831921818485364*^9}, {
  3.831921861467317*^9, 3.8319224243908787`*^9}, {3.831922516437236*^9, 
  3.831922542778727*^9}},ExpressionUUID->"1756df61-0530-49ab-9e96-\
1f92ea10557d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"subsampledGodambe", "[", 
   RowBox[{
   "\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_", ",", 
    "n_", ",", "subsample_"}], "]"}], ":=", 
  RowBox[{"With", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"enumerator", "=", 
       RowBox[{"Covariance", "@", 
        RowBox[{"MapThread", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Delta]\[ScriptL]xy", "[", 
            RowBox[{"\[Alpha]", ",", 
             RowBox[{"{", "#1", "}"}], ",", 
             RowBox[{"{", "#2", "}"}], ",", 
             RowBox[{"{", "#3", "}"}], ",", "n"}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
            "\[CapitalPhi]", "\[LeftDoubleBracket]", "subsample", 
             "\[RightDoubleBracket]"}], ",", 
            RowBox[{
            "\[Sigma]2", "\[LeftDoubleBracket]", "subsample", 
             "\[RightDoubleBracket]"}], ",", 
            RowBox[{
            "y", "\[LeftDoubleBracket]", "subsample", 
             "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"denominator", "=", 
       RowBox[{"Mean", "@", 
        RowBox[{"MapThread", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Delta]\[Delta]\[ScriptL]xy", "[", 
            RowBox[{"\[Alpha]", ",", 
             RowBox[{"{", "#1", "}"}], ",", 
             RowBox[{"{", "#2", "}"}], ",", 
             RowBox[{"{", "#3", "}"}], ",", "n"}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
            "\[CapitalPhi]", "\[LeftDoubleBracket]", "subsample", 
             "\[RightDoubleBracket]"}], ",", 
            RowBox[{
            "\[Sigma]2", "\[LeftDoubleBracket]", "subsample", 
             "\[RightDoubleBracket]"}], ",", 
            RowBox[{
            "y", "\[LeftDoubleBracket]", "subsample", 
             "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}]}]}], 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Inverse", "[", "denominator", "]"}], ".", "enumerator", ".", 
     RowBox[{"Transpose", "[", 
      RowBox[{"Inverse", "@", "denominator"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.82836667624373*^9, 3.828366687977221*^9}, {
  3.828366873913094*^9, 3.828366909777089*^9}},
 CellLabel->
  "In[1027]:=",ExpressionUUID->"d278068a-8b40-4ae1-97c2-811b4cf58020"],

Cell[BoxData[
 RowBox[{
  RowBox[{"godambeInformation", "[", 
   RowBox[{
   "\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", "y_", ",", 
    "n_"}], "]"}], ":=", 
  RowBox[{"With", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"enumerator", "=", 
       RowBox[{"Covariance", "@", 
        RowBox[{"MapThread", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Delta]\[ScriptL]xy", "[", 
            RowBox[{"\[Alpha]", ",", 
             RowBox[{"{", "#1", "}"}], ",", 
             RowBox[{"{", "#2", "}"}], ",", 
             RowBox[{"{", "#3", "}"}], ",", "n"}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "}"}]}], 
         "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"denominator", "=", 
       RowBox[{"Mean", "@", 
        RowBox[{"MapThread", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Delta]\[Delta]\[ScriptL]xy", "[", 
            RowBox[{"\[Alpha]", ",", 
             RowBox[{"{", "#1", "}"}], ",", 
             RowBox[{"{", "#2", "}"}], ",", 
             RowBox[{"{", "#3", "}"}], ",", "n"}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[CapitalPhi]", ",", "\[Sigma]2", ",", "y"}], "}"}]}], 
         "]"}]}]}]}], "\[IndentingNewLine]", "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"First", "[", "#", "]"}], "/", 
           RowBox[{"Last", "[", "#", "]"}]}], "&"}], "@", 
         RowBox[{"Eigenvalues", "[", "denominator", "]"}]}], ")"}], "<", 
       RowBox[{"10", "^", "6"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Inverse", "[", "denominator", "]"}], ".", "enumerator", ".", 
       RowBox[{"Transpose", "[", 
        RowBox[{"Inverse", "@", "denominator"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"subsampledGodambe", "[", 
       RowBox[{
       "\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2", ",", "y", ",", "n",
         ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Flatten", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"#", ",", 
             RowBox[{"x_", "/;", 
              RowBox[{"x", ">", 
               RowBox[{"Quantile", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"1", "-", 
                  RowBox[{"300", "/", 
                   RowBox[{"Length", "[", "#", "]"}]}]}]}], "]"}]}]}]}], 
            "]"}], "]"}], "&"}], "@", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"y", "/", "n"}], "-", 
           RowBox[{"\[CapitalPhi]", ".", "\[Alpha]"}]}], ")"}]}]}], "]"}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",\

 CellChangeTimes->{{3.8251907809370337`*^9, 3.825190784011251*^9}, {
   3.825190820037283*^9, 3.825190833763513*^9}, {3.825190871593034*^9, 
   3.82519092393752*^9}, {3.8251910250502872`*^9, 3.8251911121618032`*^9}, {
   3.82519145005529*^9, 3.8251914680226097`*^9}, {3.828365999954062*^9, 
   3.828366002741596*^9}, {3.828366041102377*^9, 3.828366056950273*^9}, {
   3.828366091428505*^9, 3.828366139016857*^9}, {3.8283661749192743`*^9, 
   3.8283661788657513`*^9}, {3.828366316726181*^9, 3.8283663368511677`*^9}, 
   3.828366524497592*^9, {3.82836669592878*^9, 3.82836677896574*^9}, {
   3.828366917531559*^9, 3.828366956019245*^9}},
 CellLabel->
  "In[1028]:=",ExpressionUUID->"8fb770d1-8a68-4839-a4f3-3bca8f783b91"],

Cell[BoxData[
 RowBox[{
  RowBox[{"singleConfidences", "[", 
   RowBox[{"fisher_", ",", "G_"}], "]"}], ":=", 
  RowBox[{"2", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Append", "[", 
       RowBox[{
        RowBox[{"Diagonal", "@", "#"}], ",", 
        RowBox[{"Total", "[", 
         RowBox[{"#", ",", "2"}], "]"}]}], "]"}], "&"}], "@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"fisher", "\[LeftDoubleBracket]", 
        RowBox[{
         RowBox[{";;", 
          RowBox[{"-", "2"}]}], ",", 
         RowBox[{";;", 
          RowBox[{"-", "2"}]}]}], "\[RightDoubleBracket]"}], "/", "G"}], 
      ")"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.825038317473737*^9, 3.825038437401965*^9}, {
  3.825041331103017*^9, 3.825041333160363*^9}, {3.82504136462733*^9, 
  3.825041365502186*^9}},
 CellLabel->
  "In[391]:=",ExpressionUUID->"abd74979-7cb0-4e26-a510-c9ca049124cd"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Filtering", "Section",
 CellChangeTimes->{{3.798921573063904*^9, 
  3.798921573823341*^9}},ExpressionUUID->"0d39abcd-b1ce-4c9a-aab7-\
7927d77f847b"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Filtering based on worst case distance of ",
  FontSize->24],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["\[CapitalPsi]", "g"],
    FontSize->24], TraditionalForm]],ExpressionUUID->
  "0a3de3e3-5783-428e-a871-abfd488ebeb4"],
 " ",
 StyleBox["from [min ",
  FontSize->24],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["\[CapitalPhi]", "g"],
    FontSize->24], TraditionalForm]],ExpressionUUID->
  "b21c8530-f482-4a56-bf6d-4e32245fd7f6"],
 ", ",
 StyleBox["max ",
  FontSize->24],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["\[CapitalPhi]", "g"],
    FontSize->24], TraditionalForm]],ExpressionUUID->
  "91d5960f-6f08-4b95-899e-848ec66d5ee2"],
 StyleBox["] \[LongDash] by quantile and by absolute threshold",
  FontSize->24]
}], "Subsubsection",
 CellChangeTimes->{{3.7990729237543697`*^9, 
  3.799073073514289*^9}},ExpressionUUID->"b1f09e25-1fa0-45be-ad5b-\
b01300c1aa62"],

Cell[BoxData[
 RowBox[{
  RowBox[{"offSimplexDistances", "[", 
   RowBox[{"means_", ",", "variances_", ",", "bulk_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"max\[Sigma]", "=", 
       RowBox[{"Max", "/@", "variances"}]}], ",", 
      RowBox[{"min\[Mu]", "=", 
       RowBox[{"Min", "/@", "means"}]}], ",", 
      RowBox[{"max\[Mu]", "=", 
       RowBox[{"Max", "/@", "means"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    
    RowBox[{"(", 
     RowBox[{"Max", "/@", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Max", "[", 
             RowBox[{"#", ",", "0"}], "]"}], "&"}], "/@", 
           RowBox[{"(", 
            RowBox[{"min\[Mu]", "-", "bulk"}], ")"}]}], "/", "max\[Sigma]"}], 
         ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Max", "[", 
             RowBox[{"#", ",", "0"}], "]"}], "&"}], "/@", 
           RowBox[{"(", 
            RowBox[{"bulk", "-", "max\[Mu]"}], ")"}]}], "/", 
          "max\[Sigma]"}]}], "}"}], "]"}]}], ")"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.797880167077808*^9, 3.797880272373932*^9}, {
   3.7978803207952414`*^9, 3.79788048769551*^9}, {3.797880520607251*^9, 
   3.797880527828739*^9}, {3.797880705416991*^9, 3.7978807269443607`*^9}, {
   3.799160201297913*^9, 3.7991602056000843`*^9}, {3.799160327820794*^9, 
   3.7991603279462967`*^9}, 3.799160447416622*^9, 3.799160493975053*^9, {
   3.799161819562435*^9, 3.799161841191345*^9}, {3.799161908512467*^9, 
   3.799161913836462*^9}, {3.799162044435678*^9, 3.79916204556059*^9}, 
   3.799162137294132*^9, {3.799186013665752*^9, 3.7991860182852097`*^9}, {
   3.799186508602805*^9, 3.799186512343315*^9}},
 CellLabel->
  "In[401]:=",ExpressionUUID->"d0e3647a-82ce-4f6f-8be3-6bca79292e19"],

Cell[BoxData[
 RowBox[{
  RowBox[{"offSimplexFilter", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[CapitalPsi]_", ",", 
    "remainder_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", "=", 
      RowBox[{"\[ScriptCapitalS]", "/.", 
       RowBox[{"Quiet", "@", 
        RowBox[{
         RowBox[{"FindMinimum", "[", 
          RowBox[{
           RowBox[{"Median", "[", 
            RowBox[{"offSimplexDistances", "[", 
             RowBox[{"\[CapitalPhi]", ",", 
              RowBox[{"\[Sigma]", "/", "\[ScriptCapitalS]"}], ",", 
              RowBox[{"\[CapitalPsi]", "/", "\[ScriptCapitalS]"}]}], "]"}], 
            "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[ScriptCapitalS]", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"Total", "[", "#", "]"}], "&"}], "@", 
              RowBox[{"LeastSquares", "[", 
               RowBox[{"\[CapitalPhi]", ",", "\[CapitalPsi]"}], "]"}]}]}], 
            "}"}]}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Extract", "[", 
         RowBox[{"#", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Position", "[", 
             RowBox[{"#", ",", 
              RowBox[{"x_", "/;", 
               RowBox[{"x", "\[LessEqual]", 
                RowBox[{"Quantile", "[", 
                 RowBox[{"#", ",", 
                  RowBox[{"remainder", "/", 
                   RowBox[{"Length", "[", "#", "]"}]}]}], "]"}]}]}]}], "]"}], 
            "&"}], "@", 
           RowBox[{"offSimplexDistances", "[", 
            RowBox[{"\[CapitalPhi]", ",", 
             RowBox[{"\[Sigma]", "/", "n"}], ",", 
             RowBox[{"\[CapitalPsi]", "/", "n"}]}], "]"}]}]}], "]"}], "&"}], "/@", 
       RowBox[{"{", 
        RowBox[{"\[CapitalPhi]", ",", "\[Sigma]", ",", "\[CapitalPsi]"}], 
        "}"}]}]}], "}"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.798921729788087*^9, 3.798921934631469*^9}, {
  3.798924865010304*^9, 3.798924870993722*^9}, {3.798925147723168*^9, 
  3.798925150714046*^9}, {3.79892592826567*^9, 3.7989259307433653`*^9}, {
  3.7991599501529207`*^9, 3.7991599505489893`*^9}, {3.7991599979031057`*^9, 
  3.7991600195202503`*^9}, {3.799160105567596*^9, 3.799160187475341*^9}, {
  3.799160371921742*^9, 3.79916037250089*^9}, {3.799160629047678*^9, 
  3.799160629537446*^9}, {3.7998552547142572`*^9, 3.799855262009945*^9}, {
  3.800211490038476*^9, 3.800211524595992*^9}},
 CellLabel->
  "In[402]:=",ExpressionUUID->"33cbe71e-8a72-49f1-bf81-9ea0f2341513"],

Cell[BoxData[
 RowBox[{
  RowBox[{"offSimplexFilterAbsolute", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[CapitalPsi]_", ",", "p_"}], 
   "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", "=", 
      RowBox[{"\[ScriptCapitalS]", "/.", 
       RowBox[{"Quiet", "@", 
        RowBox[{
         RowBox[{"FindMinimum", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Median", "[", 
              RowBox[{"offSimplexDistances", "[", 
               RowBox[{"\[CapitalPhi]", ",", 
                RowBox[{"\[Sigma]", "/", "\[ScriptCapitalS]"}], ",", 
                RowBox[{"\[CapitalPsi]", "/", "\[ScriptCapitalS]"}]}], "]"}], 
              "]"}], ",", 
             RowBox[{"\[ScriptCapitalS]", ">", "0"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[ScriptCapitalS]", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"Total", "[", "#", "]"}], "&"}], "@", 
              RowBox[{"LeastSquares", "[", 
               RowBox[{"\[CapitalPhi]", ",", "\[CapitalPsi]"}], "]"}]}]}], 
            "}"}]}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Extract", "[", 
         RowBox[{"#", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Position", "[", 
             RowBox[{"#", ",", 
              RowBox[{"x_", "/;", 
               RowBox[{"x", "\[LessEqual]", "p"}]}]}], "]"}], "&"}], "@", 
           RowBox[{"offSimplexDistances", "[", 
            RowBox[{"\[CapitalPhi]", ",", 
             RowBox[{"\[Sigma]", "/", "n"}], ",", 
             RowBox[{"\[CapitalPsi]", "/", "n"}]}], "]"}]}]}], "]"}], "&"}], "/@", 
       RowBox[{"{", 
        RowBox[{"\[CapitalPhi]", ",", "\[Sigma]", ",", "\[CapitalPsi]"}], 
        "}"}]}]}], "}"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.798921729788087*^9, 3.798921934631469*^9}, {
  3.798924865010304*^9, 3.798924870993722*^9}, {3.798925147723168*^9, 
  3.798925174158847*^9}, {3.7989252569397573`*^9, 3.798925317050905*^9}, {
  3.798925919601294*^9, 3.798925921847313*^9}, {3.799160411354122*^9, 
  3.799160411928281*^9}, {3.799160451053602*^9, 3.799160467015869*^9}, {
  3.7991605049887543`*^9, 3.7991605121924477`*^9}, {3.7991606341403093`*^9, 
  3.799160634676412*^9}, {3.799187193756559*^9, 3.799187200553336*^9}, {
  3.800199379723089*^9, 3.800199392417778*^9}},
 CellLabel->
  "In[403]:=",ExpressionUUID->"dd9972de-bfa9-4946-9616-f151d21d6149"],

Cell[BoxData[
 RowBox[{
  RowBox[{"adjustVariances", "[", 
   RowBox[{
   "\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[CapitalPsi]_", ",", "p_"}], 
   "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", "=", 
      RowBox[{"\[ScriptCapitalS]", "/.", 
       RowBox[{"Quiet", "@", 
        RowBox[{
         RowBox[{"FindMinimum", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Median", "[", 
              RowBox[{"offSimplexDistances", "[", 
               RowBox[{"\[CapitalPhi]", ",", 
                RowBox[{"\[Sigma]", "/", "\[ScriptCapitalS]"}], ",", 
                RowBox[{"\[CapitalPsi]", "/", "\[ScriptCapitalS]"}]}], "]"}], 
              "]"}], ",", 
             RowBox[{"\[ScriptCapitalS]", ">", "0"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[ScriptCapitalS]", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"Total", "[", "#", "]"}], "&"}], "@", 
              RowBox[{"LeastSquares", "[", 
               RowBox[{"\[CapitalPhi]", ",", "\[CapitalPsi]"}], "]"}]}]}], 
            "}"}]}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"p", "*", "\[Sigma]", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"offSimplexDistances", "[", 
        RowBox[{"\[CapitalPhi]", ",", 
         RowBox[{"\[Sigma]", "/", "n"}], ",", 
         RowBox[{"\[CapitalPsi]", "/", "n"}]}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"0", "|", "0."}], "\[Rule]", "1."}], "}"}]}], ")"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.7990763117084923`*^9, 3.799076389021236*^9}, {
  3.799076460918159*^9, 3.799076461107795*^9}, {3.799162133406961*^9, 
  3.79916213383629*^9}, {3.799334899969604*^9, 3.799334906839274*^9}},
 CellLabel->
  "In[404]:=",ExpressionUUID->"0c0d59f5-a27c-4238-b4c1-d19e00d14ae8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"simpleFilter", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[CapitalPsi]_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"nonzero\[CapitalPhi]", "=", 
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{"Max", "/@", "\[CapitalPhi]"}], ",", 
         RowBox[{"x_", "/;", 
          RowBox[{"x", ">", "0"}]}]}], "]"}]}], ",", 
      RowBox[{"nonzero\[CapitalPsi]", "=", 
       RowBox[{"Position", "[", 
        RowBox[{"\[CapitalPsi]", ",", 
         RowBox[{"x_", "/;", 
          RowBox[{"x", ">", "0"}]}]}], "]"}]}]}], "}"}], ",", 
    RowBox[{"Intersection", "[", 
     RowBox[{"nonzero\[CapitalPhi]", ",", "nonzero\[CapitalPsi]"}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.805992195920175*^9, 3.805992279707156*^9}},
 CellLabel->
  "In[405]:=",ExpressionUUID->"5762f635-8e12-41e4-9534-da882973a04e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Empirical Protocol Filters",
 FontSize->24]], "Subsubsection",
 CellChangeTimes->{{3.801431833320158*^9, 
  3.801431843607936*^9}},ExpressionUUID->"fa8c62a1-562e-4ca4-aa66-\
2891288cb2c6"],

Cell[TextData[{
 "Filter a gene g based on its (one-sided) distance (in units of median \
deviations) from the median of the following key statistics:\n\t\n\t1. max ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    RowBox[{"{", 
     FractionBox[
      SubsuperscriptBox["\[Sigma]", 
       RowBox[{"g", ",", "k"}], "2"], 
      SubscriptBox["\[CapitalPhi]", 
       RowBox[{"g", ",", "k"}]]], "}"}], 
    RowBox[{"k", "\[Element]", 
     RowBox[{"[", "K", "]"}]}]], TraditionalForm]],ExpressionUUID->
  "17745775-f06b-4799-8b66-40777d8d6e13"],
 "\n\t2. min ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    RowBox[{"{", 
     FractionBox[
      SubscriptBox["\[CapitalPsi]", "g"], 
      SubscriptBox["\[CapitalPhi]", 
       RowBox[{"g", ",", "k"}]]], "}"}], 
    RowBox[{"k", "\[Element]", 
     RowBox[{"[", "K", "]"}]}]], TraditionalForm]],ExpressionUUID->
  "3beab77b-a612-4dad-b0cc-19a9c83835a7"],
 "\n\nIndividual thresholds (given by thresholdrule and iterationrule) are \
based on empirical trends in thirteen tissues of the Tabula Muris dataset "
}], "Text",
 CellChangeTimes->{{3.801432192565358*^9, 3.801432491000873*^9}, {
  3.8014326053045053`*^9, 3.801432642408617*^9}, {3.8014328267712803`*^9, 
  3.8014328483115597`*^9}, {3.8014329556133327`*^9, 3.801432964692031*^9}, {
  3.802910971297696*^9, 3.802911001526775*^9}},
 FontSize->24,ExpressionUUID->"5b750651-5ce6-487a-9eab-34e6c3d41618"],

Cell["\[Bullet] F/D Filtering Helper Functions", "Text",
 CellChangeTimes->{{3.801448268677129*^9, 3.801448278218871*^9}},
 FontSize->24,ExpressionUUID->"28cce0e1-ddc0-4a15-a167-bb40f5fdbcc8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fdfilter", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[CapitalPsi]_", ",", 
    RowBox[{"mdplus_", ":", "0"}], ",", 
    RowBox[{"mdminus_", ":", "Infinity"}], ",", 
    RowBox[{"extraratio_", ":", "0"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Sigma]\[CapitalPhi]ratios", "=", 
       RowBox[{"Max", "/@", 
        RowBox[{"(", 
         RowBox[{"\[Sigma]", "/", 
          RowBox[{"(", 
           RowBox[{"\[CapitalPhi]", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"0", "|", "0."}], "\[Rule]", 
              RowBox[{"10", "^", 
               RowBox[{"(", 
                RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ")"}]}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\[CapitalPsi]\[CapitalPhi]ratios", "=", 
       RowBox[{"Min", "/@", 
        RowBox[{"(", 
         RowBox[{"\[CapitalPsi]", "/", 
          RowBox[{"(", 
           RowBox[{"\[CapitalPhi]", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"0", "|", "0."}], "\[Rule]", 
              RowBox[{"10", "^", 
               RowBox[{"(", 
                RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ")"}]}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"nonzeros", "=", 
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{"Max", "/@", "\[CapitalPhi]"}], ",", 
         RowBox[{"x_", "/;", 
          RowBox[{"x", ">", "0."}]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"\[CapitalPhi]m", "=", 
       RowBox[{"Median", "[", 
        RowBox[{"Max", "/@", "\[CapitalPhi]"}], "]"}]}], ",", 
      RowBox[{"\[CapitalPhi]md", "=", 
       RowBox[{"MedianDeviation", "[", 
        RowBox[{"Max", "/@", "\[CapitalPhi]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Sigma]m", "=", 
       RowBox[{"Median", "[", 
        RowBox[{"Max", "/@", "\[Sigma]"}], "]"}]}], ",", 
      RowBox[{"\[Sigma]md", "=", 
       RowBox[{"MedianDeviation", "[", 
        RowBox[{"Max", "/@", "\[Sigma]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Sigma]\[CapitalPhi]m", "=", 
       RowBox[{"Median", "[", 
        RowBox[{"Max", "/@", 
         RowBox[{"(", 
          RowBox[{"\[Sigma]", "/", 
           RowBox[{"(", 
            RowBox[{"\[CapitalPhi]", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0", "|", "0."}], "\[Rule]", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ")"}]}], 
        "]"}]}], ",", 
      RowBox[{"\[Sigma]\[CapitalPhi]md", "=", 
       RowBox[{"MedianDeviation", "[", 
        RowBox[{"Max", "/@", 
         RowBox[{"(", 
          RowBox[{"\[Sigma]", "/", 
           RowBox[{"(", 
            RowBox[{"\[CapitalPhi]", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0", "|", "0."}], "\[Rule]", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ")"}]}], 
        "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"\[CapitalPsi]\[CapitalPhi]m", "=", 
       RowBox[{"Median", "[", 
        RowBox[{"Min", "/@", 
         RowBox[{"(", 
          RowBox[{"\[CapitalPsi]", "/", 
           RowBox[{"(", 
            RowBox[{"\[CapitalPhi]", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0", "|", "0."}], "\[Rule]", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ")"}]}], 
        "]"}]}], ",", 
      RowBox[{"\[CapitalPsi]\[CapitalPhi]md", "=", 
       RowBox[{"MedianDeviation", "[", 
        RowBox[{"Min", "/@", 
         RowBox[{"(", 
          RowBox[{"\[CapitalPsi]", "/", 
           RowBox[{"(", 
            RowBox[{"\[CapitalPhi]", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0", "|", "0."}], "\[Rule]", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ")"}]}], 
        "]"}]}]}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Intersection", "[", "\[IndentingNewLine]", 
     RowBox[{"nonzeros", ",", "\[IndentingNewLine]", 
      RowBox[{"Position", "[", 
       RowBox[{"\[CapitalPsi]", ",", 
        RowBox[{"x_", "/;", 
         RowBox[{"x", ">", "0."}]}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"Max", "/@", "\[CapitalPhi]"}], ",", 
        RowBox[{"x_", "/;", 
         RowBox[{
          RowBox[{"\[CapitalPhi]m", "-", 
           RowBox[{"\[CapitalPhi]md", "*", "mdminus"}]}], "\[LessEqual]", "x",
           "\[LessEqual]", 
          RowBox[{"\[CapitalPhi]m", "+", 
           RowBox[{"\[CapitalPhi]md", "*", "mdplus"}]}]}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"Max", "/@", "\[Sigma]"}], ",", 
        RowBox[{"x_", "/;", 
         RowBox[{
          RowBox[{"\[Sigma]m", "-", 
           RowBox[{"\[Sigma]md", "*", "mdminus"}]}], "\[LessEqual]", "x", 
          "\[LessEqual]", 
          RowBox[{"\[Sigma]m", "+", 
           RowBox[{"\[Sigma]md", "*", "mdplus"}]}]}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Position", "[", 
       RowBox[{"\[Sigma]\[CapitalPhi]ratios", ",", 
        RowBox[{"x_", "/;", 
         RowBox[{
          RowBox[{"\[Sigma]\[CapitalPhi]m", "-", 
           RowBox[{"\[Sigma]\[CapitalPhi]md", "*", "mdminus"}]}], 
          "\[LessEqual]", "x", "\[LessEqual]", 
          RowBox[{"\[Sigma]\[CapitalPhi]m", "+", 
           RowBox[{"\[Sigma]\[CapitalPhi]md", "*", "mdplus"}]}]}]}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Position", "[", 
       RowBox[{"\[CapitalPsi]\[CapitalPhi]ratios", ",", 
        RowBox[{"x_", "/;", 
         RowBox[{
          RowBox[{"\[CapitalPsi]\[CapitalPhi]m", "-", 
           RowBox[{"\[CapitalPsi]\[CapitalPhi]md", "*", "Infinity"}]}], 
          "\[LessEqual]", "x", "\[LessEqual]", 
          RowBox[{"\[CapitalPsi]\[CapitalPhi]m", "+", 
           RowBox[{"\[CapitalPsi]\[CapitalPhi]md", "*", "mdplus"}]}]}]}]}], 
       "]"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.800194798574263*^9, 3.800194882420979*^9}, {
   3.800195137546957*^9, 3.80019531948384*^9}, {3.800195389342311*^9, 
   3.800195755257802*^9}, {3.80028663629587*^9, 3.800286684477149*^9}, 
   3.800303557568157*^9, {3.8005626528109837`*^9, 3.800562655512665*^9}, {
   3.800565910197156*^9, 3.800565912570269*^9}, {3.800582525175181*^9, 
   3.8005825253041983`*^9}, {3.800622271393004*^9, 3.800622271496986*^9}, {
   3.800634016804824*^9, 3.800634016918963*^9}, {3.80064555132362*^9, 
   3.8006455518944397`*^9}, {3.800714858227407*^9, 3.8007148583454523`*^9}, {
   3.8007149251943693`*^9, 3.800714925296434*^9}, {3.800715054277629*^9, 
   3.8007150644042473`*^9}, 3.800715378182168*^9, {3.80072010589608*^9, 
   3.800720136861999*^9}, {3.8007388995362186`*^9, 3.8007388996658916`*^9}, 
   3.8007544661784277`*^9, {3.800818048726824*^9, 3.8008180488541403`*^9}, {
   3.800818144853859*^9, 3.800818167614327*^9}, {3.8009971429584513`*^9, 
   3.800997161517346*^9}, {3.800997197258657*^9, 3.8009971988348207`*^9}, {
   3.80246421088437*^9, 3.80246422509225*^9}, {3.802464514119776*^9, 
   3.8024645172478437`*^9}, {3.802464569726473*^9, 3.802464572031472*^9}, {
   3.8024646200930862`*^9, 3.802464625252016*^9}, {3.802881367946455*^9, 
   3.80288136856709*^9}},
 CellLabel->
  "In[406]:=",ExpressionUUID->"ef2b9554-59dc-4cae-b0c7-98ab0ae87340"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fdthresholdrule", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[CapitalPsi]_"}], "]"}],
   ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalPsi]\[CapitalPhi]ratios", "=", 
      RowBox[{"Min", "/@", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\[CapitalPsi]", "/", 
          RowBox[{"(", 
           RowBox[{"\[CapitalPhi]", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"0", "|", "0."}], "\[Rule]", 
              RowBox[{"10", "^", 
               RowBox[{"(", 
                RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ",", 
         RowBox[{"Intersection", "[", 
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{
             RowBox[{"Max", "/@", "\[CapitalPhi]"}], ",", 
             RowBox[{"_", "?", "Positive"}]}], "]"}], ",", 
           RowBox[{"Position", "[", 
            RowBox[{"\[CapitalPsi]", ",", 
             RowBox[{"_", "?", "Positive"}]}], "]"}]}], "]"}]}], "]"}]}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"MedianDeviation", "[", "#", "]"}], "/", 
            RowBox[{"Median", "[", "#", "]"}]}], "<", "0.55"}], ")"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Skewness", "[", "#", "]"}], "<", "105"}], ")"}]}], ",", 
        "1", ",", "5"}], "]"}], "&"}], "@", 
     "\[CapitalPsi]\[CapitalPhi]ratios"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.802564953268614*^9, 3.8025649942952833`*^9}, {
  3.8025650256833572`*^9, 3.80256513555665*^9}, {3.8025652834925213`*^9, 
  3.8025653541941977`*^9}, {3.802565481696897*^9, 3.80256548897386*^9}, {
  3.8025670656360064`*^9, 3.802567065673582*^9}, {3.802567366393187*^9, 
  3.802567374863538*^9}},
 CellLabel->
  "In[407]:=",ExpressionUUID->"88197535-b6bd-4f69-afb9-9f37cdefb1b7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fditerationrule", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[CapitalPsi]_"}], "]"}],
   ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"\[CapitalPsi]\[CapitalPhi]ratios", "=", 
      RowBox[{"Min", "/@", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\[CapitalPsi]", "/", 
          RowBox[{"(", 
           RowBox[{"\[CapitalPhi]", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"0", "|", "0."}], "\[Rule]", 
              RowBox[{"10", "^", 
               RowBox[{"(", 
                RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ",", 
         RowBox[{"Intersection", "[", 
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{
             RowBox[{"Max", "/@", "\[CapitalPhi]"}], ",", 
             RowBox[{"_", "?", "Positive"}]}], "]"}], ",", 
           RowBox[{"Position", "[", 
            RowBox[{"\[CapitalPsi]", ",", 
             RowBox[{"_", "?", "Positive"}]}], "]"}]}], "]"}]}], "]"}]}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"0.52", "<", 
           RowBox[{
            RowBox[{"MedianDeviation", "[", "#", "]"}], "/", 
            RowBox[{"Median", "[", "#", "]"}]}], "<", "0.7"}], ")"}], "||", 
         RowBox[{"(", 
          RowBox[{".06", "<", 
           RowBox[{
            RowBox[{"Quantile", "[", 
             RowBox[{"#", ",", "0.05"}], "]"}], "/", 
            RowBox[{"Median", "[", "#", "]"}]}], "<", "0.18"}], ")"}]}], ",", 
        "1", ",", "2"}], "]"}], "&"}], "@", 
     "\[CapitalPsi]\[CapitalPhi]ratios"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.802567066749825*^9, 3.802567123560363*^9}, {
  3.8025671582549763`*^9, 3.8025672628156776`*^9}, {3.80256729772818*^9, 
  3.802567311175599*^9}, {3.802567380810164*^9, 3.802567381391512*^9}},
 CellLabel->
  "In[408]:=",ExpressionUUID->"92c0d271-a07b-4de6-8368-77ff937ca27b"],

Cell["\<\
\[Bullet] Final F/D Filtering (note: iterations is to be fed as maxIter into \
findMixture)\
\>", "Text",
 CellChangeTimes->{{3.801448241619253*^9, 3.801448260034318*^9}, {
  3.802911096589787*^9, 3.802911137563588*^9}},
 FontSize->24,ExpressionUUID->"1c41e540-8c76-46d2-a9ca-60019a2730b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"filterFD", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[CapitalPsi]_"}], "]"}],
   ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"threshold", "=", 
       RowBox[{"fdthresholdrule", "[", 
        RowBox[{"\[CapitalPhi]", ",", "\[Sigma]", ",", "\[CapitalPsi]"}], 
        "]"}]}], ",", 
      RowBox[{"iterations", "=", 
       RowBox[{"fditerationrule", "[", 
        RowBox[{"\[CapitalPhi]", ",", "\[Sigma]", ",", "\[CapitalPsi]"}], 
        "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"iterations", ",", 
      RowBox[{"fdfilter", "[", 
       RowBox[{
       "\[CapitalPhi]", ",", "\[Sigma]", ",", "\[CapitalPsi]", ",", 
        "threshold", ",", "3"}], "]"}]}], "}"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8009964581571693`*^9, 3.800996479703453*^9}, {
   3.800997022878271*^9, 3.800997092272047*^9}, {3.800997224294456*^9, 
   3.80099731205715*^9}, {3.80099740162288*^9, 3.800997413880601*^9}, {
   3.802567451050705*^9, 3.802567510872313*^9}, 3.8028812573781013`*^9},
 CellLabel->
  "In[409]:=",ExpressionUUID->"9e3d11fd-64d0-4657-afbf-7c28c428a839"],

Cell["\[Bullet] D/F Filtering Helper Functions", "Text",
 CellChangeTimes->{{3.801448268677129*^9, 3.801448286866086*^9}},
 FontSize->24,ExpressionUUID->"1fe0daaa-bfea-42c8-a5d1-b79994800910"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dffilter", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[CapitalPsi]_", ",", 
    RowBox[{"mdplus_", ":", "0"}], ",", 
    RowBox[{"mdminus_", ":", "Infinity"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Sigma]\[CapitalPhi]ratios", "=", 
       RowBox[{"Max", "/@", 
        RowBox[{"(", 
         RowBox[{"\[Sigma]", "/", 
          RowBox[{"(", 
           RowBox[{"\[CapitalPhi]", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"0", "|", "0."}], "\[Rule]", 
              RowBox[{"10", "^", 
               RowBox[{"(", 
                RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ")"}]}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"\[CapitalPsi]\[CapitalPhi]ratios", "=", 
       RowBox[{"Min", "/@", 
        RowBox[{"(", 
         RowBox[{"\[CapitalPsi]", "/", 
          RowBox[{"(", 
           RowBox[{"\[CapitalPhi]", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"0", "|", "0."}], "\[Rule]", 
              RowBox[{"10", "^", 
               RowBox[{"(", 
                RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ")"}]}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"nonzeros", "=", 
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{"Max", "/@", "\[CapitalPhi]"}], ",", 
         RowBox[{"x_", "/;", 
          RowBox[{"x", ">", "0."}]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"\[CapitalPhi]m", "=", 
       RowBox[{"Median", "[", 
        RowBox[{"Max", "/@", "\[CapitalPhi]"}], "]"}]}], ",", 
      RowBox[{"\[CapitalPhi]md", "=", 
       RowBox[{"MedianDeviation", "[", 
        RowBox[{"Max", "/@", "\[CapitalPhi]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Sigma]m", "=", 
       RowBox[{"Median", "[", 
        RowBox[{"Max", "/@", "\[Sigma]"}], "]"}]}], ",", 
      RowBox[{"\[Sigma]md", "=", 
       RowBox[{"MedianDeviation", "[", 
        RowBox[{"Max", "/@", "\[Sigma]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Sigma]\[CapitalPhi]m", "=", 
       RowBox[{"Median", "[", 
        RowBox[{"Max", "/@", 
         RowBox[{"(", 
          RowBox[{"\[Sigma]", "/", 
           RowBox[{"(", 
            RowBox[{"\[CapitalPhi]", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0", "|", "0."}], "\[Rule]", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ")"}]}], 
        "]"}]}], ",", 
      RowBox[{"\[Sigma]\[CapitalPhi]md", "=", 
       RowBox[{"MedianDeviation", "[", 
        RowBox[{"Max", "/@", 
         RowBox[{"(", 
          RowBox[{"\[Sigma]", "/", 
           RowBox[{"(", 
            RowBox[{"\[CapitalPhi]", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0", "|", "0."}], "\[Rule]", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ")"}]}], 
        "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"\[CapitalPsi]\[CapitalPhi]m", "=", 
       RowBox[{"Median", "[", 
        RowBox[{"Min", "/@", 
         RowBox[{"(", 
          RowBox[{"\[CapitalPsi]", "/", 
           RowBox[{"(", 
            RowBox[{"\[CapitalPhi]", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0", "|", "0."}], "\[Rule]", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ")"}]}], 
        "]"}]}], ",", 
      RowBox[{"\[CapitalPsi]\[CapitalPhi]md", "=", 
       RowBox[{"MedianDeviation", "[", 
        RowBox[{"Min", "/@", 
         RowBox[{"(", 
          RowBox[{"\[CapitalPsi]", "/", 
           RowBox[{"(", 
            RowBox[{"\[CapitalPhi]", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0", "|", "0."}], "\[Rule]", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ")"}]}], 
        "]"}]}]}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Intersection", "[", "\[IndentingNewLine]", 
     RowBox[{"nonzeros", ",", "\[IndentingNewLine]", 
      RowBox[{"Position", "[", 
       RowBox[{"\[CapitalPsi]", ",", 
        RowBox[{"x_", "/;", 
         RowBox[{"x", ">", "0."}]}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"Max", "/@", "\[CapitalPhi]"}], ",", 
        RowBox[{"x_", "/;", 
         RowBox[{
          RowBox[{"\[CapitalPhi]m", "-", 
           RowBox[{"\[CapitalPhi]md", "*", "mdminus"}]}], "\[LessEqual]", "x",
           "\[LessEqual]", 
          RowBox[{"\[CapitalPhi]m", "+", 
           RowBox[{"\[CapitalPhi]md", "*", "mdplus"}]}]}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"Max", "/@", "\[Sigma]"}], ",", 
        RowBox[{"x_", "/;", 
         RowBox[{
          RowBox[{"\[Sigma]m", "-", 
           RowBox[{"\[Sigma]md", "*", "mdminus"}]}], "\[LessEqual]", "x", 
          "\[LessEqual]", 
          RowBox[{"\[Sigma]m", "+", 
           RowBox[{"\[Sigma]md", "*", "mdplus"}]}]}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Position", "[", 
       RowBox[{"\[Sigma]\[CapitalPhi]ratios", ",", 
        RowBox[{"x_", "/;", 
         RowBox[{
          RowBox[{"\[Sigma]\[CapitalPhi]m", "-", 
           RowBox[{"\[Sigma]\[CapitalPhi]md", "*", "mdminus"}]}], 
          "\[LessEqual]", "x", "\[LessEqual]", 
          RowBox[{"\[Sigma]\[CapitalPhi]m", "+", 
           RowBox[{"\[Sigma]\[CapitalPhi]md", "*", "mdplus"}]}]}]}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Position", "[", 
       RowBox[{"\[CapitalPsi]\[CapitalPhi]ratios", ",", 
        RowBox[{"x_", "/;", 
         RowBox[{
          RowBox[{"\[CapitalPsi]\[CapitalPhi]m", "-", 
           RowBox[{"\[CapitalPsi]\[CapitalPhi]md", "*", "mdminus"}]}], 
          "\[LessEqual]", "x", "\[LessEqual]", 
          RowBox[{"\[CapitalPsi]\[CapitalPhi]m", "+", 
           RowBox[{"\[CapitalPsi]\[CapitalPhi]md", "*", "mdplus"}]}]}]}]}], 
       "]"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.800194798574263*^9, 3.800194882420979*^9}, {
  3.800195137546957*^9, 3.80019531948384*^9}, {3.800195389342311*^9, 
  3.800195755257802*^9}, {3.8002791696847982`*^9, 3.800279170102626*^9}, {
  3.800279229788872*^9, 3.800279247846711*^9}, {3.8002866967826967`*^9, 
  3.800286769234771*^9}, {3.8002869042029057`*^9, 3.80028693726252*^9}, {
  3.80028760587153*^9, 3.8002876173147*^9}, {3.8002876619499607`*^9, 
  3.8002876656361113`*^9}, {3.802620692485944*^9, 3.802620693309271*^9}, {
  3.802620827936275*^9, 3.802620828850202*^9}, {3.802631076089779*^9, 
  3.8026310775427094`*^9}, {3.802631967655799*^9, 3.802631968333187*^9}, {
  3.802633568759489*^9, 3.802633570159492*^9}, {3.802633868380481*^9, 
  3.802633868901029*^9}, {3.8026608840125713`*^9, 3.802660884460211*^9}, {
  3.802661010075233*^9, 3.802661011104455*^9}},
 CellLabel->
  "In[410]:=",ExpressionUUID->"0e284e52-5b31-47c2-ad31-9c10beb8c734"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dfiterationrule", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[CapitalPsi]_"}], "]"}],
   ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"leftTail", "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Quantile", "[", 
          RowBox[{"#", ",", "0.05"}], "]"}], "/", 
         RowBox[{"Median", "[", "#", "]"}]}], "&"}], "@", 
       RowBox[{"(", 
        RowBox[{"Min", "/@", 
         RowBox[{"Extract", "[", 
          RowBox[{
           RowBox[{"\[CapitalPsi]", "/", 
            RowBox[{"(", 
             RowBox[{"\[CapitalPhi]", "/.", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"0", "|", "0."}], "\[Rule]", 
                RowBox[{"10", "^", 
                 RowBox[{"(", 
                  RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ",", 
           RowBox[{"Intersection", "[", 
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{
               RowBox[{"Max", "/@", "\[CapitalPhi]"}], ",", 
               RowBox[{"_", "?", "Positive"}]}], "]"}], ",", 
             RowBox[{"Position", "[", 
              RowBox[{"\[CapitalPsi]", ",", 
               RowBox[{"_", "?", "Positive"}]}], "]"}]}], "]"}]}], "]"}]}], 
        ")"}]}]}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"leftTail", "\[GreaterEqual]", "0.1"}], ",", "1", ",", "3"}], 
     "]"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.8027961954637947`*^9, 3.8027962588593073`*^9}},
 CellLabel->
  "In[411]:=",ExpressionUUID->"d0333c54-64c8-4035-96d9-7939d98c2805"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dfthresholdrule", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[CapitalPsi]_"}], "]"}],
   ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"skew", "=", 
      RowBox[{"Skewness", "[", 
       RowBox[{"Max", "/@", 
        RowBox[{"Extract", "[", 
         RowBox[{
          RowBox[{"\[Sigma]", "/", 
           RowBox[{"(", 
            RowBox[{"\[CapitalPhi]", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0", "|", "0."}], "\[Rule]", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], ")"}]}], ",", 
          RowBox[{"Intersection", "[", 
           RowBox[{
            RowBox[{"Position", "[", 
             RowBox[{
              RowBox[{"Max", "/@", "\[CapitalPhi]"}], ",", 
              RowBox[{"_", "?", "Positive"}]}], "]"}], ",", 
            RowBox[{"Position", "[", 
             RowBox[{"\[CapitalPsi]", ",", 
              RowBox[{"_", "?", "Positive"}]}], "]"}]}], "]"}]}], "]"}]}], 
       "]"}]}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"skew", "\[LessEqual]", "40"}], ",", "4", ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"skew", "\[LessEqual]", "60"}], ",", "1", ",", "7"}], "]"}]}],
      "]"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.802875787163015*^9, 3.802875855918582*^9}, {
  3.802875912151331*^9, 3.802875923864121*^9}, {3.8028810924450808`*^9, 
  3.802881138632678*^9}},
 CellLabel->
  "In[412]:=",ExpressionUUID->"a85a4310-f5c8-468e-9908-f8eec2a79963"],

Cell["\<\
\[Bullet] Final D/F Filtering (note: iterations is to be fed as maxIter into \
findMixture; moreover, final projection typically outperform the minimizer \
resulting from the alternating optimization, so should be selected by default)\
\>", "Text",
 CellChangeTimes->{{3.801448241619253*^9, 3.801448260034318*^9}, {
  3.8014482932738543`*^9, 3.801448294161491*^9}, {3.802911121500708*^9, 
  3.80291119052479*^9}},
 FontSize->24,ExpressionUUID->"5fb9e801-60ed-45e6-a3fa-ed45db677537"],

Cell[BoxData[
 RowBox[{
  RowBox[{"filterDF", "[", 
   RowBox[{"\[CapitalPhi]_", ",", "\[Sigma]_", ",", "\[CapitalPsi]_"}], "]"}],
   ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"threshold", "=", 
       RowBox[{"dfthresholdrule", "[", 
        RowBox[{"\[CapitalPhi]", ",", "\[Sigma]", ",", "\[CapitalPsi]"}], 
        "]"}]}], ",", 
      RowBox[{"iterations", "=", 
       RowBox[{"dfiterationrule", "[", 
        RowBox[{"\[CapitalPhi]", ",", "\[Sigma]", ",", "\[CapitalPsi]"}], 
        "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"iterations", ",", 
      RowBox[{"dffilter", "[", 
       RowBox[{
       "\[CapitalPhi]", ",", "\[Sigma]", ",", "\[CapitalPsi]", ",", 
        "threshold", ",", "Infinity"}], "]"}]}], "}"}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.801431721772553*^9, 3.8014317697072983`*^9}, {
  3.802881310364245*^9, 3.8028813421179953`*^9}},
 CellLabel->
  "In[413]:=",ExpressionUUID->"9367a69c-c298-44c5-b1e4-cd7a719c42c7"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example Run", "Section",
 CellChangeTimes->{{3.778698368886112*^9, 
  3.7786983795648937`*^9}},ExpressionUUID->"63170702-c9b8-413c-afe8-\
3ea4f3846f89"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", "1000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mList", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"200.", ",", "k"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Phi]", "=", 
   RowBox[{"RandomVariate", "[", 
    RowBox[{
     RowBox[{"ExponentialDistribution", "[", 
      RowBox[{"1", "/", "100"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "k"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{"10", "\[Phi]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]s", "=", 
   RowBox[{"Transpose", "@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}], "/", "10."}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "/", "10"}]}], 
     "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ns", "=", 
   RowBox[{"{", 
    RowBox[{"500.", ",", "1100"}], "}"}]}], ";", 
  RowBox[{"\[Psi]s", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Phi]", ".", "\[Alpha]s"}], ")"}], ".", 
    RowBox[{"DiagonalMatrix", "[", "ns", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.778698603749916*^9, 3.7786986566942787`*^9}, {
   3.778698705226945*^9, 3.7786987427091923`*^9}, {3.77869888601038*^9, 
   3.778698889015397*^9}, {3.7786989420914707`*^9, 3.778698950265196*^9}, {
   3.778698991525641*^9, 3.778698991875148*^9}, {3.778699942242588*^9, 
   3.7786999536719627`*^9}, {3.778700009401841*^9, 3.778700009574977*^9}, {
   3.778700546099207*^9, 3.778700573237953*^9}, {3.778700727824605*^9, 
   3.778700754531624*^9}, 3.794161116609661*^9, {3.7964931810961313`*^9, 
   3.7964931814126177`*^9}, 3.796493486685347*^9, {3.79649383171661*^9, 
   3.796493832087809*^9}, {3.7964939376795673`*^9, 3.796493939506894*^9}, {
   3.7989007527513323`*^9, 3.798900758404183*^9}, {3.798926549597267*^9, 
   3.798926574046052*^9}, {3.799896280718395*^9, 3.7998963213374367`*^9}, {
   3.799896463605546*^9, 3.799896463810206*^9}, {3.803565355234323*^9, 
   3.803565373057699*^9}, {3.825079540406096*^9, 3.825079541450759*^9}, 
   3.8250820515131063`*^9, {3.825871823777762*^9, 3.825871886651094*^9}, {
   3.825871963583091*^9, 3.8258719754137983`*^9}, {3.825959534223982*^9, 
   3.8259595366658916`*^9}, {3.825959687699623*^9, 3.82595968941012*^9}, {
   3.827773622109614*^9, 
   3.8277736249976177`*^9}},ExpressionUUID->"150efdae-f4bf-4091-9031-\
920d50da2006"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalPhi]", "=", 
   RowBox[{"\[Phi]", "+", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"RandomVariate", "[", 
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"0", ",", 
         RowBox[{
          RowBox[{"\[Sigma]", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
          RowBox[{"mList", "[", 
           RowBox[{"[", "j", "]"}], "]"}]}]}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "@", "\[Phi]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"Length", "@", "\[Alpha]s"}]}], "}"}]}], "]"}]}]}], ";", 
  RowBox[{"\[CapitalPsi]s", "=", 
   RowBox[{"\[Psi]s", "+", 
    RowBox[{"Transpose", "@", 
     RowBox[{"MapThread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"RandomVariate", "[", 
           RowBox[{"NormalDistribution", "[", 
            RowBox[{"0", ",", 
             RowBox[{"Sqrt", "[", "#", "]"}]}], "]"}], "]"}], "&"}], "/@", 
         RowBox[{"(", 
          RowBox[{"#2", "*", 
           RowBox[{"mixture\[Sigma]", "[", 
            RowBox[{"#1", ",", "\[Sigma]", ",", "\[Phi]"}], "]"}]}], ")"}]}], 
        "&"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Transpose", "@", "\[Alpha]s"}], ",", "ns"}], "}"}]}], 
      "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.778698752981237*^9, 3.778698768844281*^9}, {
   3.778698927270631*^9, 3.778698960081349*^9}, {3.7786990039917717`*^9, 
   3.77869903457871*^9}, {3.778699119877948*^9, 3.778699122958312*^9}, 
   3.778699967346257*^9, {3.7787000118577547`*^9, 3.778700021213763*^9}, {
   3.7941624106853323`*^9, 3.794162416636331*^9}, 3.794162477021714*^9, {
   3.796487409200429*^9, 3.796487411091913*^9}, {3.79649320312237*^9, 
   3.7964932050013638`*^9}, {3.7996992135171833`*^9, 3.799699249240115*^9}, {
   3.825871991925321*^9, 3.82587207974113*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"caabed15-8795-47d1-99e9-88fb0360bdbb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Quiet", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Alpha]Inferred", ",", "\[CapitalPhi]Inferred", ",", 
      "\[ScriptCapitalL]Inferred", ",", "nInferred", ",", "LSInferred"}], 
     "}"}], "=", 
    RowBox[{"findMixturesJoint", "[", 
     RowBox[{"\[CapitalPhi]", ",", "\[CapitalPsi]s", ",", "\[Sigma]", ",", 
      RowBox[{"10", "^", 
       RowBox[{"(", 
        RowBox[{"-", "10"}], ")"}]}], ",", 
      RowBox[{"10", "^", 
       RowBox[{"(", 
        RowBox[{"-", "10"}], ")"}]}], ",", "3", ",", "mList"}], "]"}]}], 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.778699053373011*^9, 3.778699099424972*^9}, {
   3.778699839578974*^9, 3.7786998432962713`*^9}, {3.794160460616914*^9, 
   3.7941605913089314`*^9}, {3.7941609804746943`*^9, 
   3.7941609916057987`*^9}, {3.7941610464294147`*^9, 3.794161090948687*^9}, {
   3.794161132049761*^9, 3.794161164898254*^9}, {3.794161978980563*^9, 
   3.7941619795936947`*^9}, {3.7941621250102262`*^9, 3.794162150575212*^9}, 
   3.79416248165765*^9, {3.796494679654305*^9, 3.79649469491184*^9}, {
   3.796494977626194*^9, 3.796494977950837*^9}, {3.796501559409967*^9, 
   3.796501563765749*^9}, {3.796501696629533*^9, 3.796501697706934*^9}, 
   3.7989188114810867`*^9, 3.803497516542148*^9, {3.8248588582824297`*^9, 
   3.82485886133696*^9}, {3.825872090158746*^9, 3.825872091510462*^9}, {
   3.825872257225799*^9, 3.825872269268877*^9}, {3.825959180112299*^9, 
   3.825959182953342*^9}},
 CellLabel->
  "In[163]:=",ExpressionUUID->"17498438-c6fd-42f0-a733-914a913bda72"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\!\\(\\*SubscriptBox[\\(\[Alpha]\\), \\(0\\)]\\) = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.4057363321795612`", ",", "0.2972032527105766`", ",", 
       "0.19836494091114423`", ",", "0.09869547419871796`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.1017195033476667`", ",", "0.19757403969820303`", ",", 
       "0.30094693565846226`", ",", "0.399759521295668`"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(\[ScriptCapitalL]\\), \
\\(0\\)]\\) = \"\>", "\[InvisibleSpace]", "35246.26251572235`", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(n\\), \\(0\\)]\\) = \
\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"498.58391473554616`", ",", "1098.6172995869765`"}], "}"}]}],
  SequenceForm[
  "\!\(\*SubscriptBox[\(\[Alpha]\), \(0\)]\) = ", {{0.4057363321795612, 
   0.2972032527105766, 0.19836494091114423`, 0.09869547419871796}, {
   0.1017195033476667, 0.19757403969820303`, 0.30094693565846226`, 
   0.399759521295668}}, 
   ", \!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(0\)]\) = ", 
   35246.26251572235, ", \!\(\*SubscriptBox[\(n\), \(0\)]\) = ", {
   498.58391473554616`, 1098.6172995869765`}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.80356537921628*^9, 3.824858721326703*^9, 3.82485886381625*^9, 
   3.824988187449099*^9, 3.825004377064767*^9, 3.8250795448631153`*^9, 
   3.825187384559621*^9, 3.825872095524911*^9, {3.8258722618055077`*^9, 
   3.8258722710465508`*^9}, 3.825959187388384*^9, 3.82595954347824*^9, {
   3.825959677567857*^9, 3.825959693482925*^9}, 3.827772269274363*^9, 
   3.827773156653104*^9, 3.827773270360085*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"70cf2777-78db-4205-a32e-db2cc21744ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Alpha] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.40410568303054434`", ",", "0.2979787893402308`", ",", 
       "0.19829645704723464`", ",", "0.0996190705819902`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.10096995335360134`", ",", "0.1981475275414477`", ",", 
       "0.3007955918624401`", ",", "0.4000869272425109`"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\", \[ScriptCapitalL] = \"\>", "\[InvisibleSpace]",
    "35438.50068725341`", "\[InvisibleSpace]", "\<\", n = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"498.2910431247547`", ",", "1098.7043341894387`"}], "}"}]}],
  SequenceForm[
  "\[Alpha] = ", {{0.40410568303054434`, 0.2979787893402308, 
   0.19829645704723464`, 0.0996190705819902}, {0.10096995335360134`, 
   0.1981475275414477, 0.3007955918624401, 0.4000869272425109}}, 
   ", \[ScriptCapitalL] = ", 35438.50068725341, ", n = ", {498.2910431247547, 
   1098.7043341894387`}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.80356537921628*^9, 3.824858721326703*^9, 3.82485886381625*^9, 
   3.824988187449099*^9, 3.825004377064767*^9, 3.8250795448631153`*^9, 
   3.825187384559621*^9, 3.825872095524911*^9, {3.8258722618055077`*^9, 
   3.8258722710465508`*^9}, 3.825959187388384*^9, 3.82595954347824*^9, {
   3.825959677567857*^9, 3.825959693482925*^9}, 3.827772269274363*^9, 
   3.827773156653104*^9, 3.827773270364715*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"b09ad713-6c82-4752-bd2e-ecca13187529"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Alpha] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.40286135344186863`", ",", "0.29862038480971514`", ",", 
       "0.1982315326471152`", ",", "0.10028672910130108`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.10032482622242797`", ",", "0.19894165775199774`", ",", 
       "0.30031929449249833`", ",", "0.40041422153307593`"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\", \[ScriptCapitalL] = \"\>", "\[InvisibleSpace]",
    "33713.37184755839`", "\[InvisibleSpace]", "\<\", n = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"498.4589596067243`", ",", "1099.575415211681`"}], "}"}]}],
  SequenceForm[
  "\[Alpha] = ", {{0.40286135344186863`, 0.29862038480971514`, 
   0.1982315326471152, 0.10028672910130108`}, {0.10032482622242797`, 
   0.19894165775199774`, 0.30031929449249833`, 0.40041422153307593`}}, 
   ", \[ScriptCapitalL] = ", 33713.37184755839, ", n = ", {498.4589596067243, 
   1099.575415211681}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.80356537921628*^9, 3.824858721326703*^9, 3.82485886381625*^9, 
   3.824988187449099*^9, 3.825004377064767*^9, 3.8250795448631153`*^9, 
   3.825187384559621*^9, 3.825872095524911*^9, {3.8258722618055077`*^9, 
   3.8258722710465508`*^9}, 3.825959187388384*^9, 3.82595954347824*^9, {
   3.825959677567857*^9, 3.825959693482925*^9}, 3.827772269274363*^9, 
   3.827773156653104*^9, 3.8277732949279222`*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"16d453c1-02b3-4e94-abc2-bbc615f0def2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Alpha] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.4022757657798916`", ",", "0.2990102296815585`", ",", 
       "0.19814673069815353`", ",", "0.10056727384039633`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.09987008448786809`", ",", "0.19931684981311415`", ",", 
       "0.30014598799300324`", ",", "0.40066707770601456`"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\", \[ScriptCapitalL] = \"\>", "\[InvisibleSpace]",
    "33707.98366502385`", "\[InvisibleSpace]", "\<\", n = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"498.487378706666`", ",", "1099.9032262932287`"}], "}"}]}],
  SequenceForm[
  "\[Alpha] = ", {{0.4022757657798916, 0.2990102296815585, 
   0.19814673069815353`, 0.10056727384039633`}, {0.09987008448786809, 
   0.19931684981311415`, 0.30014598799300324`, 0.40066707770601456`}}, 
   ", \[ScriptCapitalL] = ", 33707.98366502385, ", n = ", {498.487378706666, 
   1099.9032262932287`}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.80356537921628*^9, 3.824858721326703*^9, 3.82485886381625*^9, 
   3.824988187449099*^9, 3.825004377064767*^9, 3.8250795448631153`*^9, 
   3.825187384559621*^9, 3.825872095524911*^9, {3.8258722618055077`*^9, 
   3.8258722710465508`*^9}, 3.825959187388384*^9, 3.82595954347824*^9, {
   3.825959677567857*^9, 3.825959693482925*^9}, 3.827772269274363*^9, 
   3.827773156653104*^9, 3.827773319469367*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"3234bbc7-9906-4299-9548-efae23fd007d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Alpha] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.4021252896943423`", ",", "0.29911679874207614`", ",", 
       "0.19812183539555156`", ",", "0.10063607616803007`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.09974114927917488`", ",", "0.1994233286829009`", ",", 
       "0.3000959259090648`", ",", "0.4007395961288594`"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\", \[ScriptCapitalL] = \"\>", "\[InvisibleSpace]",
    "33707.5024155412`", "\[InvisibleSpace]", "\<\", n = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"498.512333988591`", ",", "1100.0261363987327`"}], "}"}]}],
  SequenceForm[
  "\[Alpha] = ", {{0.4021252896943423, 0.29911679874207614`, 
   0.19812183539555156`, 0.10063607616803007`}, {0.09974114927917488, 
   0.1994233286829009, 0.3000959259090648, 0.4007395961288594}}, 
   ", \[ScriptCapitalL] = ", 33707.5024155412, ", n = ", {498.512333988591, 
   1100.0261363987327`}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.80356537921628*^9, 3.824858721326703*^9, 3.82485886381625*^9, 
   3.824988187449099*^9, 3.825004377064767*^9, 3.8250795448631153`*^9, 
   3.825187384559621*^9, 3.825872095524911*^9, {3.8258722618055077`*^9, 
   3.8258722710465508`*^9}, 3.825959187388384*^9, 3.82595954347824*^9, {
   3.825959677567857*^9, 3.825959693482925*^9}, 3.827772269274363*^9, 
   3.827773156653104*^9, 3.827773344068841*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"f3115e52-da68-4b89-b9cf-a6c6e9821536"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\!\\(\\*SubscriptBox[\\(\[Alpha]\\), \\(Final\\)]\\) = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.4022757657798916`", ",", "0.2990102296815585`", ",", 
       "0.19814673069815353`", ",", "0.10056727384039633`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.09987008448786809`", ",", "0.19931684981311415`", ",", 
       "0.30014598799300324`", ",", "0.40066707770601456`"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(\[ScriptCapitalL]\\), \
\\(Final\\)]\\) = \"\>", "\[InvisibleSpace]", "33707.62948738272`", 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(n\\), \\(Final\\)]\\) \
= \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"498.487378706666`", ",", "1099.9032262932287`"}], "}"}]}],
  SequenceForm[
  "\!\(\*SubscriptBox[\(\[Alpha]\), \(Final\)]\) = ", {{0.4022757657798916, 
   0.2990102296815585, 0.19814673069815353`, 0.10056727384039633`}, {
   0.09987008448786809, 0.19931684981311415`, 0.30014598799300324`, 
   0.40066707770601456`}}, 
   ", \!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(Final\)]\) = ", 
   33707.62948738272, ", \!\(\*SubscriptBox[\(n\), \(Final\)]\) = ", {
   498.487378706666, 1099.9032262932287`}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.80356537921628*^9, 3.824858721326703*^9, 3.82485886381625*^9, 
   3.824988187449099*^9, 3.825004377064767*^9, 3.8250795448631153`*^9, 
   3.825187384559621*^9, 3.825872095524911*^9, {3.8258722618055077`*^9, 
   3.8258722710465508`*^9}, 3.825959187388384*^9, 3.82595954347824*^9, {
   3.825959677567857*^9, 3.825959693482925*^9}, 3.827772269274363*^9, 
   3.827773156653104*^9, 3.827773344082982*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"420b2fdb-4748-4935-a87c-8649601e5dee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\!\\(\\*SubscriptBox[\\(\[Alpha]\\), \\(LS\\)]\\) = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.40168473389083237`", ",", "0.2996405891798641`", ",", 
       "0.1980134822783235`", ",", "0.10066119465098003`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.0997303531545867`", ",", "0.2002103587998849`", ",", 
       "0.2997804040423647`", ",", "0.4002788840031635`"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\", \\!\\(\\*SubscriptBox[\\(\[ScriptCapitalL]\\), \
\\(LS\\)]\\) = \"\>", "\[InvisibleSpace]", "33708.62826114104`"}],
  SequenceForm[
  "\!\(\*SubscriptBox[\(\[Alpha]\), \(LS\)]\) = ", {{0.40168473389083237`, 
   0.2996405891798641, 0.1980134822783235, 0.10066119465098003`}, {
   0.0997303531545867, 0.2002103587998849, 0.2997804040423647, 
   0.4002788840031635}}, 
   ", \!\(\*SubscriptBox[\(\[ScriptCapitalL]\), \(LS\)]\) = ", 
   33708.62826114104],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.80356537921628*^9, 3.824858721326703*^9, 3.82485886381625*^9, 
   3.824988187449099*^9, 3.825004377064767*^9, 3.8250795448631153`*^9, 
   3.825187384559621*^9, 3.825872095524911*^9, {3.8258722618055077`*^9, 
   3.8258722710465508`*^9}, 3.825959187388384*^9, 3.82595954347824*^9, {
   3.825959677567857*^9, 3.825959693482925*^9}, 3.827772269274363*^9, 
   3.827773156653104*^9, 3.8277733441212606`*^9},
 CellLabel->
  "During evaluation of \
In[163]:=",ExpressionUUID->"3608a468-4f87-4e9f-baa4-31cee555ac16"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalL]Joint", "[", 
  RowBox[{
  "\[Phi]", ",", "\[Phi]", ",", "\[Psi]s", ",", "\[Alpha]s", ",", "\[Sigma]", 
   ",", "ns", ",", "mList"}], "]"}]], "Input",
 CellChangeTimes->{{3.7988985320961018`*^9, 3.798898548858492*^9}, {
  3.8277723291552563`*^9, 3.827772335722066*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"02df155c-9a80-46af-8643-9b9331f05f73"],

Cell[BoxData["29866.140010426312`"], "Output",
 CellChangeTimes->{{3.7988985384001617`*^9, 3.798898549268095*^9}, 
   3.798899978030809*^9, 3.798900803007763*^9, 3.799073152638631*^9, 
   3.803497579253158*^9, 3.803565438611947*^9, 3.824858819634502*^9, 
   3.8248589062016153`*^9, 3.824988229139658*^9, 3.8250044406226053`*^9, 
   3.825079552737072*^9, 3.827772349310597*^9, 3.827773260968006*^9, 
   3.827773359094749*^9},
 CellLabel->
  "Out[164]=",ExpressionUUID->"42f76c05-c1a4-4663-a6c9-2ee09971e431"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"100", 
  RowBox[{"Mean", "/@", 
   RowBox[{"(", 
    RowBox[{"Transpose", "@", 
     RowBox[{"Abs", "[", 
      RowBox[{"\[Alpha]s", "-", 
       RowBox[{"\[Alpha]Inferred", "\[LeftDoubleBracket]", 
        RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], "]"}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.803497682615267*^9, 3.803497689682096*^9}, {
  3.8277723392514*^9, 3.82777239357143*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"0956009a-a375-4da4-b634-dc6fbc67d950"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.14215198101439863`", ",", "0.04065328495088914`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8034976828142567`*^9, 3.803497690223092*^9}, 
   3.8035654399104156`*^9, 3.824858823040509*^9, 3.824858911041101*^9, 
   3.824988231567175*^9, 3.825004441554658*^9, 3.825079553883181*^9, {
   3.827772363629867*^9, 3.827772393754794*^9}, 3.827773360248691*^9},
 CellLabel->
  "Out[165]=",ExpressionUUID->"8a46509c-f540-43ae-b4d2-c17eb94e9167"]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"exampleGodambe", "=", 
   RowBox[{"MapThread", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"godambeInformation", "[", 
       RowBox[{
       "#1", ",", "\[CapitalPhi]Inferred", ",", "\[Sigma]", ",", "#2", ",", 
        "#3"}], "]"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Transpose", "@", 
        RowBox[{"\[Alpha]Inferred", "\[LeftDoubleBracket]", 
         RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], ",", 
       RowBox[{"Transpose", "@", "\[CapitalPsi]s"}], ",", 
       RowBox[{"nInferred", "\[LeftDoubleBracket]", 
        RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.799073100899982*^9, 3.7990731269617987`*^9}, {
  3.82777228801225*^9, 3.82777231957036*^9}, {3.827772404538876*^9, 
  3.8277724877615356`*^9}, {3.827772651794859*^9, 3.827772657169671*^9}},
 CellLabel->
  "In[166]:=",ExpressionUUID->"be355d43-810a-4514-8f10-3340a013d746"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"CDF", "[", 
          RowBox[{
           RowBox[{"ChiSquareDistribution", "[", 
            RowBox[{"k", "-", "1"}], "]"}], ",", "#"}], "]"}]}], "}"}], "&"}],
       "@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Most", "[", 
         RowBox[{"#1", "-", "#2"}], "]"}], ".", 
        RowBox[{
         RowBox[{"Inverse", "[", "#3", "]"}], "\[LeftDoubleBracket]", 
         RowBox[{
          RowBox[{";;", 
           RowBox[{"k", "-", "1"}]}], ",", 
          RowBox[{";;", 
           RowBox[{"k", "-", "1"}]}]}], "\[RightDoubleBracket]"}], ".", 
        RowBox[{"Most", "[", 
         RowBox[{"#1", "-", "#2"}], "]"}]}], ")"}]}], "*", "g"}], "&"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Transpose", "@", "\[Alpha]s"}], ",", 
     RowBox[{"Transpose", "@", 
      RowBox[{"\[Alpha]Inferred", "\[LeftDoubleBracket]", 
       RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], ",", 
     "exampleGodambe"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.798900390794216*^9, 3.798900452014723*^9}, {
  3.798900905702261*^9, 3.798900919130015*^9}, {3.79890099379403*^9, 
  3.7989009948153553`*^9}, {3.7990731791815147`*^9, 3.79907319754573*^9}, {
  3.803497650580659*^9, 3.803497652199378*^9}, {3.827772838338483*^9, 
  3.827772938559256*^9}, {3.8277729883752193`*^9, 3.827773011453813*^9}, {
  3.827773042918277*^9, 3.827773075012323*^9}, {3.827773148262211*^9, 
  3.8277731521785097`*^9}, {3.827773376663666*^9, 3.827773391878557*^9}, {
  3.827773463426277*^9, 3.827773601245713*^9}},
 CellLabel->
  "In[177]:=",ExpressionUUID->"41f847b6-14b6-422b-bd0d-23862dbd2193"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.1507514051371533`", ",", "0.0004922562273716566`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.01773832750892635`", ",", "0.000019869434156913317`"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7989007357409153`*^9, {3.7989008961702147`*^9, 3.798900919708304*^9}, 
   3.7989009952660437`*^9, 3.798901119128907*^9, 3.799073199084125*^9, {
   3.80349758398337*^9, 3.80349760475801*^9}, 3.80349765244274*^9, 
   3.803501854486971*^9, 3.803565467324287*^9, 3.824858990868292*^9, 
   3.824988256578532*^9, 3.825004469253354*^9, 3.825079556185573*^9, 
   3.825190731510912*^9, {3.827772897239259*^9, 3.8277729391560783`*^9}, {
   3.8277729940766983`*^9, 3.827773012523116*^9}, {3.827773045410407*^9, 
   3.827773075473818*^9}, {3.827773148702853*^9, 3.827773152492525*^9}, {
   3.827773365408519*^9, 3.8277733934174833`*^9}, {3.8277734867369432`*^9, 
   3.82777351436658*^9}, {3.827773575030119*^9, 3.827773601745352*^9}},
 CellLabel->
  "Out[177]=",ExpressionUUID->"f78fb49f-58b9-44ff-bc60-b329708c2464"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Data Analysis", "Section",
 CellChangeTimes->{{3.825002197820112*^9, 
  3.825002209436056*^9}},ExpressionUUID->"eaa967cd-07cb-4e9b-83de-\
67b3837064a2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tissues", "=", 
   RowBox[{"{", 
    RowBox[{
    "skin", ",", "liver", ",", "pancreas", ",", "bladder", ",", "thymus", ",",
      "mammarygland", ",", "tongue", ",", "trachea", ",", "largeintestine", 
     ",", "limbmuscle", ",", "kidney", ",", "lung", ",", "marrow"}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8005654364925127`*^9, 3.800565438850103*^9}, {
  3.8061136522568703`*^9, 3.8061136638705263`*^9}, {3.810167422933751*^9, 
  3.810167423496521*^9}, {3.825857247124778*^9, 3.825857247676097*^9}},
 CellLabel->
  "In[768]:=",ExpressionUUID->"84956ceb-bb8e-414a-96d0-a61c50baa1ee"],

Cell[CellGroupData[{

Cell["Cross-Protocol", "Subsection",
 CellChangeTimes->{{3.825002400738874*^9, 
  3.825002404284367*^9}},ExpressionUUID->"0c641d6f-3626-4888-b69a-\
9bb4df0f169f"],

Cell[CellGroupData[{

Cell["Load Data", "Subsubsection",
 CellChangeTimes->{{3.82500221061152*^9, 
  3.82500221159619*^9}},ExpressionUUID->"94c317c3-3943-4867-aea6-\
717d573f1e8a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MapIndexed", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ddropCols", "[", "#1", "]"}], "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "3", "}"}], ",", 
          RowBox[{"{", "3", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4"}], "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}]}], "}"}], "\[LeftDoubleBracket]", 
        RowBox[{"First", "@", "#2"}], "\[RightDoubleBracket]"}]}], ")"}], 
     "&"}], ",", "tissues"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.825002605479538*^9, 3.825002670948902*^9}, {
   3.825002715873982*^9, 3.825002838735839*^9}, 3.825003257252282*^9},
 CellLabel->
  "In[772]:=",ExpressionUUID->"a6320d17-d000-4eb6-bcf5-7e2d7c96860d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "fileDirectory", "=", 
   "\"\</Users/Dani/Dropbox \
(Personal)/Berkeley/Research/Deconvolution/individual_files/\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.825857280438827*^9, 3.825857283796564*^9}},
 CellLabel->
  "In[776]:=",ExpressionUUID->"f4bfb4eb-7fb0-4dc6-8120-954302fecb21"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"dmlist", "[", "#", "]"}], "=", 
      RowBox[{"Drop", "[", 
       RowBox[{
        RowBox[{"Transpose", "@", 
         RowBox[{
          RowBox[{"Import", "[", 
           RowBox[{
            RowBox[{"fileDirectory", "<>", 
             RowBox[{"ToString", "[", "#", "]"}], "<>", 
             "\"\</droplet/m_mat.csv\>\""}], ",", "\"\<Data\>\""}], "]"}], 
          "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"ddropCols", "[", "#", "]"}]}], "]"}]}], ")"}], "&"}], "/@", 
   "tissues"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"dfilenames", "[", "tissue", "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "<>", "\"\<.csv\>\""}], "&"}], "/@", 
      RowBox[{
       RowBox[{"Import", "[", 
        RowBox[{
         RowBox[{"fileDirectory", "<>", 
          RowBox[{"ToString", "[", "tissue", "]"}], "<>", 
          "\"\</droplet/m_mat.csv\>\""}], ",", "\"\<Data\>\""}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", 
         RowBox[{"2", ";;"}]}], "]"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.799682808630184*^9, 3.799682808821123*^9}, {
   3.8250028502790127`*^9, 3.825002920251528*^9}, 3.825002969034129*^9, 
   3.8250032606416407`*^9, {3.825857057761272*^9, 3.825857103906556*^9}, {
   3.825857221334257*^9, 3.825857228726989*^9}, {3.825857289074489*^9, 
   3.825857295440723*^9}},
 CellLabel->
  "In[777]:=",ExpressionUUID->"ae15ad17-82fd-4513-bc56-afbdb2f03d5c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MapIndexed", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"fdropCols", "[", "#1", "]"}], "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "2", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "4", ",", "3"}], "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}]}], "}"}], "\[LeftDoubleBracket]", 
        RowBox[{"First", "@", "#2"}], "\[RightDoubleBracket]"}]}], ")"}], 
     "&"}], ",", "tissues"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.825003291856779*^9, 3.825003292152266*^9}, {
  3.8250033222108707`*^9, 3.82500332637724*^9}},
 CellLabel->
  "In[779]:=",ExpressionUUID->"85412a55-447f-4742-817f-2e3970d8cda4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"fmlist", "[", "#", "]"}], "=", 
      RowBox[{"Drop", "[", 
       RowBox[{
        RowBox[{"Transpose", "@", 
         RowBox[{
          RowBox[{"Import", "[", 
           RowBox[{
            RowBox[{"fileDirectory", "<>", 
             RowBox[{"ToString", "[", "#", "]"}], "<>", 
             "\"\</facs/m_mat.csv\>\""}], ",", "\"\<Data\>\""}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"fdropCols", "[", "#", "]"}]}], "]"}]}], ")"}], "&"}], "/@", 
   "tissues"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ffilenames", "[", "tissue", "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "<>", "\"\<.csv\>\""}], "&"}], "/@", 
      RowBox[{
       RowBox[{"Import", "[", 
        RowBox[{
         RowBox[{"fileDirectory", "<>", 
          RowBox[{"ToString", "[", "tissue", "]"}], "<>", 
          "\"\</facs/m_mat.csv\>\""}], ",", "\"\<Data\>\""}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", 
         RowBox[{"2", ";;"}]}], "]"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.799682832334104*^9, 3.7996828430399923`*^9}, {
  3.825003397963368*^9, 3.825003469066402*^9}, {3.825857303227264*^9, 
  3.825857308893078*^9}},
 CellLabel->
  "In[780]:=",ExpressionUUID->"e9b4b4bd-fb95-4ec2-a46e-5193e66fea36"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"d\[CapitalPhi]s", "[", "tissue", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Import", "[", 
             RowBox[{"fileDirectory", "<>", 
              RowBox[{"ToString", "[", "tissue", "]"}], "<>", 
              "\"\</droplet/mean/mean_\>\"", "<>", "#"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"2", ";;"}], ",", 
              RowBox[{"2", ";;"}]}], "]"}], "]"}], ",", 
           RowBox[{"{", "}"}], ",", 
           RowBox[{"ddropCols", "[", "tissue", "]"}]}], "]"}], "&"}], "/@", 
        RowBox[{"dfilenames", "[", "tissue", "]"}]}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"\"\<\>\"", "\[Rule]", 
        RowBox[{"-", 
         RowBox[{"10", "^", "10"}]}]}], "}"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"d\[Sigma]s", "[", "tissue", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Import", "[", 
             RowBox[{"fileDirectory", "<>", 
              RowBox[{"ToString", "[", "tissue", "]"}], "<>", 
              "\"\</droplet/var/var_\>\"", "<>", "#"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"2", ";;"}], ",", 
              RowBox[{"2", ";;"}]}], "]"}], "]"}], ",", 
           RowBox[{"{", "}"}], ",", 
           RowBox[{"ddropCols", "[", "tissue", "]"}]}], "]"}], "&"}], "/@", 
        RowBox[{"dfilenames", "[", "tissue", "]"}]}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"\"\<\>\"", "\[Rule]", 
        RowBox[{"-", 
         RowBox[{"10", "^", "10"}]}]}], "}"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8250030636191263`*^9, 3.825003093582796*^9}, {
  3.825003263869767*^9, 3.825003272778448*^9}, {3.825857317517384*^9, 
  3.825857324418577*^9}},
 CellLabel->
  "In[782]:=",ExpressionUUID->"c145e433-7052-433c-be77-2ad39111be1c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f\[CapitalPhi]s", "[", "tissue", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Import", "[", 
             RowBox[{"fileDirectory", "<>", 
              RowBox[{"ToString", "[", "tissue", "]"}], "<>", 
              "\"\</facs/mean/mean_\>\"", "<>", "#"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"2", ";;"}], ",", 
              RowBox[{"2", ";;"}]}], "]"}], "]"}], ",", 
           RowBox[{"{", "}"}], ",", 
           RowBox[{"fdropCols", "[", "tissue", "]"}]}], "]"}], "&"}], "/@", 
        RowBox[{"ffilenames", "[", "tissue", "]"}]}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"\"\<\>\"", "\[Rule]", 
        RowBox[{"-", 
         RowBox[{"10", "^", "10"}]}]}], "}"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f\[Sigma]s", "[", "tissue", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Import", "[", 
             RowBox[{"fileDirectory", "<>", 
              RowBox[{"ToString", "[", "tissue", "]"}], "<>", 
              "\"\</facs/var/var_\>\"", "<>", "#"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"2", ";;"}], ",", 
              RowBox[{"2", ";;"}]}], "]"}], "]"}], ",", 
           RowBox[{"{", "}"}], ",", 
           RowBox[{"fdropCols", "[", "tissue", "]"}]}], "]"}], "&"}], "/@", 
        RowBox[{"ffilenames", "[", "tissue", "]"}]}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"\"\<\>\"", "\[Rule]", 
        RowBox[{"-", 
         RowBox[{"10", "^", "10"}]}]}], "}"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.799268810210528*^9, 3.799268921573637*^9}, {
  3.7992689966833677`*^9, 3.799269004595145*^9}, {3.799269110523885*^9, 
  3.799269139674487*^9}, {3.79933079554277*^9, 3.799330803260858*^9}, {
  3.799332089733533*^9, 3.79933210998656*^9}, {3.799334573703692*^9, 
  3.799334575083907*^9}, {3.799334615757698*^9, 3.799334617410816*^9}, {
  3.799507669718286*^9, 3.799507718427343*^9}, {3.7996815748371162`*^9, 
  3.799681586985813*^9}, {3.799681673216406*^9, 3.799681677317534*^9}, {
  3.799681731250383*^9, 3.7996817465063353`*^9}, {3.7996823230731497`*^9, 
  3.7996823569256897`*^9}, {3.799682421846958*^9, 3.799682436100165*^9}, {
  3.7996978758749123`*^9, 3.79969793871064*^9}, {3.825003492760754*^9, 
  3.825003569441742*^9}, {3.825857422233852*^9, 3.825857426539536*^9}},
 CellLabel->
  "In[784]:=",ExpressionUUID->"a500ab6f-afb2-41f8-9b99-f6ae11d86cd3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"d\[CapitalPhi]", "[", "tissue", "]"}], "=", 
     RowBox[{
      RowBox[{"Total", "[", 
       RowBox[{"MapThread", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"mMatrix", "[", 
            RowBox[{"#2", ",", 
             RowBox[{"Length", "@", "#1"}]}], "]"}], "*", "#1"}], "&"}], ",", 
         
         RowBox[{"{", 
          RowBox[{
           RowBox[{"d\[CapitalPhi]s", "[", "tissue", "]"}], ",", 
           RowBox[{"dmlist", "[", "tissue", "]"}]}], "}"}]}], "]"}], "]"}], 
      "/", 
      RowBox[{"mMatrix", "[", 
       RowBox[{
        RowBox[{"Total", "[", 
         RowBox[{"dmlist", "[", "tissue", "]"}], "]"}], ",", 
        RowBox[{"Length", "[", 
         RowBox[{"First", "@", 
          RowBox[{"d\[CapitalPhi]s", "[", "tissue", "]"}]}], "]"}]}], 
       "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f\[CapitalPhi]", "[", "tissue", "]"}], "=", 
     RowBox[{
      RowBox[{"Total", "[", 
       RowBox[{"MapThread", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"mMatrix", "[", 
            RowBox[{"#2", ",", 
             RowBox[{"Length", "@", "#1"}]}], "]"}], "*", "#1"}], "&"}], ",", 
         
         RowBox[{"{", 
          RowBox[{
           RowBox[{"f\[CapitalPhi]s", "[", "tissue", "]"}], ",", 
           RowBox[{"fmlist", "[", "tissue", "]"}]}], "}"}]}], "]"}], "]"}], 
      "/", 
      RowBox[{"mMatrix", "[", 
       RowBox[{
        RowBox[{"Total", "[", 
         RowBox[{"fmlist", "[", "tissue", "]"}], "]"}], ",", 
        RowBox[{"Length", "[", 
         RowBox[{"First", "@", 
          RowBox[{"f\[CapitalPhi]s", "[", "tissue", "]"}]}], "]"}]}], 
       "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7993309457482*^9, 3.79933094720912*^9}, {
   3.799331020619349*^9, 3.79933113288789*^9}, {3.799507922572279*^9, 
   3.799507954050024*^9}, {3.7995079980027943`*^9, 3.799508014409342*^9}, {
   3.799681756601836*^9, 3.799681794320148*^9}, 3.799682090867483*^9, {
   3.7996830254521923`*^9, 3.7996830364088306`*^9}, {3.8250036219800587`*^9, 
   3.8250036785637407`*^9}},
 CellLabel->
  "In[786]:=",ExpressionUUID->"47c4f077-c610-4535-8787-a93cade2ddbf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"d\[Sigma]", "[", "tissue", "]"}], "=", 
     RowBox[{"Transpose", "@", 
      RowBox[{"MapThread", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"mixture\[Sigma]", "[", 
          RowBox[{"#1", ",", "#3", ",", "#2"}], "]"}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Normalize", "[", 
             RowBox[{"#", ",", "Total"}], "]"}], "&"}], "/@", 
           RowBox[{"Transpose", "[", 
            RowBox[{"dmlist", "[", "tissue", "]"}], "]"}]}], ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{
            RowBox[{"d\[CapitalPhi]s", "[", "tissue", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "]"}], ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{
            RowBox[{"d\[Sigma]s", "[", "tissue", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "]"}]}], "}"}]}], 
       "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f\[Sigma]", "[", "tissue", "]"}], "=", 
     RowBox[{"Transpose", "@", 
      RowBox[{"MapThread", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"mixture\[Sigma]", "[", 
          RowBox[{"#1", ",", "#3", ",", "#2"}], "]"}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Normalize", "[", 
             RowBox[{"#", ",", "Total"}], "]"}], "&"}], "/@", 
           RowBox[{"Transpose", "[", 
            RowBox[{"fmlist", "[", "tissue", "]"}], "]"}]}], ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{
            RowBox[{"f\[CapitalPhi]s", "[", "tissue", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "]"}], ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{
            RowBox[{"f\[Sigma]s", "[", "tissue", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "]"}]}], "}"}]}], 
       "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.799332910618965*^9, 3.799332912225593*^9}, {
  3.799333073558065*^9, 3.799333075206153*^9}, {3.7993331110467176`*^9, 
  3.7993331781386213`*^9}, {3.799333307247087*^9, 3.799333384428293*^9}, {
  3.7995080185274878`*^9, 3.799508046496059*^9}, {3.7996822415693617`*^9, 
  3.799682253804593*^9}, {3.7996830398594418`*^9, 3.799683046562932*^9}, {
  3.802374792016926*^9, 3.802374794935049*^9}, {3.802550044125441*^9, 
  3.802550057096051*^9}, {3.8250037163712683`*^9, 3.8250037346218443`*^9}, {
  3.825003816104204*^9, 3.825003832305081*^9}},
 CellLabel->
  "In[788]:=",ExpressionUUID->"b3fac88c-3dd2-4f60-bd3d-21174bbc3e0e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"d\[CapitalPsi]", "[", "tissue", "]"}], "=", 
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"Total", "[", 
        RowBox[{"MapThread", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"mMatrix", "[", 
             RowBox[{"#2", ",", 
              RowBox[{"Length", "@", "#1"}]}], "]"}], "*", "#1"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"d\[CapitalPhi]s", "[", "tissue", "]"}], ",", 
            RowBox[{"dmlist", "[", "tissue", "]"}]}], "}"}]}], "]"}], "]"}], 
       ",", 
       RowBox[{"{", "2", "}"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f\[CapitalPsi]", "[", "tissue", "]"}], "=", 
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"Total", "[", 
        RowBox[{"MapThread", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"mMatrix", "[", 
             RowBox[{"#2", ",", 
              RowBox[{"Length", "@", "#1"}]}], "]"}], "*", "#1"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"f\[CapitalPhi]s", "[", "tissue", "]"}], ",", 
            RowBox[{"fmlist", "[", "tissue", "]"}]}], "}"}]}], "]"}], "]"}], 
       ",", 
       RowBox[{"{", "2", "}"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.799333440737834*^9, 3.799333478031584*^9}, {
  3.7993335090145187`*^9, 3.7993335106709127`*^9}, {3.799333542526802*^9, 
  3.799333568141205*^9}, {3.799508049855434*^9, 3.799508062639118*^9}, {
  3.825003853741768*^9, 3.825003902798164*^9}},
 CellLabel->
  "In[790]:=",ExpressionUUID->"e4cf818e-b02e-49ac-8ab2-c9e9d20128ba"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"dmixture", "[", "tissue", "]"}], "=", 
     RowBox[{"1.", "*", 
      RowBox[{"Normalize", "[", 
       RowBox[{
        RowBox[{"Total", "[", 
         RowBox[{"dmlist", "[", "tissue", "]"}], "]"}], ",", "Total"}], 
       "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"fmixture", "[", "tissue", "]"}], "=", 
     RowBox[{"1.", "*", 
      RowBox[{"Normalize", "[", 
       RowBox[{
        RowBox[{"Total", "[", 
         RowBox[{"fmlist", "[", "tissue", "]"}], "]"}], ",", "Total"}], 
       "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7993336439697733`*^9, 3.7993336457164583`*^9}, {
  3.7993336965302153`*^9, 3.79933371480968*^9}, {3.7995080747418222`*^9, 
  3.799508085162628*^9}, {3.8250039074054747`*^9, 3.825003926354121*^9}},
 CellLabel->
  "In[792]:=",ExpressionUUID->"e45bbd37-7ddd-43ab-bdd0-c3e548c1adfd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"dnames", "[", "tissue", "]"}], "=", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"fileDirectory", "<>", 
        RowBox[{"ToString", "[", "tissue", "]"}], "<>", 
        "\"\</droplet/mean/mean_\>\"", "<>", 
        RowBox[{
         RowBox[{"dfilenames", "[", "tissue", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"fnames", "[", "tissue", "]"}], "=", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"fileDirectory", "<>", 
        RowBox[{"ToString", "[", "tissue", "]"}], "<>", 
        "\"\</facs/mean/mean_\>\"", "<>", 
        RowBox[{
         RowBox[{"ffilenames", "[", "tissue", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8001132258968067`*^9, 3.800113301592329*^9}, {
  3.800113353910038*^9, 3.800113366246194*^9}, {3.825003931389455*^9, 
  3.825003953644877*^9}, {3.8250040051794157`*^9, 3.825004021050824*^9}, {
  3.825857582443301*^9, 3.825857586890916*^9}},
 CellLabel->
  "In[794]:=",ExpressionUUID->"b38edd37-9853-4b82-849d-d97e5f114d14"]
}, Closed]],

Cell[CellGroupData[{

Cell["Filter Data", "Subsubsection",
 CellChangeTimes->{{3.825002467617132*^9, 
  3.825002469890193*^9}},ExpressionUUID->"a1ba9b61-1908-46f3-bd19-\
d1293004bb2b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d\[CapitalPhi]simple", "[", "tissue", "]"}], ",", 
       RowBox[{"d\[Sigma]simple", "[", "tissue", "]"}], ",", 
       RowBox[{"f\[CapitalPsi]simple", "[", "tissue", "]"}]}], "}"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Extract", "[", 
        RowBox[{"#", ",", 
         RowBox[{"simpleFilter", "[", 
          RowBox[{
           RowBox[{"d\[CapitalPhi]", "[", "tissue", "]"}], ",", 
           RowBox[{"f\[CapitalPsi]", "[", "tissue", "]"}]}], "]"}]}], "]"}], 
       "&"}], "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"d\[CapitalPhi]", "[", "tissue", "]"}], ",", 
        RowBox[{"d\[Sigma]", "[", "tissue", "]"}], ",", 
        RowBox[{"f\[CapitalPsi]", "[", "tissue", "]"}]}], "}"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.8258591666074533`*^9, 3.825859267278036*^9}, {
  3.825859298303918*^9, 3.8258593073945017`*^9}},
 CellLabel->
  "In[837]:=",ExpressionUUID->"5bf93dc9-6159-4ea0-99ea-37124382ad06"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"Part", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"fiterations", "[", "#", "]"}], ",", 
         RowBox[{"ffilter", "[", "#", "]"}]}], "}"}], "=", 
       RowBox[{"filterFD", "[", 
        RowBox[{
         RowBox[{"f\[CapitalPhi]", "[", "#", "]"}], ",", 
         RowBox[{"f\[Sigma]", "[", "#", "]"}], ",", 
         RowBox[{"d\[CapitalPsi]", "[", "#", "]"}]}], "]"}]}], ",", "2"}], 
     "]"}], "]"}], "&"}], "/@", "tissues"}]], "Input",
 CellChangeTimes->{{3.800720053482037*^9, 3.800720055269115*^9}, 
   3.800738920384651*^9, {3.800743980041473*^9, 3.8007439806201143`*^9}, {
   3.8007598562837563`*^9, 3.800759856604528*^9}, {3.8009974532935743`*^9, 
   3.8009974648147173`*^9}, {3.8025675716088047`*^9, 3.802567585259019*^9}, {
   3.802567641987997*^9, 3.80256764833841*^9}, {3.802567680402619*^9, 
   3.802567681009712*^9}},
 CellLabel->
  "In[113]:=",ExpressionUUID->"f0c7a193-5f10-49ce-b1cb-5ce4ae9afe76"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3210", ",", "9909", ",", "10113", ",", "10109", ",", "2553", ",", "10233", 
   ",", "10049", ",", "10873", ",", "3263", ",", "11456", ",", "10137", ",", 
   "11116", ",", "10014"}], "}"}]], "Output",
 CellChangeTimes->{3.825004083043455*^9, 3.825005073093359*^9},
 CellLabel->
  "Out[113]=",ExpressionUUID->"b8265ec0-8b07-485d-bb09-cdc2a4233f5a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"Part", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"diterations", "[", "#", "]"}], ",", 
         RowBox[{"dfilter", "[", "#", "]"}]}], "}"}], "=", 
       RowBox[{"filterDF", "[", 
        RowBox[{
         RowBox[{"d\[CapitalPhi]", "[", "#", "]"}], ",", 
         RowBox[{"d\[Sigma]", "[", "#", "]"}], ",", 
         RowBox[{"f\[CapitalPsi]", "[", "#", "]"}]}], "]"}]}], ",", "2"}], 
     "]"}], "]"}], "&"}], "/@", "tissues"}]], "Input",
 CellChangeTimes->{{3.802886074765874*^9, 3.802886079021719*^9}, {
  3.802898267412469*^9, 3.802898270652441*^9}},
 CellLabel->
  "In[114]:=",ExpressionUUID->"d060d54a-75ec-4392-a261-1cc7c8b0174a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "9774", ",", "12123", ",", "12806", ",", "11981", ",", "6540", ",", "10780",
    ",", "8464", ",", "12483", ",", "3762", ",", "12992", ",", "5023", ",", 
   "13326", ",", "11232"}], "}"}]], "Output",
 CellChangeTimes->{3.8250041051742563`*^9, 3.825005093363325*^9},
 CellLabel->
  "Out[114]=",ExpressionUUID->"87d275f3-59f7-460f-ab94-28d0531b526d"]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d\[CapitalPhi]f", "[", "tissue", "]"}], ",", 
       RowBox[{"d\[Sigma]f", "[", "tissue", "]"}], ",", 
       RowBox[{"f\[CapitalPsi]f", "[", "tissue", "]"}]}], "}"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Extract", "[", 
        RowBox[{"#", ",", 
         RowBox[{"dfilter", "[", "tissue", "]"}]}], "]"}], "&"}], "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"d\[CapitalPhi]", "[", "tissue", "]"}], ",", 
        RowBox[{"d\[Sigma]", "[", "tissue", "]"}], ",", 
        RowBox[{"f\[CapitalPsi]", "[", "tissue", "]"}]}], "}"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.799508284591166*^9, 3.799508315037199*^9}, {
   3.7995095164009447`*^9, 3.799509536477344*^9}, {3.799510111190886*^9, 
   3.799510125836546*^9}, {3.799513244847413*^9, 3.7995132646363153`*^9}, 
   3.8000453418858356`*^9, {3.800304036667383*^9, 3.800304036714366*^9}, {
   3.800304256599262*^9, 3.800304256633033*^9}, {3.8005603933524218`*^9, 
   3.800560396850593*^9}, {3.800565489013028*^9, 3.800565569867399*^9}, {
   3.801009873276352*^9, 3.8010098962847013`*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"7dbeae9f-5495-4c18-b305-bc24870381e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f\[CapitalPhi]f", "[", "tissue", "]"}], ",", 
       RowBox[{"f\[Sigma]f", "[", "tissue", "]"}], ",", 
       RowBox[{"d\[CapitalPsi]f", "[", "tissue", "]"}]}], "}"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Extract", "[", 
        RowBox[{"#", ",", 
         RowBox[{"ffilter", "[", "tissue", "]"}]}], "]"}], "&"}], "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f\[CapitalPhi]", "[", "tissue", "]"}], ",", 
        RowBox[{"f\[Sigma]", "[", "tissue", "]"}], ",", 
        RowBox[{"d\[CapitalPsi]", "[", "tissue", "]"}]}], "}"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.799508284591166*^9, 3.799508315037199*^9}, {
   3.7995095164009447`*^9, 3.799509536477344*^9}, {3.799510111190886*^9, 
   3.799510125836546*^9}, {3.799513244847413*^9, 3.7995132646363153`*^9}, 
   3.8000453418858356`*^9, {3.800304036667383*^9, 3.800304036714366*^9}, {
   3.800304256599262*^9, 3.800304256633033*^9}, {3.8005603933524218`*^9, 
   3.800560396850593*^9}, {3.800565489013028*^9, 3.800565569867399*^9}},
 CellLabel->
  "In[116]:=",ExpressionUUID->"b2658919-b317-4167-a32e-0c849ae91182"]
}, Closed]],

Cell[CellGroupData[{

Cell["Deconvolve Data", "Subsubsection",
 CellChangeTimes->{{3.825004224544161*^9, 
  3.82500422780822*^9}},ExpressionUUID->"7d9f6278-8417-40c6-bb04-\
a241b180f0e3"],

Cell[BoxData[
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Block", "[", 
       RowBox[{
        RowBox[{"{", "Print", "}"}], ",", 
        RowBox[{"Quiet", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], ",", 
            RowBox[{"estf\[CapitalPhi]", "[", "tissue", "]"}], ",", 
            RowBox[{"fLf", "[", "tissue", "]"}], ",", 
            RowBox[{"fnf", "[", "tissue", "]"}], ",", 
            RowBox[{"fLSf", "[", "tissue", "]"}]}], "}"}], "=", 
          RowBox[{"findMixtures", "[", 
           RowBox[{
            RowBox[{"f\[CapitalPhi]f", "[", "tissue", "]"}], ",", 
            RowBox[{"d\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
            RowBox[{
             RowBox[{"f\[Sigma]f", "[", "tissue", "]"}], "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0", "|", "0."}], "\[Rule]", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "6"}], ")"}]}]}], "}"}]}], ",", 
            RowBox[{"10", "^", 
             RowBox[{"(", 
              RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", 
            RowBox[{"fiterations", "[", "tissue", "]"}], ",", 
            RowBox[{"Total", "[", 
             RowBox[{"fmlist", "[", "tissue", "]"}], "]"}]}], "]"}]}], 
         "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ";"}], ",", 
   "tissue"}], "]"}]], "Input",
 CellChangeTimes->{{3.798922435701625*^9, 3.798922448214319*^9}, {
   3.798922481394609*^9, 3.79892248294687*^9}, {3.7989225796165047`*^9, 
   3.798922655316934*^9}, {3.79892275120147*^9, 3.798922751447682*^9}, {
   3.798923349120165*^9, 3.7989233599103518`*^9}, {3.798925436114792*^9, 
   3.798925438527006*^9}, 3.798925997735408*^9, {3.7989265914012403`*^9, 
   3.798926596903174*^9}, {3.7989272376259003`*^9, 3.7989272406988688`*^9}, {
   3.7989275710300913`*^9, 3.7989275731222897`*^9}, {3.798927818493825*^9, 
   3.798927818965199*^9}, {3.798927852766836*^9, 3.798927854327039*^9}, {
   3.798927991742342*^9, 3.7989279991299963`*^9}, {3.798928145074263*^9, 
   3.7989281451512537`*^9}, {3.79892832507578*^9, 3.7989283252565536`*^9}, 
   3.7989285065636053`*^9, {3.798928690936316*^9, 3.7989287057715178`*^9}, {
   3.7989288637112207`*^9, 3.798928863802656*^9}, {3.798928948592865*^9, 
   3.798928965579913*^9}, {3.7989291509183598`*^9, 3.798929150993289*^9}, {
   3.798929308454877*^9, 3.7989293356099987`*^9}, {3.798930196466031*^9, 
   3.798930201711224*^9}, {3.798986852164213*^9, 3.798986855331832*^9}, {
   3.798986888614773*^9, 3.798986893476081*^9}, {3.799010255309252*^9, 
   3.799010259680196*^9}, {3.7992520563458548`*^9, 3.7992521104671*^9}, {
   3.799252596465269*^9, 3.799252596629333*^9}, {3.799252990522542*^9, 
   3.7992529927641077`*^9}, {3.799263386152048*^9, 3.7992633878181667`*^9}, {
   3.799268723359261*^9, 3.799268724436514*^9}, {3.79933378060758*^9, 
   3.799333805591447*^9}, {3.799333840366021*^9, 3.7993338427121572`*^9}, {
   3.799335118117861*^9, 3.7993351243693237`*^9}, {3.799336572619834*^9, 
   3.799336576327943*^9}, {3.799336610969742*^9, 3.79933661326479*^9}, {
   3.799338004476356*^9, 3.7993380050633707`*^9}, {3.7993380668009644`*^9, 
   3.799338081958205*^9}, {3.7993383659814053`*^9, 3.799338366133841*^9}, 
   3.799338432737977*^9, {3.799338788865843*^9, 3.7993388025216208`*^9}, {
   3.7993389068341427`*^9, 3.799338907045867*^9}, {3.7994375107202806`*^9, 
   3.7994375253421497`*^9}, {3.7994413445155478`*^9, 3.799441364162554*^9}, {
   3.799508371986891*^9, 3.799508397615197*^9}, {3.799509256748159*^9, 
   3.7995092700071*^9}, {3.799509438800191*^9, 3.799509459007793*^9}, 
   3.7995128468483667`*^9, 3.7995128773125362`*^9, {3.799513291654278*^9, 
   3.799513304092721*^9}, 3.799513354051106*^9, 3.799513414376492*^9, 
   3.79951350515443*^9, {3.799513687183229*^9, 3.799513689187449*^9}, {
   3.7995138196843243`*^9, 3.7995138481616793`*^9}, {3.799513914513282*^9, 
   3.7995139940960093`*^9}, {3.799514062404841*^9, 3.7995140792000427`*^9}, {
   3.7995324142988997`*^9, 3.799532433844152*^9}, 3.799535050926887*^9, {
   3.799608823168144*^9, 3.799608840956114*^9}, 3.799612588694024*^9, {
   3.7996130003513327`*^9, 3.799613008705964*^9}, {3.799613132131172*^9, 
   3.799613133096027*^9}, {3.799613636912318*^9, 3.799613661652954*^9}, 
   3.7996137438467007`*^9, 3.799636254457396*^9, {3.799636302877851*^9, 
   3.799636304418736*^9}, 3.799636338810712*^9, 3.79963639708136*^9, 
   3.799637311281228*^9, 3.7996375907529097`*^9, {3.799637634059217*^9, 
   3.799637645507154*^9}, {3.799637732067583*^9, 3.7996377822574673`*^9}, 
   3.799674076434032*^9, {3.799767125614369*^9, 3.799767147737596*^9}, {
   3.799767237003035*^9, 3.799767237271412*^9}, {3.7997672728229103`*^9, 
   3.799767284435116*^9}, {3.799768357902299*^9, 3.7997683592840147`*^9}, {
   3.799768587390051*^9, 3.799768587713304*^9}, {3.79993630270045*^9, 
   3.799936310786399*^9}, {3.799936572957116*^9, 3.7999365732272663`*^9}, {
   3.7999800801466208`*^9, 3.7999800921063557`*^9}, {3.800022235370915*^9, 
   3.800022242526992*^9}, {3.8000223111209297`*^9, 3.8000223454118557`*^9}, {
   3.800022387534848*^9, 3.800022428990312*^9}, {3.800022476241342*^9, 
   3.80002247673291*^9}, {3.800022508006921*^9, 3.8000225612288733`*^9}, {
   3.800022630448991*^9, 3.8000226515702953`*^9}, {3.800023698478178*^9, 
   3.800023743349483*^9}, 3.8000241198049707`*^9, 3.800033700479238*^9, {
   3.8000385412797956`*^9, 3.800038542923335*^9}, 3.8000385826697407`*^9, 
   3.800038664746491*^9, {3.8000392342317343`*^9, 3.800039263415851*^9}, 
   3.800042735656836*^9, 3.800043042069841*^9, {3.800195914718794*^9, 
   3.800195916000791*^9}, 3.800196145891646*^9, {3.800198290502776*^9, 
   3.800198293737721*^9}, {3.800198336551197*^9, 3.800198343421056*^9}, {
   3.8002021972980022`*^9, 3.800202199611557*^9}, {3.800565940193829*^9, 
   3.80056602610483*^9}, {3.800566092205843*^9, 3.800566100987122*^9}, {
   3.8005765675093803`*^9, 3.800576572949217*^9}, {3.802567698567058*^9, 
   3.802567701249572*^9}, {3.803572702374708*^9, 3.803572706601087*^9}},
 CellLabel->
  "In[600]:=",ExpressionUUID->"e5270022-07ea-4c60-8ae6-03702b5b569d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tissue", "=", "trachea"}], "}"}], ",", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", "Print", "}"}], ",", 
      RowBox[{"Quiet", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], ",", 
          RowBox[{"estf\[CapitalPhi]", "[", "tissue", "]"}], ",", 
          RowBox[{"fLf", "[", "tissue", "]"}], ",", 
          RowBox[{"fnf", "[", "tissue", "]"}], ",", 
          RowBox[{"fLSf", "[", "tissue", "]"}]}], "}"}], "=", 
        RowBox[{"findMixtures", "[", 
         RowBox[{
          RowBox[{"f\[CapitalPhi]f", "[", "tissue", "]"}], ",", 
          RowBox[{"d\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
          RowBox[{
           RowBox[{"f\[Sigma]f", "[", "tissue", "]"}], "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"0", "|", "0."}], "\[Rule]", 
             RowBox[{"10", "^", 
              RowBox[{"(", 
               RowBox[{"-", "6"}], ")"}]}]}], "}"}]}], ",", 
          RowBox[{"10", "^", 
           RowBox[{"(", 
            RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", 
          RowBox[{"fiterations", "[", "tissue", "]"}], ",", 
          RowBox[{"Total", "[", 
           RowBox[{"fmlist", "[", "tissue", "]"}], "]"}]}], "]"}]}], "]"}]}], 
     "]"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.798922435701625*^9, 3.798922448214319*^9}, {
   3.798922481394609*^9, 3.79892248294687*^9}, {3.7989225796165047`*^9, 
   3.798922655316934*^9}, {3.79892275120147*^9, 3.798922751447682*^9}, {
   3.798923349120165*^9, 3.7989233599103518`*^9}, {3.798925436114792*^9, 
   3.798925438527006*^9}, 3.798925997735408*^9, {3.7989265914012403`*^9, 
   3.798926596903174*^9}, {3.7989272376259003`*^9, 3.7989272406988688`*^9}, {
   3.7989275710300913`*^9, 3.7989275731222897`*^9}, {3.798927818493825*^9, 
   3.798927818965199*^9}, {3.798927852766836*^9, 3.798927854327039*^9}, {
   3.798927991742342*^9, 3.7989279991299963`*^9}, {3.798928145074263*^9, 
   3.7989281451512537`*^9}, {3.79892832507578*^9, 3.7989283252565536`*^9}, 
   3.7989285065636053`*^9, {3.798928690936316*^9, 3.7989287057715178`*^9}, {
   3.7989288637112207`*^9, 3.798928863802656*^9}, {3.798928948592865*^9, 
   3.798928965579913*^9}, {3.7989291509183598`*^9, 3.798929150993289*^9}, {
   3.798929308454877*^9, 3.7989293356099987`*^9}, {3.798930196466031*^9, 
   3.798930201711224*^9}, {3.798986852164213*^9, 3.798986855331832*^9}, {
   3.798986888614773*^9, 3.798986893476081*^9}, {3.799010255309252*^9, 
   3.799010259680196*^9}, {3.7992520563458548`*^9, 3.7992521104671*^9}, {
   3.799252596465269*^9, 3.799252596629333*^9}, {3.799252990522542*^9, 
   3.7992529927641077`*^9}, {3.799263386152048*^9, 3.7992633878181667`*^9}, {
   3.799268723359261*^9, 3.799268724436514*^9}, {3.79933378060758*^9, 
   3.799333805591447*^9}, {3.799333840366021*^9, 3.7993338427121572`*^9}, {
   3.799335118117861*^9, 3.7993351243693237`*^9}, {3.799336572619834*^9, 
   3.799336576327943*^9}, {3.799336610969742*^9, 3.79933661326479*^9}, {
   3.799338004476356*^9, 3.7993380050633707`*^9}, {3.7993380668009644`*^9, 
   3.799338081958205*^9}, {3.7993383659814053`*^9, 3.799338366133841*^9}, 
   3.799338432737977*^9, {3.799338788865843*^9, 3.7993388025216208`*^9}, {
   3.7993389068341427`*^9, 3.799338907045867*^9}, {3.7994375107202806`*^9, 
   3.7994375253421497`*^9}, {3.7994413445155478`*^9, 3.799441364162554*^9}, {
   3.799508371986891*^9, 3.799508397615197*^9}, {3.799509256748159*^9, 
   3.7995092700071*^9}, {3.799509438800191*^9, 3.799509459007793*^9}, 
   3.7995128468483667`*^9, 3.7995128773125362`*^9, {3.799513291654278*^9, 
   3.799513304092721*^9}, 3.799513354051106*^9, 3.799513414376492*^9, 
   3.79951350515443*^9, {3.799513687183229*^9, 3.799513689187449*^9}, {
   3.7995138196843243`*^9, 3.7995138481616793`*^9}, {3.799513914513282*^9, 
   3.7995139940960093`*^9}, {3.799514062404841*^9, 3.7995140792000427`*^9}, {
   3.7995324142988997`*^9, 3.799532433844152*^9}, 3.799535050926887*^9, {
   3.799608823168144*^9, 3.799608840956114*^9}, 3.799612588694024*^9, {
   3.7996130003513327`*^9, 3.799613008705964*^9}, {3.799613132131172*^9, 
   3.799613133096027*^9}, {3.799613636912318*^9, 3.799613661652954*^9}, 
   3.7996137438467007`*^9, 3.799636254457396*^9, {3.799636302877851*^9, 
   3.799636304418736*^9}, 3.799636338810712*^9, 3.79963639708136*^9, 
   3.799637311281228*^9, 3.7996375907529097`*^9, {3.799637634059217*^9, 
   3.799637645507154*^9}, {3.799637732067583*^9, 3.7996377822574673`*^9}, 
   3.799674076434032*^9, {3.799767125614369*^9, 3.799767147737596*^9}, {
   3.799767237003035*^9, 3.799767237271412*^9}, {3.7997672728229103`*^9, 
   3.799767284435116*^9}, {3.799768357902299*^9, 3.7997683592840147`*^9}, {
   3.799768587390051*^9, 3.799768587713304*^9}, {3.79993630270045*^9, 
   3.799936310786399*^9}, {3.799936572957116*^9, 3.7999365732272663`*^9}, {
   3.7999800801466208`*^9, 3.7999800921063557`*^9}, {3.800022235370915*^9, 
   3.800022242526992*^9}, {3.8000223111209297`*^9, 3.8000223454118557`*^9}, {
   3.800022387534848*^9, 3.800022428990312*^9}, {3.800022476241342*^9, 
   3.80002247673291*^9}, {3.800022508006921*^9, 3.8000225612288733`*^9}, {
   3.800022630448991*^9, 3.8000226515702953`*^9}, {3.800023698478178*^9, 
   3.800023743349483*^9}, 3.8000241198049707`*^9, 3.800033700479238*^9, {
   3.8000385412797956`*^9, 3.800038542923335*^9}, 3.8000385826697407`*^9, 
   3.800038664746491*^9, {3.8000392342317343`*^9, 3.800039263415851*^9}, 
   3.800042735656836*^9, 3.800043042069841*^9, {3.800195914718794*^9, 
   3.800195916000791*^9}, 3.800196145891646*^9, {3.800198290502776*^9, 
   3.800198293737721*^9}, {3.800198336551197*^9, 3.800198343421056*^9}, {
   3.8002021972980022`*^9, 3.800202199611557*^9}, {3.800565940193829*^9, 
   3.80056602610483*^9}, {3.800566092205843*^9, 3.800566100987122*^9}, {
   3.8005765675093803`*^9, 3.800576572949217*^9}, {3.802567698567058*^9, 
   3.802567701249572*^9}, {3.803572702374708*^9, 3.803572706601087*^9}, {
   3.825074798577626*^9, 3.825074817221978*^9}, {3.8250749065141573`*^9, 
   3.8250749089372387`*^9}},
 CellLabel->
  "In[543]:=",ExpressionUUID->"c88f6ae6-6c8c-4845-8562-78cce34e126b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tissue", "=", "trachea"}], "}"}], ",", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"Quiet", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"d\[Alpha]f", "[", "tissue", "]"}], ",", 
          RowBox[{"estd\[CapitalPhi]", "[", "tissue", "]"}], ",", 
          RowBox[{"dLf", "[", "tissue", "]"}], ",", 
          RowBox[{"dnf", "[", "tissue", "]"}], ",", 
          RowBox[{"dLSf", "[", "tissue", "]"}]}], "}"}], "=", 
        RowBox[{"findMixtures", "[", 
         RowBox[{
          RowBox[{"d\[CapitalPhi]f", "[", "tissue", "]"}], ",", 
          RowBox[{"f\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
          RowBox[{
           RowBox[{"d\[Sigma]f", "[", "tissue", "]"}], "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"0", "|", "0."}], "\[Rule]", 
             RowBox[{"10", "^", 
              RowBox[{"(", 
               RowBox[{"-", "6"}], ")"}]}]}], "}"}]}], ",", 
          RowBox[{"10", "^", 
           RowBox[{"(", 
            RowBox[{"-", "10"}], ")"}]}], ",", "50", ",", 
          RowBox[{"diterations", "[", "tissue", "]"}], ",", 
          RowBox[{"Total", "[", 
           RowBox[{"dmlist", "[", "tissue", "]"}], "]"}]}], "]"}]}], "]"}]}], 
     "]"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.798922435701625*^9, 3.798922448214319*^9}, {
   3.798922481394609*^9, 3.79892248294687*^9}, {3.7989225796165047`*^9, 
   3.798922655316934*^9}, {3.79892275120147*^9, 3.798922751447682*^9}, {
   3.798923349120165*^9, 3.7989233599103518`*^9}, {3.798925436114792*^9, 
   3.798925438527006*^9}, 3.798925997735408*^9, {3.7989265914012403`*^9, 
   3.798926596903174*^9}, {3.7989272376259003`*^9, 3.7989272406988688`*^9}, {
   3.7989275710300913`*^9, 3.7989275731222897`*^9}, {3.798927818493825*^9, 
   3.798927818965199*^9}, {3.798927852766836*^9, 3.798927854327039*^9}, {
   3.798927991742342*^9, 3.7989279991299963`*^9}, {3.798928145074263*^9, 
   3.7989281451512537`*^9}, {3.79892832507578*^9, 3.7989283252565536`*^9}, 
   3.7989285065636053`*^9, {3.798928690936316*^9, 3.7989287057715178`*^9}, {
   3.7989288637112207`*^9, 3.798928863802656*^9}, {3.798928948592865*^9, 
   3.798928965579913*^9}, {3.7989291509183598`*^9, 3.798929150993289*^9}, {
   3.798929308454877*^9, 3.7989293356099987`*^9}, {3.798930196466031*^9, 
   3.798930201711224*^9}, {3.798986852164213*^9, 3.798986855331832*^9}, {
   3.798986888614773*^9, 3.798986893476081*^9}, {3.799010255309252*^9, 
   3.799010259680196*^9}, {3.7992520563458548`*^9, 3.7992521104671*^9}, {
   3.799252596465269*^9, 3.799252596629333*^9}, {3.799252990522542*^9, 
   3.7992529927641077`*^9}, {3.799263386152048*^9, 3.7992633878181667`*^9}, {
   3.799268723359261*^9, 3.799268724436514*^9}, {3.79933378060758*^9, 
   3.799333805591447*^9}, {3.799333840366021*^9, 3.7993338427121572`*^9}, {
   3.799335118117861*^9, 3.7993351243693237`*^9}, {3.799336572619834*^9, 
   3.799336576327943*^9}, {3.799336610969742*^9, 3.79933661326479*^9}, {
   3.799338004476356*^9, 3.7993380050633707`*^9}, {3.7993380668009644`*^9, 
   3.799338081958205*^9}, {3.7993383659814053`*^9, 3.799338366133841*^9}, 
   3.799338432737977*^9, {3.799338788865843*^9, 3.7993388025216208`*^9}, {
   3.7993389068341427`*^9, 3.799338907045867*^9}, {3.7994375107202806`*^9, 
   3.7994375253421497`*^9}, {3.7994413445155478`*^9, 3.799441364162554*^9}, {
   3.799508371986891*^9, 3.799508397615197*^9}, {3.799509256748159*^9, 
   3.7995092700071*^9}, {3.799509438800191*^9, 3.799509459007793*^9}, 
   3.7995128468483667`*^9, 3.7995128773125362`*^9, {3.799513291654278*^9, 
   3.799513304092721*^9}, 3.799513354051106*^9, 3.799513414376492*^9, 
   3.79951350515443*^9, {3.799513687183229*^9, 3.799513689187449*^9}, {
   3.7995138196843243`*^9, 3.7995138481616793`*^9}, {3.799513914513282*^9, 
   3.7995139940960093`*^9}, {3.799514062404841*^9, 3.7995140792000427`*^9}, {
   3.7995324142988997`*^9, 3.799532433844152*^9}, 3.799535050926887*^9, {
   3.799608823168144*^9, 3.799608840956114*^9}, 3.799612588694024*^9, {
   3.7996130003513327`*^9, 3.799613008705964*^9}, {3.799613132131172*^9, 
   3.799613133096027*^9}, {3.799613636912318*^9, 3.799613661652954*^9}, 
   3.7996137438467007`*^9, 3.799636254457396*^9, {3.799636302877851*^9, 
   3.799636304418736*^9}, 3.799636338810712*^9, 3.79963639708136*^9, 
   3.799637311281228*^9, 3.7996375907529097`*^9, {3.799637634059217*^9, 
   3.799637645507154*^9}, {3.799637732067583*^9, 3.7996377822574673`*^9}, 
   3.799674076434032*^9, {3.799767125614369*^9, 3.799767147737596*^9}, {
   3.799767237003035*^9, 3.799767237271412*^9}, {3.7997672728229103`*^9, 
   3.799767284435116*^9}, {3.799768357902299*^9, 3.7997683592840147`*^9}, {
   3.799768587390051*^9, 3.799768587713304*^9}, {3.79993630270045*^9, 
   3.799936310786399*^9}, {3.799936572957116*^9, 3.7999365732272663`*^9}, {
   3.7999800801466208`*^9, 3.7999800921063557`*^9}, {3.800022235370915*^9, 
   3.800022242526992*^9}, {3.8000223111209297`*^9, 3.8000223454118557`*^9}, {
   3.800022387534848*^9, 3.800022428990312*^9}, {3.800022476241342*^9, 
   3.80002247673291*^9}, {3.800022508006921*^9, 3.8000225612288733`*^9}, {
   3.800022630448991*^9, 3.8000226515702953`*^9}, {3.800023698478178*^9, 
   3.800023743349483*^9}, 3.8000241198049707`*^9, 3.800033700479238*^9, {
   3.8000385412797956`*^9, 3.800038542923335*^9}, 3.8000385826697407`*^9, 
   3.800038664746491*^9, {3.8000392342317343`*^9, 3.800039263415851*^9}, 
   3.800042735656836*^9, 3.800043042069841*^9, {3.800195914718794*^9, 
   3.800195916000791*^9}, 3.800196145891646*^9, {3.800198290502776*^9, 
   3.800198293737721*^9}, {3.800198336551197*^9, 3.800198343421056*^9}, {
   3.8002021972980022`*^9, 3.800202199611557*^9}, {3.800565940193829*^9, 
   3.80056602610483*^9}, {3.800566092205843*^9, 3.800566100987122*^9}, {
   3.8005765675093803`*^9, 3.800576572949217*^9}, {3.802567698567058*^9, 
   3.802567701249572*^9}, {3.803572702374708*^9, 3.803572706601087*^9}, {
   3.825074798577626*^9, 3.825074817221978*^9}, {3.8250749065141573`*^9, 
   3.8250749089372387`*^9}, {3.825094069275599*^9, 3.8250940736748343`*^9}, {
   3.825096997823701*^9, 3.825097022719812*^9}},
 CellLabel->
  "In[953]:=",ExpressionUUID->"349f8a5e-8b22-44c9-8598-b09c2e1c7a9d"]
}, Closed]],

Cell[CellGroupData[{

Cell["Confidence Regions", "Subsubsection",
 CellChangeTimes->{{3.825004301001809*^9, 
  3.825004303394967*^9}},ExpressionUUID->"4ca24fe7-065e-4a67-83e2-\
a295d56031bb"],

Cell[TextData[StyleBox["Import Files",
 FontColor->RGBColor[0.6, 0.4, 0.2]]], "Text",
 CellChangeTimes->{{3.825087278581699*^9, 3.825087280643589*^9}},
 FontSize->18,ExpressionUUID->"791ee096-8361-497c-bc0d-b6922dfcd826"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "Import", "[", "\"\</Users/Dani/deconvolution_variables/fd_alphas.wl\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Import", "[", "\"\</Users/Dani/deconvolution_variables/fd_Phis.wl\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Import", "[", "\"\</Users/Dani/deconvolution_variables/fd_Ns.wl\>\"", 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.805293236090734*^9, 3.805293276040227*^9}, {
   3.806887467213633*^9, 3.806887470392852*^9}, {3.8068875009603767`*^9, 
   3.8068875090695343`*^9}, {3.8068880522908*^9, 3.806888065649782*^9}, {
   3.8250058418603573`*^9, 3.825005886080392*^9}, 3.82500598528761*^9, {
   3.825075164089717*^9, 
   3.8250751644639378`*^9}},ExpressionUUID->"019b643f-ba6c-46e9-839f-\
5f09b80b7e59"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "Import", "[", "\"\</Users/Dani/deconvolution_variables/df_LSs.wl\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Import", "[", "\"\</Users/Dani/deconvolution_variables/df_Phis.wl\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "Import", "[", "\"\</Users/Dani/deconvolution_variables/df_Ns.wl\>\"", 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"d\[Alpha]f", "[", "#", "]"}], "=", 
      RowBox[{
       RowBox[{"dLSf", "[", "#", "]"}], "\[LeftDoubleBracket]", "1", 
       "\[RightDoubleBracket]"}]}], ")"}], "&"}], "/@", "tissues"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.805293236090734*^9, 3.805293276040227*^9}, {
   3.806887467213633*^9, 3.806887470392852*^9}, {3.8068875009603767`*^9, 
   3.8068875090695343`*^9}, {3.8068880522908*^9, 3.806888065649782*^9}, {
   3.8250058418603573`*^9, 3.825005886080392*^9}, 3.82500598528761*^9, {
   3.825075164089717*^9, 3.8250751644639378`*^9}, {3.82508725589261*^9, 
   3.825087259222674*^9}, {3.82508749815963*^9, 3.8250874983521023`*^9}, 
   3.8250875298056192`*^9, {3.825087563603175*^9, 
   3.8250875917275887`*^9}},ExpressionUUID->"a9a0c8ab-fdf8-4649-b267-\
b4cb5d17e635"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"d\[Alpha]f", "[", "trachea", "]"}], "=", 
   RowBox[{
    RowBox[{"dLSf", "[", "trachea", "]"}], "\[LeftDoubleBracket]", "1", 
    "\[RightDoubleBracket]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.825098867433672*^9, 3.825098885053334*^9}},
 CellLabel->
  "In[958]:=",ExpressionUUID->"0dac6f01-1702-4533-b24d-27b927d02333"],

Cell["Compute Empirical Fisher Matrices", "Text",
 CellChangeTimes->{{3.825087287415244*^9, 3.8250872957538557`*^9}},
 FontSize->18,
 FontColor->RGBColor[
  0.6, 0.4, 0.2],ExpressionUUID->"05826f06-e479-4779-a096-441b307532a6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Monitor", "[", 
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"fempFisher", "[", "tissue", "]"}], "=", " ", 
        RowBox[{"Covariance", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"sampleFisher", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
              "\[LeftDoubleBracket]", 
              RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", 
             RowBox[{"estf\[CapitalPhi]", "[", "tissue", "]"}], ",", 
             RowBox[{"f\[Sigma]f", "[", "tissue", "]"}], ",", 
             RowBox[{"d\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
             RowBox[{
              RowBox[{"fnf", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
              RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "100"}], 
            "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "1000"}], "}"}]}], "]"}], "]"}]}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", 
      RowBox[{"ProgressIndicator", "[", 
       RowBox[{"i", "/", "1000"}], "]"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.825005992355979*^9, 3.8250060924513893`*^9}, {
   3.8250061225643797`*^9, 3.82500621860539*^9}, {3.825006498821232*^9, 
   3.825006553817264*^9}, {3.825006622133973*^9, 3.8250066291967373`*^9}, {
   3.825006665349613*^9, 3.825006701712419*^9}, {3.82500741643221*^9, 
   3.825007418509789*^9}, {3.825041459498214*^9, 3.8250414642769833`*^9}, {
   3.8250415379899387`*^9, 3.8250415431682158`*^9}, {3.825041695018174*^9, 
   3.82504169530634*^9}, {3.82504236774999*^9, 3.8250423684624023`*^9}, {
   3.8250765145690536`*^9, 3.82507651480678*^9}, {3.8250771976802807`*^9, 
   3.825077198241774*^9}, 3.82508784239808*^9, {3.825094133508265*^9, 
   3.825094135306356*^9}, 
   3.8250952887545443`*^9},ExpressionUUID->"d40a740c-9085-4cd0-b8fe-\
2705028790dd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quiet", "[", 
   RowBox[{"Monitor", "[", 
    RowBox[{
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tissue", "=", "skin"}], "}"}], ",", 
       RowBox[{
        RowBox[{"fempFisher", "[", "tissue", "]"}], "=", " ", 
        RowBox[{"Covariance", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"sampleFisher", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
              "\[LeftDoubleBracket]", 
              RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", 
             RowBox[{"f\[CapitalPhi]f", "[", "tissue", "]"}], ",", 
             RowBox[{"f\[Sigma]f", "[", "tissue", "]"}], ",", 
             RowBox[{"d\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
             RowBox[{
              RowBox[{"fnf", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
              RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "100"}], 
            "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "1000"}], "}"}]}], "]"}], "]"}]}]}], 
      "]"}], ",", 
     RowBox[{"ProgressIndicator", "[", 
      RowBox[{"i", "/", "1000"}], "]"}]}], "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.825005992355979*^9, 3.8250060924513893`*^9}, {
   3.8250061225643797`*^9, 3.82500621860539*^9}, {3.825006498821232*^9, 
   3.825006553817264*^9}, {3.825006622133973*^9, 3.8250066291967373`*^9}, {
   3.825006665349613*^9, 3.825006701712419*^9}, {3.82500741643221*^9, 
   3.825007418509789*^9}, {3.825013706863798*^9, 3.825013743332375*^9}, {
   3.825013812590076*^9, 3.825013813636466*^9}, {3.8250293634015303`*^9, 
   3.825029385856772*^9}, {3.82502967155619*^9, 3.8250296837586718`*^9}, {
   3.825029895257599*^9, 3.82502992825124*^9}, {3.825032097796813*^9, 
   3.8250321124511223`*^9}, {3.825032158606945*^9, 3.825032160206163*^9}, {
   3.8250416386959352`*^9, 3.825041643421465*^9}, 3.825042737234213*^9, {
   3.825077184802773*^9, 3.825077185554604*^9}, {3.825081450009161*^9, 
   3.825081450615159*^9}, {3.825087828164488*^9, 3.825087829330531*^9}, {
   3.825095268742795*^9, 3.825095274274087*^9}, {3.8251143640324383`*^9, 
   3.825114364458529*^9}},
 CellLabel->
  "In[1175]:=",ExpressionUUID->"feae91fe-f409-4b57-a820-5370cb6584c4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Monitor", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"fGodambe", "[", "tissue", "]"}], "=", 
       RowBox[{"godambeInformation", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
          
          RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", 
         RowBox[{"estf\[CapitalPhi]", "[", "tissue", "]"}], ",", 
         RowBox[{"f\[Sigma]f", "[", "tissue", "]"}], ",", 
         RowBox[{"d\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
         RowBox[{
          RowBox[{"fnf", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
          RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ",", "tissue"}], 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.825005992355979*^9, 3.8250060924513893`*^9}, {
   3.8250061225643797`*^9, 3.82500621860539*^9}, {3.825006498821232*^9, 
   3.825006553817264*^9}, {3.825006622133973*^9, 3.8250066291967373`*^9}, {
   3.825006665349613*^9, 3.825006701712419*^9}, {3.82500741643221*^9, 
   3.825007418509789*^9}, {3.825041459498214*^9, 3.8250414642769833`*^9}, {
   3.8250415379899387`*^9, 3.8250415431682158`*^9}, {3.825041695018174*^9, 
   3.82504169530634*^9}, {3.82504236774999*^9, 3.8250423684624023`*^9}, {
   3.8250765145690536`*^9, 3.82507651480678*^9}, {3.8250771976802807`*^9, 
   3.825077198241774*^9}, 3.82508784239808*^9, {3.825094133508265*^9, 
   3.825094135306356*^9}, 3.8250952887545443`*^9, {3.82519159820858*^9, 
   3.825191641713512*^9}},
 CellLabel->
  "In[1316]:=",ExpressionUUID->"fe195b22-4095-4b98-8fc4-13c3946a37e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Monitor", "[", 
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"dempFisher", "[", "tissue", "]"}], "=", " ", 
        RowBox[{"Covariance", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"sampleFisherInvertible", "[", 
            RowBox[{
             RowBox[{"d\[Alpha]f", "[", "tissue", "]"}], ",", 
             RowBox[{"estd\[CapitalPhi]", "[", "tissue", "]"}], ",", 
             RowBox[{"d\[Sigma]f", "[", "tissue", "]"}], ",", 
             RowBox[{"f\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
             RowBox[{
              RowBox[{"dnf", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
              RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "100"}], 
            "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "1000"}], "}"}]}], "]"}], "]"}]}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"tissue", ",", 
      RowBox[{"ProgressIndicator", "[", 
       RowBox[{"i", "/", "1000"}], "]"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.825005992355979*^9, 3.8250060924513893`*^9}, {
   3.8250061225643797`*^9, 3.82500621860539*^9}, {3.825006498821232*^9, 
   3.825006553817264*^9}, {3.825006622133973*^9, 3.8250066291967373`*^9}, {
   3.825006665349613*^9, 3.825006701712419*^9}, {3.82500741643221*^9, 
   3.825007418509789*^9}, {3.825041459498214*^9, 3.8250414642769833`*^9}, {
   3.8250415379899387`*^9, 3.8250415431682158`*^9}, {3.825041695018174*^9, 
   3.82504169530634*^9}, {3.82504236774999*^9, 3.8250423684624023`*^9}, {
   3.8250765145690536`*^9, 3.82507651480678*^9}, {3.8250771976802807`*^9, 
   3.825077198241774*^9}, {3.825087306355698*^9, 3.825087318859908*^9}, {
   3.825087619578964*^9, 3.825087619618294*^9}, 3.825087840400985*^9, 
   3.825088191050179*^9, {3.825089531977605*^9, 3.82508954357615*^9}, {
   3.825100573190056*^9, 3.825100575439711*^9}},
 CellLabel->
  "In[1094]:=",ExpressionUUID->"a1435fb8-b712-4626-a825-0224b839c292"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quiet", "[", 
   RowBox[{"Monitor", "[", 
    RowBox[{
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tissue", "=", "skin"}], "}"}], ",", 
       RowBox[{
        RowBox[{"dempFisher", "[", "tissue", "]"}], "=", " ", 
        RowBox[{"Covariance", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"sampleFisherInvertible", "[", 
            RowBox[{
             RowBox[{"d\[Alpha]f", "[", "tissue", "]"}], ",", 
             RowBox[{"d\[CapitalPhi]f", "[", "tissue", "]"}], ",", 
             RowBox[{"d\[Sigma]f", "[", "tissue", "]"}], ",", 
             RowBox[{"f\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
             RowBox[{
              RowBox[{"dnf", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
              RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "100"}], 
            "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "1000"}], "}"}]}], "]"}], "]"}]}]}], 
      "]"}], ",", 
     RowBox[{"ProgressIndicator", "[", 
      RowBox[{"i", "/", "1000"}], "]"}]}], "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.825005992355979*^9, 3.8250060924513893`*^9}, {
   3.8250061225643797`*^9, 3.82500621860539*^9}, {3.825006498821232*^9, 
   3.825006553817264*^9}, {3.825006622133973*^9, 3.8250066291967373`*^9}, {
   3.825006665349613*^9, 3.825006701712419*^9}, {3.82500741643221*^9, 
   3.825007418509789*^9}, {3.825013706863798*^9, 3.825013743332375*^9}, {
   3.825013812590076*^9, 3.825013813636466*^9}, {3.8250293634015303`*^9, 
   3.825029385856772*^9}, {3.82502967155619*^9, 3.8250296837586718`*^9}, {
   3.825029895257599*^9, 3.82502992825124*^9}, {3.825032097796813*^9, 
   3.8250321124511223`*^9}, {3.825032158606945*^9, 3.825032160206163*^9}, {
   3.8250416386959352`*^9, 3.825041643421465*^9}, 3.825042737234213*^9, {
   3.825077184802773*^9, 3.825077185554604*^9}, {3.825081450009161*^9, 
   3.825081450615159*^9}, {3.825087669626779*^9, 3.8250876897682657`*^9}, 
   3.825087831050747*^9},
 CellLabel->
  "In[728]:=",ExpressionUUID->"a34b9aba-4501-4c30-9ae8-24b30d190ada"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Monitor", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"dGodambe", "[", "tissue", "]"}], "=", 
       RowBox[{"godambeInformation", "[", 
        RowBox[{
         RowBox[{"d\[Alpha]f", "[", "tissue", "]"}], ",", 
         RowBox[{"estd\[CapitalPhi]", "[", "tissue", "]"}], ",", 
         RowBox[{"d\[Sigma]f", "[", "tissue", "]"}], ",", 
         RowBox[{"f\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
         RowBox[{
          RowBox[{"dnf", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
          RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ",", "tissue"}], 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.825005992355979*^9, 3.8250060924513893`*^9}, {
   3.8250061225643797`*^9, 3.82500621860539*^9}, {3.825006498821232*^9, 
   3.825006553817264*^9}, {3.825006622133973*^9, 3.8250066291967373`*^9}, {
   3.825006665349613*^9, 3.825006701712419*^9}, {3.82500741643221*^9, 
   3.825007418509789*^9}, {3.825041459498214*^9, 3.8250414642769833`*^9}, {
   3.8250415379899387`*^9, 3.8250415431682158`*^9}, {3.825041695018174*^9, 
   3.82504169530634*^9}, {3.82504236774999*^9, 3.8250423684624023`*^9}, {
   3.8250765145690536`*^9, 3.82507651480678*^9}, {3.8250771976802807`*^9, 
   3.825077198241774*^9}, 3.82508784239808*^9, {3.825094133508265*^9, 
   3.825094135306356*^9}, 3.8250952887545443`*^9, {3.82519159820858*^9, 
   3.8251916637650127`*^9}},
 CellLabel->
  "In[1322]:=",ExpressionUUID->"b6afa1f8-3e6c-4b27-af9b-42c4f92cc343"],

Cell["Evaluate Quality of Confidence Regions", "Text",
 CellChangeTimes->{{3.825088111911242*^9, 3.825088137507453*^9}, {
  3.825095360825471*^9, 3.8250953628958282`*^9}},
 FontSize->18,
 FontColor->RGBColor[
  0.6, 0.4, 0.2],ExpressionUUID->"37d59eae-422d-4b23-b691-20838e61c6b0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"testStatistic", "[", 
   RowBox[{
   "\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", 
    "\[CapitalPsi]_", ",", "n_", ",", "G0_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"zScores", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[CapitalPhi]", ".", "\[Alpha]"}], "-", 
          RowBox[{"\[CapitalPsi]", "/", "n"}]}], ")"}], "/", 
        RowBox[{"MapThread", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Sqrt", "[", 
             RowBox[{
              RowBox[{"\[Sigma]g2", "[", 
               RowBox[{"\[Alpha]", ",", "#1", ",", "#2"}], "]"}], "/", "n"}], 
             "]"}], "/.", 
            RowBox[{"{", 
             RowBox[{"0.", "\[Rule]", 
              RowBox[{"10", "^", 
               RowBox[{"(", 
                RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[CapitalPhi]", ",", "\[Sigma]2"}], "}"}]}], "]"}]}]}], 
      ",", 
      RowBox[{"G", "=", 
       RowBox[{"Length", "[", "\[CapitalPsi]", "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Total", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"CDF", "[", 
             RowBox[{
              RowBox[{"EmpiricalDistribution", "[", 
               RowBox[{"zScores", "-", 
                RowBox[{"Median", "[", "zScores", "]"}]}], "]"}], ",", "#"}], 
             "]"}], "-", 
            RowBox[{"CDF", "[", 
             RowBox[{
              RowBox[{"NormalDistribution", "[", 
               RowBox[{"0", ",", "1."}], "]"}], ",", "#"}], "]"}]}], "]"}], 
          "&"}], "/@", 
         RowBox[{"equiRange", "[", 
          RowBox[{
           RowBox[{"-", "5"}], ",", "5", ",", "G0"}], "]"}]}], "]"}], ")"}], 
      "/", "G0"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"G", 
     RowBox[{"(", 
      RowBox[{"Mean", "[", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{"Sort", "[", "zScores", "]"}], "-", 
          RowBox[{"Sort", "[", 
           RowBox[{"RandomVariate", "[", 
            RowBox[{
             RowBox[{"NormalDistribution", "[", 
              RowBox[{"0", ",", "1"}], "]"}], ",", 
             RowBox[{"Length", "@", "zScores"}]}], "]"}], "]"}]}], "]"}], "^",
         "2"}], "]"}], ")"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.825079697644642*^9, 3.825079815085745*^9}, {
   3.8250813064565983`*^9, 3.82508130664112*^9}, {3.82508825720262*^9, 
   3.82508829067887*^9}, {3.825090880754917*^9, 3.825090892342017*^9}, {
   3.82509099670833*^9, 3.825091056393157*^9}, {3.825091096299844*^9, 
   3.82509109866096*^9}, {3.8250911354384613`*^9, 3.825091191883803*^9}, {
   3.8250912220763073`*^9, 3.8250912245377283`*^9}, {3.8250913495698357`*^9, 
   3.825091353413419*^9}, {3.82509142469147*^9, 3.825091461406836*^9}, 
   3.825091568877143*^9, {3.8250916559904623`*^9, 3.825091700105989*^9}, 
   3.8250917544772463`*^9, {3.8250917861241913`*^9, 3.825091809213436*^9}, {
   3.8250918431328793`*^9, 3.825091844802816*^9}, {3.825091998110466*^9, 
   3.825092073110034*^9}, {3.825092188721856*^9, 3.8250921925310163`*^9}, {
   3.825092227842029*^9, 3.825092233446066*^9}, {3.8250923396763563`*^9, 
   3.825092342271927*^9}, {3.825092380263836*^9, 3.825092394846561*^9}, {
   3.825092985858224*^9, 3.82509298864221*^9}, 3.82509307313848*^9, {
   3.825093147608284*^9, 3.825093150802503*^9}, {3.8250936077825527`*^9, 
   3.825093616076557*^9}, {3.82509364972796*^9, 3.8250936693962297`*^9}, {
   3.825095684052772*^9, 3.825095688212668*^9}, {3.825095729723268*^9, 
   3.825095809934741*^9}, {3.825098927661625*^9, 3.825098949972631*^9}, {
   3.825099199740543*^9, 3.825099266222694*^9}, {3.825099322600322*^9, 
   3.82509932399121*^9}, {3.825099356190605*^9, 3.825099444700449*^9}, {
   3.825099487507003*^9, 3.825099596636882*^9}, {3.825099958040395*^9, 
   3.825099983741724*^9}, {3.825100076539605*^9, 3.825100121784643*^9}, {
   3.8251001799907207`*^9, 3.825100386174185*^9}, {3.8251139779352694`*^9, 
   3.825114045443389*^9}, {3.8251140771053867`*^9, 3.825114130835414*^9}, {
   3.8251142968346233`*^9, 3.825114322387742*^9}},
 CellLabel->
  "In[1166]:=",ExpressionUUID->"be9c2306-6924-48cc-9a6a-2300ade6ea9a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KendallTau", "@@", 
  RowBox[{"Transpose", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"testStatistic", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
          
          RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", 
         RowBox[{"estf\[CapitalPhi]", "[", "tissue", "]"}], ",", 
         RowBox[{"f\[Sigma]f", "[", "tissue", "]"}], ",", 
         RowBox[{"d\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
         RowBox[{
          RowBox[{"fnf", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
          RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "100"}], "]"}], 
       ",", 
       RowBox[{"Mean", "@", 
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{"dmixture", "[", "tissue", "]"}], "-", 
          RowBox[{
           RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
           RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], "]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.825093042600895*^9, 3.825093055568996*^9}, {
  3.8250936377360363`*^9, 3.825093638607519*^9}, {3.8251139392910843`*^9, 
  3.825113940354315*^9}},
 CellLabel->
  "In[1167]:=",ExpressionUUID->"e05ac7b1-eb1d-47b8-8170-07e966eedf13"],

Cell[BoxData["0.23076923076923078`"], "Output",
 CellChangeTimes->{
  3.8250934927791452`*^9, {3.8250936238027*^9, 3.8250936743811483`*^9}, 
   3.82509569192353*^9, 3.825095731905491*^9, 3.825095819704402*^9, 
   3.825098917043227*^9, {3.825099361835206*^9, 3.825099377549728*^9}, {
   3.8250994186695433`*^9, 3.825099447996923*^9}, {3.825099530046633*^9, 
   3.8250996141330767`*^9}, {3.82509996744989*^9, 3.825099987731987*^9}, {
   3.8251000800664873`*^9, 3.825100123842289*^9}, {3.82510018280214*^9, 
   3.825100207114687*^9}, {3.825100268326936*^9, 3.825100343647875*^9}, {
   3.825100376900625*^9, 3.825100388553557*^9}, 3.8251139446300297`*^9, {
   3.825113984925758*^9, 3.825114047916275*^9}, {3.8251141049155817`*^9, 
   3.8251141328622*^9}, {3.825114316652812*^9, 3.825114324715818*^9}},
 CellLabel->
  "Out[1167]=",ExpressionUUID->"813b445d-33c2-435b-93b2-99a09941f9d6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KendallTau", "@@", 
  RowBox[{"Transpose", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"testStatistic", "[", 
        RowBox[{
         RowBox[{"d\[Alpha]f", "[", "tissue", "]"}], ",", 
         RowBox[{"estd\[CapitalPhi]", "[", "tissue", "]"}], ",", 
         RowBox[{"d\[Sigma]f", "[", "tissue", "]"}], ",", 
         RowBox[{"f\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
         RowBox[{
          RowBox[{"dnf", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
          RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "100"}], "]"}], 
       ",", 
       RowBox[{"Mean", "@", 
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{"fmixture", "[", "tissue", "]"}], "-", 
          RowBox[{"d\[Alpha]f", "[", "tissue", "]"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.825093042600895*^9, 3.825093055568996*^9}, {
  3.8250936377360363`*^9, 3.825093638607519*^9}, {3.825093993188469*^9, 
  3.825094011521299*^9}, {3.825113947132577*^9, 3.825113948331987*^9}},
 CellLabel->
  "In[1168]:=",ExpressionUUID->"aee54b42-e501-488b-92c3-339632228f00"],

Cell[BoxData["0.3076923076923077`"], "Output",
 CellChangeTimes->{
  3.825094016060822*^9, 3.82509890267706*^9, {3.8250989446040583`*^9, 
   3.8250989538325367`*^9}, 3.825099273680582*^9, 3.82509933559275*^9, 
   3.825099369094954*^9, {3.8250994290620823`*^9, 3.825099452144333*^9}, {
   3.8250995325598927`*^9, 3.825099616375717*^9}, {3.82509996976327*^9, 
   3.825099989923993*^9}, {3.82510008220007*^9, 3.825100126190404*^9}, {
   3.825100185268941*^9, 3.8251002088098917`*^9}, {3.8251002724736567`*^9, 
   3.825100347747777*^9}, {3.825100379456503*^9, 3.8251003906019087`*^9}, 
   3.825111625677917*^9, 3.8251139499784203`*^9, {3.8251139892355537`*^9, 
   3.825114049328979*^9}, {3.825114107154829*^9, 3.825114134453155*^9}, {
   3.825114319256959*^9, 3.825114326298896*^9}},
 CellLabel->
  "Out[1168]=",ExpressionUUID->"5e824bb8-1b6d-4a0a-ba47-73b1b9591dcc"]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"effectiveG", "[", 
   RowBox[{
   "\[Alpha]_", ",", "\[CapitalPhi]_", ",", "\[Sigma]2_", ",", 
    "\[CapitalPsi]_", ",", "n_", ",", "G0_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"testStat", "=", 
       RowBox[{"testStatistic", "[", 
        RowBox[{
        "\[Alpha]", ",", "\[CapitalPhi]", ",", "\[Sigma]2", ",", 
         "\[CapitalPsi]", ",", "n", ",", "G0"}], "]"}]}], ",", 
      RowBox[{"G", "=", 
       RowBox[{"Length", "[", "\[CapitalPsi]", "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"1.", "*", 
     RowBox[{"Sqrt", "[", "G", "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.825079697644642*^9, 3.825079815085745*^9}, {
  3.8250813064565983`*^9, 3.82508130664112*^9}, {3.82508825720262*^9, 
  3.82508829067887*^9}, {3.825092844229856*^9, 3.825092850590435*^9}, {
  3.825093191339641*^9, 3.825093232654337*^9}, {3.825093292939769*^9, 
  3.82509329508779*^9}, {3.8250934255761623`*^9, 3.825093428956416*^9}, {
  3.825093467976025*^9, 3.825093470125671*^9}, {3.825093686689186*^9, 
  3.825093687096084*^9}, {3.825093738031726*^9, 3.82509373833318*^9}, {
  3.82510040845335*^9, 3.825100408729362*^9}, {3.8251004792186527`*^9, 
  3.825100485859911*^9}, {3.825100528851139*^9, 3.825100535406567*^9}, {
  3.825113775190298*^9, 3.825113776302703*^9}, {3.825114155324704*^9, 
  3.825114163101651*^9}, {3.825114198455594*^9, 3.825114199268774*^9}, {
  3.825114326227461*^9, 3.825114328024529*^9}},
 CellLabel->
  "In[250]:=",ExpressionUUID->"74b65fe9-a773-4432-bce7-9d22775adaf7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"Transpose", "@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", 
             RowBox[{"f\[CapitalPhi]f", "[", "#", "]"}], "]"}], "&"}], "/@", 
           "tissues"}], ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Mean", "@", 
             RowBox[{"Abs", "[", 
              RowBox[{
               RowBox[{"dmixture", "[", "tissue", "]"}], "-", 
               RowBox[{
                RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
                "\[LeftDoubleBracket]", 
                RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}]}], "}"}]}], 
       ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"300", ",", "200"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Full"}], ",", 
       RowBox[{"PlotTheme", "\[Rule]", "\"\<Scientific\>\""}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<G\>\"", ",", 
          "\"\<\!\(\*SubscriptBox[\(E\), SuperscriptBox[\(L\), \
\(1\)]]\)\>\""}], "}"}]}]}], "]"}], ",", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"Transpose", "@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"effectiveG", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"f\[Alpha]f", "[", "#", "]"}], "\[LeftDoubleBracket]", 
               
               RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", 
              RowBox[{"f\[CapitalPhi]f", "[", "#", "]"}], ",", 
              RowBox[{"f\[Sigma]f", "[", "#", "]"}], ",", 
              RowBox[{"d\[CapitalPsi]f", "[", "#", "]"}], ",", 
              RowBox[{
               RowBox[{"fnf", "[", "#", "]"}], "\[LeftDoubleBracket]", 
               RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "500"}], 
             "]"}], "&"}], "/@", "tissues"}], ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Mean", "@", 
             RowBox[{"Abs", "[", 
              RowBox[{
               RowBox[{"dmixture", "[", "tissue", "]"}], "-", 
               RowBox[{
                RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
                "\[LeftDoubleBracket]", 
                RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}]}], "}"}]}], 
       ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"300", ",", "200"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Full"}], ",", 
       RowBox[{"PlotTheme", "\[Rule]", "\"\<Scientific\>\""}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(G\), \(eff\)]\)\>\"", ",", 
          "\"\<\!\(\*SubscriptBox[\(E\), SuperscriptBox[\(L\), \
\(1\)]]\)\>\""}], "}"}]}]}], "]"}], ",", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Tooltip", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"testStatistic", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
                "\[LeftDoubleBracket]", 
                RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", 
               RowBox[{"f\[CapitalPhi]f", "[", "tissue", "]"}], ",", 
               RowBox[{"f\[Sigma]f", "[", "tissue", "]"}], ",", 
               RowBox[{"d\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
               RowBox[{
                RowBox[{"fnf", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
                RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "100"}], 
              "]"}], ",", 
             RowBox[{"Mean", "@", 
              RowBox[{"Abs", "[", 
               RowBox[{
                RowBox[{"dmixture", "[", "tissue", "]"}], "-", 
                RowBox[{
                 RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
                 "\[LeftDoubleBracket]", 
                 RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], "]"}]}]}], 
            "}"}], ",", "tissue"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "All"}], "}"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"300", ",", "200"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Full"}], ",", 
       RowBox[{"PlotTheme", "\[Rule]", "\"\<Scientific\>\""}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<z-median\>\"", ",", 
          "\"\<\!\(\*SubscriptBox[\(E\), SuperscriptBox[\(L\), \
\(1\)]]\)\>\""}], "}"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Spacer", "[", "10", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8250806687455063`*^9, 3.8250807513175793`*^9}, 
   3.8250808705509987`*^9, {3.82508910305219*^9, 3.82508917210956*^9}, {
   3.825090897542563*^9, 3.8250908996958*^9}, {3.8250921101781178`*^9, 
   3.8250921692742167`*^9}, {3.8250922545862226`*^9, 3.825092254771019*^9}, {
   3.825093120370261*^9, 3.825093124552545*^9}, {3.825099939061969*^9, 
   3.825099939831664*^9}},
 CellLabel->
  "In[1041]:=",ExpressionUUID->"8722b34c-6308-49d2-b028-d66f3af95570"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{10}, "Spacer1"], 
   GraphicsBox[{{}, {{{
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        PointBox[{{3210., 0.018927798535639917`}, {9909., 
         0.05724280883513015}, {10113., 0.008291223116877902}, {10109., 
         0.08113093837980909}, {2553., 0.016756914548680474`}, {10233., 
         0.020130106535967963`}, {10049., 0.016359410550164516`}, {10873., 
         0.1229125818137067}, {3263., 0.07601915303104552}, {11456., 
         0.03845891313923175}, {10137., 0.04042346457809729}, {11116., 
         0.05079395712089335}, {10014., 0.060859175693539}}]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     Full, Axes -> {False, False}, AxesLabel -> {None, None}, 
     AxesOrigin -> {2367.5208333333335`, 0}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(E\\), SuperscriptBox[\\(L\\), \
\\(1\\)]]\\)\"", TraditionalForm], None}, {
        FormBox["\"G\"", TraditionalForm], None}}, FrameStyle -> Automatic, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{0}, {0}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> {300, 200}, 
     LabelStyle -> {FontFamily -> "Times"}, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{2367.5208333333335`, 11456.}, {0, 0.1229125818137067}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   GraphicsBox[{{}, {{{
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        PointBox[{{717721.3778942719, 0.018927798535639917`}, {
         1.2165333320512923`*^6, 0.05724280883513015}, {1.668151542235941*^6, 
         0.008291223116877902}, {2.2337631060420293`*^6, 
         0.08113093837980909}, {907093.907519507, 0.016756914548680474`}, {
         928591.0764978394, 0.020130106535967963`}, {4.841481451888751*^6, 
         0.016359410550164516`}, {1.5238291426256753`*^6, 
         0.1229125818137067}, {1.0534432056934487`*^6, 0.07601915303104552}, {
         1.0028395441867434`*^6, 0.03845891313923175}, {1.044348796475521*^6, 
         0.04042346457809729}, {1.2860134436470168`*^6, 
         0.05079395712089335}, {2.1042186533482132`*^20, 
         0.060859175693539}}]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     Full, Axes -> {False, False}, AxesLabel -> {None, None}, 
     AxesOrigin -> {645350.5493012711, 0}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(E\\), SuperscriptBox[\\(L\\), \
\\(1\\)]]\\)\"", TraditionalForm], None}, {
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(G\\), \\(eff\\)]\\)\"", TraditionalForm], 
        None}}, FrameStyle -> Automatic, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{0}, {0}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> {300, 200}, 
     LabelStyle -> {FontFamily -> "Times"}, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{645350.5493012711, 4.1915211503583146`*^6}, {
       0, 0.1229125818137067}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   GraphicsBox[{{}, {{{
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        PointBox[{{1472.8707852410002`, 0.018927798535639917`}, {
         2454.5087543100108`, 0.05724280883513015}, {3379.651957354644, 
         0.008291223116877902}, {4282.277482437709, 0.08113093837980909}, {
         1859.9231655467524`, 0.016756914548680474`}, {1785.6269706405342`, 
         0.020130106535967963`}, {9686.06884996653, 0.016359410550164516`}, {
         3195.0037497554404`, 0.1229125818137067}, {2110.757722748899, 
         0.07601915303104552}, {2034.6161151182748`, 0.03845891313923175}, {
         1906.2804939439425`, 0.04042346457809729}, {2590.884699183051, 
         0.05079395712089335}, {4.208437310953327*^17, 
         0.060859175693539}}]}}, {
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{1472.8707852410002`, 0.018927798535639917`}}]}, "skin"], 
        Annotation[#, $CellContext`skin, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{2454.5087543100108`, 0.05724280883513015}}]}, "liver"], 
        Annotation[#, $CellContext`liver, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{3379.651957354644, 0.008291223116877902}}]}, "pancreas"],
         Annotation[#, $CellContext`pancreas, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{4282.277482437709, 0.08113093837980909}}]}, "bladder"], 
        Annotation[#, $CellContext`bladder, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{1859.9231655467524`, 0.016756914548680474`}}]}, 
         "thymus"], Annotation[#, $CellContext`thymus, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{1785.6269706405342`, 0.020130106535967963`}}]}, 
         "mammarygland"], 
        Annotation[#, $CellContext`mammarygland, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{9686.06884996653, 0.016359410550164516`}}]}, "tongue"], 
        Annotation[#, $CellContext`tongue, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{3195.0037497554404`, 0.1229125818137067}}]}, "trachea"], 
        Annotation[#, $CellContext`trachea, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{2110.757722748899, 0.07601915303104552}}]}, 
         "largeintestine"], 
        Annotation[#, $CellContext`largeintestine, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{2034.6161151182748`, 0.03845891313923175}}]}, 
         "limbmuscle"], Annotation[#, $CellContext`limbmuscle, "Tooltip"]& ], 
       
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{1906.2804939439425`, 0.04042346457809729}}]}, "kidney"], 
        Annotation[#, $CellContext`kidney, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{2590.884699183051, 0.05079395712089335}}]}, "lung"], 
        Annotation[#, $CellContext`lung, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{4.208437310953327*^17, 0.060859175693539}}]}, "marrow"], 
        Annotation[#, $CellContext`marrow, "Tooltip"]& ]}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     Full, Axes -> {False, False}, AxesLabel -> {None, None}, 
     AxesOrigin -> {1338.6429066465598`, 0}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(E\\), SuperscriptBox[\\(L\\), \
\\(1\\)]]\\)\"", TraditionalForm], None}, {
        FormBox["\"z-median\"", TraditionalForm], None}}, FrameStyle -> 
     Automatic, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{0}, {0}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> {300, 200}, 
     LabelStyle -> {FontFamily -> "Times"}, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{1338.6429066465598`, 7915.808957774145}, {
       0, 0.1229125818137067}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}]},
  "RowWithSeparator"]], "Output",
 CellChangeTimes->{{3.825080705687047*^9, 3.825080751898653*^9}, 
   3.8250808708760633`*^9, 3.825089110612555*^9, 3.8250891753924017`*^9, {
   3.825092114043817*^9, 3.825092170929062*^9}, 3.825092257944076*^9, 
   3.825092997466066*^9, 3.825093082752055*^9, 3.825093127804866*^9, 
   3.825093165996276*^9, 3.825095702361435*^9, 3.8250957364286957`*^9, 
   3.8250958392599897`*^9, 3.82509964480595*^9, 3.825099943162244*^9, 
   3.825100134316791*^9},
 CellLabel->
  "Out[1041]=",ExpressionUUID->"900aaaee-40b5-431d-8f26-ef9a824af532"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"Transpose", "@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", 
             RowBox[{"d\[CapitalPhi]f", "[", "#", "]"}], "]"}], "&"}], "/@", 
           "tissues"}], ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Mean", "@", 
             RowBox[{"Abs", "[", 
              RowBox[{
               RowBox[{"fmixture", "[", "tissue", "]"}], "-", 
               RowBox[{"d\[Alpha]f", "[", "tissue", "]"}]}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}]}], "}"}]}], 
       ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"300", ",", "200"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Full"}], ",", 
       RowBox[{"PlotTheme", "\[Rule]", "\"\<Scientific\>\""}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<G\>\"", ",", 
          "\"\<\!\(\*SubscriptBox[\(E\), SuperscriptBox[\(L\), \
\(1\)]]\)\>\""}], "}"}]}]}], "]"}], ",", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"Transpose", "@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"effectiveG", "[", 
             RowBox[{
              RowBox[{"d\[Alpha]f", "[", "#", "]"}], ",", 
              RowBox[{"d\[CapitalPhi]f", "[", "#", "]"}], ",", 
              RowBox[{"d\[Sigma]f", "[", "#", "]"}], ",", 
              RowBox[{"f\[CapitalPsi]f", "[", "#", "]"}], ",", 
              RowBox[{
               RowBox[{"dnf", "[", "#", "]"}], "\[LeftDoubleBracket]", 
               RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "500"}], 
             "]"}], "&"}], "/@", "tissues"}], ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Mean", "@", 
             RowBox[{"Abs", "[", 
              RowBox[{
               RowBox[{"fmixture", "[", "tissue", "]"}], "-", 
               RowBox[{"d\[Alpha]f", "[", "tissue", "]"}]}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}]}], "}"}]}], 
       ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"300", ",", "200"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Full"}], ",", 
       RowBox[{"PlotTheme", "\[Rule]", "\"\<Scientific\>\""}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(G\), \(eff\)]\)\>\"", ",", 
          "\"\<\!\(\*SubscriptBox[\(E\), SuperscriptBox[\(L\), \
\(1\)]]\)\>\""}], "}"}]}]}], "]"}], ",", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Tooltip", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"testStatistic", "[", 
              RowBox[{
               RowBox[{"d\[Alpha]f", "[", "tissue", "]"}], ",", 
               RowBox[{"d\[CapitalPhi]f", "[", "tissue", "]"}], ",", 
               RowBox[{"d\[Sigma]f", "[", "tissue", "]"}], ",", 
               RowBox[{"f\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
               RowBox[{
                RowBox[{"dnf", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
                RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "100"}], 
              "]"}], ",", 
             RowBox[{"Mean", "@", 
              RowBox[{"Abs", "[", 
               RowBox[{
                RowBox[{"fmixture", "[", "tissue", "]"}], "-", 
                RowBox[{"d\[Alpha]f", "[", "tissue", "]"}]}], "]"}]}]}], 
            "}"}], ",", "tissue"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "All"}], "}"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"300", ",", "200"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Full"}], ",", 
       RowBox[{"PlotTheme", "\[Rule]", "\"\<Scientific\>\""}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<z-median\>\"", ",", 
          "\"\<\!\(\*SubscriptBox[\(E\), SuperscriptBox[\(L\), \
\(1\)]]\)\>\""}], "}"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Spacer", "[", "10", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8250806687455063`*^9, 3.8250807513175793`*^9}, 
   3.8250808705509987`*^9, {3.82508910305219*^9, 3.82508917210956*^9}, {
   3.825090897542563*^9, 3.8250908996958*^9}, {3.8250921101781178`*^9, 
   3.8250921692742167`*^9}, {3.8250922545862226`*^9, 3.825092254771019*^9}, {
   3.825093120370261*^9, 3.825093124552545*^9}, {3.825099939061969*^9, 
   3.825099939831664*^9}, {3.8251005488658323`*^9, 3.825100564338826*^9}, {
   3.825111645191985*^9, 3.8251116954502974`*^9}},
 CellLabel->
  "In[1101]:=",ExpressionUUID->"4fb325cb-8e2f-457c-ad9a-33a7a525162e"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{10}, "Spacer1"], 
   GraphicsBox[{{}, {{{
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        PointBox[{{9774., 0.03672318248591139}, {12123., 
         0.038410220684054544`}, {12806., 0.09543675426055935}, {11981., 
         0.001736007810590856}, {6540., 0.0016561581459757224`}, {10780., 
         0.008839946853855455}, {8464., 0.0060963827232151935`}, {12483., 
         0.09155369982906192}, {3762., 0.11700189002987611`}, {12992., 
         0.017802085342013618`}, {5023., 0.028472364798096915`}, {13326., 
         0.02626914496394543}, {11232., 
         0.06959330555596482}}]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     Full, Axes -> {False, False}, AxesLabel -> {None, None}, 
     AxesOrigin -> {3562.7500000000005`, 0}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(E\\), SuperscriptBox[\\(L\\), \
\\(1\\)]]\\)\"", TraditionalForm], None}, {
        FormBox["\"G\"", TraditionalForm], None}}, FrameStyle -> Automatic, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{0}, {0}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> {300, 200}, 
     LabelStyle -> {FontFamily -> "Times"}, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{3562.7500000000005`, 13326.}, {0, 0.11700189002987611`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   GraphicsBox[{{}, {{{
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        PointBox[{{98.8635423197045, 0.03672318248591139}, {110.1044958210154,
          0.038410220684054544`}, {113.16359838746733`, 
         0.09543675426055935}, {109.45775440780794`, 0.001736007810590856}, {
         80.87026647662292, 0.0016561581459757224`}, {103.82677881933928`, 
         0.008839946853855455}, {92., 0.0060963827232151935`}, {
         111.72734669721643`, 0.09155369982906192}, {61.335144900782616`, 
         0.11700189002987611`}, {113.98245479020005`, 
         0.017802085342013618`}, {70.87312607751969, 0.028472364798096915`}, {
         115.43829520570719`, 0.02626914496394543}, {105.98113039593416`, 
         0.06959330555596482}}]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     Full, Axes -> {False, False}, AxesLabel -> {None, None}, 
     AxesOrigin -> {60.20799593609669, 0}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(E\\), SuperscriptBox[\\(L\\), \
\\(1\\)]]\\)\"", TraditionalForm], None}, {
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(G\\), \\(eff\\)]\\)\"", TraditionalForm], 
        None}}, FrameStyle -> Automatic, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{0}, {0}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> {300, 200}, 
     LabelStyle -> {FontFamily -> "Times"}, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{60.20799593609669, 115.43829520570719`}, {
       0, 0.11700189002987611`}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   GraphicsBox[{{}, {{{
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        PointBox[{{3.529366741963576*^7, 0.03672318248591139}, {
         7.539623040541632*^7, 0.038410220684054544`}, {9.235625821421818*^7, 
         0.09543675426055935}, {4.813990354122145*^7, 0.001736007810590856}, {
         3.2354856484836165`*^7, 0.0016561581459757224`}, {
         6.02791340738732*^7, 0.008839946853855455}, {1.7086543398901045`*^7, 
         0.0060963827232151935`}, {1.358799517143551*^8, 
         0.09155369982906192}, {5.777460784649181*^6, 0.11700189002987611`}, {
         9.398658733284292*^7, 0.017802085342013618`}, {3.40723958587009*^6, 
         0.028472364798096915`}, {2.659031639410434*^15, 
         0.02626914496394543}, {1.4660151098146578`*^14, 
         0.06959330555596482}}]}}, {
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{3.529366741963576*^7, 0.03672318248591139}}]}, "skin"], 
        Annotation[#, $CellContext`skin, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{7.539623040541632*^7, 0.038410220684054544`}}]}, 
         "liver"], Annotation[#, $CellContext`liver, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{9.235625821421818*^7, 0.09543675426055935}}]}, 
         "pancreas"], Annotation[#, $CellContext`pancreas, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{4.813990354122145*^7, 0.001736007810590856}}]}, 
         "bladder"], Annotation[#, $CellContext`bladder, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{3.2354856484836165`*^7, 0.0016561581459757224`}}]}, 
         "thymus"], Annotation[#, $CellContext`thymus, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{6.02791340738732*^7, 0.008839946853855455}}]}, 
         "mammarygland"], 
        Annotation[#, $CellContext`mammarygland, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{1.7086543398901045`*^7, 0.0060963827232151935`}}]}, 
         "tongue"], Annotation[#, $CellContext`tongue, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{1.358799517143551*^8, 0.09155369982906192}}]}, 
         "trachea"], Annotation[#, $CellContext`trachea, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{5.777460784649181*^6, 0.11700189002987611`}}]}, 
         "largeintestine"], 
        Annotation[#, $CellContext`largeintestine, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{9.398658733284292*^7, 0.017802085342013618`}}]}, 
         "limbmuscle"], Annotation[#, $CellContext`limbmuscle, "Tooltip"]& ], 
       
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{3.40723958587009*^6, 0.028472364798096915`}}]}, 
         "kidney"], Annotation[#, $CellContext`kidney, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{2.659031639410434*^15, 0.02626914496394543}}]}, "lung"], 
        Annotation[#, $CellContext`lung, "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Opacity[0.], 
          PointBox[{{1.4660151098146578`*^14, 0.06959330555596482}}]}, 
         "marrow"], 
        Annotation[#, $CellContext`marrow, "Tooltip"]& ]}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     Full, Axes -> {False, False}, AxesLabel -> {None, None}, 
     AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(E\\), SuperscriptBox[\\(L\\), \
\\(1\\)]]\\)\"", TraditionalForm], None}, {
        FormBox["\"z-median\"", TraditionalForm], None}}, FrameStyle -> 
     Automatic, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{0}, {0}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> {300, 200}, 
     LabelStyle -> {FontFamily -> "Times"}, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0, 3.1407006418753624`*^8}, {0, 0.11700189002987611`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}]},
  "RowWithSeparator"]], "Output",
 CellChangeTimes->{3.825111700316629*^9},
 CellLabel->
  "Out[1101]=",ExpressionUUID->"be2a8e10-0079-4582-8f79-bfd60413498e"]
}, Closed]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"fempConfidences", "[", "#", "]"}], "=", 
      RowBox[{"singleConfidences", "[", 
       RowBox[{"(*", 
        RowBox[{"fempFisher", "[", "#", "]"}], "*)"}], 
       RowBox[{
        RowBox[{"fGodambe", "[", "#", "]"}], ",", 
        RowBox[{"effectiveG", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"f\[Alpha]f", "[", "#", "]"}], "\[LeftDoubleBracket]", 
           RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", 
          RowBox[{"estf\[CapitalPhi]", "[", "#", "]"}], ",", 
          RowBox[{"f\[Sigma]f", "[", "#", "]"}], ",", 
          RowBox[{"d\[CapitalPsi]f", "[", "#", "]"}], ",", 
          RowBox[{
           RowBox[{"fnf", "[", "#", "]"}], "\[LeftDoubleBracket]", 
           RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "1"}], "]"}]}],
        "]"}]}], ")"}], "&"}], "/@", "tissues"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"dempConfidences", "[", "#", "]"}], "=", 
      RowBox[{"singleConfidences", "[", 
       StyleBox[
        RowBox[{"(*", 
         RowBox[{"dempFisher", "[", "#", "]"}], "*)"}], "CodeText"], 
       RowBox[{
        RowBox[{"dGodambe", "[", "#", "]"}], ",", 
        RowBox[{"effectiveG", "[", 
         RowBox[{
          RowBox[{"d\[Alpha]f", "[", "#", "]"}], ",", 
          RowBox[{"estd\[CapitalPhi]", "[", "#", "]"}], ",", 
          RowBox[{"d\[Sigma]f", "[", "#", "]"}], ",", 
          RowBox[{"f\[CapitalPsi]f", "[", "#", "]"}], ",", 
          RowBox[{
           RowBox[{"dnf", "[", "#", "]"}], "\[LeftDoubleBracket]", 
           RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "1"}], "]"}]}],
        "]"}]}], ")"}], "&"}], "/@", "tissues"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8250384624558496`*^9, 3.82503848001868*^9}, {
   3.825038812793841*^9, 3.825038816860279*^9}, {3.825042702860712*^9, 
   3.825042739923188*^9}, {3.8250772100725393`*^9, 3.8250772107599363`*^9}, {
   3.825080940417789*^9, 3.8250809480720987`*^9}, {3.82508101957695*^9, 
   3.8250810234710407`*^9}, {3.8250810626457253`*^9, 3.825081106559539*^9}, {
   3.8250811630451307`*^9, 3.8250811661187*^9}, {3.825081584277103*^9, 
   3.8250815844965687`*^9}, {3.8250817909222307`*^9, 3.825081790968676*^9}, 
   3.825087928259282*^9, 3.8250881670499487`*^9, {3.8250889620200357`*^9, 
   3.825088972931767*^9}, {3.825094100274828*^9, 3.825094102953905*^9}, {
   3.8250954417985*^9, 3.825095448326974*^9}, 3.825095554437544*^9, {
   3.825100417220928*^9, 3.825100423088347*^9}, 3.825100517318372*^9, {
   3.825114334632072*^9, 3.825114334799678*^9}, {3.8251145298274517`*^9, 
   3.8251145314976892`*^9}, {3.825192170791293*^9, 3.825192186616829*^9}, {
   3.825192253823078*^9, 3.825192255525635*^9}, {3.82519230179947*^9, 
   3.825192303281966*^9}},
 CellLabel->
  "In[1335]:=",ExpressionUUID->"a0f78ba1-74eb-41f6-8b57-7f6e4190c10b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{
             RowBox[{"ChiSquareDistribution", "[", 
              RowBox[{"Length", "@", 
               RowBox[{"dmixture", "[", "tissue", "]"}]}], "]"}], ",", "#"}], 
            "]"}], "&"}], "@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Part", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"dmixture", "[", "tissue", "]"}], "-", 
               RowBox[{
                RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
                "\[LeftDoubleBracket]", 
                RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], ",", 
              RowBox[{";;", 
               RowBox[{"-", "2"}]}]}], "]"}], ".", 
            RowBox[{"Inverse", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"fempFisher", "[", "tissue", "]"}], 
               "\[LeftDoubleBracket]", 
               RowBox[{
                RowBox[{";;", 
                 RowBox[{"-", "2"}]}], ",", 
                RowBox[{";;", 
                 RowBox[{"-", "2"}]}]}], "\[RightDoubleBracket]"}], "/", 
              RowBox[{"(", 
               RowBox[{"effectiveG", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
                  "\[LeftDoubleBracket]", 
                  RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", 
                 RowBox[{"f\[CapitalPhi]f", "[", "tissue", "]"}], ",", 
                 RowBox[{"f\[Sigma]f", "[", "tissue", "]"}], ",", 
                 RowBox[{"d\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
                 RowBox[{
                  RowBox[{"fnf", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
                  RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "1"}], 
                "]"}], ")"}]}], "]"}], ".", 
            RowBox[{"Part", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"dmixture", "[", "tissue", "]"}], "-", 
               RowBox[{
                RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
                "\[LeftDoubleBracket]", 
                RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], ",", 
              RowBox[{";;", 
               RowBox[{"-", "2"}]}]}], "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"300", ",", "200"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Full"}], ",", 
       RowBox[{"PlotTheme", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Scientific\>\"", ",", "\"\<BoldScheme\>\""}], "}"}]}], 
       ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.025"}], ",", "1"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{
             RowBox[{"ChiSquareDistribution", "[", 
              RowBox[{"Length", "@", 
               RowBox[{"fmixture", "[", "tissue", "]"}]}], "]"}], ",", "#"}], 
            "]"}], "&"}], "@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Part", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"fmixture", "[", "tissue", "]"}], "-", 
               RowBox[{"d\[Alpha]f", "[", "tissue", "]"}]}], ",", 
              RowBox[{";;", 
               RowBox[{"-", "2"}]}]}], "]"}], ".", 
            RowBox[{"Inverse", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"dempFisher", "[", "tissue", "]"}], 
               "\[LeftDoubleBracket]", 
               RowBox[{
                RowBox[{";;", 
                 RowBox[{"-", "2"}]}], ",", 
                RowBox[{";;", 
                 RowBox[{"-", "2"}]}]}], "\[RightDoubleBracket]"}], "/", 
              RowBox[{"(", 
               RowBox[{"effectiveG", "[", 
                RowBox[{
                 RowBox[{"d\[Alpha]f", "[", "tissue", "]"}], ",", 
                 RowBox[{"d\[CapitalPhi]f", "[", "tissue", "]"}], ",", 
                 RowBox[{"d\[Sigma]f", "[", "tissue", "]"}], ",", 
                 RowBox[{"f\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
                 RowBox[{
                  RowBox[{"dnf", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
                  RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "1"}], 
                "]"}], ")"}]}], "]"}], ".", 
            RowBox[{"Part", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"fmixture", "[", "tissue", "]"}], "-", 
               RowBox[{"d\[Alpha]f", "[", "tissue", "]"}]}], ",", 
              RowBox[{";;", 
               RowBox[{"-", "2"}]}]}], "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"300", ",", "200"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Full"}], ",", 
       RowBox[{"PlotTheme", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Scientific\>\"", ",", "\"\<BoldScheme\>\""}], "}"}]}], 
       ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.025"}], ",", "1"}], "}"}]}]}], "]"}]}], "}"}], ",", 
   
   RowBox[{"Spacer", "[", "10", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.82503703120687*^9, 3.825037224192007*^9}, {
   3.8250427781933107`*^9, 3.8250427870152283`*^9}, {3.82507719390096*^9, 
   3.825077194550398*^9}, {3.8250878030279207`*^9, 3.825087817800074*^9}, {
   3.8250889893844643`*^9, 3.8250890146275787`*^9}, {3.825089051301076*^9, 
   3.825089052332111*^9}, {3.825089084021214*^9, 3.825089084388377*^9}, {
   3.8250899359069347`*^9, 3.8250899603511477`*^9}, {3.8250907676643143`*^9, 
   3.825090775186919*^9}, {3.82509229825926*^9, 3.8250923341572847`*^9}, {
   3.825092440688744*^9, 3.825092509495598*^9}, {3.825092699511845*^9, 
   3.8250928006205053`*^9}, {3.825093245473806*^9, 3.825093259871872*^9}, {
   3.825093436949348*^9, 3.825093455261701*^9}, {3.825093703590807*^9, 
   3.825093724215804*^9}, {3.825095335259563*^9, 3.8250953440616493`*^9}, {
   3.825095404151134*^9, 3.825095418658535*^9}, {3.825095541317049*^9, 
   3.825095546871273*^9}, {3.825100026609909*^9, 3.82510004582417*^9}, {
   3.825100429434453*^9, 3.825100502654591*^9}, {3.825111741198349*^9, 
   3.825111870697812*^9}, 3.825114225303389*^9},
 CellLabel->
  "In[1337]:=",ExpressionUUID->"7fbb8093-cee6-4c62-b1ab-c03a8f9a22ed"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{10}, "Spacer1"], 
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[7, 360], 0.019444444444444445`]], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        LineBox[{{1., 0.01517068298328017}, {2., 0.36982785243724947`}, {3., 
         0.00006861472692174649}, {4., 0.6364559657991832}, {5., 
         0.004735602288394203}, {6., 0.019127467809524953`}, {7., 
         0.04029141757689558}, {8., 0.38776245264923137`}, {9., 
         0.0020331384839467636`}, {10., 0.37886854207762954`}, {11., 
         0.9268895766086224}, {12., 0.2246800123433866}, {13., 
         0.999999979553431}}]}}, {{
        Directive[
         PointSize[
          NCache[
           Rational[7, 360], 0.019444444444444445`]], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{{
                GrayLevel[1], 
                DiskBox[{0, 0}, 
                 Offset[{3, 3}]]}, 
               AbsoluteThickness[1.5], 
               Dashing[{}], 
               CircleBox[{0, 0}, 
                Offset[{3, 3}]]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 PointSize[
                  Rational[7, 360]], 
                 RGBColor[0.9, 0.36, 0.054], 
                 CapForm["Butt"], 
                 AbsoluteThickness[1.6]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Scaled[9.75]], {{{1., 0.01517068298328017}}, {{2., 
         0.36982785243724947`}}, {{3., 0.00006861472692174649}}, {{4., 
         0.6364559657991832}}, {{5., 0.004735602288394203}}, {{6., 
         0.019127467809524953`}}, {{7., 0.04029141757689558}}, {{8., 
         0.38776245264923137`}}, {{9., 0.0020331384839467636`}}, {{10., 
         0.37886854207762954`}}, {{11., 0.9268895766086224}}, {{12., 
         0.2246800123433866}}, {{13., 0.999999979553431}}}]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     Full, Axes -> {False, False}, AxesLabel -> {None, None}, 
     AxesOrigin -> {0., 0}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> Automatic, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{0}, {0}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> {300, 200}, 
     LabelStyle -> {FontFamily -> "Times"}, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotRange -> {{0., 13.}, {-0.025, 1}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {Automatic, Automatic}}], 
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[7, 360], 0.019444444444444445`]], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        LineBox[{{1., 0.07047632403523174}, {2., 0.7228272919399938}, {3., 
         0.9993223287153803}, {4., 0.0016402496808570755`}, {5., 
         0.0003518991506842317}, {6., 0.02955890402444623}, {7., 
         0.002462480310471027}, {8., 0.999999994489534}, {9., 
         0.9998059845595864}, {10., 0.155906856230597}, {11., 
         0.12077533062139391`}, {12., 0.12921924563564263`}, {13., 1.}}]}}, {{
       
        Directive[
         PointSize[
          NCache[
           Rational[7, 360], 0.019444444444444445`]], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{{
                GrayLevel[1], 
                DiskBox[{0, 0}, 
                 Offset[{3, 3}]]}, 
               AbsoluteThickness[1.5], 
               Dashing[{}], 
               CircleBox[{0, 0}, 
                Offset[{3, 3}]]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 PointSize[
                  Rational[7, 360]], 
                 RGBColor[0.9, 0.36, 0.054], 
                 CapForm["Butt"], 
                 AbsoluteThickness[1.6]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Scaled[9.75]], {{{1., 0.07047632403523174}}, {{2., 
         0.7228272919399938}}, {{3., 0.9993223287153803}}, {{4., 
         0.0016402496808570755`}}, {{5., 0.0003518991506842317}}, {{6., 
         0.02955890402444623}}, {{7., 0.002462480310471027}}, {{8., 
         0.999999994489534}}, {{9., 0.9998059845595864}}, {{10., 
         0.155906856230597}}, {{11., 0.12077533062139391`}}, {{12., 
         0.12921924563564263`}}, {{13., 1.}}}]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     Full, Axes -> {False, False}, AxesLabel -> {None, None}, 
     AxesOrigin -> {0., 0}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> Automatic, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{0}, {0}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> {300, 200}, 
     LabelStyle -> {FontFamily -> "Times"}, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotRange -> {{0., 13.}, {-0.025, 1}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {Automatic, Automatic}}]},
  "RowWithSeparator"]], "Output",
 CellChangeTimes->{{3.8250889983452387`*^9, 3.8250890279929256`*^9}, {
   3.8250890766127577`*^9, 3.825089086294458*^9}, {3.825090743792334*^9, 
   3.8250907771168756`*^9}, {3.825092322848659*^9, 3.825092336814286*^9}, {
   3.825092447249908*^9, 3.825092511406562*^9}, {3.825092701159775*^9, 
   3.825092713421569*^9}, {3.825092744071102*^9, 3.825092802282421*^9}, {
   3.825093240479906*^9, 3.8250932637241383`*^9}, {3.825093441792938*^9, 
   3.825093458975465*^9}, {3.825093712254569*^9, 3.8250937282421303`*^9}, 
   3.8250953454377193`*^9, {3.82509540912431*^9, 3.825095419062454*^9}, {
   3.82509554222736*^9, 3.825095547201393*^9}, {3.825100027555481*^9, 
   3.825100046060267*^9}, {3.8251004419609632`*^9, 3.825100471641433*^9}, 
   3.825100505398409*^9, 3.825111798655422*^9, 3.8251118292380733`*^9, {
   3.825111861142836*^9, 3.8251118736626167`*^9}, {3.8251141799889383`*^9, 
   3.825114229093069*^9}, 3.8251143412067842`*^9, {3.825114512794629*^9, 
   3.825114540508717*^9}, 3.825192313567877*^9},
 CellLabel->
  "Out[1337]=",ExpressionUUID->"11c07d92-c97b-473a-9915-3621cf267d63"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quiet", "@", 
  RowBox[{"Row", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ListLinePlot", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"CDF", "[", 
             RowBox[{
              RowBox[{"ChiSquareDistribution", "[", 
               RowBox[{"Length", "@", 
                RowBox[{"dmixture", "[", "tissue", "]"}]}], "]"}], ",", "#"}],
              "]"}], "&"}], "@", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"dmixture", "[", "tissue", "]"}], "-", 
                RowBox[{
                 RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
                 "\[LeftDoubleBracket]", 
                 RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], ",", 
               RowBox[{";;", 
                RowBox[{"-", "2"}]}]}], "]"}], ".", 
             RowBox[{"Inverse", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"fGodambe", "[", "tissue", "]"}], 
                "\[LeftDoubleBracket]", 
                RowBox[{
                 RowBox[{";;", 
                  RowBox[{"-", "2"}]}], ",", 
                 RowBox[{";;", 
                  RowBox[{"-", "2"}]}]}], "\[RightDoubleBracket]"}], "/", 
               RowBox[{"(", 
                RowBox[{"effectiveG", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
                   "\[LeftDoubleBracket]", 
                   RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", 
                  RowBox[{"f\[CapitalPhi]f", "[", "tissue", "]"}], ",", 
                  RowBox[{"f\[Sigma]f", "[", "tissue", "]"}], ",", 
                  RowBox[{"d\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
                  RowBox[{
                   RowBox[{"fnf", "[", "tissue", "]"}], 
                   "\[LeftDoubleBracket]", 
                   RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "1"}], 
                 "]"}], ")"}]}], "]"}], ".", 
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"dmixture", "[", "tissue", "]"}], "-", 
                RowBox[{
                 RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
                 "\[LeftDoubleBracket]", 
                 RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], ",", 
               RowBox[{";;", 
                RowBox[{"-", "2"}]}]}], "]"}]}], ")"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"300", ",", "200"}], "}"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Full"}], ",", 
        RowBox[{"PlotTheme", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<Scientific\>\"", ",", "\"\<BoldScheme\>\""}], "}"}]}], 
        ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.025"}], ",", "1"}], "}"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ListLinePlot", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"CDF", "[", 
             RowBox[{
              RowBox[{"ChiSquareDistribution", "[", 
               RowBox[{"Length", "@", 
                RowBox[{"fmixture", "[", "tissue", "]"}]}], "]"}], ",", "#"}],
              "]"}], "&"}], "@", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"fmixture", "[", "tissue", "]"}], "-", 
                RowBox[{"d\[Alpha]f", "[", "tissue", "]"}]}], ",", 
               RowBox[{";;", 
                RowBox[{"-", "2"}]}]}], "]"}], ".", 
             RowBox[{"Inverse", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"dGodambe", "[", "tissue", "]"}], 
                "\[LeftDoubleBracket]", 
                RowBox[{
                 RowBox[{";;", 
                  RowBox[{"-", "2"}]}], ",", 
                 RowBox[{";;", 
                  RowBox[{"-", "2"}]}]}], "\[RightDoubleBracket]"}], "/", 
               RowBox[{"(", 
                RowBox[{"effectiveG", "[", 
                 RowBox[{
                  RowBox[{"d\[Alpha]f", "[", "tissue", "]"}], ",", 
                  RowBox[{"d\[CapitalPhi]f", "[", "tissue", "]"}], ",", 
                  RowBox[{"d\[Sigma]f", "[", "tissue", "]"}], ",", 
                  RowBox[{"f\[CapitalPsi]f", "[", "tissue", "]"}], ",", 
                  RowBox[{
                   RowBox[{"dnf", "[", "tissue", "]"}], 
                   "\[LeftDoubleBracket]", 
                   RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "1"}], 
                 "]"}], ")"}]}], "]"}], ".", 
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"fmixture", "[", "tissue", "]"}], "-", 
                RowBox[{"d\[Alpha]f", "[", "tissue", "]"}]}], ",", 
               RowBox[{";;", 
                RowBox[{"-", "2"}]}]}], "]"}]}], ")"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"300", ",", "200"}], "}"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Full"}], ",", 
        RowBox[{"PlotTheme", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<Scientific\>\"", ",", "\"\<BoldScheme\>\""}], "}"}]}], 
        ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.025"}], ",", "1"}], "}"}]}]}], "]"}]}], "}"}], ",", 
    RowBox[{"Spacer", "[", "10", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.82503703120687*^9, 3.825037224192007*^9}, {
   3.8250427781933107`*^9, 3.8250427870152283`*^9}, {3.82507719390096*^9, 
   3.825077194550398*^9}, {3.8250878030279207`*^9, 3.825087817800074*^9}, {
   3.8250889893844643`*^9, 3.8250890146275787`*^9}, {3.825089051301076*^9, 
   3.825089052332111*^9}, {3.825089084021214*^9, 3.825089084388377*^9}, {
   3.8250899359069347`*^9, 3.8250899603511477`*^9}, {3.8250907676643143`*^9, 
   3.825090775186919*^9}, {3.82509229825926*^9, 3.8250923341572847`*^9}, {
   3.825092440688744*^9, 3.825092509495598*^9}, {3.825092699511845*^9, 
   3.8250928006205053`*^9}, {3.825093245473806*^9, 3.825093259871872*^9}, {
   3.825093436949348*^9, 3.825093455261701*^9}, {3.825093703590807*^9, 
   3.825093724215804*^9}, {3.825095335259563*^9, 3.8250953440616493`*^9}, {
   3.825095404151134*^9, 3.825095418658535*^9}, {3.825095541317049*^9, 
   3.825095546871273*^9}, {3.825100026609909*^9, 3.82510004582417*^9}, {
   3.825100429434453*^9, 3.825100502654591*^9}, {3.825111741198349*^9, 
   3.825111870697812*^9}, 3.825114225303389*^9, {3.825191995699101*^9, 
   3.8251919990663567`*^9}, {3.825192129249992*^9, 3.825192147275383*^9}, {
   3.825192319605939*^9, 3.825192327264455*^9}},
 CellLabel->
  "In[1339]:=",ExpressionUUID->"42511c4b-e409-4afd-ae5a-ca86ee7d50fa"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{10}, "Spacer1"], 
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[7, 360], 0.019444444444444445`]], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        LineBox[{{1., 0.014364616651285411`}, {2., 0.2831646619994694}, {3., 
         0.0002315592084085195}, {4., 0.1922962525029127}, {5., 
         0.012324991490529014`}, {6., 0.002484485481281414}, {7., 
         0.007338242189391275}, {8., 0.9999999999410049}, {9., 
         0.0080884868835321}, {10., 0.03216398003370055}, {11., 
         0.3685764431025625}, {12., 0.0943250521115214}, {13., 1.}}]}}, {{
        Directive[
         PointSize[
          NCache[
           Rational[7, 360], 0.019444444444444445`]], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{{
                GrayLevel[1], 
                DiskBox[{0, 0}, 
                 Offset[{3, 3}]]}, 
               AbsoluteThickness[1.5], 
               Dashing[{}], 
               CircleBox[{0, 0}, 
                Offset[{3, 3}]]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 PointSize[
                  Rational[7, 360]], 
                 RGBColor[0.9, 0.36, 0.054], 
                 CapForm["Butt"], 
                 AbsoluteThickness[1.6]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Scaled[9.75]], {{{1., 0.014364616651285411`}}, {{2., 
         0.2831646619994694}}, {{3., 0.0002315592084085195}}, {{4., 
         0.1922962525029127}}, {{5., 0.012324991490529014`}}, {{6., 
         0.002484485481281414}}, {{7., 0.007338242189391275}}, {{8., 
         0.9999999999410049}}, {{9., 0.0080884868835321}}, {{10., 
         0.03216398003370055}}, {{11., 0.3685764431025625}}, {{12., 
         0.0943250521115214}}, {{13., 1.}}}]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     Full, Axes -> {False, False}, AxesLabel -> {None, None}, 
     AxesOrigin -> {0., 0}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> Automatic, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{0}, {0}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> {300, 200}, 
     LabelStyle -> {FontFamily -> "Times"}, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotRange -> {{0., 13.}, {-0.025, 1}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {Automatic, Automatic}}], 
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[7, 360], 0.019444444444444445`]], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        LineBox[{{1., 0.03671027833208551}, {2., 0.1611342777118663}, {3., 
         0.7314886447723962}, {4., 0.0005040346231890425}, {5., 
         0.0001041573592971412}, {6., 0.0026747853851890073`}, {7., 
         0.000626905216955187}, {8., 0.4451399561805369}, {9., 
         0.7283058772445645}, {10., 0.003633131919717533}, {11., 
         0.018058032757110733`}, {12., 1.}, {13., 1.}}]}}, {{
        Directive[
         PointSize[
          NCache[
           Rational[7, 360], 0.019444444444444445`]], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{{
                GrayLevel[1], 
                DiskBox[{0, 0}, 
                 Offset[{3, 3}]]}, 
               AbsoluteThickness[1.5], 
               Dashing[{}], 
               CircleBox[{0, 0}, 
                Offset[{3, 3}]]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 PointSize[
                  Rational[7, 360]], 
                 RGBColor[0.9, 0.36, 0.054], 
                 CapForm["Butt"], 
                 AbsoluteThickness[1.6]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Scaled[9.75]], {{{1., 0.03671027833208551}}, {{2., 
         0.1611342777118663}}, {{3., 0.7314886447723962}}, {{4., 
         0.0005040346231890425}}, {{5., 0.0001041573592971412}}, {{6., 
         0.0026747853851890073`}}, {{7., 0.000626905216955187}}, {{8., 
         0.4451399561805369}}, {{9., 0.7283058772445645}}, {{10., 
         0.003633131919717533}}, {{11., 0.018058032757110733`}}, {{12., 
         1.}}, {{13., 1.}}}]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     Full, Axes -> {False, False}, AxesLabel -> {None, None}, 
     AxesOrigin -> {0., 0}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> Automatic, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{0}, {0}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> {300, 200}, 
     LabelStyle -> {FontFamily -> "Times"}, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotRange -> {{0., 13.}, {-0.025, 1}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {Automatic, Automatic}}]},
  "RowWithSeparator"]], "Output",
 CellChangeTimes->{{3.825192107822028*^9, 3.8251921506562147`*^9}, {
  3.825192319976289*^9, 3.825192330391124*^9}},
 CellLabel->
  "Out[1339]=",ExpressionUUID->"bb0c493d-9537-4b5f-95b8-a48a73fe4bfd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Count", "[", 
      RowBox[{"#", ",", "True"}], "]"}], "/", 
     RowBox[{"Length", "[", "#", "]"}]}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"f\[Alpha]f", "[", "#", "]"}], "\[LeftDoubleBracket]", 
             RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], "-", 
            RowBox[{"dmixture", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
         "tissues"}], "]"}], "\[LessEqual]", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"fempConfidences", "[", "#", "]"}], "&"}], "/@", 
         "tissues"}], "]"}]}], "]"}], ",", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"d\[Alpha]f", "[", "#", "]"}], "-", 
            RowBox[{"fmixture", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
         "tissues"}], "]"}], "\[LessEqual]", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"dempConfidences", "[", "#", "]"}], "&"}], "/@", 
         "tissues"}], "]"}]}], "]"}]}], "}"}]}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.825081661761326*^9, 3.8250816647240677`*^9}, {
   3.825081700803197*^9, 3.825081767209553*^9}, 3.825092870971676*^9, {
   3.8251118857002783`*^9, 3.825111901972349*^9}},
 CellLabel->
  "In[1340]:=",ExpressionUUID->"20a27158-c297-4571-8c54-449a73e22200"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9180327868852459`", ",", "0.9180327868852459`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.825081664993614*^9, {3.8250817037185583`*^9, 3.825081713750534*^9}, {
   3.825081748542399*^9, 3.825081794904022*^9}, 3.825092871409288*^9, {
   3.825093320977796*^9, 3.825093343050776*^9}, 3.825095455302396*^9, 
   3.825100521651432*^9, 3.825111902776945*^9, {3.825114515547175*^9, 
   3.825114541835129*^9}, 3.8251922662072887`*^9, 3.825192335144829*^9},
 CellLabel->
  "Out[1340]=",ExpressionUUID->"c83c3d01-17a4-4f0e-9992-f61eaf2ba6ac"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Column", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Histogram", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"estf\[CapitalPhi]", "[", "tissue", "]"}], ".", 
                RowBox[{
                 RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
                 "\[LeftDoubleBracket]", 
                 RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], "-", 
               RowBox[{
                RowBox[{"d\[CapitalPsi]f", "[", "tissue", "]"}], "/", 
                RowBox[{
                 RowBox[{"fnf", "[", "tissue", "]"}], "\[LeftDoubleBracket]", 
                 
                 RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}]}], ")"}], 
             "/", 
             RowBox[{"MapThread", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"\[Sigma]g2", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", "#1", 
                    ",", "#2"}], "]"}], "/", 
                   RowBox[{
                    RowBox[{"fnf", "[", "tissue", "]"}], 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], "]"}], "/.", 
                 RowBox[{"{", 
                  RowBox[{"0.", "\[Rule]", 
                   RowBox[{"10", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "10"}], ")"}]}]}], "}"}]}], "&"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"estf\[CapitalPhi]", "[", "tissue", "]"}], ",", 
                 RowBox[{"f\[Sigma]f", "[", "tissue", "]"}]}], "}"}]}], 
              "]"}]}], ",", "Automatic", ",", "\"\<PDF\>\"", ",", 
            RowBox[{"PlotTheme", "\[Rule]", "\"\<Scientific\>\""}], ",", 
            RowBox[{"ImageSize", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"1.25", 
               RowBox[{"{", 
                RowBox[{"300", ",", "100"}], "}"}]}], ")"}]}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", "Full"}], ",", 
            RowBox[{"Epilog", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Framed", "[", 
                 RowBox[{
                  RowBox[{"mathWrapper", "[", 
                   RowBox[{
                    RowBox[{"\"\<G = \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Length", "@", 
                    RowBox[{"d\[CapitalPsi]f", "[", "tissue", "]"}]}], 
                    "]"}]}], ",", "20"}], "]"}], ",", 
                  RowBox[{"RoundingRadius", "\[Rule]", "5"}], ",", 
                  RowBox[{"FrameStyle", "\[Rule]", "None"}], ",", 
                  RowBox[{"Background", "\[Rule]", 
                   RowBox[{"Lighter", "[", 
                    RowBox[{"Gray", ",", "0.9"}], "]"}]}]}], "]"}], ",", 
                RowBox[{"Scaled", "[", 
                 RowBox[{"{", 
                  RowBox[{".1", ",", ".6"}], "}"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], "]"}], "}"}]}]}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"BarChart", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Transpose", "@", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"dmixture", "[", "tissue", "]"}], ",", 
               RowBox[{"MapThread", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Around", "[", 
                   RowBox[{"#1", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{
                    RowBox[{"#2", "/", "2"}], ",", "#1"}], "]"}], ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{
                    RowBox[{"#2", "/", "2"}], ",", 
                    RowBox[{"1", "-", "#1"}]}], "]"}]}], "}"}]}], "]"}], 
                  "&"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"f\[Alpha]f", "[", "tissue", "]"}], 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], ",", 
                   RowBox[{"fempConfidences", "[", "tissue", "]"}]}], "}"}]}],
                 "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"PlotTheme", "\[Rule]", "\"\<Scientific\>\""}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"ImageSize", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"1.25", 
               RowBox[{"{", 
                RowBox[{"300", ",", "100"}], "}"}]}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"AspectRatio", "\[Rule]", "Full"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"FrameTicks", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"None", ",", "Automatic"}], "}"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BarSpacing", "\[Rule]", "None"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Epilog", "\[Rule]", "\[IndentingNewLine]", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Framed", "[", 
                 RowBox[{
                  RowBox[{"mathWrapper", "[", 
                   RowBox[{
                    RowBox[{"ToString", "@", "tissue"}], ",", "24"}], "]"}], 
                  ",", 
                  RowBox[{"RoundingRadius", "\[Rule]", "5"}], ",", 
                  RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
                RowBox[{"Scaled", "[", 
                 RowBox[{"{", 
                  RowBox[{".05", ",", ".6"}], "}"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], "]"}], "\[IndentingNewLine]",
               "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
         "\[IndentingNewLine]", "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"tissue", ",", "tissues"}], "}"}]}], "]"}], ",", 
     RowBox[{"UpTo", "[", "3", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.8250784372613277`*^9, 3.825078789623258*^9}, {
   3.82507895305661*^9, 3.825078981095611*^9}, {3.825079048550323*^9, 
   3.825079192023054*^9}, {3.825079232458515*^9, 3.825079346201461*^9}, {
   3.825079404899407*^9, 3.825079492842889*^9}, {3.825079878767823*^9, 
   3.825079905306862*^9}, {3.8250892558518047`*^9, 3.825089261122023*^9}, 
   3.825089649621561*^9, {3.82511379758454*^9, 3.8251137979890537`*^9}, {
   3.825113886519959*^9, 3.8251138941859083`*^9}},
 CellLabel->
  "In[1354]:=",ExpressionUUID->"7b2d59b4-4d4c-4b87-9590-897395392fd8"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         GraphicsBox[{
           {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[
            0.5459999999999999], Thickness[Small]}], {}, 
            {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[
             0.5459999999999999], Thickness[Small]}], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4., 0}, {-3.8, 0.001557632398753894}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-97.22, -79.55999999999997}, {
                   45.57677392739273, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001557632398753894]& ,
                TagBoxNote->"0.001557632398753894"],
               StyleBox[
               "0.001557632398753894`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001557632398753894, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.6, 0}, {-3.4, 0.001557632398753894}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-62.900000000000006`, \
-45.23999999999998}, {45.57677392739273, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001557632398753894]& ,
                TagBoxNote->"0.001557632398753894"],
               StyleBox[
               "0.001557632398753894`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001557632398753894, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.4, 0}, {-3.2, 0.001557632398753894}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-45.73999999999998, \
-28.080000000000013`}, {45.57677392739273, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001557632398753894]& ,
                TagBoxNote->"0.001557632398753894"],
               StyleBox[
               "0.001557632398753894`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001557632398753894, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.2, 0}, {-3., 0.001557632398753894}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-28.580000000000013`, \
-10.919999999999987`}, {45.57677392739273, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001557632398753894]& ,
                TagBoxNote->"0.001557632398753894"],
               StyleBox[
               "0.001557632398753894`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001557632398753894, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3., 0}, {-2.8, 0.001557632398753894}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-11.419999999999987`, 
                   6.240000000000009}, {45.57677392739273, 
                   46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001557632398753894]& ,
                TagBoxNote->"0.001557632398753894"],
               StyleBox[
               "0.001557632398753894`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001557632398753894, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.8, 0}, {-2.6, 0.006230529595015576}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{5.740000000000009, 23.399999999999977`}, {
                   45.05709570957095, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.006230529595015576]& ,
                TagBoxNote->"0.006230529595015576"],
               StyleBox[
               "0.006230529595015576`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.006230529595015576, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.6, 0}, {-2.4, 0.018691588785046728`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{22.899999999999977`, 40.56}, {
                   43.67128712871286, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.018691588785046728`]& ,
                TagBoxNote->"0.018691588785046728"],
               StyleBox[
               "0.018691588785046728`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.018691588785046728`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.4, 0}, {-2.2, 0.0264797507788162}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{40.06, 57.71999999999997}, {
                   42.80515676567656, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0264797507788162]& ,
                TagBoxNote->"0.0264797507788162"],
               StyleBox[
               "0.0264797507788162`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.0264797507788162, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.2, 0}, {-2., 0.04672897196261682}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{57.21999999999997, 74.88}, {
                   40.55321782178217, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.04672897196261682]& ,
                TagBoxNote->"0.04672897196261682"],
               StyleBox[
               "0.04672897196261682`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.04672897196261682, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2., 0}, {-1.8, 0.06853582554517133}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{74.38, 92.03999999999999}, {
                   38.12805280528052, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.06853582554517133]& ,
                TagBoxNote->"0.06853582554517133"],
               StyleBox[
               "0.06853582554517133`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.06853582554517133, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.8, 0}, {-1.6, 0.11214953271028037`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{91.53999999999999, 109.19999999999999`}, {
                   33.27772277227722, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.11214953271028037`]& ,
                TagBoxNote->"0.11214953271028037"],
               StyleBox[
               "0.11214953271028037`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.11214953271028037`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.6, 0}, {-1.4, 0.15109034267912771`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{108.69999999999999`, 126.36}, {
                   28.947070957095704`, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.15109034267912771`]& ,
                TagBoxNote->"0.15109034267912771"],
               StyleBox[
               "0.15109034267912771`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.15109034267912771`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.4, 0}, {-1.2, 0.22274143302180685`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{125.86, 143.51999999999998`}, {
                   20.978671617161712`, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.22274143302180685`]& ,
                TagBoxNote->"0.22274143302180685"],
               StyleBox[
               "0.22274143302180685`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.22274143302180685`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.2, 0}, {-1., 0.2367601246105919}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{143.01999999999998`, 160.68}, {
                   19.419636963696366`, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.2367601246105919]& ,
                TagBoxNote->"0.2367601246105919"],
               StyleBox[
               "0.2367601246105919`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.2367601246105919, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1., 0}, {-0.8, 0.3426791277258567}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{160.18, 177.83999999999997`}, {
                   7.64026402640264, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.3426791277258567]& ,
                TagBoxNote->"0.3426791277258567"],
               StyleBox[
               "0.3426791277258567`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.3426791277258567, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.8, 0}, {-0.6, 0.4657320872274143}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{177.33999999999997`, 
                   195.}, {-6.044595709570963, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.4657320872274143]& ,
                TagBoxNote->"0.4657320872274143"],
               StyleBox[
               "0.4657320872274143`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.4657320872274143, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.6, 0}, {-0.4, 0.6448598130841121}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{194.5, 212.16}, {-25.965594059405937`, 
                   46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.6448598130841121]& ,
                TagBoxNote->"0.6448598130841121"],
               StyleBox[
               "0.6448598130841121`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.6448598130841121, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.4, 0}, {-0.2, 0.8426791277258567}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{211.66, 229.32}, {-47.965305280528064`, 
                   46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.8426791277258567]& ,
                TagBoxNote->"0.8426791277258567"],
               StyleBox[
               "0.8426791277258567`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.8426791277258567, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.2, 0}, {0., 0.9439252336448598}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{228.82, 246.48}, {-59.225, 
                   46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.9439252336448598]& ,
                TagBoxNote->"0.9439252336448598"],
               StyleBox[
               "0.9439252336448598`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.9439252336448598, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0., 0}, {0.2, 0.6464174454828661}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{245.98, 263.64}, {-26.1388201320132, 
                   46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.6464174454828661]& ,
                TagBoxNote->"0.6464174454828661"],
               StyleBox[
               "0.6464174454828661`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.6464174454828661, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.2, 0}, {0.4, 0.1573208722741433}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{263.14, 280.8}, {28.254166666666663`, 
                   46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.1573208722741433]& ,
                TagBoxNote->"0.1573208722741433"],
               StyleBox[
               "0.1573208722741433`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.1573208722741433, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.4, 0}, {0.6, 0.037383177570093455`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{280.3, 297.96}, {41.59257425742574, 
                   46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.037383177570093455`]& ,
                TagBoxNote->"0.037383177570093455"],
               StyleBox[
               "0.037383177570093455`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.037383177570093455`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.6, 0}, {0.8, 0.012461059190031152`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{297.46, 315.12}, {44.36419141914191, 
                   46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.012461059190031152`]& ,
                TagBoxNote->"0.012461059190031152"],
               StyleBox[
               "0.012461059190031152`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.012461059190031152`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.8, 0}, {1., 0.003115264797507788}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{314.62, 332.28}, {45.40354785478547, 
                   46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.003115264797507788]& ,
                TagBoxNote->"0.003115264797507788"],
               StyleBox[
               "0.003115264797507788`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.003115264797507788, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1., 0}, {1.2, 0.004672897196261682}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{331.78, 349.44}, {45.23032178217821, 
                   46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.004672897196261682]& ,
                TagBoxNote->"0.004672897196261682"],
               StyleBox[
               "0.004672897196261682`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.004672897196261682, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.2, 0}, {1.4, 0.001557632398753894}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{348.94, 366.59999999999997`}, {
                   45.57677392739273, 46.24999999999999}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001557632398753894]& ,
                TagBoxNote->"0.001557632398753894"],
               StyleBox[
               "0.001557632398753894`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001557632398753894, {FontFamily -> "Times"}], 
               "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{-2.68, 0},
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"G = 3210\"", FontFamily -> "Latin Modern Math", FontSize -> 
                20, "", StripOnInput -> False], RoundingRadius -> 5, 
               FrameStyle -> None, Background -> RGBColor[0.95, 0.95, 0.95], 
               StripOnInput -> False], TraditionalForm], 
             Scaled[{0.1, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->NCache[{{
              Rational[-13, 5], 
              Rational[7, 5]}, {All, All}}, {{-2.6, 1.4}, {All, All}}],
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]},
        {
         GraphicsBox[{{
            {Opacity[0], 
             PointBox[{{0.11599999999999999`, 0.}, {5.200000000000001, 
              0.}}]}, {{}, {{{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.6, 0.}, {1.6, 0.5379310344827586}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{55.57285601888277, 
                    123.57875688434302`}, {-6.807586206896552, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.5379310344827586]& ,
                    TagBoxNote->"0.5379310344827586"],
                    StyleBox[
                    "0.5379310344827586`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.5379310344827586, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.6, 0.}, {2.6, 0.5568588330183986}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{123.07875688434302`, 
                    191.08465774980328`}, {-8.938383127046222, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.5568588330183986]& ,
                    TagBoxNote->"0.5568588330183986"],
                    StyleBox[
                    "0.5568588330183986`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.5568588330183986, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.8000000000000003`, 0.}, {
                    3.8000000000000003`, 0.46206896551724136`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{204.08583792289537`, 
                    272.0917387883556}, {1.7325862068965492`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.46206896551724136`]& ,
                    TagBoxNote->"0.46206896551724136"],
                    StyleBox[
                    "0.46206896551724136`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.46206896551724136`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.8000000000000003`, 0.}, {
                    4.800000000000001, 0.4431411669816015}, "RoundingRadius" -> 
                    0]},
                    ImageSizeCache->{{271.5917387883556, 339.5976396538159}, {
                    3.8633831270462125`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.4431411669816015]& ,
                    TagBoxNote->"0.4431411669816015"],
                    StyleBox[
                    "0.4431411669816015`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.4431411669816015, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}}, {}, {}}, {}, {}, {}, {}, {}}, \
{{
             
             StyleBox[{{}, {
                LineBox[{{2.1, 0.4455911480399132}, {2.1, 
                 0.5568588330183986}}], 
                LineBox[{{2.1, 0.5568588330183986}, {2.1, 
                 0.6681265179968839}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{4.300000000000001, 0.3318734820031161}, {
                 4.300000000000001, 0.4431411669816015}}], 
                LineBox[{{4.300000000000001, 0.4431411669816015}, {
                 4.300000000000001, 0.5544088519600868}}]}},
              Antialiasing->False]}, {
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{2.1, 0.6681265179968839}, 
                   Offset[{3, 0}, {2.1, 0.6681265179968839}]}, {{2.1, 
                   0.6681265179968839}, 
                   Offset[{-3, 0}, {2.1, 0.6681265179968839}]}, {{2.1, 
                   0.4455911480399132}, 
                   Offset[{3, 0}, {2.1, 0.4455911480399132}]}, {{2.1, 
                   0.4455911480399132}, 
                   Offset[{-3, 0}, {2.1, 0.4455911480399132}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{4.300000000000001, 0.5544088519600868}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.5544088519600868}]}, {{4.300000000000001, 
                   0.5544088519600868}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.5544088519600868}]}, {{4.300000000000001, 
                   0.3318734820031161}, 
                   Offset[{3, 0}, {4.300000000000001, 0.3318734820031161}]}, {
                  {4.300000000000001, 0.3318734820031161}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.3318734820031161}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False]}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0.11599999999999999`, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          DisplayFunction->Identity,
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"skin\"", FontFamily -> "Latin Modern Math", FontSize -> 24, 
                "", StripOnInput -> False], RoundingRadius -> 5, Background -> 
               GrayLevel[1], StripOnInput -> False], TraditionalForm], 
             Scaled[{0.05, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {None, None}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->{{All, All}, {0, 1}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{None, Automatic}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"], 
     TagBox[GridBox[{
        {
         GraphicsBox[{
           {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.574], 
            Thickness[Small]}], {}, 
            {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.574], 
             Thickness[Small]}], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-7.8, 0}, {-7.6, 0.0005045917852457363}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-642.05, -620.0999999999999}, {
                   45.708801020408174`, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0005045917852457363]& ,
                TagBoxNote->"0.0005045917852457363"],
               StyleBox[
               "0.0005045917852457363`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0005045917852457363, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.8, 0}, {-5.6, 0.0005045917852457363}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-427.54999999999995`, \
-405.5999999999999}, {45.708801020408174`, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0005045917852457363]& ,
                TagBoxNote->"0.0005045917852457363"],
               StyleBox[
               "0.0005045917852457363`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0005045917852457363, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.2, 0}, {-5., 0.0010091835704914725`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-363.20000000000005`, -341.25}, {
                   45.66760204081634, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0010091835704914725`]& ,
                TagBoxNote->"0.0010091835704914725"],
               StyleBox[
               "0.0010091835704914725`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0010091835704914725`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5., 0}, {-4.8, 0.0005045917852457363}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-341.75, -319.79999999999995`}, {
                   45.708801020408174`, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0005045917852457363]& ,
                TagBoxNote->"0.0005045917852457363"],
               StyleBox[
               "0.0005045917852457363`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0005045917852457363, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.8, 0}, {-4.6, 0.0010091835704914725`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-320.29999999999995`, \
-298.34999999999997`}, {45.66760204081634, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0010091835704914725`]& ,
                TagBoxNote->"0.0010091835704914725"],
               StyleBox[
               "0.0010091835704914725`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0010091835704914725`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.6, 0}, {-4.4, 0.0010091835704914725`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-298.84999999999997`, \
-276.90000000000003`}, {45.66760204081634, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0010091835704914725`]& ,
                TagBoxNote->"0.0010091835704914725"],
               StyleBox[
               "0.0010091835704914725`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0010091835704914725`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.4, 0}, {-4.2, 0.0005045917852457363}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-277.40000000000003`, \
-255.45000000000005`}, {45.708801020408174`, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0005045917852457363]& ,
                TagBoxNote->"0.0005045917852457363"],
               StyleBox[
               "0.0005045917852457363`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0005045917852457363, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.2, 0}, {-4., 0.0010091835704914725`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-255.95000000000005`, -234.}, {
                   45.66760204081634, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0010091835704914725`]& ,
                TagBoxNote->"0.0010091835704914725"],
               StyleBox[
               "0.0010091835704914725`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0010091835704914725`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4., 0}, {-3.8, 0.0005045917852457363}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-234.5, -212.54999999999995`}, {
                   45.708801020408174`, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0005045917852457363]& ,
                TagBoxNote->"0.0005045917852457363"],
               StyleBox[
               "0.0005045917852457363`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0005045917852457363, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.8, 0}, {-3.6, 0.0005045917852457363}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-213.04999999999995`, \
-191.10000000000002`}, {45.708801020408174`, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0005045917852457363]& ,
                TagBoxNote->"0.0005045917852457363"],
               StyleBox[
               "0.0005045917852457363`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0005045917852457363, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.6, 0}, {-3.4, 0.005550509637703098}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-191.60000000000002`, \
-169.64999999999998`}, {45.29681122448981, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.005550509637703098]& ,
                TagBoxNote->"0.005550509637703098"],
               StyleBox[
               "0.005550509637703098`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.005550509637703098, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.4, 0}, {-3.2, 0.002018367140982945}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-170.14999999999998`, \
-148.20000000000005`}, {45.58520408163267, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.002018367140982945]& ,
                TagBoxNote->"0.002018367140982945"],
               StyleBox[
               "0.002018367140982945`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.002018367140982945, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.2, 0}, {-3., 0.0035321424967201536`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-148.70000000000005`, -126.75}, {
                   45.461607142857154`, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0035321424967201536`]& ,
                TagBoxNote->"0.0035321424967201536"],
               StyleBox[
               "0.0035321424967201536`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0035321424967201536`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3., 0}, {-2.8, 0.00807346856393178}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-127.25, -105.29999999999995`}, {
                   45.09081632653063, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.00807346856393178]& ,
                TagBoxNote->"0.00807346856393178"],
               StyleBox[
               "0.00807346856393178`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.00807346856393178, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.8, 0}, {-2.6, 0.011101019275406196`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-105.79999999999995`, \
-83.85000000000002}, {44.84362244897961, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.011101019275406196`]& ,
                TagBoxNote->"0.011101019275406196"],
               StyleBox[
               "0.011101019275406196`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.011101019275406196`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.6, 0}, {-2.4, 0.011101019275406196`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-84.35000000000002, -62.39999999999998}, {
                   44.84362244897961, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.011101019275406196`]& ,
                TagBoxNote->"0.011101019275406196"],
               StyleBox[
               "0.011101019275406196`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.011101019275406196`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.4, 0}, {-2.2, 0.014128569986880614`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-62.89999999999998, -40.95000000000002}, {
                   44.59642857142858, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.014128569986880614`]& ,
                TagBoxNote->"0.014128569986880614"],
               StyleBox[
               "0.014128569986880614`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.014128569986880614`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.2, 0}, {-2., 0.023211222121303866`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-41.45000000000002, -19.5}, {
                   43.85484693877552, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.023211222121303866`]& ,
                TagBoxNote->"0.023211222121303866"],
               StyleBox[
               "0.023211222121303866`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.023211222121303866`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2., 0}, {-1.8, 0.022706630336058128`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-20., 1.9499999999999886`}, {
                   43.89604591836736, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.022706630336058128`]& ,
                TagBoxNote->"0.022706630336058128"],
               StyleBox[
               "0.022706630336058128`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.022706630336058128`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.8, 0}, {-1.6, 0.02825713997376123}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{1.4499999999999886`, 
                   23.399999999999977`}, {43.44285714285716, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.02825713997376123]& ,
                TagBoxNote->"0.02825713997376123"],
               StyleBox[
               "0.02825713997376123`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.02825713997376123, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.6, 0}, {-1.4, 0.04692703602785347}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{22.899999999999977`, 44.85000000000002}, {
                   41.9184948979592, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.04692703602785347]& ,
                TagBoxNote->"0.04692703602785347"],
               StyleBox[
               "0.04692703602785347`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.04692703602785347, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.4, 0}, {-1.2, 0.060551014229488345`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{44.35000000000002, 66.30000000000001}, {
                   40.80612244897961, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.060551014229488345`]& ,
                TagBoxNote->"0.060551014229488345"],
               StyleBox[
               "0.060551014229488345`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.060551014229488345`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.2, 0}, {-1., 0.08174386920980926}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{65.80000000000001, 87.75}, {
                   39.07576530612246, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.08174386920980926]& ,
                TagBoxNote->"0.08174386920980926"],
               StyleBox[
               "0.08174386920980926`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.08174386920980926, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1., 0}, {-0.8, 0.1115147845393077}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{87.25, 109.19999999999999`}, {
                   36.64502551020409, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.1115147845393077]& ,
                TagBoxNote->"0.1115147845393077"],
               StyleBox[
               "0.1115147845393077`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.1115147845393077, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.8, 0}, {-0.6, 0.1866989605409224}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{108.69999999999999`, 130.65}, {
                   30.50637755102042, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.1866989605409224]& ,
                TagBoxNote->"0.1866989605409224"],
               StyleBox[
               "0.1866989605409224`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.1866989605409224, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.6, 0}, {-0.4, 0.2689474215359774}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{130.15, 152.1}, {23.790943877551033`, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.2689474215359774]& ,
                TagBoxNote->"0.2689474215359774"],
               StyleBox[
               "0.2689474215359774`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.2689474215359774, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.4, 0}, {-0.2, 0.457160157432637}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{151.6, 173.55}, {8.42372448979593, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.457160157432637]& ,
                TagBoxNote->"0.457160157432637"],
               StyleBox[
               "0.457160157432637`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.457160157432637, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.2, 0}, {0., 0.709456050055505}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{173.05, 195.}, {-12.175765306122429`, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.709456050055505]& ,
                TagBoxNote->"0.709456050055505"],
               StyleBox[
               "0.709456050055505`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.709456050055505, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0., 0}, {0.2, 1.2856998688061358`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{194.5, 216.45}, {-59.224999999999994`, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 1.2856998688061358`]& ,
                TagBoxNote->"1.2856998688061358"],
               StyleBox[
               "1.2856998688061358`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[1.2856998688061358`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.2, 0}, {0.4, 0.9193662327177313}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{215.95, 237.9}, {-29.314540816326513`, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.9193662327177313]& ,
                TagBoxNote->"0.9193662327177313"],
               StyleBox[
               "0.9193662327177313`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.9193662327177313, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.4, 0}, {0.6, 0.4294076092441215}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{237.4, 259.35}, {10.689668367346954`, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.4294076092441215]& ,
                TagBoxNote->"0.4294076092441215"],
               StyleBox[
               "0.4294076092441215`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.4294076092441215, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.6, 0}, {0.8, 0.17105661519830456`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{258.85, 280.8}, {31.78354591836736, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.17105661519830456`]& ,
                TagBoxNote->"0.17105661519830456"],
               StyleBox[
               "0.17105661519830456`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.17105661519830456`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.8, 0}, {1., 0.07821172671308911}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{280.3, 302.25}, {39.36415816326532, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.07821172671308911]& ,
                TagBoxNote->"0.07821172671308911"],
               StyleBox[
               "0.07821172671308911`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.07821172671308911, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1., 0}, {1.2, 0.025734181047532546`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{301.75, 323.7}, {43.648852040816344`, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.025734181047532546`]& ,
                TagBoxNote->"0.025734181047532546"],
               StyleBox[
               "0.025734181047532546`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.025734181047532546`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.2, 0}, {1.4, 0.01614693712786356}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{323.2, 345.15}, {44.431632653061236`, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.01614693712786356]& ,
                TagBoxNote->"0.01614693712786356"],
               StyleBox[
               "0.01614693712786356`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.01614693712786356, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.4, 0}, {1.6, 0.004541326067211626}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{344.65, 366.6}, {45.37920918367348, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.004541326067211626]& ,
                TagBoxNote->"0.004541326067211626"],
               StyleBox[
               "0.004541326067211626`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.004541326067211626, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.6, 0}, {1.8, 0.005045917852457362}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{366.1, 388.05}, {45.33801020408165, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.005045917852457362]& ,
                TagBoxNote->"0.005045917852457362"],
               StyleBox[
               "0.005045917852457362`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.005045917852457362, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.8, 0}, {2., 0.003027550711474417}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{387.55, 409.5}, {45.502806122448995`, 
                   46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.003027550711474417]& ,
                TagBoxNote->"0.003027550711474417"],
               StyleBox[
               "0.003027550711474417`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.003027550711474417, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2., 0}, {2.2, 0.0005045917852457363}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{409., 430.95000000000005`}, {
                   45.708801020408174`, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0005045917852457363]& ,
                TagBoxNote->"0.0005045917852457363"],
               StyleBox[
               "0.0005045917852457363`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0005045917852457363, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.2, 0}, {2.4, 0.0010091835704914725`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{430.45000000000005`, 452.4}, {
                   45.66760204081634, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0010091835704914725`]& ,
                TagBoxNote->"0.0010091835704914725"],
               StyleBox[
               "0.0010091835704914725`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0010091835704914725`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.8, 0}, {3., 0.0005045917852457363}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{494.79999999999995`, 516.75}, {
                   45.708801020408174`, 46.250000000000014`}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0005045917852457363]& ,
                TagBoxNote->"0.0005045917852457363"],
               StyleBox[
               "0.0005045917852457363`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0005045917852457363, {FontFamily -> "Times"}], 
               "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{-1.6640000000000001`, 0},
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"G = 9909\"", FontFamily -> "Latin Modern Math", FontSize -> 
                20, "", StripOnInput -> False], RoundingRadius -> 5, 
               FrameStyle -> None, Background -> RGBColor[0.95, 0.95, 0.95], 
               StripOnInput -> False], TraditionalForm], 
             Scaled[{0.1, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->NCache[{{
              Rational[-8, 5], 
              Rational[8, 5]}, {All, All}}, {{-1.6, 1.6}, {All, All}}],
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]},
        {
         GraphicsBox[{{
            {Opacity[0], 
             PointBox[{{0.38399999999999995`, 0.}, {11.4, 
              0.}}]}, {{}, {{{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.63], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.6, 0.}, {1.6, 0.024083769633507852`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{29.629411764705882`, 
                    61.28409586056645}, {51.038769633507854`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.024083769633507852`]& ,
                    TagBoxNote->"0.024083769633507852"],
                    StyleBox[
                    "0.024083769633507852`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.024083769633507852`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.63], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.6, 0.}, {2.6, 0.026183627162739625`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{60.78409586056645, 92.43877995642701}, {
                    50.80237817215459, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.026183627162739625`]& ,
                    TagBoxNote->"0.026183627162739625"],
                    StyleBox[
                    "0.026183627162739625`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.026183627162739625`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.63], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.8000000000000003`, 0.}, {
                    3.8000000000000003`, 0.437521815008726}, "RoundingRadius" -> 
                    0]},
                    
                    ImageSizeCache->{{98.16971677559913, 129.8244008714597}, {
                    4.495981675392677, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.437521815008726]& ,
                    TagBoxNote->"0.437521815008726"],
                    StyleBox[
                    "0.437521815008726`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.437521815008726, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.63], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.8000000000000003`, 0.}, {
                    4.800000000000001, 0.29441479292090067`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{129.3244008714597, 
                    160.97908496732026`}, {20.60625468692961, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.29441479292090067`]& ,
                    TagBoxNote->"0.29441479292090067"],
                    StyleBox[
                    "0.29441479292090067`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.29441479292090067`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.63], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{5.000000000000001, 0.}, {6.000000000000001, 
                    0.09633507853403141}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{166.71002178649238`, 
                    198.36470588235295`}, {42.90507853403142, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.09633507853403141]& ,
                    TagBoxNote->"0.09633507853403141"],
                    StyleBox[
                    "0.09633507853403141`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.09633507853403141, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.63], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{6.000000000000001, 0.}, {7.000000000000001, 
                    0.10459938096369084`}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{197.86470588235295`, 
                    229.5193899782135}, {41.9747246880125, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.10459938096369084`]& ,
                    TagBoxNote->"0.10459938096369084"],
                    StyleBox[
                    "0.10459938096369084`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.10459938096369084`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.63], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{7.200000000000001, 0.}, {8.200000000000001, 
                    0.39267015706806285`}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{235.2503267973856, 266.9050108932462}, {
                    9.545157068062828, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.39267015706806285`]& ,
                    TagBoxNote->"0.39267015706806285"],
                    StyleBox[
                    "0.39267015706806285`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.39267015706806285`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.63], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{8.200000000000001, 0.}, {9.200000000000001, 
                    0.39299579481688335`}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{266.4050108932462, 298.0596949891068}, {
                    9.508498398489358, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.39299579481688335`]& ,
                    TagBoxNote->"0.39299579481688335"],
                    StyleBox[
                    "0.39299579481688335`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.39299579481688335`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.63], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{9.4, 0.}, {10.4, 0.049389179755671905`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{303.7906318082789, 335.4453159041394}, {
                    48.190013089005234`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.049389179755671905`]& ,
                    TagBoxNote->"0.049389179755671905"],
                    StyleBox[
                    "0.049389179755671905`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.049389179755671905`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.63], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{10.4, 0.}, {11.4, 0.18180640413578564`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{334.9453159041394, 366.6}, {
                    33.28314405441394, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.18180640413578564`]& ,
                    TagBoxNote->"0.18180640413578564"],
                    StyleBox[
                    "0.18180640413578564`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.18180640413578564`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}}, {}, {}}, {}, {}, {}, {}, {}}, \
{{
             
             StyleBox[{{}, {
                LineBox[{{2.1, 0.002899240489628776}, {2.1, 
                 0.026183627162739625`}}], 
                LineBox[{{2.1, 0.026183627162739625`}, {2.1, 
                 0.04946801383585048}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{4.300000000000001, 0.19352436850981636`}, {
                 4.300000000000001, 0.29441479292090067`}}], 
                LineBox[{{4.300000000000001, 0.29441479292090067`}, {
                 4.300000000000001, 0.395305217331985}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{6.500000000000001, 0.060995017068605425`}, {
                 6.500000000000001, 0.10459938096369084`}}], 
                LineBox[{{6.500000000000001, 0.10459938096369084`}, {
                 6.500000000000001, 0.14820374485877624`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{8.700000000000001, 0.2982637571930125}, {
                 8.700000000000001, 0.39299579481688335`}}], 
                LineBox[{{8.700000000000001, 0.39299579481688335`}, {
                 8.700000000000001, 0.4877278324407542}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{10.9, 0.08856531217332764}, {10.9, 
                 0.18180640413578564`}}], 
                LineBox[{{10.9, 0.18180640413578564`}, {10.9, 
                 0.27504749609824364`}}]}},
              Antialiasing->False]}, {
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{2.1, 0.04946801383585048}, 
                   Offset[{3, 0}, {2.1, 0.04946801383585048}]}, {{2.1, 
                   0.04946801383585048}, 
                   Offset[{-3, 0}, {2.1, 0.04946801383585048}]}, {{2.1, 
                   0.002899240489628776}, 
                   Offset[{3, 0}, {2.1, 0.002899240489628776}]}, {{2.1, 
                   0.002899240489628776}, 
                   Offset[{-3, 0}, {2.1, 0.002899240489628776}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{4.300000000000001, 0.395305217331985}, 
                   Offset[{3, 0}, {4.300000000000001, 0.395305217331985}]}, {{
                   4.300000000000001, 0.395305217331985}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.395305217331985}]}, {{4.300000000000001, 
                   0.19352436850981636`}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.19352436850981636`}]}, {{4.300000000000001, 
                   0.19352436850981636`}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.19352436850981636`}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{6.500000000000001, 0.14820374485877624`}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.14820374485877624`}]}, {{6.500000000000001, 
                   0.14820374485877624`}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.14820374485877624`}]}, {{6.500000000000001, 
                   0.060995017068605425`}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.060995017068605425`}]}, {{6.500000000000001, 
                   0.060995017068605425`}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.060995017068605425`}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{8.700000000000001, 0.4877278324407542}, 
                   Offset[{3, 0}, {8.700000000000001, 
                    0.4877278324407542}]}, {{8.700000000000001, 
                   0.4877278324407542}, 
                   Offset[{-3, 0}, {8.700000000000001, 
                    0.4877278324407542}]}, {{8.700000000000001, 
                   0.2982637571930125}, 
                   Offset[{3, 0}, {8.700000000000001, 
                    0.2982637571930125}]}, {{8.700000000000001, 
                   0.2982637571930125}, 
                   Offset[{-3, 0}, {8.700000000000001, 
                    0.2982637571930125}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{10.9, 0.27504749609824364`}, 
                   Offset[{3, 0}, {10.9, 0.27504749609824364`}]}, {{10.9, 
                   0.27504749609824364`}, 
                   Offset[{-3, 0}, {10.9, 0.27504749609824364`}]}, {{10.9, 
                   0.08856531217332764}, 
                   Offset[{3, 0}, {10.9, 0.08856531217332764}]}, {{10.9, 
                   0.08856531217332764}, 
                   Offset[{-3, 0}, {10.9, 0.08856531217332764}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False]}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0.38399999999999995`, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          DisplayFunction->Identity,
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"liver\"", FontFamily -> "Latin Modern Math", FontSize -> 24,
                 "", StripOnInput -> False], RoundingRadius -> 5, Background -> 
               GrayLevel[1], StripOnInput -> False], TraditionalForm], 
             Scaled[{0.05, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {None, None}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->{{All, All}, {0, 1}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{None, Automatic}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"], 
     TagBox[GridBox[{
        {
         GraphicsBox[{
           {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.588], 
            Thickness[Small]}], {}, 
            {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.588], 
             Thickness[Small]}], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-9.6, 0}, {-9.4, 0.0009888262632255513}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-982.1857142857143, -957.1714285714286}, {
                   45.67646234676007, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0009888262632255513]& ,
                TagBoxNote->"0.0009888262632255513"],
               StyleBox[
               "0.0009888262632255513`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0009888262632255513, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-9.2, 0}, {-9., 0.0004944131316127757}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-933.1571428571428, -908.1428571428571}, {
                   45.71323117338004, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004944131316127757]& ,
                TagBoxNote->"0.0004944131316127757"],
               StyleBox[
               "0.0004944131316127757`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004944131316127757, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-9., 0}, {-8.8, 0.0004944131316127757}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-908.6428571428571, -883.6285714285716}, {
                   45.71323117338004, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004944131316127757]& ,
                TagBoxNote->"0.0004944131316127757"],
               StyleBox[
               "0.0004944131316127757`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004944131316127757, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-8.4, 0}, {-8.2, 0.0004944131316127757}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-835.1000000000001, -810.0857142857142}, {
                   45.71323117338004, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004944131316127757]& ,
                TagBoxNote->"0.0004944131316127757"],
               StyleBox[
               "0.0004944131316127757`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004944131316127757, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-8.2, 0}, {-8., 0.0004944131316127757}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-810.5857142857142, -785.5714285714286}, {
                   45.71323117338004, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004944131316127757]& ,
                TagBoxNote->"0.0004944131316127757"],
               StyleBox[
               "0.0004944131316127757`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004944131316127757, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-7.4, 0}, {-7.2, 0.0014832393948383269`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-712.5285714285715, -687.5142857142857}, {
                   45.639693520140106`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0014832393948383269`]& ,
                TagBoxNote->"0.0014832393948383269"],
               StyleBox[
               "0.0014832393948383269`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0014832393948383269`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-7.2, 0}, {-7., 0.0009888262632255513}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-688.0142857142857, -663.}, {
                   45.67646234676007, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0009888262632255513]& ,
                TagBoxNote->"0.0009888262632255513"],
               StyleBox[
               "0.0009888262632255513`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0009888262632255513, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-7., 0}, {-6.8, 0.0004944131316127757}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-663.5, -638.4857142857143}, {
                   45.71323117338004, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004944131316127757]& ,
                TagBoxNote->"0.0004944131316127757"],
               StyleBox[
               "0.0004944131316127757`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004944131316127757, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-6.2, 0}, {-6., 0.0014832393948383269`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-565.4428571428572, -540.4285714285714}, {
                   45.639693520140106`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0014832393948383269`]& ,
                TagBoxNote->"0.0014832393948383269"],
               StyleBox[
               "0.0014832393948383269`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0014832393948383269`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-6., 0}, {-5.8, 0.0009888262632255513}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-540.9285714285714, -515.9142857142857}, {
                   45.67646234676007, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0009888262632255513]& ,
                TagBoxNote->"0.0009888262632255513"],
               StyleBox[
               "0.0009888262632255513`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0009888262632255513, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.6, 0}, {-5.4, 0.0004944131316127757}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-491.9, -466.88571428571436`}, {
                   45.71323117338004, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004944131316127757]& ,
                TagBoxNote->"0.0004944131316127757"],
               StyleBox[
               "0.0004944131316127757`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004944131316127757, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.4, 0}, {-5.2, 0.0009888262632255513}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-467.38571428571436`, \
-442.3714285714286}, {45.67646234676007, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0009888262632255513]& ,
                TagBoxNote->"0.0009888262632255513"],
               StyleBox[
               "0.0009888262632255513`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0009888262632255513, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.2, 0}, {-5., 0.0004944131316127757}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-442.8714285714286, -417.8571428571429}, {
                   45.71323117338004, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004944131316127757]& ,
                TagBoxNote->"0.0004944131316127757"],
               StyleBox[
               "0.0004944131316127757`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004944131316127757, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.6, 0}, {-4.4, 0.0009888262632255513}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-369.3285714285714, -344.3142857142858}, {
                   45.67646234676007, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0009888262632255513]& ,
                TagBoxNote->"0.0009888262632255513"],
               StyleBox[
               "0.0009888262632255513`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0009888262632255513, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.4, 0}, {-4.2, 0.0004944131316127757}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-344.8142857142858, \
-319.80000000000007`}, {45.71323117338004, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004944131316127757]& ,
                TagBoxNote->"0.0004944131316127757"],
               StyleBox[
               "0.0004944131316127757`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004944131316127757, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.2, 0}, {-4., 0.0004944131316127757}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-320.30000000000007`, \
-295.2857142857142}, {45.71323117338004, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004944131316127757]& ,
                TagBoxNote->"0.0004944131316127757"],
               StyleBox[
               "0.0004944131316127757`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004944131316127757, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4., 0}, {-3.8, 0.0014832393948383269`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-295.7857142857142, -270.7714285714285}, {
                   45.639693520140106`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0014832393948383269`]& ,
                TagBoxNote->"0.0014832393948383269"],
               StyleBox[
               "0.0014832393948383269`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0014832393948383269`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.8, 0}, {-3.6, 0.0014832393948383269`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-271.2714285714285, \
-246.25714285714284`}, {45.639693520140106`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0014832393948383269`]& ,
                TagBoxNote->"0.0014832393948383269"],
               StyleBox[
               "0.0014832393948383269`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0014832393948383269`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.6, 0}, {-3.4, 0.0019776525264511026`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-246.75714285714284`, \
-221.7428571428571}, {45.60292469352014, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0019776525264511026`]& ,
                TagBoxNote->"0.0019776525264511026"],
               StyleBox[
               "0.0019776525264511026`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0019776525264511026`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.4, 0}, {-3.2, 0.002472065658063878}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-222.2428571428571, \
-197.22857142857143`}, {45.566155866900175`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.002472065658063878]& ,
                TagBoxNote->"0.002472065658063878"],
               StyleBox[
               "0.002472065658063878`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.002472065658063878, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.2, 0}, {-3., 0.0034608919212894295`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-197.72857142857143`, \
-172.7142857142857}, {45.49261821366024, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0034608919212894295`]& ,
                TagBoxNote->"0.0034608919212894295"],
               StyleBox[
               "0.0034608919212894295`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0034608919212894295`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3., 0}, {-2.8, 0.0014832393948383269`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-173.2142857142857, \
-148.19999999999996`}, {45.639693520140106`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0014832393948383269`]& ,
                TagBoxNote->"0.0014832393948383269"],
               StyleBox[
               "0.0014832393948383269`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0014832393948383269`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.8, 0}, {-2.6, 0.0029664787896766538`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-148.69999999999996`, \
-123.68571428571428`}, {45.52938704028021, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0029664787896766538`]& ,
                TagBoxNote->"0.0029664787896766538"],
               StyleBox[
               "0.0029664787896766538`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0029664787896766538`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.6, 0}, {-2.4, 0.006427370710966083}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-124.18571428571428`, \
-99.17142857142855}, {45.272005253940456`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.006427370710966083]& ,
                TagBoxNote->"0.006427370710966083"],
               StyleBox[
               "0.006427370710966083`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.006427370710966083, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.4, 0}, {-2.2, 0.010877088895481064`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-99.67142857142855, -74.65714285714287}, {
                   44.94108581436077, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.010877088895481064`]& ,
                TagBoxNote->"0.010877088895481064"],
               StyleBox[
               "0.010877088895481064`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.010877088895481064`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.2, 0}, {-2., 0.010877088895481064`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-75.15714285714287, -50.14285714285711}, {
                   44.94108581436077, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.010877088895481064`]& ,
                TagBoxNote->"0.010877088895481064"],
               StyleBox[
               "0.010877088895481064`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.010877088895481064`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2., 0}, {-1.8, 0.017798872738059923`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-50.64285714285711, \
-25.628571428571405`}, {44.42632224168126, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.017798872738059923`]& ,
                TagBoxNote->"0.017798872738059923"],
               StyleBox[
               "0.017798872738059923`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.017798872738059923`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.8, 0}, {-1.6, 0.019776525264511024`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-26.128571428571405`, \
-1.1142857142856997`}, {44.2792469352014, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.019776525264511024`]& ,
                TagBoxNote->"0.019776525264511024"],
               StyleBox[
               "0.019776525264511024`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.019776525264511024`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.6, 0}, {-1.4, 0.030653614159992088`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-1.6142857142856997`, 
                   23.400000000000034`}, {43.470332749562175`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.030653614159992088`]& ,
                TagBoxNote->"0.030653614159992088"],
               StyleBox[
               "0.030653614159992088`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.030653614159992088`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.4, 0}, {-1.2, 0.04301394245031148}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{22.900000000000034`, 47.91428571428574}, {
                   42.55111208406305, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.04301394245031148]& ,
                TagBoxNote->"0.04301394245031148"],
               StyleBox[
               "0.04301394245031148`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.04301394245031148, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.2, 0}, {-1., 0.07811727479481854}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{47.41428571428574, 72.42857142857146}, {
                   39.94052539404554, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.07811727479481854]& ,
                TagBoxNote->"0.07811727479481854"],
               StyleBox[
               "0.07811727479481854`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.07811727479481854, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1., 0}, {-0.8, 0.12063680411351725`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{71.92857142857146, 96.94285714285716}, {
                   36.77840630472855, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.12063680411351725`]& ,
                TagBoxNote->"0.12063680411351725"],
               StyleBox[
               "0.12063680411351725`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.12063680411351725`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.8, 0}, {-0.6, 0.1666172253535054}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{96.44285714285716, 121.45714285714288`}, {
                   33.358905429071804`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.1666172253535054]& ,
                TagBoxNote->"0.1666172253535054"],
               StyleBox[
               "0.1666172253535054`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.1666172253535054, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.6, 0}, {-0.4, 0.28329872441412046`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{120.95714285714288`, 145.9714285714286}, {
                   24.681462346760068`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.28329872441412046`]& ,
                TagBoxNote->"0.28329872441412046"],
               StyleBox[
               "0.28329872441412046`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.28329872441412046`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.4, 0}, {-0.2, 0.49194106595471176`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{145.4714285714286, 170.48571428571432`}, {
                   9.165017513134849, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.49194106595471176`]& ,
                TagBoxNote->"0.49194106595471176"],
               StyleBox[
               "0.49194106595471176`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.49194106595471176`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.2, 0}, {0., 0.8711559379017106}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{169.98571428571432`, 
                   195.00000000000003`}, {-19.036672504378288`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.8711559379017106]& ,
                TagBoxNote->"0.8711559379017106"],
               StyleBox[
               "0.8711559379017106`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.8711559379017106, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0., 0}, {0.2, 1.4115494907544743`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{194.50000000000003`, 
                   219.51428571428573`}, {-59.224999999999994`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 1.4115494907544743`]& ,
                TagBoxNote->"1.4115494907544743"],
               StyleBox[
               "1.4115494907544743`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[1.4115494907544743`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.2, 0}, {0.4, 0.8251755166617225}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{219.01428571428573`, 
                   244.02857142857147`}, {-15.617171628721543`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.8251755166617225]& ,
                TagBoxNote->"0.8251755166617225"],
               StyleBox[
               "0.8251755166617225`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.8251755166617225, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.4, 0}, {0.6, 0.35993275981410067`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{243.52857142857147`, 268.5428571428572}, {
                   18.982294220665498`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.35993275981410067`]& ,
                TagBoxNote->"0.35993275981410067"],
               StyleBox[
               "0.35993275981410067`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.35993275981410067`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.6, 0}, {0.8, 0.1339859586670622}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{268.0428571428572, 293.0571428571429}, {
                   35.78564798598949, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.1339859586670622]& ,
                TagBoxNote->"0.1339859586670622"],
               StyleBox[
               "0.1339859586670622`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.1339859586670622, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.8, 0}, {1., 0.06180164145159695}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{292.5571428571429, 317.5714285714286}, {
                   41.15389667250438, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.06180164145159695]& ,
                TagBoxNote->"0.06180164145159695"],
               StyleBox[
               "0.06180164145159695`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.06180164145159695, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1., 0}, {1.2, 0.014832393948383269`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{317.0714285714286, 342.0857142857143}, {
                   44.64693520140105, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.014832393948383269`]& ,
                TagBoxNote->"0.014832393948383269"],
               StyleBox[
               "0.014832393948383269`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.014832393948383269`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.2, 0}, {1.4, 0.007416196974191634}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{341.5857142857143, 366.6}, {
                   45.198467600700525`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.007416196974191634]& ,
                TagBoxNote->"0.007416196974191634"],
               StyleBox[
               "0.007416196974191634`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.007416196974191634, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.4, 0}, {1.6, 0.0034608919212894295`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{366.1, 391.11428571428576`}, {
                   45.49261821366024, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0034608919212894295`]& ,
                TagBoxNote->"0.0034608919212894295"],
               StyleBox[
               "0.0034608919212894295`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0034608919212894295`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.6, 0}, {1.8, 0.0009888262632255513}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{390.61428571428576`, 415.6285714285715}, {
                   45.67646234676007, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0009888262632255513]& ,
                TagBoxNote->"0.0009888262632255513"],
               StyleBox[
               "0.0009888262632255513`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0009888262632255513, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.8, 0}, {2., 0.0009888262632255513}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{415.1285714285715, 440.14285714285717`}, {
                   45.67646234676007, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0009888262632255513]& ,
                TagBoxNote->"0.0009888262632255513"],
               StyleBox[
               "0.0009888262632255513`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0009888262632255513, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.2, 0}, {2.4, 0.0004944131316127757}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{464.15714285714296`, 489.1714285714286}, {
                   45.71323117338004, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004944131316127757]& ,
                TagBoxNote->"0.0004944131316127757"],
               StyleBox[
               "0.0004944131316127757`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004944131316127757, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{3., 0}, {3.2, 0.0004944131316127757}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{562.2142857142858, 587.2285714285715}, {
                   45.71323117338004, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004944131316127757]& ,
                TagBoxNote->"0.0004944131316127757"],
               StyleBox[
               "0.0004944131316127757`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004944131316127757, {FontFamily -> "Times"}], 
               "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{-1.456, 0},
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"G = 10113\"", FontFamily -> "Latin Modern Math", FontSize -> 
                20, "", StripOnInput -> False], RoundingRadius -> 5, 
               FrameStyle -> None, Background -> RGBColor[0.95, 0.95, 0.95], 
               StripOnInput -> False], TraditionalForm], 
             Scaled[{0.1, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->NCache[{{
              Rational[-7, 5], 
              Rational[7, 5]}, {All, All}}, {{-1.4, 1.4}, {All, All}}],
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]},
        {
         GraphicsBox[{{
            {Opacity[0], 
             PointBox[{{0.472, 0.}, {7.000000000000001, 
              0.}}]}, {{}, {{{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.6, 0.}, {1.6, 0.09040880503144653}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{29.629411764705882`, 
                    82.7029411764706}, {43.572228773584904`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.09040880503144653]& ,
                    TagBoxNote->"0.09040880503144653"],
                    StyleBox[
                    "0.09040880503144653`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.09040880503144653, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.6, 0.}, {2.6, 0.09988386817784663}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{82.2029411764706, 135.2764705882353}, {
                    42.50557353987892, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.09988386817784663]& ,
                    TagBoxNote->"0.09988386817784663"],
                    StyleBox[
                    "0.09988386817784663`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.09988386817784663, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.8000000000000003`, 0.}, {
                    3.8000000000000003`, 0.8014937106918238}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{145.29117647058825`, 
                    198.36470588235295`}, {-36.478154481132066`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.8014937106918238]& ,
                    TagBoxNote->"0.8014937106918238"],
                    StyleBox[
                    "0.8014937106918238`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.8014937106918238, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.8000000000000003`, 0.}, {
                    4.800000000000001, 0.7890568760165071}, "RoundingRadius" -> 
                    0]},
                    
                    ImageSizeCache->{{197.86470588235295`, 
                    250.93823529411767`}, {-35.07807781755828, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.7890568760165071]& ,
                    TagBoxNote->"0.7890568760165071"],
                    StyleBox[
                    "0.7890568760165071`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.7890568760165071, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{5.000000000000001, 0.}, {6.000000000000001, 
                    0.10809748427672956`}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{260.9529411764706, 314.0264705882353}, {
                    41.580925707547166`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.10809748427672956`]& ,
                    TagBoxNote->"0.10809748427672956"],
                    StyleBox[
                    "0.10809748427672956`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.10809748427672956`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{6.000000000000001, 0.}, {7.000000000000001, 
                    0.11105925580564642`}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{313.5264705882353, 366.6}, {
                    41.247504277679354`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.11105925580564642`]& ,
                    TagBoxNote->"0.11105925580564642"],
                    StyleBox[
                    "0.11105925580564642`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.11105925580564642`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}}, {}, {}}, {}, {}, {}, {}, {}}, \
{{
             
             StyleBox[{{}, {LineBox[{{2.1, 0.}, {2.1, 0.09988386817784663}}], 
                LineBox[{{2.1, 0.09988386817784663}, {2.1, 
                 0.212064482531806}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{4.300000000000001, 0.6575142115057843}, {
                 4.300000000000001, 0.7890568760165071}}], 
                LineBox[{{4.300000000000001, 0.7890568760165071}, {
                 4.300000000000001, 0.9205995405272299}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{6.500000000000001, 0.03290253634996597}, {
                 6.500000000000001, 0.11105925580564642`}}], 
                LineBox[{{6.500000000000001, 0.11105925580564642`}, {
                 6.500000000000001, 0.18921597526132689`}}]}},
              Antialiasing->False]}, {
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{2.1, 0.212064482531806}, 
                   Offset[{3, 0}, {2.1, 0.212064482531806}]}, {{2.1, 
                   0.212064482531806}, 
                   Offset[{-3, 0}, {2.1, 0.212064482531806}]}, {{2.1, 0.}, 
                   Offset[{3, 0}, {2.1, 0.}]}, {{2.1, 0.}, 
                   Offset[{-3, 0}, {2.1, 0.}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{4.300000000000001, 0.9205995405272299}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.9205995405272299}]}, {{4.300000000000001, 
                   0.9205995405272299}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.9205995405272299}]}, {{4.300000000000001, 
                   0.6575142115057843}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.6575142115057843}]}, {{4.300000000000001, 
                   0.6575142115057843}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.6575142115057843}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{6.500000000000001, 0.18921597526132689`}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.18921597526132689`}]}, {{6.500000000000001, 
                   0.18921597526132689`}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.18921597526132689`}]}, {{6.500000000000001, 
                   0.03290253634996597}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.03290253634996597}]}, {{6.500000000000001, 
                   0.03290253634996597}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.03290253634996597}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False]}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0.472, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          DisplayFunction->Identity,
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"pancreas\"", FontFamily -> "Latin Modern Math", FontSize -> 
                24, "", StripOnInput -> False], RoundingRadius -> 5, 
               Background -> GrayLevel[1], StripOnInput -> False], 
              TraditionalForm], 
             Scaled[{0.05, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {None, None}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->{{All, All}, {0, 1}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{None, Automatic}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"]},
    {
     TagBox[GridBox[{
        {
         GraphicsBox[{
           {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[
            0.44099999999999995`], Thickness[Small]}], {}, 
            {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[
             0.44099999999999995`], Thickness[Small]}], 
             RectangleBox[{-12.4, 0}, {-12.2, 0.0004946087644673064},
              RoundingRadius->0], 
             RectangleBox[{-11.6, 0}, {-11.4, 0.0009892175289346128},
              RoundingRadius->0], 
             RectangleBox[{-11.4, 0}, {-11.2, 0.0004946087644673064},
              RoundingRadius->0], 
             RectangleBox[{-10.6, 0}, {-10.4, 0.0004946087644673064},
              RoundingRadius->0], 
             RectangleBox[{-9.6, 0}, {-9.4, 0.0004946087644673064},
              RoundingRadius->0], 
             RectangleBox[{-9.4, 0}, {-9.2, 0.0019784350578692256},
              RoundingRadius->0], 
             RectangleBox[{-9.2, 0}, {-9., 0.0004946087644673064},
              RoundingRadius->0], 
             RectangleBox[{-8.8, 0}, {-8.6, 0.0009892175289346128},
              RoundingRadius->0], 
             RectangleBox[{-8.6, 0}, {-8.4, 0.0009892175289346128},
              RoundingRadius->0], 
             RectangleBox[{-8.4, 0}, {-8.2, 0.001483826293401919},
              RoundingRadius->0], 
             RectangleBox[{-8., 0}, {-7.8, 0.0004946087644673064},
              RoundingRadius->0], 
             RectangleBox[{-7.8, 0}, {-7.6, 0.0019784350578692256},
              RoundingRadius->0], 
             RectangleBox[{-7.6, 0}, {-7.4, 0.001483826293401919},
              RoundingRadius->0], 
             RectangleBox[{-7.2, 0}, {-7., 0.0009892175289346128},
              RoundingRadius->0], 
             RectangleBox[{-7., 0}, {-6.8, 0.0009892175289346128},
              RoundingRadius->0], 
             RectangleBox[{-6.8, 0}, {-6.6, 0.0009892175289346128},
              RoundingRadius->0], 
             RectangleBox[{-6.6, 0}, {-6.4, 0.002967652586803838},
              RoundingRadius->0], 
             RectangleBox[{-6.4, 0}, {-6.2, 0.001483826293401919},
              RoundingRadius->0], 
             RectangleBox[{-6.2, 0}, {-6., 0.0024730438223365316},
              RoundingRadius->0], 
             RectangleBox[{-6., 0}, {-5.8, 0.0024730438223365316},
              RoundingRadius->0], 
             RectangleBox[{-5.8, 0}, {-5.6, 0.0024730438223365316},
              RoundingRadius->0], 
             RectangleBox[{-5.6, 0}, {-5.4, 0.003956870115738451},
              RoundingRadius->0], 
             RectangleBox[{-5.4, 0}, {-5.2, 0.003956870115738451},
              RoundingRadius->0], 
             RectangleBox[{-5.2, 0}, {-5., 0.002967652586803838},
              RoundingRadius->0], 
             RectangleBox[{-5., 0}, {-4.8, 0.004946087644673063},
              RoundingRadius->0], 
             RectangleBox[{-4.8, 0}, {-4.6, 0.00544069640914037},
              RoundingRadius->0], 
             RectangleBox[{-4.6, 0}, {-4.4, 0.00544069640914037},
              RoundingRadius->0], 
             RectangleBox[{-4.4, 0}, {-4.2, 0.011376001582748046},
              RoundingRadius->0], 
             RectangleBox[{-4.2, 0}, {-4., 0.006924522702542289},
              RoundingRadius->0], 
             RectangleBox[{-4., 0}, {-3.8, 0.008408348995944209},
              RoundingRadius->0], 
             RectangleBox[{-3.8, 0}, {-3.6, 0.008902957760411515},
              RoundingRadius->0], 
             RectangleBox[{-3.6, 0}, {-3.4, 0.015332871698486497},
              RoundingRadius->0], 
             RectangleBox[{-3.4, 0}, {-3.2, 0.014343654169551884},
              RoundingRadius->0], 
             RectangleBox[{-3.2, 0}, {-3., 0.011376001582748046},
              RoundingRadius->0], 
             RectangleBox[{-3., 0}, {-2.8, 0.02176278563656148},
              RoundingRadius->0], 
             RectangleBox[{-2.8, 0}, {-2.6, 0.0232466119299634},
              RoundingRadius->0], 
             RectangleBox[{-2.6, 0}, {-2.4, 0.026214264516767238},
              RoundingRadius->0], 
             RectangleBox[{-2.4, 0}, {-2.2, 0.02473043822336532},
              RoundingRadius->0], 
             RectangleBox[{-2.2, 0}, {-2., 0.02819269957463646},
              RoundingRadius->0], 
             RectangleBox[{-2., 0}, {-1.8, 0.0311603521614403},
              RoundingRadius->0], 
             RectangleBox[{-1.8, 0}, {-1.6, 0.04253635374418835},
              RoundingRadius->0], 
             RectangleBox[{-1.6, 0}, {-1.4, 0.057374616678207535},
              RoundingRadius->0], 
             RectangleBox[{-1.4, 0}, {-1.2, 0.06429913938074983},
              RoundingRadius->0], 
             RectangleBox[{-1.2, 0}, {-1., 0.08012661984370363},
              RoundingRadius->0], 
             RectangleBox[{-1., 0}, {-0.8, 0.10584627559600356},
              RoundingRadius->0], 
             RectangleBox[{-0.8, 0}, {-0.6, 0.15481254327826688},
              RoundingRadius->0], 
             RectangleBox[{-0.6, 0}, {-0.4, 0.19833811455138986},
              RoundingRadius->0], 
             RectangleBox[{-0.4, 0}, {-0.2, 0.263131862696607},
              RoundingRadius->0], 
             RectangleBox[{-0.2, 0}, {0., 0.3882678801068355},
              RoundingRadius->0], 
             RectangleBox[{0., 0}, {0.2, 0.5257691166287467},
              RoundingRadius->0], 
             RectangleBox[{0.2, 0}, {0.4, 0.6256800870511425},
              RoundingRadius->0], 
             RectangleBox[{0.4, 0}, {0.6, 0.4753190226530814},
              RoundingRadius->0], 
             RectangleBox[{0.6, 0}, {0.8, 0.3892570976357701},
              RoundingRadius->0], 
             RectangleBox[{0.8, 0}, {1., 0.26807795034128007},
              RoundingRadius->0], 
             RectangleBox[{1., 0}, {1.2, 0.23048768424176477},
              RoundingRadius->0], 
             RectangleBox[{1.2, 0}, {1.4, 0.2022949846671283},
              RoundingRadius->0], 
             RectangleBox[{1.4, 0}, {1.6, 0.16866158868335146},
              RoundingRadius->0], 
             RectangleBox[{1.6, 0}, {1.8, 0.12018992976555544},
              RoundingRadius->0], 
             RectangleBox[{1.8, 0}, {2., 0.09644870907112474},
              RoundingRadius->0], 
             RectangleBox[{2., 0}, {2.2, 0.06776140073202097},
              RoundingRadius->0], 
             RectangleBox[{2.2, 0}, {2.4, 0.05984766050054407},
              RoundingRadius->0], 
             RectangleBox[{2.4, 0}, {2.6, 0.03561183104164606},
              RoundingRadius->0], 
             RectangleBox[{2.6, 0}, {2.8, 0.03165496092590761},
              RoundingRadius->0], 
             RectangleBox[{2.8, 0}, {3., 0.016816697991888417},
              RoundingRadius->0], 
             RectangleBox[{3., 0}, {3.2, 0.013354436640617272},
              RoundingRadius->0], 
             RectangleBox[{3.2, 0}, {3.4, 0.007913740231476903},
              RoundingRadius->0], 
             RectangleBox[{3.4, 0}, {3.6, 0.0034622613512711444},
              RoundingRadius->0], 
             RectangleBox[{3.6, 0}, {3.8, 0.004451478880205757},
              RoundingRadius->0], 
             RectangleBox[{3.8, 0}, {4., 0.002967652586803838},
              RoundingRadius->0], 
             RectangleBox[{4., 0}, {4.2, 0.0024730438223365316},
              RoundingRadius->0], 
             RectangleBox[{4.2, 0}, {4.4, 0.0004946087644673064},
              RoundingRadius->0], 
             RectangleBox[{4.4, 0}, {4.6, 0.0009892175289346128},
              RoundingRadius->0], 
             RectangleBox[{4.6, 0}, {4.8, 0.0004946087644673064},
              RoundingRadius->0], 
             RectangleBox[{4.8, 0}, {5., 0.001483826293401919},
              RoundingRadius->0], 
             RectangleBox[{5., 0}, {5.2, 0.0019784350578692256},
              RoundingRadius->0], 
             RectangleBox[{5.2, 0}, {5.4, 0.001483826293401919},
              RoundingRadius->0], 
             RectangleBox[{5.4, 0}, {5.6, 0.0009892175289346128},
              RoundingRadius->0], 
             RectangleBox[{5.8, 0}, {6., 0.0004946087644673064},
              RoundingRadius->0], 
             RectangleBox[{6.8, 0}, {7., 0.0004946087644673064},
              RoundingRadius->0], 
             RectangleBox[{7.6, 0}, {7.8, 0.0004946087644673064},
              RoundingRadius->0], 
             RectangleBox[{9.8, 0}, {10., 0.0004946087644673064},
              RoundingRadius->0], 
             RectangleBox[{12.4, 0}, {12.6, 0.0004946087644673064},
              
              RoundingRadius->
               0]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{-3.3400000000000003`, 0},
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"G = 10109\"", FontFamily -> "Latin Modern Math", FontSize -> 
                20, "", StripOnInput -> False], RoundingRadius -> 5, 
               FrameStyle -> None, Background -> RGBColor[0.95, 0.95, 0.95], 
               StripOnInput -> False], TraditionalForm], 
             Scaled[{0.1, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->NCache[{{
              Rational[-16, 5], 
              Rational[19, 5]}, {All, All}}, {{-3.2, 3.8}, {All, All}}],
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]},
        {
         GraphicsBox[{{
            {Opacity[0], 
             PointBox[{{0.11599999999999999`, 0.}, {5.200000000000001, 
              0.}}]}, {{}, {{{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.6, 0.}, {1.6, 0.37837476610531945`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{55.57285601888277, 
                    123.57875688434302`}, {11.154460705693658`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.37837476610531945`]& ,
                    TagBoxNote->"0.37837476610531945"],
                    StyleBox[
                    "0.37837476610531945`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.37837476610531945`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.6, 0.}, {2.6, 0.4595057044851285}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{123.07875688434302`, 
                    191.08465774980328`}, {2.021145317586658, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.4595057044851285]& ,
                    TagBoxNote->"0.4595057044851285"],
                    StyleBox[
                    "0.4595057044851285`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.4595057044851285, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.8000000000000003`, 0.}, {
                    3.8000000000000003`, 0.6216252338946806}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{204.08583792289537`, 
                    272.0917387883556}, {-16.22946070569367, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.6216252338946806]& ,
                    TagBoxNote->"0.6216252338946806"],
                    StyleBox[
                    "0.6216252338946806`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.6216252338946806, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.8000000000000003`, 0.}, {
                    4.800000000000001, 0.5404942955148715}, "RoundingRadius" -> 
                    0]},
                    
                    ImageSizeCache->{{271.5917387883556, 
                    339.5976396538159}, {-7.096145317586661, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.5404942955148715]& ,
                    TagBoxNote->"0.5404942955148715"],
                    StyleBox[
                    "0.5404942955148715`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.5404942955148715, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}}, {}, {}}, {}, {}, {}, {}, {}}, \
{{
             
             StyleBox[{{}, {
                LineBox[{{2.1, 0.33536574209723546`}, {2.1, 
                 0.4595057044851285}}], 
                LineBox[{{2.1, 0.4595057044851285}, {2.1, 
                 0.5836456668730216}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{4.300000000000001, 0.41635433312697845`}, {
                 4.300000000000001, 0.5404942955148715}}], 
                LineBox[{{4.300000000000001, 0.5404942955148715}, {
                 4.300000000000001, 0.6646342579027645}}]}},
              Antialiasing->False]}, {
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{2.1, 0.5836456668730216}, 
                   Offset[{3, 0}, {2.1, 0.5836456668730216}]}, {{2.1, 
                   0.5836456668730216}, 
                   Offset[{-3, 0}, {2.1, 0.5836456668730216}]}, {{2.1, 
                   0.33536574209723546`}, 
                   Offset[{3, 0}, {2.1, 0.33536574209723546`}]}, {{2.1, 
                   0.33536574209723546`}, 
                   Offset[{-3, 0}, {2.1, 0.33536574209723546`}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{4.300000000000001, 0.6646342579027645}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.6646342579027645}]}, {{4.300000000000001, 
                   0.6646342579027645}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.6646342579027645}]}, {{4.300000000000001, 
                   0.41635433312697845`}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.41635433312697845`}]}, {{4.300000000000001, 
                   0.41635433312697845`}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.41635433312697845`}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False]}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0.11599999999999999`, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          DisplayFunction->Identity,
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"bladder\"", FontFamily -> "Latin Modern Math", FontSize -> 
                24, "", StripOnInput -> False], RoundingRadius -> 5, 
               Background -> GrayLevel[1], StripOnInput -> False], 
              TraditionalForm], 
             Scaled[{0.05, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {None, None}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->{{All, All}, {0, 1}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{None, Automatic}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"], 
     TagBox[GridBox[{
        {
         GraphicsBox[{
           {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.574], 
            Thickness[Small]}], {}, 
            {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.574], 
             Thickness[Small]}], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-6., 0}, {-5.8, 0.0019584802193497847`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-298.84999999999997`, \
-276.8999999999999}, {45.54576848249028, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0019584802193497847`]& ,
                TagBoxNote->"0.0019584802193497847"],
               StyleBox[
               "0.0019584802193497847`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0019584802193497847`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.6, 0}, {-5.4, 0.0019584802193497847`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-255.94999999999987`, \
-234.00000000000006`}, {45.54576848249028, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0019584802193497847`]& ,
                TagBoxNote->"0.0019584802193497847"],
               StyleBox[
               "0.0019584802193497847`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0019584802193497847`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.4, 0}, {-4.2, 0.0019584802193497847`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-127.25, -105.30000000000001`}, {
                   45.54576848249028, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0019584802193497847`]& ,
                TagBoxNote->"0.0019584802193497847"],
               StyleBox[
               "0.0019584802193497847`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0019584802193497847`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4., 0}, {-3.8, 0.0019584802193497847`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-84.34999999999997, -62.39999999999992}, {
                   45.54576848249028, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0019584802193497847`]& ,
                TagBoxNote->"0.0019584802193497847"],
               StyleBox[
               "0.0019584802193497847`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0019584802193497847`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.6, 0}, {-3.4, 0.0019584802193497847`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-41.44999999999999, \
-19.499999999999943`}, {45.54576848249028, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0019584802193497847`]& ,
                TagBoxNote->"0.0019584802193497847"],
               StyleBox[
               "0.0019584802193497847`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0019584802193497847`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.4, 0}, {-3.2, 0.009792401096748922}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-19.999999999999943`, 
                   1.9499999999999886`}, {44.72884241245137, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.009792401096748922]& ,
                TagBoxNote->"0.009792401096748922"],
               StyleBox[
               "0.009792401096748922`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.009792401096748922, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.2, 0}, {-3., 0.005875440658049354}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{1.4499999999999886`, 
                   23.400000000000034`}, {45.13730544747082, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.005875440658049354]& ,
                TagBoxNote->"0.005875440658049354"],
               StyleBox[
               "0.005875440658049354`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.005875440658049354, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3., 0}, {-2.8, 0.013709361535448493`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{22.900000000000034`, 44.85000000000008}, {
                   44.32037937743191, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.013709361535448493`]& ,
                TagBoxNote->"0.013709361535448493"],
               StyleBox[
               "0.013709361535448493`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.013709361535448493`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.8, 0}, {-2.6, 0.023501762632197415`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{44.35000000000008, 66.30000000000001}, {
                   43.299221789883276`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.023501762632197415`]& ,
                TagBoxNote->"0.023501762632197415"],
               StyleBox[
               "0.023501762632197415`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.023501762632197415`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.6, 0}, {-2.4, 0.04308656482569526}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{65.80000000000001, 87.75000000000006}, {
                   41.256906614786, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.04308656482569526]& ,
                TagBoxNote->"0.04308656482569526"],
               StyleBox[
               "0.04308656482569526`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.04308656482569526, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.4, 0}, {-2.2, 0.06267136701919311}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{87.25000000000006, 109.20000000000002`}, {
                   39.214591439688725`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.06267136701919311]& ,
                TagBoxNote->"0.06267136701919311"],
               StyleBox[
               "0.06267136701919311`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.06267136701919311, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.2, 0}, {-2., 0.0881316098707403}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{108.70000000000002`, 
                   130.65000000000003`}, {36.55958171206227, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0881316098707403]& ,
                TagBoxNote->"0.0881316098707403"],
               StyleBox[
               "0.0881316098707403`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.0881316098707403, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2., 0}, {-1.8, 0.12925969447708577`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{130.15000000000003`, 
                   152.10000000000002`}, {32.270719844357984`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.12925969447708577`]& ,
                TagBoxNote->"0.12925969447708577"],
               StyleBox[
               "0.12925969447708577`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.12925969447708577`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.8, 0}, {-1.6, 0.12925969447708577`}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{151.60000000000002`, 173.55}, {
                   32.270719844357984`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.12925969447708577`]& ,
                TagBoxNote->"0.12925969447708577"],
               StyleBox[
               "0.12925969447708577`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.12925969447708577`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.6, 0}, {-1.4, 0.199764982373678}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{173.05, 195.00000000000006`}, {
                   24.91838521400779, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.199764982373678]& ,
                TagBoxNote->"0.199764982373678"],
               StyleBox[
               "0.199764982373678`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.199764982373678, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.4, 0}, {-1.2, 0.23893458676067372`}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{194.50000000000006`, 
                   216.45000000000005`}, {20.83375486381324, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.23893458676067372`]& ,
                TagBoxNote->"0.23893458676067372"],
               StyleBox[
               "0.23893458676067372`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.23893458676067372`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.2, 0}, {-1., 0.3427340383862123}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{215.95000000000005`, 
                   237.90000000000003`}, {10.009484435797674`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.3427340383862123]& ,
                TagBoxNote->"0.3427340383862123"],
               StyleBox[
               "0.3427340383862123`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.3427340383862123, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1., 0}, {-0.8, 0.4132393262828045}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{237.40000000000003`, 259.35}, {
                   2.6571498054474816`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.4132393262828045]& ,
                TagBoxNote->"0.4132393262828045"],
               StyleBox[
               "0.4132393262828045`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.4132393262828045, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.8, 0}, {-0.6, 0.599294947121034}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{258.85, 
                   280.80000000000007`}, {-16.74484435797664, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.599294947121034]& ,
                TagBoxNote->"0.599294947121034"],
               StyleBox[
               "0.599294947121034`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.599294947121034, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.6, 0}, {-0.4, 0.6776341558950255}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{280.30000000000007`, 
                   302.25}, {-24.914105058365756`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.6776341558950255]& ,
                TagBoxNote->"0.6776341558950255"],
               StyleBox[
               "0.6776341558950255`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.6776341558950255, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.4, 0}, {-0.2, 0.9341950646298472}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{301.75, 
                   323.70000000000005`}, {-51.66843385214006, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.9341950646298472]& ,
                TagBoxNote->"0.9341950646298472"],
               StyleBox[
               "0.9341950646298472`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.9341950646298472, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.2, 0}, {0., 1.0066588327457893`}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{323.20000000000005`, 
                   345.15000000000003`}, {-59.22499999999999, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 1.0066588327457893`]& ,
                TagBoxNote->"1.0066588327457893"],
               StyleBox[
               "1.0066588327457893`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[1.0066588327457893`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0., 0}, {0.2, 0.07246376811594203}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{344.65000000000003`, 366.6}, {
                   38.19343385214009, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.07246376811594203]& ,
                TagBoxNote->"0.07246376811594203"],
               StyleBox[
               "0.07246376811594203`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.07246376811594203, {FontFamily -> "Times"}], 
               "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{-3.064, 0},
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"G = 2553\"", FontFamily -> "Latin Modern Math", FontSize -> 
                20, "", StripOnInput -> False], RoundingRadius -> 5, 
               FrameStyle -> None, Background -> RGBColor[0.95, 0.95, 0.95], 
               StripOnInput -> False], TraditionalForm], 
             Scaled[{0.1, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->NCache[{{-3, 
              Rational[1, 5]}, {All, All}}, {{-3, 0.2}, {All, All}}],
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]},
        {
         GraphicsBox[{{
            {Opacity[0], 
             PointBox[{{0.11599999999999999`, 0.}, {5.200000000000001, 
              0.}}]}, {{}, {{{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.6, 0.}, {1.6, 0.5183603757472246}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{55.57285601888277, 
                    123.57875688434302`}, {-4.60441929974381, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.5183603757472246]& ,
                    TagBoxNote->"0.5183603757472246"],
                    StyleBox[
                    "0.5183603757472246`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.5183603757472246, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.6, 0.}, {2.6, 0.535117290295905}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{123.07875688434302`, 
                    191.08465774980328`}, {-6.4908289550615095`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.535117290295905]& ,
                    TagBoxNote->"0.535117290295905"],
                    StyleBox[
                    "0.535117290295905`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.535117290295905, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.8000000000000003`, 0.}, {
                    3.8000000000000003`, 0.4816396242527754}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{204.08583792289537`, 
                    272.0917387883556}, {-0.4705807002561926, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.4816396242527754]& ,
                    TagBoxNote->"0.4816396242527754"],
                    StyleBox[
                    "0.4816396242527754`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.4816396242527754, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.8000000000000003`, 0.}, {
                    4.800000000000001, 0.4648827097040949}, "RoundingRadius" -> 
                    0]},
                    
                    ImageSizeCache->{{271.5917387883556, 339.5976396538159}, {
                    1.4158289550615137`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.4648827097040949]& ,
                    TagBoxNote->"0.4648827097040949"],
                    StyleBox[
                    "0.4648827097040949`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.4648827097040949, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}}, {}, {}}, {}, {}, {}, {}, {}}, \
{{
             
             StyleBox[{{}, {
                LineBox[{{2.1, 0.4287175296814293}, {2.1, 
                 0.535117290295905}}], 
                LineBox[{{2.1, 0.535117290295905}, {2.1, 
                 0.6415170509103808}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{4.300000000000001, 0.3584829490896192}, {
                 4.300000000000001, 0.4648827097040949}}], 
                LineBox[{{4.300000000000001, 0.4648827097040949}, {
                 4.300000000000001, 0.5712824703185706}}]}},
              Antialiasing->False]}, {
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{2.1, 0.6415170509103808}, 
                   Offset[{3, 0}, {2.1, 0.6415170509103808}]}, {{2.1, 
                   0.6415170509103808}, 
                   Offset[{-3, 0}, {2.1, 0.6415170509103808}]}, {{2.1, 
                   0.4287175296814293}, 
                   Offset[{3, 0}, {2.1, 0.4287175296814293}]}, {{2.1, 
                   0.4287175296814293}, 
                   Offset[{-3, 0}, {2.1, 0.4287175296814293}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{4.300000000000001, 0.5712824703185706}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.5712824703185706}]}, {{4.300000000000001, 
                   0.5712824703185706}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.5712824703185706}]}, {{4.300000000000001, 
                   0.3584829490896192}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.3584829490896192}]}, {{4.300000000000001, 
                   0.3584829490896192}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.3584829490896192}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False]}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0.11599999999999999`, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          DisplayFunction->Identity,
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"thymus\"", FontFamily -> "Latin Modern Math", FontSize -> 
                24, "", StripOnInput -> False], RoundingRadius -> 5, 
               Background -> GrayLevel[1], StripOnInput -> False], 
              TraditionalForm], 
             Scaled[{0.05, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {None, None}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->{{All, All}, {0, 1}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{None, Automatic}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"], 
     TagBox[GridBox[{
        {
         GraphicsBox[{
           {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[
            0.5319999999999999], Thickness[Small]}], {}, 
            {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[
             0.5319999999999999], Thickness[Small]}], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-10.4, 0}, {-10.2, 0.000488615264340858}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{-616.6999999999999, -600.5999999999998}, {
                   45.69436936936937, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.000488615264340858]& ,
                TagBoxNote->"0.000488615264340858"],
               StyleBox[
               "0.000488615264340858`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.000488615264340858, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-7.4, 0}, {-7.2, 0.000488615264340858}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-382.69999999999993`, \
-366.5999999999999}, {45.69436936936937, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.000488615264340858]& ,
                TagBoxNote->"0.000488615264340858"],
               StyleBox[
               "0.000488615264340858`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.000488615264340858, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-6.8, 0}, {-6.6, 0.000488615264340858}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-335.89999999999986`, \
-319.79999999999984`}, {45.69436936936937, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.000488615264340858]& ,
                TagBoxNote->"0.000488615264340858"],
               StyleBox[
               "0.000488615264340858`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.000488615264340858, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-6.6, 0}, {-6.4, 0.001465845793022574}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-320.29999999999984`, \
-304.19999999999993`}, {45.58310810810811, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001465845793022574]& ,
                TagBoxNote->"0.001465845793022574"],
               StyleBox[
               "0.001465845793022574`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001465845793022574, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-6.4, 0}, {-6.2, 0.000488615264340858}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-304.69999999999993`, \
-288.5999999999999}, {45.69436936936937, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.000488615264340858]& ,
                TagBoxNote->"0.000488615264340858"],
               StyleBox[
               "0.000488615264340858`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.000488615264340858, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-6.2, 0}, {-6., 0.000488615264340858}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-289.0999999999999, -272.9999999999999}, {
                   45.69436936936937, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.000488615264340858]& ,
                TagBoxNote->"0.000488615264340858"],
               StyleBox[
               "0.000488615264340858`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.000488615264340858, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-6., 0}, {-5.8, 0.001954461057363432}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-273.4999999999999, \
-257.39999999999986`}, {45.527477477477476`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001954461057363432]& ,
                TagBoxNote->"0.001954461057363432"],
               StyleBox[
               "0.001954461057363432`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001954461057363432, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.8, 0}, {-5.6, 0.001954461057363432}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-257.89999999999986`, \
-241.79999999999987`}, {45.527477477477476`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001954461057363432]& ,
                TagBoxNote->"0.001954461057363432"],
               StyleBox[
               "0.001954461057363432`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001954461057363432, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.6, 0}, {-5.4, 0.001465845793022574}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-242.29999999999987`, \
-226.1999999999999}, {45.58310810810811, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001465845793022574]& ,
                TagBoxNote->"0.001465845793022574"],
               StyleBox[
               "0.001465845793022574`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001465845793022574, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.4, 0}, {-5.2, 0.002931691586045148}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-226.6999999999999, \
-210.59999999999994`}, {45.41621621621621, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.002931691586045148]& ,
                TagBoxNote->"0.002931691586045148"],
               StyleBox[
               "0.002931691586045148`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.002931691586045148, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.2, 0}, {-5., 0.00244307632170429}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-211.09999999999994`, \
-194.99999999999991`}, {45.471846846846844`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.00244307632170429]& ,
                TagBoxNote->"0.00244307632170429"],
               StyleBox[
               "0.00244307632170429`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.00244307632170429, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5., 0}, {-4.8, 0.00244307632170429}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-195.49999999999991`, \
-179.3999999999999}, {45.471846846846844`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.00244307632170429]& ,
                TagBoxNote->"0.00244307632170429"],
               StyleBox[
               "0.00244307632170429`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.00244307632170429, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.8, 0}, {-4.6, 0.00244307632170429}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-179.8999999999999, \
-163.79999999999987`}, {45.471846846846844`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.00244307632170429]& ,
                TagBoxNote->"0.00244307632170429"],
               StyleBox[
               "0.00244307632170429`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.00244307632170429, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.6, 0}, {-4.4, 0.00244307632170429}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-164.29999999999987`, \
-148.19999999999996`}, {45.471846846846844`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.00244307632170429]& ,
                TagBoxNote->"0.00244307632170429"],
               StyleBox[
               "0.00244307632170429`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.00244307632170429, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.4, 0}, {-4.2, 0.0043975373790677225`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-148.69999999999996`, \
-132.59999999999994`}, {45.24932432432433, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0043975373790677225`]& ,
                TagBoxNote->"0.0043975373790677225"],
               StyleBox[
               "0.0043975373790677225`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0043975373790677225`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.2, 0}, {-4., 0.003908922114726864}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-133.09999999999994`, \
-116.99999999999991`}, {45.30495495495496, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.003908922114726864]& ,
                TagBoxNote->"0.003908922114726864"],
               StyleBox[
               "0.003908922114726864`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.003908922114726864, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4., 0}, {-3.8, 0.006351998436431154}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-117.49999999999991`, \
-101.39999999999989`}, {45.0268018018018, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.006351998436431154]& ,
                TagBoxNote->"0.006351998436431154"],
               StyleBox[
               "0.006351998436431154`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.006351998436431154, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.8, 0}, {-3.6, 0.006351998436431154}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-101.89999999999989`, \
-85.79999999999993}, {45.0268018018018, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.006351998436431154]& ,
                TagBoxNote->"0.006351998436431154"],
               StyleBox[
               "0.006351998436431154`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.006351998436431154, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.6, 0}, {-3.4, 0.009283690022476303}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{-86.29999999999993, -70.1999999999999}, {
                   44.693018018018016`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.009283690022476303]& ,
                TagBoxNote->"0.009283690022476303"],
               StyleBox[
               "0.009283690022476303`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.009283690022476303, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.4, 0}, {-3.2, 0.009283690022476303}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-70.6999999999999, -54.59999999999994}, {
                   44.693018018018016`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.009283690022476303]& ,
                TagBoxNote->"0.009283690022476303"],
               StyleBox[
               "0.009283690022476303`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.009283690022476303, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.2, 0}, {-3., 0.00732922896511287}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-55.09999999999994, \
-38.999999999999915`}, {44.91554054054054, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.00732922896511287]& ,
                TagBoxNote->"0.00732922896511287"],
               StyleBox[
               "0.00732922896511287`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.00732922896511287, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3., 0}, {-2.8, 0.010260920551158018`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-39.499999999999915`, \
-23.39999999999992}, {44.581756756756754`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.010260920551158018`]& ,
                TagBoxNote->"0.010260920551158018"],
               StyleBox[
               "0.010260920551158018`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.010260920551158018`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.8, 0}, {-2.6, 0.015147073194566598`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-23.89999999999992, \
-7.7999999999999545`}, {44.02545045045045, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.015147073194566598`]& ,
                TagBoxNote->"0.015147073194566598"],
               StyleBox[
               "0.015147073194566598`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.015147073194566598`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.6, 0}, {-2.4, 0.018567380044952606`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-8.299999999999955, 7.800000000000068}, {
                   43.63603603603604, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.018567380044952606`]& ,
                TagBoxNote->"0.018567380044952606"],
               StyleBox[
               "0.018567380044952606`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.018567380044952606`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.4, 0}, {-2.2, 0.021499071630997752`}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{7.300000000000068, 23.400000000000034`}, {
                   43.30225225225225, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.021499071630997752`]& ,
                TagBoxNote->"0.021499071630997752"],
               StyleBox[
               "0.021499071630997752`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.021499071630997752`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.2, 0}, {-2., 0.020521841102316037`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{22.900000000000034`, 39.00000000000006}, {
                   43.413513513513514`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.020521841102316037`]& ,
                TagBoxNote->"0.020521841102316037"],
               StyleBox[
               "0.020521841102316037`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.020521841102316037`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2., 0}, {-1.8, 0.03518029903254178}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{38.50000000000006, 54.60000000000005}, {
                   41.744594594594595`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.03518029903254178]& ,
                TagBoxNote->"0.03518029903254178"],
               StyleBox[
               "0.03518029903254178`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.03518029903254178, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.8, 0}, {-1.6, 0.03860060588292778}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{54.10000000000005, 70.20000000000005}, {
                   41.35518018018018, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.03860060588292778]& ,
                TagBoxNote->"0.03860060588292778"],
               StyleBox[
               "0.03860060588292778`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.03860060588292778, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.6, 0}, {-1.4, 0.05912244698524382}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{69.70000000000005, 85.80000000000005}, {
                   39.01869369369369, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.05912244698524382]& ,
                TagBoxNote->"0.05912244698524382"],
               StyleBox[
               "0.05912244698524382`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.05912244698524382, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.4, 0}, {-1.2, 0.06254275383562982}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{85.30000000000005, 101.40000000000005`}, {
                   38.62927927927928, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.06254275383562982]& ,
                TagBoxNote->"0.06254275383562982"],
               StyleBox[
               "0.06254275383562982`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.06254275383562982, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.2, 0}, {-1., 0.09918889866119418}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{100.90000000000005`, 
                   117.00000000000004`}, {34.45698198198198, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.09918889866119418]& ,
                TagBoxNote->"0.09918889866119418"],
               StyleBox[
               "0.09918889866119418`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.09918889866119418, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1., 0}, {-0.8, 0.13241473663637252`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{116.50000000000004`, 
                   132.60000000000002`}, {30.674099099099102`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.13241473663637252`]& ,
                TagBoxNote->"0.13241473663637252"],
               StyleBox[
               "0.13241473663637252`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.13241473663637252`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.8, 0}, {-0.6, 0.17883318674875404`}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{132.10000000000002`, 
                   148.20000000000005`}, {25.38918918918919, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.17883318674875404`]& ,
                TagBoxNote->"0.17883318674875404"],
               StyleBox[
               "0.17883318674875404`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.17883318674875404`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.6, 0}, {-0.4, 0.3102706928564448}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{147.70000000000005`, 
                   163.80000000000004`}, {10.424549549549553`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.3102706928564448]& ,
                TagBoxNote->"0.3102706928564448"],
               StyleBox[
               "0.3102706928564448`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.3102706928564448, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.4, 0}, {-0.2, 0.4309586631486368}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{163.30000000000004`, 
                   179.40000000000003`}, {-3.316216216216219, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.4309586631486368]& ,
                TagBoxNote->"0.4309586631486368"],
               StyleBox[
               "0.4309586631486368`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.4309586631486368, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.2, 0}, {0., 0.646926609987296}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{178.90000000000003`, 
                   195.00000000000003`}, {-27.904954954954945`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.646926609987296]& ,
                TagBoxNote->"0.646926609987296"],
               StyleBox[
               "0.646926609987296`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.646926609987296, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0., 0}, {0.2, 0.9220170038111991}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{194.50000000000003`, 
                   210.60000000000002`}, {-59.224999999999994`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.9220170038111991]& ,
                TagBoxNote->"0.9220170038111991"],
               StyleBox[
               "0.9220170038111991`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.9220170038111991, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.2, 0}, {0.4, 0.7553991986709665}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{210.10000000000002`, 
                   226.20000000000002`}, {-40.254954954954954`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.7553991986709665]& ,
                TagBoxNote->"0.7553991986709665"],
               StyleBox[
               "0.7553991986709665`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.7553991986709665, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.4, 0}, {0.6, 0.4724909606176097}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{225.70000000000002`, 
                   241.8}, {-8.044819819819821, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.4724909606176097]& ,
                TagBoxNote->"0.4724909606176097"],
               StyleBox[
               "0.4724909606176097`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.4724909606176097, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.6, 0}, {0.8, 0.28828300596110623`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{241.3, 257.40000000000003`}, {
                   12.927927927927925`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.28828300596110623`]& ,
                TagBoxNote->"0.28828300596110623"],
               StyleBox[
               "0.28828300596110623`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.28828300596110623`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.8, 0}, {1., 0.20033225837975177`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{256.90000000000003`, 273.}, {
                   22.941441441441444`, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.20033225837975177`]& ,
                TagBoxNote->"0.20033225837975177"],
               StyleBox[
               "0.20033225837975177`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.20033225837975177`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1., 0}, {1.2, 0.10554089709762533`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{272.5, 288.6}, {33.733783783783785`, 
                   46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.10554089709762533`]& ,
                TagBoxNote->"0.10554089709762533"],
               StyleBox[
               "0.10554089709762533`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.10554089709762533`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.2, 0}, {1.4, 0.05423629434183524}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{288.1, 304.2}, {39.575, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.05423629434183524]& ,
                TagBoxNote->"0.05423629434183524"],
               StyleBox[
               "0.05423629434183524`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.05423629434183524, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.4, 0}, {1.6, 0.028339685331769764`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{303.7, 319.8}, {42.523423423423424`, 
                   46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.028339685331769764`]& ,
                TagBoxNote->"0.028339685331769764"],
               StyleBox[
               "0.028339685331769764`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.028339685331769764`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.6, 0}, {1.8, 0.009283690022476303}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{319.3, 335.4}, {44.693018018018016`, 
                   46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.009283690022476303]& ,
                TagBoxNote->"0.009283690022476303"],
               StyleBox[
               "0.009283690022476303`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.009283690022476303, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.8, 0}, {2., 0.0043975373790677225`}, 
                    "RoundingRadius" -> 0]},
                  ImageSizeCache->{{334.9, 351.}, {45.24932432432433, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0043975373790677225`]& ,
                TagBoxNote->"0.0043975373790677225"],
               StyleBox[
               "0.0043975373790677225`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0043975373790677225`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2., 0}, {2.2, 0.0043975373790677225`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{350.5, 366.6}, {45.24932432432433, 
                   46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0043975373790677225`]& ,
                TagBoxNote->"0.0043975373790677225"],
               StyleBox[
               "0.0043975373790677225`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0043975373790677225`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.2, 0}, {2.4, 0.001954461057363432}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{366.1, 382.2}, {45.527477477477476`, 
                   46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001954461057363432]& ,
                TagBoxNote->"0.001954461057363432"],
               StyleBox[
               "0.001954461057363432`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001954461057363432, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.4, 0}, {2.6, 0.000488615264340858}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{381.7, 397.8}, {45.69436936936937, 
                   46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.000488615264340858]& ,
                TagBoxNote->"0.000488615264340858"],
               StyleBox[
               "0.000488615264340858`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.000488615264340858, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.6, 0}, {2.8, 0.00244307632170429}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{397.3, 413.4}, {45.471846846846844`, 
                   46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.00244307632170429]& ,
                TagBoxNote->"0.00244307632170429"],
               StyleBox[
               "0.00244307632170429`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.00244307632170429, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{3.2, 0}, {3.4, 0.000488615264340858}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{444.1, 460.19999999999993`}, {
                   45.69436936936937, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.000488615264340858]& ,
                TagBoxNote->"0.000488615264340858"],
               StyleBox[
               "0.000488615264340858`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.000488615264340858, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{4.6, 0}, {4.8, 0.000488615264340858}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{553.3, 569.4}, {45.69436936936937, 
                   46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.000488615264340858]& ,
                TagBoxNote->"0.000488615264340858"],
               StyleBox[
               "0.000488615264340858`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.000488615264340858, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{6.8, 0}, {7., 0.000488615264340858}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{724.8999999999999, 740.9999999999999}, {
                   45.69436936936937, 46.25}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.000488615264340858]& ,
                TagBoxNote->"0.000488615264340858"],
               StyleBox[
               "0.000488615264340858`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.000488615264340858, {FontFamily -> "Times"}], 
               "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{-2.2880000000000003`, 0},
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"G = 10233\"", FontFamily -> "Latin Modern Math", FontSize -> 
                20, "", StripOnInput -> False], RoundingRadius -> 5, 
               FrameStyle -> None, Background -> RGBColor[0.95, 0.95, 0.95], 
               StripOnInput -> False], TraditionalForm], 
             Scaled[{0.1, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->NCache[{{
              Rational[-11, 5], 
              Rational[11, 5]}, {All, All}}, {{-2.2, 2.2}, {All, All}}],
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]},
        {
         GraphicsBox[{{
            {Opacity[0], 
             PointBox[{{0.472, 0.}, {7.000000000000001, 
              0.}}]}, {{}, {{{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.6, 0.}, {1.6, 0.25887193553917365`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{29.629411764705882`, 
                    82.7029411764706}, {24.607491856677527`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.25887193553917365`]& ,
                    TagBoxNote->"0.25887193553917365"],
                    StyleBox[
                    "0.25887193553917365`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.25887193553917365`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.6, 0.}, {2.6, 0.24814792467361738`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{82.2029411764706, 135.2764705882353}, {
                    25.814747379867523`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.24814792467361738`]& ,
                    TagBoxNote->"0.24814792467361738"],
                    StyleBox[
                    "0.24814792467361738`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.24814792467361738`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.8000000000000003`, 0.}, {
                    3.8000000000000003`, 0.29744556831818963`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{145.29117647058825`, 
                    198.36470588235295`}, {20.2650651465798, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.29744556831818963`]& ,
                    TagBoxNote->"0.29744556831818963"],
                    StyleBox[
                    "0.29744556831818963`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.29744556831818963`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.8000000000000003`, 0.}, {
                    4.800000000000001, 0.32764072812214157`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{197.86470588235295`, 
                    250.93823529411767`}, {16.86584503164991, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.32764072812214157`]& ,
                    TagBoxNote->"0.32764072812214157"],
                    StyleBox[
                    "0.32764072812214157`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.32764072812214157`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{5.000000000000001, 0.}, {6.000000000000001, 
                    0.4436824961426367}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{260.9529411764706, 314.0264705882353}, {
                    3.80244299674267, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.4436824961426367]& ,
                    TagBoxNote->"0.4436824961426367"],
                    StyleBox[
                    "0.4436824961426367`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.4436824961426367, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{6.000000000000001, 0.}, {7.000000000000001, 
                    0.42421134720424103`}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{313.5264705882353, 366.6}, {
                    5.9944075884825665`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.42421134720424103`]& ,
                    TagBoxNote->"0.42421134720424103"],
                    StyleBox[
                    "0.42421134720424103`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.42421134720424103`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}}, {}, {}}, {}, {}, {}, {}, {}}, \
{{
             
             StyleBox[{{}, {
                LineBox[{{2.1, 0.11816265584552935`}, {2.1, 
                 0.24814792467361738`}}], 
                LineBox[{{2.1, 0.24814792467361738`}, {2.1, 
                 0.3781331935017054}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{4.300000000000001, 0.1799818917451059}, {
                 4.300000000000001, 0.32764072812214157`}}], 
                LineBox[{{4.300000000000001, 0.32764072812214157`}, {
                 4.300000000000001, 0.4752995644991772}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{6.500000000000001, 0.3010272781456983}, {
                 6.500000000000001, 0.42421134720424103`}}], 
                LineBox[{{6.500000000000001, 0.42421134720424103`}, {
                 6.500000000000001, 0.5473954162627838}}]}},
              Antialiasing->False]}, {
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{2.1, 0.3781331935017054}, 
                   Offset[{3, 0}, {2.1, 0.3781331935017054}]}, {{2.1, 
                   0.3781331935017054}, 
                   Offset[{-3, 0}, {2.1, 0.3781331935017054}]}, {{2.1, 
                   0.11816265584552935`}, 
                   Offset[{3, 0}, {2.1, 0.11816265584552935`}]}, {{2.1, 
                   0.11816265584552935`}, 
                   Offset[{-3, 0}, {2.1, 0.11816265584552935`}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{4.300000000000001, 0.4752995644991772}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.4752995644991772}]}, {{4.300000000000001, 
                   0.4752995644991772}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.4752995644991772}]}, {{4.300000000000001, 
                   0.1799818917451059}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.1799818917451059}]}, {{4.300000000000001, 
                   0.1799818917451059}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.1799818917451059}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{6.500000000000001, 0.5473954162627838}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.5473954162627838}]}, {{6.500000000000001, 
                   0.5473954162627838}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.5473954162627838}]}, {{6.500000000000001, 
                   0.3010272781456983}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.3010272781456983}]}, {{6.500000000000001, 
                   0.3010272781456983}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.3010272781456983}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False]}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0.472, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          DisplayFunction->Identity,
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"mammarygland\"", FontFamily -> "Latin Modern Math", 
                FontSize -> 24, "", StripOnInput -> False], RoundingRadius -> 
               5, Background -> GrayLevel[1], StripOnInput -> False], 
              TraditionalForm], 
             Scaled[{0.05, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {None, None}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->{{All, All}, {0, 1}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{None, Automatic}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"]},
    {
     TagBox[GridBox[{
        {
         GraphicsBox[{
           {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.581], 
            Thickness[Small]}], {}, 
            {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.581], 
             Thickness[Small]}], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-15.5, 0}, {-15., 0.0001990247785849338}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-526.22, -502.84}, {45.71225278676736, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0001990247785849338]& ,
                TagBoxNote->"0.0001990247785849338"],
               StyleBox[
               "0.0001990247785849338`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0001990247785849338, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-14., 0}, {-13.5, 0.0001990247785849338}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-457.58, -434.2}, {45.71225278676736, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0001990247785849338]& ,
                TagBoxNote->"0.0001990247785849338"],
               StyleBox[
               "0.0001990247785849338`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0001990247785849338, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-13.5, 0}, {-13., 0.0001990247785849338}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-434.7, -411.32}, {45.71225278676736, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0001990247785849338]& ,
                TagBoxNote->"0.0001990247785849338"],
               StyleBox[
               "0.0001990247785849338`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0001990247785849338, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-13., 0}, {-12.5, 0.0003980495571698676}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-411.82, -388.44}, {45.67450557353471, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0003980495571698676]& ,
                TagBoxNote->"0.0003980495571698676"],
               StyleBox[
               "0.0003980495571698676`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0003980495571698676, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-12.5, 0}, {-12., 0.0001990247785849338}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-388.94, -365.56}, {45.71225278676736, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0001990247785849338]& ,
                TagBoxNote->"0.0001990247785849338"],
               StyleBox[
               "0.0001990247785849338`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0001990247785849338, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-12., 0}, {-11.5, 0.0001990247785849338}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-366.06, -342.68}, {45.71225278676736, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0001990247785849338]& ,
                TagBoxNote->"0.0001990247785849338"],
               StyleBox[
               "0.0001990247785849338`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0001990247785849338, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-11.5, 0}, {-11., 0.0007960991143397353}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-343.18, -319.79999999999995`}, {
                   45.599011147069405`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0007960991143397353]& ,
                TagBoxNote->"0.0007960991143397353"],
               StyleBox[
               "0.0007960991143397353`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0007960991143397353, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-11., 0}, {-10.5, 0.0009951238929246692}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-320.29999999999995`, \
-296.91999999999996`}, {45.561263933836756`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0009951238929246692]& ,
                TagBoxNote->"0.0009951238929246692"],
               StyleBox[
               "0.0009951238929246692`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0009951238929246692, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-10.5, 0}, {-10., 0.0013931734500945367`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-297.41999999999996`, \
-274.03999999999996`}, {45.48576950737146, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0013931734500945367`]& ,
                TagBoxNote->"0.0013931734500945367"],
               StyleBox[
               "0.0013931734500945367`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0013931734500945367`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-10., 0}, {-9.5, 0.0009951238929246692}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-274.53999999999996`, \
-251.15999999999997`}, {45.561263933836756`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0009951238929246692]& ,
                TagBoxNote->"0.0009951238929246692"],
               StyleBox[
               "0.0009951238929246692`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0009951238929246692, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-9.5, 0}, {-9., 0.0015921982286794705`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-251.65999999999997`, \
-228.27999999999997`}, {45.44802229413881, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0015921982286794705`]& ,
                TagBoxNote->"0.0015921982286794705"],
               StyleBox[
               "0.0015921982286794705`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0015921982286794705`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-9., 0}, {-8.5, 0.001194148671509603}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-228.77999999999997`, \
-205.39999999999998`}, {45.52351672060411, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001194148671509603]& ,
                TagBoxNote->"0.001194148671509603"],
               StyleBox[
               "0.001194148671509603`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001194148671509603, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-8.5, 0}, {-8., 0.0007960991143397353}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-205.89999999999998`, \
-182.51999999999998`}, {45.599011147069405`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0007960991143397353]& ,
                TagBoxNote->"0.0007960991143397353"],
               StyleBox[
               "0.0007960991143397353`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0007960991143397353, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-8., 0}, {-7.5, 0.003184396457358941}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-183.01999999999998`, -159.64}, {
                   45.146044588277604`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.003184396457358941]& ,
                TagBoxNote->"0.003184396457358941"],
               StyleBox[
               "0.003184396457358941`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.003184396457358941, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-7.5, 0}, {-7., 0.003383421235943875}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-160.14, -136.76}, {45.108297375044955`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.003383421235943875]& ,
                TagBoxNote->"0.003383421235943875"],
               StyleBox[
               "0.003383421235943875`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.003383421235943875, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-7., 0}, {-6.5, 0.0027863469001890733`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-137.26, -113.88}, {45.2215390147429, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0027863469001890733`]& ,
                TagBoxNote->"0.0027863469001890733"],
               StyleBox[
               "0.0027863469001890733`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0027863469001890733`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-6.5, 0}, {-6., 0.005373669021793213}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-114.38, -91.}, {44.73082524271845, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.005373669021793213]& ,
                TagBoxNote->"0.005373669021793213"],
               StyleBox[
               "0.005373669021793213`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.005373669021793213, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-6., 0}, {-5.5, 0.005373669021793213}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-91.5, -68.11999999999998}, {
                   44.73082524271845, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.005373669021793213]& ,
                TagBoxNote->"0.005373669021793213"],
               StyleBox[
               "0.005373669021793213`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.005373669021793213, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.5, 0}, {-5., 0.004975619464623346}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-68.61999999999998, -45.23999999999998}, {
                   44.80631966918375, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.004975619464623346]& ,
                TagBoxNote->"0.004975619464623346"],
               StyleBox[
               "0.004975619464623346`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.004975619464623346, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5., 0}, {-4.5, 0.004975619464623346}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-45.73999999999998, \
-22.359999999999985`}, {44.80631966918375, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.004975619464623346]& ,
                TagBoxNote->"0.004975619464623346"],
               StyleBox[
               "0.004975619464623346`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.004975619464623346, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.5, 0}, {-4., 0.009951238929246691}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-22.859999999999985`, 
                   0.5200000000000102}, {43.8626393383675, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.009951238929246691]& ,
                TagBoxNote->"0.009951238929246691"],
               StyleBox[
               "0.009951238929246691`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.009951238929246691, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4., 0}, {-3.5, 0.018907353965568714`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{0.020000000000010232`, 
                   23.400000000000006`}, {42.164014742898246`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.018907353965568714`]& ,
                TagBoxNote->"0.018907353965568714"],
               StyleBox[
               "0.018907353965568714`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.018907353965568714`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.5, 0}, {-3., 0.01452880883670017}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{22.900000000000006`, 46.28}, {
                   42.99445343401655, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.01452880883670017]& ,
                TagBoxNote->"0.01452880883670017"],
               StyleBox[
               "0.01452880883670017`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.01452880883670017, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3., 0}, {-2.5, 0.024679072544531794`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{45.78, 69.16000000000001}, {
                   41.069345559151394`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.024679072544531794`]& ,
                TagBoxNote->"0.024679072544531794"],
               StyleBox[
               "0.024679072544531794`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.024679072544531794`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.5, 0}, {-2., 0.028261518559060603`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{68.66000000000001, 92.04}, {
                   40.38989572096369, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.028261518559060603`]& ,
                TagBoxNote->"0.028261518559060603"],
               StyleBox[
               "0.028261518559060603`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.028261518559060603`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2., 0}, {-1.5, 0.04657179818887452}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{91.54, 114.92}, {36.91715210355988, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.04657179818887452]& ,
                TagBoxNote->"0.04657179818887452"],
               StyleBox[
               "0.04657179818887452`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.04657179818887452, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.5, 0}, {-1., 0.08398845656284207}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{114.42, 137.8}, {29.820676015821654`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.08398845656284207]& ,
                TagBoxNote->"0.08398845656284207"],
               StyleBox[
               "0.08398845656284207`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.08398845656284207, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1., 0}, {-0.5, 0.14289979102398248`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{137.3, 160.68}, {18.64750089895722, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.14289979102398248`]& ,
                TagBoxNote->"0.14289979102398248"],
               StyleBox[
               "0.14289979102398248`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.14289979102398248`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.5, 0}, {0., 0.28619763160513484`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{160.18, 183.56}, {-8.530492628550874, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.28619763160513484`]& ,
                TagBoxNote->"0.28619763160513484"],
               StyleBox[
               "0.28619763160513484`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.28619763160513484`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0., 0}, {0.5, 0.5534879092447009}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{183.06, 206.44}, {-59.22499999999999, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.5534879092447009]& ,
                TagBoxNote->"0.5534879092447009"],
               StyleBox[
               "0.5534879092447009`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.5534879092447009, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.5, 0}, {1., 0.3512787342024082}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{205.94, 229.32}, {-20.873831355627466`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.3512787342024082]& ,
                TagBoxNote->"0.3512787342024082"],
               StyleBox[
               "0.3512787342024082`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.3512787342024082, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1., 0}, {1.5, 0.19385013434172554`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{228.82, 252.2}, {8.984214311398787, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.19385013434172554`]& ,
                TagBoxNote->"0.19385013434172554"],
               StyleBox[
               "0.19385013434172554`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.19385013434172554`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.5, 0}, {2., 0.10190068663548611`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{251.7, 275.08}, {26.423426824883144`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.10190068663548611`]& ,
                TagBoxNote->"0.10190068663548611"],
               StyleBox[
               "0.10190068663548611`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.10190068663548611`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2., 0}, {2.5, 0.04955716986764852}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{274.58, 297.96}, {36.350943905070125`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.04955716986764852]& ,
                TagBoxNote->"0.04955716986764852"],
               StyleBox[
               "0.04955716986764852`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.04955716986764852, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.5, 0}, {3., 0.02348492387302219}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{297.46, 320.84000000000003`}, {
                   41.295828838547294`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.02348492387302219]& ,
                TagBoxNote->"0.02348492387302219"],
               StyleBox[
               "0.02348492387302219`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.02348492387302219, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{3., 0}, {3.5, 0.013334660165190566`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{320.34000000000003`, 343.72}, {
                   43.22093671341245, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.013334660165190566`]& ,
                TagBoxNote->"0.013334660165190566"],
               StyleBox[
               "0.013334660165190566`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.013334660165190566`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{3.5, 0}, {4., 0.005572693800378147}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{343.22, 366.6}, {44.693078029485804`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.005572693800378147]& ,
                TagBoxNote->"0.005572693800378147"],
               StyleBox[
               "0.005572693800378147`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.005572693800378147, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{4., 0}, {4.5, 0.004975619464623346}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{366.1, 389.48}, {44.80631966918375, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.004975619464623346]& ,
                TagBoxNote->"0.004975619464623346"],
               StyleBox[
               "0.004975619464623346`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.004975619464623346, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{4.5, 0}, {5., 0.0027863469001890733`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{388.98, 412.36}, {45.2215390147429, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0027863469001890733`]& ,
                TagBoxNote->"0.0027863469001890733"],
               StyleBox[
               "0.0027863469001890733`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0027863469001890733`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{5., 0}, {5.5, 0.0017912230072644043`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{411.86, 435.24}, {45.41027508090615, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0017912230072644043`]& ,
                TagBoxNote->"0.0017912230072644043"],
               StyleBox[
               "0.0017912230072644043`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0017912230072644043`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{5.5, 0}, {6., 0.0003980495571698676}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{434.74, 458.12}, {45.67450557353471, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0003980495571698676]& ,
                TagBoxNote->"0.0003980495571698676"],
               StyleBox[
               "0.0003980495571698676`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0003980495571698676, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{6., 0}, {6.5, 0.0003980495571698676}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{457.62, 481.}, {45.67450557353471, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0003980495571698676]& ,
                TagBoxNote->"0.0003980495571698676"],
               StyleBox[
               "0.0003980495571698676`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0003980495571698676, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{6.5, 0}, {7., 0.0001990247785849338}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{480.5, 503.88}, {45.71225278676736, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0001990247785849338]& ,
                TagBoxNote->"0.0001990247785849338"],
               StyleBox[
               "0.0001990247785849338`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0001990247785849338, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{7., 0}, {7.5, 0.0003980495571698676}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{503.38, 526.76}, {45.67450557353471, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0003980495571698676]& ,
                TagBoxNote->"0.0003980495571698676"],
               StyleBox[
               "0.0003980495571698676`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0003980495571698676, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{7.5, 0}, {8., 0.0007960991143397353}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{526.26, 549.64}, {45.599011147069405`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0007960991143397353]& ,
                TagBoxNote->"0.0007960991143397353"],
               StyleBox[
               "0.0007960991143397353`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0007960991143397353, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{8.5, 0}, {9., 0.0001990247785849338}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{572.02, 595.4}, {45.71225278676736, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0001990247785849338]& ,
                TagBoxNote->"0.0001990247785849338"],
               StyleBox[
               "0.0001990247785849338`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0001990247785849338, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{14.5, 0}, {15., 0.0003980495571698676}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{846.5799999999999, 869.96}, {
                   45.67450557353471, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0003980495571698676]& ,
                TagBoxNote->"0.0003980495571698676"],
               StyleBox[
               "0.0003980495571698676`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0003980495571698676, {FontFamily -> "Times"}], 
               "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{-3.65, 0},
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"G = 10049\"", FontFamily -> "Latin Modern Math", FontSize -> 
                20, "", StripOnInput -> False], RoundingRadius -> 5, 
               FrameStyle -> None, Background -> RGBColor[0.95, 0.95, 0.95], 
               StripOnInput -> False], TraditionalForm], 
             Scaled[{0.1, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->NCache[{{
              Rational[-7, 2], 4}, {All, All}}, {{-3.5, 4}, {All, All}}],
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]},
        {
         GraphicsBox[{{
            {Opacity[0], 
             PointBox[{{0.11599999999999999`, 0.}, {5.200000000000001, 
              0.}}]}, {{}, {{{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.6, 0.}, {1.6, 0.4478657889148439}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{55.57285601888277, 
                    123.57875688434302`}, {3.3315088129114443`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.4478657889148439]& ,
                    TagBoxNote->"0.4478657889148439"],
                    StyleBox[
                    "0.4478657889148439`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.4478657889148439, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.6, 0.}, {2.6, 0.4315063783646794}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{123.07875688434302`, 
                    191.08465774980328`}, {5.173169455596216, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.4315063783646794]& ,
                    TagBoxNote->"0.4315063783646794"],
                    StyleBox[
                    "0.4315063783646794`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.4315063783646794, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.8000000000000003`, 0.}, {
                    3.8000000000000003`, 0.552134211085156}, "RoundingRadius" -> 
                    0]},
                    
                    ImageSizeCache->{{204.08583792289537`, 
                    272.0917387883556}, {-8.40650881291144, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.552134211085156]& ,
                    TagBoxNote->"0.552134211085156"],
                    StyleBox[
                    "0.552134211085156`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.552134211085156, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6719999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.8000000000000003`, 0.}, {
                    4.800000000000001, 0.5684936216353206}, "RoundingRadius" -> 
                    0]},
                    
                    ImageSizeCache->{{271.5917387883556, 
                    339.5976396538159}, {-10.248169455596212`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.5684936216353206]& ,
                    TagBoxNote->"0.5684936216353206"],
                    StyleBox[
                    "0.5684936216353206`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.5684936216353206, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}}, {}, {}}, {}, {}, {}, {}, {}}, \
{{
             
             StyleBox[{{}, {
                LineBox[{{2.1, 0.2967164486962563}, {2.1, 
                 0.4315063783646794}}], 
                LineBox[{{2.1, 0.4315063783646794}, {2.1, 
                 0.5662963080331025}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{4.300000000000001, 0.43370369196689745`}, {
                 4.300000000000001, 0.5684936216353206}}], 
                LineBox[{{4.300000000000001, 0.5684936216353206}, {
                 4.300000000000001, 0.7032835513037436}}]}},
              Antialiasing->False]}, {
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{2.1, 0.5662963080331025}, 
                   Offset[{3, 0}, {2.1, 0.5662963080331025}]}, {{2.1, 
                   0.5662963080331025}, 
                   Offset[{-3, 0}, {2.1, 0.5662963080331025}]}, {{2.1, 
                   0.2967164486962563}, 
                   Offset[{3, 0}, {2.1, 0.2967164486962563}]}, {{2.1, 
                   0.2967164486962563}, 
                   Offset[{-3, 0}, {2.1, 0.2967164486962563}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{4.300000000000001, 0.7032835513037436}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.7032835513037436}]}, {{4.300000000000001, 
                   0.7032835513037436}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.7032835513037436}]}, {{4.300000000000001, 
                   0.43370369196689745`}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.43370369196689745`}]}, {{4.300000000000001, 
                   0.43370369196689745`}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.43370369196689745`}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False]}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0.11599999999999999`, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          DisplayFunction->Identity,
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"tongue\"", FontFamily -> "Latin Modern Math", FontSize -> 
                24, "", StripOnInput -> False], RoundingRadius -> 5, 
               Background -> GrayLevel[1], StripOnInput -> False], 
              TraditionalForm], 
             Scaled[{0.05, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {None, None}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->{{All, All}, {0, 1}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{None, Automatic}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"], 
     TagBox[GridBox[{
        {
         GraphicsBox[{
           {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.574], 
            Thickness[Small]}], {}, 
            {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.574], 
             Thickness[Small]}], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.6, 0}, {-5.4, 0.0004598546859192495}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-406.0999999999999, -384.15}, {
                   45.71358827610129, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004598546859192495]& ,
                TagBoxNote->"0.0004598546859192495"],
               StyleBox[
               "0.0004598546859192495`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004598546859192495, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.4, 0}, {-5.2, 0.000919709371838499}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-384.65, -362.69999999999993`}, {
                   45.677176552202575`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.000919709371838499]& ,
                TagBoxNote->"0.000919709371838499"],
               StyleBox[
               "0.000919709371838499`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.000919709371838499, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5.2, 0}, {-5., 0.0004598546859192495}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-363.19999999999993`, \
-341.2499999999999}, {45.71358827610129, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004598546859192495]& ,
                TagBoxNote->"0.0004598546859192495"],
               StyleBox[
               "0.0004598546859192495`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004598546859192495, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5., 0}, {-4.8, 0.0004598546859192495}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-341.7499999999999, \
-319.79999999999995`}, {45.71358827610129, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004598546859192495]& ,
                TagBoxNote->"0.0004598546859192495"],
               StyleBox[
               "0.0004598546859192495`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004598546859192495, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.2, 0}, {-4., 0.0013795640577577485`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-255.94999999999993`, \
-233.99999999999994`}, {45.64076482830386, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0013795640577577485`]& ,
                TagBoxNote->"0.0013795640577577485"],
               StyleBox[
               "0.0013795640577577485`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0013795640577577485`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4., 0}, {-3.8, 0.0004598546859192495}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-234.49999999999994`, \
-212.54999999999995`}, {45.71358827610129, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004598546859192495]& ,
                TagBoxNote->"0.0004598546859192495"],
               StyleBox[
               "0.0004598546859192495`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004598546859192495, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.8, 0}, {-3.6, 0.0013795640577577485`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-213.04999999999995`, \
-191.09999999999997`}, {45.64076482830386, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0013795640577577485`]& ,
                TagBoxNote->"0.0013795640577577485"],
               StyleBox[
               "0.0013795640577577485`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0013795640577577485`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.6, 0}, {-3.4, 0.001839418743676998}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-191.59999999999997`, \
-169.64999999999992`}, {45.60435310440514, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001839418743676998]& ,
                TagBoxNote->"0.001839418743676998"],
               StyleBox[
               "0.001839418743676998`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001839418743676998, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.4, 0}, {-3.2, 0.001839418743676998}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-170.14999999999992`, -148.2}, {
                   45.60435310440514, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001839418743676998]& ,
                TagBoxNote->"0.001839418743676998"],
               StyleBox[
               "0.001839418743676998`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001839418743676998, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.2, 0}, {-3., 0.002759128115515497}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-148.7, -126.74999999999994`}, {
                   45.53152965660771, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.002759128115515497]& ,
                TagBoxNote->"0.002759128115515497"],
               StyleBox[
               "0.002759128115515497`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.002759128115515497, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3., 0}, {-2.8, 0.0022992734295962476`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-127.24999999999994`, \
-105.29999999999995`}, {45.567941380506426`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0022992734295962476`]& ,
                TagBoxNote->"0.0022992734295962476"],
               StyleBox[
               "0.0022992734295962476`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0022992734295962476`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.8, 0}, {-2.6, 0.0050584015451117445`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-105.79999999999995`, \
-83.84999999999997}, {45.34947103711412, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0050584015451117445`]& ,
                TagBoxNote->"0.0050584015451117445"],
               StyleBox[
               "0.0050584015451117445`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0050584015451117445`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.6, 0}, {-2.4, 0.006897820288788743}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-84.34999999999997, -62.39999999999998}, {
                   45.203824141519256`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.006897820288788743]& ,
                TagBoxNote->"0.006897820288788743"],
               StyleBox[
               "0.006897820288788743`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.006897820288788743, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.4, 0}, {-2.2, 0.008737239032465741}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-62.89999999999998, -40.94999999999999}, {
                   45.05817724592439, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.008737239032465741]& ,
                TagBoxNote->"0.008737239032465741"],
               StyleBox[
               "0.008737239032465741`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.008737239032465741, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.2, 0}, {-2., 0.015175204635335234`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-41.44999999999999, -19.49999999999997}, {
                   44.548413111342356`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.015175204635335234`]& ,
                TagBoxNote->"0.015175204635335234"],
               StyleBox[
               "0.015175204635335234`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.015175204635335234`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2., 0}, {-1.8, 0.017474478064931482`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-19.99999999999997, 1.950000000000017}, {
                   44.366354491848774`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.017474478064931482`]& ,
                TagBoxNote->"0.017474478064931482"],
               StyleBox[
               "0.017474478064931482`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.017474478064931482`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.8, 0}, {-1.6, 0.02069346086636623}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{1.450000000000017, 23.400000000000006`}, {
                   44.11147242455776, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.02069346086636623]& ,
                TagBoxNote->"0.02069346086636623"],
               StyleBox[
               "0.02069346086636623`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.02069346086636623, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.6, 0}, {-1.4, 0.03770808424537846}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{22.900000000000006`, 44.85000000000002}, {
                   42.764238640305244`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.03770808424537846]& ,
                TagBoxNote->"0.03770808424537846"],
               StyleBox[
               "0.03770808424537846`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.03770808424537846, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.4, 0}, {-1.2, 0.0528832888807137}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{44.35000000000002, 66.30000000000001}, {
                   41.56265175164759, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0528832888807137]& ,
                TagBoxNote->"0.0528832888807137"],
               StyleBox[
               "0.0528832888807137`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.0528832888807137, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.2, 0}, {-1., 0.08001471534994942}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{65.80000000000001, 87.75000000000001}, {
                   39.41436004162332, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.08001471534994942]& ,
                TagBoxNote->"0.08001471534994942"],
               StyleBox[
               "0.08001471534994942`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.08001471534994942, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1., 0}, {-0.8, 0.11312425273613538`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{87.25000000000001, 109.2}, {
                   36.79271592091572, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.11312425273613538`]& ,
                TagBoxNote->"0.11312425273613538"],
               StyleBox[
               "0.11312425273613538`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.11312425273613538`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.8, 0}, {-0.6, 0.18532143842545756`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{108.7, 130.65}, {31.07607526881721, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.18532143842545756`]& ,
                TagBoxNote->"0.18532143842545756"],
               StyleBox[
               "0.18532143842545756`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.18532143842545756`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.6, 0}, {-0.4, 0.2644164444035685}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{130.15, 152.1}, {24.813258758237954`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.2644164444035685]& ,
                TagBoxNote->"0.2644164444035685"],
               StyleBox[
               "0.2644164444035685`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.2644164444035685, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.4, 0}, {-0.2, 0.4170882001287593}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{151.6, 173.55}, {12.72456642386404, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.4170882001287593]& ,
                TagBoxNote->"0.4170882001287593"],
               StyleBox[
               "0.4170882001287593`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.4170882001287593, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.2, 0}, {0., 0.7192127287777063}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{173.05, 195.}, {-11.19793617759278, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.7192127287777063]& ,
                TagBoxNote->"0.7192127287777063"],
               StyleBox[
               "0.7192127287777063`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.7192127287777063, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0., 0}, {0.2, 1.3257610595051963`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{194.5, 216.45}, {-59.22499999999999, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 1.3257610595051963`]& ,
                TagBoxNote->"1.3257610595051963"],
               StyleBox[
               "1.3257610595051963`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[1.3257610595051963`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.2, 0}, {0.4, 1.0222569667984918`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{215.95, 237.9}, {-35.19326222684703, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 1.0222569667984918`]& ,
                TagBoxNote->"1.0222569667984918"],
               StyleBox[
               "1.0222569667984918`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[1.0222569667984918`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.4, 0}, {0.6, 0.44559919065575276`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{237.4, 259.35}, {10.46703954214361, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.44559919065575276`]& ,
                TagBoxNote->"0.44559919065575276"],
               StyleBox[
               "0.44559919065575276`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.44559919065575276`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.6, 0}, {0.8, 0.16738710567460682`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{258.85, 280.8}, {32.49613250086716, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.16738710567460682`]& ,
                TagBoxNote->"0.16738710567460682"],
               StyleBox[
               "0.16738710567460682`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.16738710567460682`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.8, 0}, {1., 0.05426285293847144}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{280.3, 302.25}, {41.453416579951444`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.05426285293847144]& ,
                TagBoxNote->"0.05426285293847144"],
               StyleBox[
               "0.05426285293847144`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.05426285293847144, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1., 0}, {1.2, 0.014255495263496735`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{301.75, 323.7}, {44.621236559139795`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.014255495263496735`]& ,
                TagBoxNote->"0.014255495263496735"],
               StyleBox[
               "0.014255495263496735`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.014255495263496735`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.2, 0}, {1.4, 0.007357674974707992}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{323.2, 345.15}, {45.16741241762054, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.007357674974707992]& ,
                TagBoxNote->"0.007357674974707992"],
               StyleBox[
               "0.007357674974707992`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.007357674974707992, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.4, 0}, {1.6, 0.0032189828014347467`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{344.65, 366.6}, {45.49511793270899, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0032189828014347467`]& ,
                TagBoxNote->"0.0032189828014347467"],
               StyleBox[
               "0.0032189828014347467`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0032189828014347467`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.6, 0}, {1.8, 0.0004598546859192495}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{366.1, 388.04999999999995`}, {
                   45.71358827610129, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004598546859192495]& ,
                TagBoxNote->"0.0004598546859192495"],
               StyleBox[
               "0.0004598546859192495`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004598546859192495, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.8, 0}, {3., 0.0004598546859192495}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{494.79999999999995`, 516.75}, {
                   45.71358827610129, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004598546859192495]& ,
                TagBoxNote->"0.0004598546859192495"],
               StyleBox[
               "0.0004598546859192495`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004598546859192495, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{3.4, 0}, {3.6, 0.0004598546859192495}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{559.1499999999999, 581.0999999999999}, {
                   45.71358827610129, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004598546859192495]& ,
                TagBoxNote->"0.0004598546859192495"],
               StyleBox[
               "0.0004598546859192495`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004598546859192495, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{3.6, 0}, {3.8, 0.0004598546859192495}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{580.5999999999999, 602.55}, {
                   45.71358827610129, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004598546859192495]& ,
                TagBoxNote->"0.0004598546859192495"],
               StyleBox[
               "0.0004598546859192495`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004598546859192495, {FontFamily -> "Times"}], 
               "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{-1.6640000000000001`, 0},
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"G = 10873\"", FontFamily -> "Latin Modern Math", FontSize -> 
                20, "", StripOnInput -> False], RoundingRadius -> 5, 
               FrameStyle -> None, Background -> RGBColor[0.95, 0.95, 0.95], 
               StripOnInput -> False], TraditionalForm], 
             Scaled[{0.1, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->NCache[{{
              Rational[-8, 5], 
              Rational[8, 5]}, {All, All}}, {{-1.6, 1.6}, {All, All}}],
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]},
        {
         GraphicsBox[{{
            {Opacity[0], 
             PointBox[{{0.38399999999999995`, 0.}, {11.4, 
              0.}}]}, {{}, {{{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.63], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{0.6, 0.}, {1.6, 0.10579956321281242`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{29.629411764705882`, 
                    61.28409586056645}, {41.83961417131764, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.10579956321281242`]& ,
                    TagBoxNote->"0.10579956321281242"],
                    StyleBox[
                    "0.10579956321281242`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.10579956321281242`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.63], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.6, 0.}, {2.6, 0.24120228469371224`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{60.78409586056645, 92.43877995642701}, {
                    26.596652800605348`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.24120228469371224`]& ,
                    TagBoxNote->"0.24120228469371224"],
                    StyleBox[
                    "0.24120228469371224`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.24120228469371224`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.63], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.8000000000000003`, 0.}, {
                    3.8000000000000003`, 0.37005581169619023`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{98.16971677559913, 129.8244008714597}, {
                    12.09096699830139, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.37005581169619023`]& ,
                    TagBoxNote->"0.37005581169619023"],
                    StyleBox[
                    "0.37005581169619023`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.37005581169619023`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.63], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.8000000000000003`, 0.}, {
                    4.800000000000001, 0.43311093769689557`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{129.3244008714597, 
                    160.97908496732026`}, {4.992536188771986, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.43311093769689557`]& ,
                    TagBoxNote->"0.43311093769689557"],
                    StyleBox[
                    "0.43311093769689557`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.43311093769689557`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.63], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{5.000000000000001, 0.}, {6.000000000000001, 
                    0.09172530939092453}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{166.71002178649238`, 
                    198.36470588235295`}, {43.42402329531667, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.09172530939092453]& ,
                    TagBoxNote->"0.09172530939092453"],
                    StyleBox[
                    "0.09172530939092453`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.09172530939092453, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.63], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{6.000000000000001, 0.}, {7.000000000000001, 
                    0.1733598602460508}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{197.86470588235295`, 
                    229.5193899782135}, {34.23401373280083, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.1733598602460508]& ,
                    TagBoxNote->"0.1733598602460508"],
                    StyleBox[
                    "0.1733598602460508`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.1733598602460508, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.63], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{7.200000000000001, 0.}, {8.200000000000001, 
                    0.3542829410337297}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{235.2503267973856, 266.9050108932462}, {
                    13.866597913127883`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.3542829410337297]& ,
                    TagBoxNote->"0.3542829410337297"],
                    StyleBox[
                    "0.3542829410337297`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.3542829410337297, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.63], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{8.200000000000001, 0.}, {9.200000000000001, 
                    0.04700148649946287}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{266.4050108932462, 298.0596949891068}, {
                    48.458807657322964`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.04700148649946287]& ,
                    TagBoxNote->"0.04700148649946287"],
                    StyleBox[
                    "0.04700148649946287`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.04700148649946287, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.63], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{9.4, 0.}, {10.4, 0.07813637466634311}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{303.7906318082789, 335.4453159041394}, {
                    44.953797621936424`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.07813637466634311]& ,
                    TagBoxNote->"0.07813637466634311"],
                    StyleBox[
                    "0.07813637466634311`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.07813637466634311, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.63], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{10.4, 0.}, {11.4, 0.1053254308638784}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{334.9453159041394, 366.6}, {
                    41.892989620498895`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.1053254308638784]& ,
                    TagBoxNote->"0.1053254308638784"],
                    StyleBox[
                    "0.1053254308638784`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.1053254308638784, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}}, {}, {}}, {}, {}, {}, {}, {}}, \
{{
             
             StyleBox[{{}, {
                LineBox[{{2.1, 0.13854834192054258`}, {2.1, 
                 0.24120228469371224`}}], 
                LineBox[{{2.1, 0.24120228469371224`}, {2.1, 
                 0.34385622746688194`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{4.300000000000001, 0.30916901741430464`}, {
                 4.300000000000001, 0.43311093769689557`}}], 
                LineBox[{{4.300000000000001, 0.43311093769689557`}, {
                 4.300000000000001, 0.5570528579794866}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{6.500000000000001, 0.09215894204854967}, {
                 6.500000000000001, 0.1733598602460508}}], 
                LineBox[{{6.500000000000001, 0.1733598602460508}, {
                 6.500000000000001, 0.2545607784435519}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{8.700000000000001, 0.005390709876255749}, {
                 8.700000000000001, 0.04700148649946287}}], 
                LineBox[{{8.700000000000001, 0.04700148649946287}, {
                 8.700000000000001, 0.08861226312266998}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{10.9, 0.007225470883035878}, {10.9, 
                 0.1053254308638784}}], 
                LineBox[{{10.9, 0.1053254308638784}, {10.9, 
                 0.20342539084472092`}}]}},
              Antialiasing->False]}, {
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{2.1, 0.34385622746688194`}, 
                   Offset[{3, 0}, {2.1, 0.34385622746688194`}]}, {{2.1, 
                   0.34385622746688194`}, 
                   Offset[{-3, 0}, {2.1, 0.34385622746688194`}]}, {{2.1, 
                   0.13854834192054258`}, 
                   Offset[{3, 0}, {2.1, 0.13854834192054258`}]}, {{2.1, 
                   0.13854834192054258`}, 
                   Offset[{-3, 0}, {2.1, 0.13854834192054258`}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{4.300000000000001, 0.5570528579794866}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.5570528579794866}]}, {{4.300000000000001, 
                   0.5570528579794866}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.5570528579794866}]}, {{4.300000000000001, 
                   0.30916901741430464`}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.30916901741430464`}]}, {{4.300000000000001, 
                   0.30916901741430464`}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.30916901741430464`}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{6.500000000000001, 0.2545607784435519}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.2545607784435519}]}, {{6.500000000000001, 
                   0.2545607784435519}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.2545607784435519}]}, {{6.500000000000001, 
                   0.09215894204854967}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.09215894204854967}]}, {{6.500000000000001, 
                   0.09215894204854967}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.09215894204854967}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{8.700000000000001, 0.08861226312266998}, 
                   Offset[{3, 0}, {8.700000000000001, 
                    0.08861226312266998}]}, {{8.700000000000001, 
                   0.08861226312266998}, 
                   Offset[{-3, 0}, {8.700000000000001, 
                    0.08861226312266998}]}, {{8.700000000000001, 
                   0.005390709876255749}, 
                   Offset[{3, 0}, {8.700000000000001, 
                    0.005390709876255749}]}, {{8.700000000000001, 
                   0.005390709876255749}, 
                   Offset[{-3, 0}, {8.700000000000001, 
                    0.005390709876255749}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{10.9, 0.20342539084472092`}, 
                   Offset[{3, 0}, {10.9, 0.20342539084472092`}]}, {{10.9, 
                   0.20342539084472092`}, 
                   Offset[{-3, 0}, {10.9, 0.20342539084472092`}]}, {{10.9, 
                   0.007225470883035878}, 
                   Offset[{3, 0}, {10.9, 0.007225470883035878}]}, {{10.9, 
                   0.007225470883035878}, 
                   Offset[{-3, 0}, {10.9, 0.007225470883035878}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False]}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0.38399999999999995`, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          DisplayFunction->Identity,
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"trachea\"", FontFamily -> "Latin Modern Math", FontSize -> 
                24, "", StripOnInput -> False], RoundingRadius -> 5, 
               Background -> GrayLevel[1], StripOnInput -> False], 
              TraditionalForm], 
             Scaled[{0.05, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {None, None}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->{{All, All}, {0, 1}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{None, Automatic}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"], 
     TagBox[GridBox[{
        {
         GraphicsBox[{
           {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.518], 
            Thickness[Small]}], {}, 
            {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.518], 
             Thickness[Small]}], 
             RectangleBox[{-1., 0}, {-0.95, 0.006129328838492185},
              RoundingRadius->0], 
             RectangleBox[{-0.95, 0}, {-0.9, 0.006129328838492185},
              RoundingRadius->0], 
             RectangleBox[{-0.85, 0}, {-0.8, 0.02451731535396874},
              RoundingRadius->0], 
             RectangleBox[{-0.8, 0}, {-0.75, 0.01225865767698437},
              RoundingRadius->0], 
             RectangleBox[{-0.75, 0}, {-0.7, 0.02451731535396874},
              RoundingRadius->0], 
             RectangleBox[{-0.7, 0}, {-0.65, 0.030646644192460926},
              RoundingRadius->0], 
             RectangleBox[{-0.65, 0}, {-0.6, 0.030646644192460926},
              RoundingRadius->0], 
             RectangleBox[{-0.6, 0}, {-0.55, 0.07355194606190622},
              RoundingRadius->0], 
             RectangleBox[{-0.55, 0}, {-0.5, 0.0796812749003984},
              RoundingRadius->0], 
             RectangleBox[{-0.5, 0}, {-0.45, 0.06742261722341404},
              RoundingRadius->0], 
             RectangleBox[{-0.45, 0}, {-0.4, 0.165491878639289},
              RoundingRadius->0], 
             RectangleBox[{-0.4, 0}, {-0.35, 0.15323322096230463},
              RoundingRadius->0], 
             RectangleBox[{-0.35, 0}, {-0.3, 0.23904382470119523},
              RoundingRadius->0], 
             RectangleBox[{-0.3, 0}, {-0.25, 0.32485442844008583},
              RoundingRadius->0], 
             RectangleBox[{-0.25, 0}, {-0.2, 0.496475635917867},
              RoundingRadius->0], 
             RectangleBox[{-0.2, 0}, {-0.15, 0.796812749003984},
              RoundingRadius->0], 
             RectangleBox[{-0.15, 0}, {-0.1, 1.091020533251609},
              RoundingRadius->0], 
             RectangleBox[{-0.1, 0}, {-0.05, 1.4832975789151088},
              RoundingRadius->0], 
             RectangleBox[{-0.05, 0}, {0., 2.1697824088262334},
              RoundingRadius->0], 
             RectangleBox[{0., 0}, {0.05, 2.678516702421085},
              RoundingRadius->0], 
             RectangleBox[{0.05, 0}, {0.1, 3.0278884462151394},
              RoundingRadius->0], 
             RectangleBox[{0.1, 0}, {0.15, 2.3720502604964757},
              RoundingRadius->0], 
             RectangleBox[{0.15, 0}, {0.2, 1.752988047808765},
              RoundingRadius->0], 
             RectangleBox[{0.2, 0}, {0.25, 1.1277965062825621},
              RoundingRadius->0], 
             RectangleBox[{0.25, 0}, {0.3, 0.661967514557156},
              RoundingRadius->0], 
             RectangleBox[{0.3, 0}, {0.35, 0.42905301869445295},
              RoundingRadius->0], 
             RectangleBox[{0.35, 0}, {0.4, 0.2880784554091327},
              RoundingRadius->0], 
             RectangleBox[{0.4, 0}, {0.45, 0.1287159056083359},
              RoundingRadius->0], 
             RectangleBox[{0.45, 0}, {0.5, 0.04903463070793748},
              RoundingRadius->0], 
             RectangleBox[{0.5, 0}, {0.55, 0.07355194606190622},
              RoundingRadius->0], 
             RectangleBox[{0.55, 0}, {0.6, 0.030646644192460926},
              RoundingRadius->0], 
             RectangleBox[{0.6, 0}, {0.65, 0.018387986515476556},
              RoundingRadius->0], 
             RectangleBox[{0.65, 0}, {0.7, 0.01225865767698437},
              RoundingRadius->0], 
             RectangleBox[{0.7, 0}, {0.75, 0.018387986515476556},
              RoundingRadius->0], 
             RectangleBox[{0.75, 0}, {0.8, 0.006129328838492185},
              RoundingRadius->0], 
             RectangleBox[{0.8, 0}, {0.85, 0.01225865767698437},
              RoundingRadius->0], 
             RectangleBox[{0.85, 0}, {0.9, 0.006129328838492185},
              RoundingRadius->0], 
             RectangleBox[{0.95, 0}, {1., 0.006129328838492185},
              RoundingRadius->0], 
             RectangleBox[{1.05, 0}, {1.1, 0.006129328838492185},
              RoundingRadius->0], 
             RectangleBox[{1.1, 0}, {1.15, 0.006129328838492185},
              RoundingRadius->0], 
             RectangleBox[{1.2, 0}, {1.25, 0.006129328838492185},
              RoundingRadius->0], 
             RectangleBox[{1.25, 0}, {1.3, 0.006129328838492185},
              
              RoundingRadius->
               0]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{-0.5740000000000001, 0},
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"G = 3263\"", FontFamily -> "Latin Modern Math", FontSize -> 
                20, "", StripOnInput -> False], RoundingRadius -> 5, 
               FrameStyle -> None, Background -> RGBColor[0.95, 0.95, 0.95], 
               StripOnInput -> False], TraditionalForm], 
             Scaled[{0.1, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->NCache[{{
              Rational[-11, 20], 
              Rational[13, 20]}, {All, All}}, {{-0.55, 0.65}, {All, All}}],
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]},
        {
         GraphicsBox[{{
            {Opacity[0], 
             PointBox[{{0.472, 0.}, {7.000000000000001, 
              0.}}]}, {{}, {{{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.6, 0.}, {1.6, 0.6616038882138517}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{29.629411764705882`, 
                    82.7029411764706}, {-20.730057715674363`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.6616038882138517]& ,
                    TagBoxNote->"0.6616038882138517"],
                    StyleBox[
                    "0.6616038882138517`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.6616038882138517, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.6, 0.}, {2.6, 0.5475751586672835}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{82.2029411764706, 
                    135.2764705882353}, {-7.893273486969434, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.5475751586672835]& ,
                    TagBoxNote->"0.5475751586672835"],
                    StyleBox[
                    "0.5475751586672835`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.5475751586672835, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.8000000000000003`, 0.}, {
                    3.8000000000000003`, 0.13426488456865127`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{145.29117647058825`, 
                    198.36470588235295`}, {38.635130619684084`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.13426488456865127`]& ,
                    TagBoxNote->"0.13426488456865127"],
                    StyleBox[
                    "0.13426488456865127`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.13426488456865127`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.8000000000000003`, 0.}, {
                    4.800000000000001, 0.22574777943033475`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{197.86470588235295`, 
                    250.93823529411767`}, {28.336443730630066`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.22574777943033475`]& ,
                    TagBoxNote->"0.22574777943033475"],
                    StyleBox[
                    "0.22574777943033475`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.22574777943033475`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{5.000000000000001, 0.}, {6.000000000000001, 
                    0.20413122721749696`}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{260.9529411764706, 314.0264705882353}, {
                    30.76992709599028, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.20413122721749696`]& ,
                    TagBoxNote->"0.20413122721749696"],
                    StyleBox[
                    "0.20413122721749696`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.20413122721749696`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.6579999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{6.000000000000001, 0.}, {7.000000000000001, 
                    0.22667706190238177`}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{313.5264705882353, 366.6}, {
                    28.231829756339373`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.22667706190238177`]& ,
                    TagBoxNote->"0.22667706190238177"],
                    StyleBox[
                    "0.22667706190238177`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.22667706190238177`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}}, {}, {}}, {}, {}, {}, {}, {}}, \
{{
             
             StyleBox[{{}, {
                LineBox[{{2.1, 0.13029829418189354`}, {2.1, 
                 0.5475751586672835}}], 
                LineBox[{{2.1, 0.5475751586672835}, {2.1, 
                 0.9648520231526734}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{4.300000000000001, 0.}, {4.300000000000001, 
                 0.22574777943033475`}}], 
                LineBox[{{4.300000000000001, 0.22574777943033475`}, {
                 4.300000000000001, 0.6315153210737173}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{6.500000000000001, 0.}, {6.500000000000001, 
                 0.22667706190238177`}}], 
                LineBox[{{6.500000000000001, 0.22667706190238177`}, {
                 6.500000000000001, 0.7235146566469565}}]}},
              Antialiasing->False]}, {
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{2.1, 0.9648520231526734}, 
                   Offset[{3, 0}, {2.1, 0.9648520231526734}]}, {{2.1, 
                   0.9648520231526734}, 
                   Offset[{-3, 0}, {2.1, 0.9648520231526734}]}, {{2.1, 
                   0.13029829418189354`}, 
                   Offset[{3, 0}, {2.1, 0.13029829418189354`}]}, {{2.1, 
                   0.13029829418189354`}, 
                   Offset[{-3, 0}, {2.1, 0.13029829418189354`}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{4.300000000000001, 0.6315153210737173}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.6315153210737173}]}, {{4.300000000000001, 
                   0.6315153210737173}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.6315153210737173}]}, {{4.300000000000001, 0.}, 
                   Offset[{3, 0}, {4.300000000000001, 0.}]}, {{
                   4.300000000000001, 0.}, 
                   Offset[{-3, 0}, {4.300000000000001, 0.}]}}], {{{1., 0.}, {
                 0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{6.500000000000001, 0.7235146566469565}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.7235146566469565}]}, {{6.500000000000001, 
                   0.7235146566469565}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.7235146566469565}]}, {{6.500000000000001, 0.}, 
                   Offset[{3, 0}, {6.500000000000001, 0.}]}, {{
                   6.500000000000001, 0.}, 
                   Offset[{-3, 0}, {6.500000000000001, 0.}]}}], {{{1., 0.}, {
                 0., 1.}}, {0., 0.}}]},
              Antialiasing->False]}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0.472, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          DisplayFunction->Identity,
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"largeintestine\"", FontFamily -> "Latin Modern Math", 
                FontSize -> 24, "", StripOnInput -> False], RoundingRadius -> 
               5, Background -> GrayLevel[1], StripOnInput -> False], 
              TraditionalForm], 
             Scaled[{0.05, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {None, None}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->{{All, All}, {0, 1}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{None, Automatic}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"]},
    {
     TagBox[GridBox[{
        {
         GraphicsBox[{
           {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.518], 
            Thickness[Small]}], {}, 
            {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.518], 
             Thickness[Small]}], 
             RectangleBox[{-9.2, 0}, {-9., 0.0008729050279329608},
              RoundingRadius->0], 
             RectangleBox[{-8.2, 0}, {-8., 0.0004364525139664804},
              RoundingRadius->0], 
             RectangleBox[{-8., 0}, {-7.8, 0.0004364525139664804},
              RoundingRadius->0], 
             RectangleBox[{-7.4, 0}, {-7.2, 0.0008729050279329608},
              RoundingRadius->0], 
             RectangleBox[{-7.2, 0}, {-7., 0.0004364525139664804},
              RoundingRadius->0], 
             RectangleBox[{-7., 0}, {-6.8, 0.0017458100558659217},
              RoundingRadius->0], 
             RectangleBox[{-6.8, 0}, {-6.6, 0.0013093575418994413},
              RoundingRadius->0], 
             RectangleBox[{-6.4, 0}, {-6.2, 0.0008729050279329608},
              RoundingRadius->0], 
             RectangleBox[{-6., 0}, {-5.8, 0.0004364525139664804},
              RoundingRadius->0], 
             RectangleBox[{-5.8, 0}, {-5.6, 0.0008729050279329608},
              RoundingRadius->0], 
             RectangleBox[{-5.6, 0}, {-5.4, 0.0013093575418994413},
              RoundingRadius->0], 
             RectangleBox[{-5.4, 0}, {-5.2, 0.0008729050279329608},
              RoundingRadius->0], 
             RectangleBox[{-5.2, 0}, {-5., 0.0008729050279329608},
              RoundingRadius->0], 
             RectangleBox[{-5., 0}, {-4.8, 0.002182262569832402},
              RoundingRadius->0], 
             RectangleBox[{-4.8, 0}, {-4.6, 0.003928072625698324},
              RoundingRadius->0], 
             RectangleBox[{-4.6, 0}, {-4.4, 0.003928072625698324},
              RoundingRadius->0], 
             RectangleBox[{-4.4, 0}, {-4.2, 0.003928072625698324},
              RoundingRadius->0], 
             RectangleBox[{-4.2, 0}, {-4., 0.0034916201117318434},
              RoundingRadius->0], 
             RectangleBox[{-4., 0}, {-3.8, 0.00916550279329609},
              RoundingRadius->0], 
             RectangleBox[{-3.8, 0}, {-3.6, 0.005673882681564246},
              RoundingRadius->0], 
             RectangleBox[{-3.6, 0}, {-3.4, 0.007856145251396648},
              RoundingRadius->0], 
             RectangleBox[{-3.4, 0}, {-3.2, 0.00916550279329609},
              RoundingRadius->0], 
             RectangleBox[{-3.2, 0}, {-3., 0.011347765363128492},
              RoundingRadius->0], 
             RectangleBox[{-3., 0}, {-2.8, 0.00916550279329609},
              RoundingRadius->0], 
             RectangleBox[{-2.8, 0}, {-2.6, 0.017894553072625698},
              RoundingRadius->0], 
             RectangleBox[{-2.6, 0}, {-2.4, 0.02051326815642458},
              RoundingRadius->0], 
             RectangleBox[{-2.4, 0}, {-2.2, 0.022695530726256984},
              RoundingRadius->0], 
             RectangleBox[{-2.2, 0}, {-2., 0.03186103351955307},
              RoundingRadius->0], 
             RectangleBox[{-2., 0}, {-1.8, 0.04539106145251397},
              RoundingRadius->0], 
             RectangleBox[{-1.8, 0}, {-1.6, 0.044518156424581005},
              RoundingRadius->0], 
             RectangleBox[{-1.6, 0}, {-1.4, 0.06983240223463687},
              RoundingRadius->0], 
             RectangleBox[{-1.4, 0}, {-1.2, 0.07987081005586592},
              RoundingRadius->0], 
             RectangleBox[{-1.2, 0}, {-1., 0.10562150837988826},
              RoundingRadius->0], 
             RectangleBox[{-1., 0}, {-0.8, 0.14577513966480446},
              RoundingRadius->0], 
             RectangleBox[{-0.8, 0}, {-0.6, 0.1959671787709497},
              RoundingRadius->0], 
             RectangleBox[{-0.6, 0}, {-0.4, 0.24572276536312848},
              RoundingRadius->0], 
             RectangleBox[{-0.4, 0}, {-0.2, 0.3618191340782123},
              RoundingRadius->0], 
             RectangleBox[{-0.2, 0}, {0., 0.5224336592178771},
              RoundingRadius->0], 
             RectangleBox[{0., 0}, {0.2, 0.7825593575418994},
              RoundingRadius->0], 
             RectangleBox[{0.2, 0}, {0.4, 0.8676675977653632},
              RoundingRadius->0], 
             RectangleBox[{0.4, 0}, {0.6, 0.5935754189944135},
              RoundingRadius->0], 
             RectangleBox[{0.6, 0}, {0.8, 0.34436103351955305},
              RoundingRadius->0], 
             RectangleBox[{0.8, 0}, {1., 0.19378491620111732},
              RoundingRadius->0], 
             RectangleBox[{1., 0}, {1.2, 0.09994762569832402},
              RoundingRadius->0], 
             RectangleBox[{1.2, 0}, {1.4, 0.05630237430167598},
              RoundingRadius->0], 
             RectangleBox[{1.4, 0}, {1.6, 0.031424581005586594},
              RoundingRadius->0], 
             RectangleBox[{1.6, 0}, {1.8, 0.016148743016759778},
              RoundingRadius->0], 
             RectangleBox[{1.8, 0}, {2., 0.008729050279329608},
              RoundingRadius->0], 
             RectangleBox[{2., 0}, {2.2, 0.006546787709497207},
              RoundingRadius->0], 
             RectangleBox[{2.2, 0}, {2.4, 0.004800977653631285},
              RoundingRadius->0], 
             RectangleBox[{2.4, 0}, {2.6, 0.0004364525139664804},
              RoundingRadius->0], 
             RectangleBox[{2.8, 0}, {3., 0.0008729050279329608},
              RoundingRadius->0], 
             RectangleBox[{3.6, 0}, {3.8, 0.0004364525139664804},
              RoundingRadius->0], 
             RectangleBox[{4.2, 0}, {4.4, 0.0004364525139664804},
              RoundingRadius->0], 
             RectangleBox[{4.6, 0}, {4.8, 0.0004364525139664804},
              RoundingRadius->0], 
             RectangleBox[{5.4, 0}, {5.6, 0.0004364525139664804},
              RoundingRadius->
               0]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{-2.496, 0},
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"G = 11456\"", FontFamily -> "Latin Modern Math", FontSize -> 
                20, "", StripOnInput -> False], RoundingRadius -> 5, 
               FrameStyle -> None, Background -> RGBColor[0.95, 0.95, 0.95], 
               StripOnInput -> False], TraditionalForm], 
             Scaled[{0.1, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->NCache[{{
              Rational[-12, 5], 
              Rational[12, 5]}, {All, All}}, {{-2.4, 2.4}, {All, All}}],
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]},
        {
         GraphicsBox[{{
            {Opacity[0], 
             PointBox[{{0.33999999999999997`, 0.}, {13.6, 
              0.}}]}, {{}, {{{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.616], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.6, 0.}, {1.6, 0.03903229829155755}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{29.629411764705885`, 
                    56.011764705882364`}, {49.3559390198279, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.03903229829155755]& ,
                    TagBoxNote->"0.03903229829155755"],
                    StyleBox[
                    "0.03903229829155755`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.03903229829155755, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.616], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.6, 0.}, {2.6, 0.05910424180739195}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{55.511764705882364`, 
                    81.89411764705885}, {47.096339978532846`, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.05910424180739195]& ,
                    TagBoxNote->"0.05910424180739195"],
                    StyleBox[
                    "0.05910424180739195`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.05910424180739195, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.616], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.8000000000000003`, 0.}, {
                    3.8000000000000003`, 0.04298125285779607}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{86.57058823529414, 
                    112.95294117647062`}, {48.9113854595336, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.04298125285779607]& ,
                    TagBoxNote->"0.04298125285779607"],
                    StyleBox[
                    "0.04298125285779607`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.04298125285779607, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.616], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.8000000000000003`, 0.}, {
                    4.800000000000001, 0.05888595682798714}, "RoundingRadius" -> 
                    0]},
                    
                    ImageSizeCache->{{112.45294117647062`, 
                    138.8352941176471}, {47.120913410089344`, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.05888595682798714]& ,
                    TagBoxNote->"0.05888595682798714"],
                    StyleBox[
                    "0.05888595682798714`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.05888595682798714, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.616], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{5.000000000000001, 0.}, {6.000000000000001, 
                    0.24757866733175374`}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{143.5117647058824, 
                    169.89411764705886`}, {25.878831525127815`, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.24757866733175374`]& ,
                    TagBoxNote->"0.24757866733175374"],
                    StyleBox[
                    "0.24757866733175374`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.24757866733175374`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.616], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{6.000000000000001, 0.}, {7.000000000000001, 
                    0.22435094084257876`}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{169.39411764705886`, 
                    195.77647058823533`}, {28.493692834646687`, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.22435094084257876`]& ,
                    TagBoxNote->"0.22435094084257876"],
                    StyleBox[
                    "0.22435094084257876`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.22435094084257876`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.616], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{7.200000000000001, 0.}, {8.200000000000001, 
                    0.09402668661927921}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{200.45294117647063`, 
                    226.83529411764712`}, {43.16494575383464, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.09402668661927921]& ,
                    TagBoxNote->"0.09402668661927921"],
                    StyleBox[
                    "0.09402668661927921`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.09402668661927921, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.616], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{8.200000000000001, 0.}, {9.200000000000001, 
                    0.09770363818082616}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{226.33529411764712`, 
                    252.7176470588236}, {42.75101293179349, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.09770363818082616]& ,
                    TagBoxNote->"0.09770363818082616"],
                    StyleBox[
                    "0.09770363818082616`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.09770363818082616, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.616], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{9.4, 0.}, {10.4, 0.5051752088789125}, 
                    "RoundingRadius" -> 0]},
                    ImageSizeCache->{{257.39411764705886`, 
                    283.7764705882354}, {-3.1200991395435906`, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.5051752088789125]& ,
                    TagBoxNote->"0.5051752088789125"],
                    StyleBox[
                    "0.5051752088789125`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.5051752088789125, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.616], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{10.4, 0.}, {11.4, 0.41302619595039236`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{283.2764705882354, 
                    309.65882352941185`}, {7.2535759908845705`, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.41302619595039236`]& ,
                    TagBoxNote->"0.41302619595039236"],
                    StyleBox[
                    "0.41302619595039236`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.41302619595039236`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.616], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{11.6, 0.}, {12.6, 0.07120588602070084}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{314.3352941176471, 340.7176470588236}, {
                    45.733997381219595`, 54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.07120588602070084]& ,
                    TagBoxNote->"0.07120588602070084"],
                    StyleBox[
                    "0.07120588602070084`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.07120588602070084, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.616], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{12.6, 0.}, {13.6, 0.14692902639082372`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{340.2176470588236, 366.6000000000001}, {
                    37.20946485405301, 54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.14692902639082372`]& ,
                    TagBoxNote->"0.14692902639082372"],
                    StyleBox[
                    "0.14692902639082372`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.14692902639082372`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}}, {}, {}}, {}, {}, {}, {}, {}}, \
{{
             
             StyleBox[{{}, {
                LineBox[{{2.1, 0.010488641493169693`}, {2.1, 
                 0.05910424180739195}}], 
                LineBox[{{2.1, 0.05910424180739195}, {2.1, 
                 0.1077198421216142}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{4.300000000000001, 0.}, {4.300000000000001, 
                 0.05888595682798714}}], 
                LineBox[{{4.300000000000001, 0.05888595682798714}, {
                 4.300000000000001, 0.12148986192635908`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{6.500000000000001, 0.14838332250281133`}, {
                 6.500000000000001, 0.22435094084257876`}}], 
                LineBox[{{6.500000000000001, 0.22435094084257876`}, {
                 6.500000000000001, 0.3003185591823462}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{8.700000000000001, 0.027438440701143582`}, {
                 8.700000000000001, 0.09770363818082616}}], 
                LineBox[{{8.700000000000001, 0.09770363818082616}, {
                 8.700000000000001, 0.16796883566050874`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{10.9, 0.3125535683498266}, {10.9, 
                 0.41302619595039236`}}], 
                LineBox[{{10.9, 0.41302619595039236`}, {10.9, 
                 0.5134988235509581}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{13.1, 0.05186445009228392}, {13.1, 
                 0.14692902639082372`}}], 
                LineBox[{{13.1, 0.14692902639082372`}, {13.1, 
                 0.24199360268936354`}}]}},
              Antialiasing->False]}, {
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{2.1, 0.1077198421216142}, 
                   Offset[{3, 0}, {2.1, 0.1077198421216142}]}, {{2.1, 
                   0.1077198421216142}, 
                   Offset[{-3, 0}, {2.1, 0.1077198421216142}]}, {{2.1, 
                   0.010488641493169693`}, 
                   Offset[{3, 0}, {2.1, 0.010488641493169693`}]}, {{2.1, 
                   0.010488641493169693`}, 
                   Offset[{-3, 0}, {2.1, 0.010488641493169693`}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{4.300000000000001, 0.12148986192635908`}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.12148986192635908`}]}, {{4.300000000000001, 
                   0.12148986192635908`}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.12148986192635908`}]}, {{4.300000000000001, 0.}, 
                   Offset[{3, 0}, {4.300000000000001, 0.}]}, {{
                   4.300000000000001, 0.}, 
                   Offset[{-3, 0}, {4.300000000000001, 0.}]}}], {{{1., 0.}, {
                 0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{6.500000000000001, 0.3003185591823462}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.3003185591823462}]}, {{6.500000000000001, 
                   0.3003185591823462}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.3003185591823462}]}, {{6.500000000000001, 
                   0.14838332250281133`}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.14838332250281133`}]}, {{6.500000000000001, 
                   0.14838332250281133`}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.14838332250281133`}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{8.700000000000001, 0.16796883566050874`}, 
                   Offset[{3, 0}, {8.700000000000001, 
                    0.16796883566050874`}]}, {{8.700000000000001, 
                   0.16796883566050874`}, 
                   Offset[{-3, 0}, {8.700000000000001, 
                    0.16796883566050874`}]}, {{8.700000000000001, 
                   0.027438440701143582`}, 
                   Offset[{3, 0}, {8.700000000000001, 
                    0.027438440701143582`}]}, {{8.700000000000001, 
                   0.027438440701143582`}, 
                   Offset[{-3, 0}, {8.700000000000001, 
                    0.027438440701143582`}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{10.9, 0.5134988235509581}, 
                   Offset[{3, 0}, {10.9, 0.5134988235509581}]}, {{10.9, 
                   0.5134988235509581}, 
                   Offset[{-3, 0}, {10.9, 0.5134988235509581}]}, {{10.9, 
                   0.3125535683498266}, 
                   Offset[{3, 0}, {10.9, 0.3125535683498266}]}, {{10.9, 
                   0.3125535683498266}, 
                   Offset[{-3, 0}, {10.9, 0.3125535683498266}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{13.1, 0.24199360268936354`}, 
                   Offset[{3, 0}, {13.1, 0.24199360268936354`}]}, {{13.1, 
                   0.24199360268936354`}, 
                   Offset[{-3, 0}, {13.1, 0.24199360268936354`}]}, {{13.1, 
                   0.05186445009228392}, 
                   Offset[{3, 0}, {13.1, 0.05186445009228392}]}, {{13.1, 
                   0.05186445009228392}, 
                   Offset[{-3, 0}, {13.1, 0.05186445009228392}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False]}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0.33999999999999997`, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          DisplayFunction->Identity,
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"limbmuscle\"", FontFamily -> "Latin Modern Math", FontSize -> 
                24, "", StripOnInput -> False], RoundingRadius -> 5, 
               Background -> GrayLevel[1], StripOnInput -> False], 
              TraditionalForm], 
             Scaled[{0.05, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {None, None}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->{{All, All}, {0, 1}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{None, Automatic}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"], 
     TagBox[GridBox[{
        {
         GraphicsBox[{
           {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[
            0.5389999999999999], Thickness[Small]}], {}, 
            {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[
             0.5389999999999999], Thickness[Small]}], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-8.4, 0}, {-8.2, 0.0004932425766992207}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-483.7285714285715, \
-466.88571428571424`}, {45.69886751095958, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004932425766992207]& ,
                TagBoxNote->"0.0004932425766992207"],
               StyleBox[
               "0.0004932425766992207`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004932425766992207, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-6.4, 0}, {-6.2, 0.0009864851533984414}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-320.30000000000007`, \
-303.4571428571429}, {45.64773502191915, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0009864851533984414]& ,
                TagBoxNote->"0.0009864851533984414"],
               StyleBox[
               "0.0009864851533984414`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0009864851533984414, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-5., 0}, {-4.8, 0.001479727730097662}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-205.9, -189.05714285714285`}, {
                   45.59660253287872, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001479727730097662]& ,
                TagBoxNote->"0.001479727730097662"],
               StyleBox[
               "0.001479727730097662`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001479727730097662, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.8, 0}, {-4.6, 0.0009864851533984414}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-189.55714285714285`, \
-172.7142857142857}, {45.64773502191915, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0009864851533984414]& ,
                TagBoxNote->"0.0009864851533984414"],
               StyleBox[
               "0.0009864851533984414`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0009864851533984414, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.6, 0}, {-4.4, 0.001479727730097662}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-173.2142857142857, -156.3714285714286}, {
                   45.59660253287872, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001479727730097662]& ,
                TagBoxNote->"0.001479727730097662"],
               StyleBox[
               "0.001479727730097662`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001479727730097662, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.4, 0}, {-4.2, 0.001479727730097662}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-156.8714285714286, \
-140.02857142857144`}, {45.59660253287872, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001479727730097662]& ,
                TagBoxNote->"0.001479727730097662"],
               StyleBox[
               "0.001479727730097662`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001479727730097662, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4.2, 0}, {-4., 0.001479727730097662}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-140.52857142857144`, \
-123.68571428571428`}, {45.59660253287872, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001479727730097662]& ,
                TagBoxNote->"0.001479727730097662"],
               StyleBox[
               "0.001479727730097662`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001479727730097662, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-4., 0}, {-3.8, 0.001479727730097662}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-124.18571428571428`, \
-107.34285714285713`}, {45.59660253287872, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001479727730097662]& ,
                TagBoxNote->"0.001479727730097662"],
               StyleBox[
               "0.001479727730097662`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001479727730097662, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.8, 0}, {-3.6, 0.001479727730097662}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-107.84285714285713`, \
-91.00000000000003}, {45.59660253287872, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001479727730097662]& ,
                TagBoxNote->"0.001479727730097662"],
               StyleBox[
               "0.001479727730097662`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001479727730097662, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.6, 0}, {-3.4, 0.0019729703067968827`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-91.50000000000003, -74.65714285714282}, {
                   45.54547004383829, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0019729703067968827`]& ,
                TagBoxNote->"0.0019729703067968827"],
               StyleBox[
               "0.0019729703067968827`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0019729703067968827`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.4, 0}, {-3.2, 0.005918910920390648}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-75.15714285714282, -58.31428571428572}, {
                   45.136410131514864`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.005918910920390648]& ,
                TagBoxNote->"0.005918910920390648"],
               StyleBox[
               "0.005918910920390648`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.005918910920390648, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3.2, 0}, {-3., 0.00739863865048831}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-58.81428571428572, -41.97142857142856}, {
                   44.98301266439358, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.00739863865048831]& ,
                TagBoxNote->"0.00739863865048831"],
               StyleBox[
               "0.00739863865048831`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.00739863865048831, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-3., 0}, {-2.8, 0.00690539607378909}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-42.47142857142856, \
-25.628571428571405`}, {45.034145153434004`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.00690539607378909]& ,
                TagBoxNote->"0.00690539607378909"],
               StyleBox[
               "0.00690539607378909`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.00690539607378909, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.8, 0}, {-2.6, 0.00789188122718753}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-26.128571428571405`, \
-9.285714285714278}, {44.93188017535315, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.00789188122718753]& ,
                TagBoxNote->"0.00789188122718753"],
               StyleBox[
               "0.00789188122718753`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.00789188122718753, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.6, 0}, {-2.4, 0.01381079214757818}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{-9.785714285714278, 7.057142857142878}, {
                   44.31829030686801, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.01381079214757818]& ,
                TagBoxNote->"0.01381079214757818"],
               StyleBox[
               "0.01381079214757818`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.01381079214757818, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.4, 0}, {-2.2, 0.020716188221367268`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{6.557142857142878, 23.400000000000006`}, {
                   43.602435460302004`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.020716188221367268`]& ,
                TagBoxNote->"0.020716188221367268"],
               StyleBox[
               "0.020716188221367268`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.020716188221367268`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2.2, 0}, {-2., 0.027128341718457138`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{22.900000000000006`, 39.74285714285716}, {
                   42.93771310277643, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.027128341718457138`]& ,
                TagBoxNote->"0.027128341718457138"],
               StyleBox[
               "0.027128341718457138`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.027128341718457138`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-2., 0}, {-1.8, 0.04241886159613298}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{39.24285714285716, 56.08571428571429}, {
                   41.35260594252314, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.04241886159613298]& ,
                TagBoxNote->"0.04241886159613298"],
               StyleBox[
               "0.04241886159613298`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.04241886159613298, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.8, 0}, {-1.6, 0.05622965374371116}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{55.58571428571429, 72.42857142857144}, {
                   39.92089624939114, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.05622965374371116]& ,
                TagBoxNote->"0.05622965374371116"],
               StyleBox[
               "0.05622965374371116`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.05622965374371116, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.6, 0}, {-1.4, 0.06609450527769557}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{71.92857142857144, 88.7714285714286}, {
                   38.89824646858257, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.06609450527769557]& ,
                TagBoxNote->"0.06609450527769557"],
               StyleBox[
               "0.06609450527769557`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.06609450527769557, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.4, 0}, {-1.2, 0.08533096576896518}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{88.2714285714286, 105.11428571428574`}, {
                   36.904079396005855`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.08533096576896518]& ,
                TagBoxNote->"0.08533096576896518"],
               StyleBox[
               "0.08533096576896518`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.08533096576896518, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1.2, 0}, {-1., 0.11887146098451218`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{104.61428571428574`, 
                   121.45714285714288`}, {33.427070141256706`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.11887146098451218`]& ,
                TagBoxNote->"0.11887146098451218"],
               StyleBox[
               "0.11887146098451218`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.11887146098451218`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-1., 0}, {-0.8, 0.16572950577093815`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{120.95714285714288`, 137.8}, {
                   28.56948368241598, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.16572950577093815`]& ,
                TagBoxNote->"0.16572950577093815"],
               StyleBox[
               "0.16572950577093815`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.16572950577093815`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.8, 0}, {-0.6, 0.20864160994377035`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{137.3, 154.14285714285717`}, {
                   24.12095713589869, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.20864160994377035`]& ,
                TagBoxNote->"0.20864160994377035"],
               StyleBox[
               "0.20864160994377035`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.20864160994377035`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.6, 0}, {-0.4, 0.31320903620400514`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{153.64285714285717`, 
                   170.48571428571432`}, {13.280869459327818`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.31320903620400514`]& ,
                TagBoxNote->"0.31320903620400514"],
               StyleBox[
               "0.31320903620400514`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.31320903620400514`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.4, 0}, {-0.2, 0.45230344283318535`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{169.98571428571432`, 
                   186.82857142857145`}, {-1.138492450073059, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.45230344283318535`]& ,
                TagBoxNote->"0.45230344283318535"],
               StyleBox[
               "0.45230344283318535`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.45230344283318535`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{-0.2, 0}, {0., 0.672782874617737}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{186.32857142857145`, 
                   203.1714285714286}, {-23.994715051144674`, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.672782874617737]& ,
                TagBoxNote->"0.672782874617737"],
               StyleBox[
               "0.672782874617737`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.672782874617737, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0., 0}, {0.2, 1.0126270099635}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{202.6714285714286, 
                   219.51428571428576`}, {-59.225, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 1.0126270099635]& ,
                TagBoxNote->"1.0126270099635"],
               StyleBox[
               "1.0126270099635`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[1.0126270099635, {FontFamily -> "Times"}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.2, 0}, {0.4, 0.9203906481207458}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{219.01428571428576`, 
                   235.8571428571429}, {-49.66322454943985, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.9203906481207458]& ,
                TagBoxNote->"0.9203906481207458"],
               StyleBox[
               "0.9203906481207458`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.9203906481207458, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.4, 0}, {0.6, 0.4656209924040643}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{235.3571428571429, 
                   252.20000000000005`}, {-2.519069654164632, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.4656209924040643]& ,
                TagBoxNote->"0.4656209924040643"],
               StyleBox[
               "0.4656209924040643`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.4656209924040643, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.6, 0}, {0.8, 0.19729703067968826`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{251.70000000000005`, 268.5428571428572}, {
                   25.29700438382855, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.19729703067968826`]& ,
                TagBoxNote->"0.19729703067968826"],
               StyleBox[
               "0.19729703067968826`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.19729703067968826`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{0.8, 0}, {1., 0.07349314392818389}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{268.0428571428572, 284.88571428571436`}, {
                   38.13125913297614, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.07349314392818389]& ,
                TagBoxNote->"0.07349314392818389"],
               StyleBox[
               "0.07349314392818389`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.07349314392818389, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1., 0}, {1.2, 0.02120943079806649}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{284.38571428571436`, 
                   301.22857142857146`}, {43.55130297126158, 
                   46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.02120943079806649]& ,
                TagBoxNote->"0.02120943079806649"],
               StyleBox[
               "0.02120943079806649`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.02120943079806649, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.2, 0}, {1.4, 0.012331064417480516`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{300.72857142857146`, 317.5714285714286}, {
                   44.47168777398929, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.012331064417480516`]& ,
                TagBoxNote->"0.012331064417480516"],
               StyleBox[
               "0.012331064417480516`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.012331064417480516`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.4, 0}, {1.6, 0.003452698036894545}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{317.0714285714286, 333.91428571428577`}, {
                   45.392072576717005`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.003452698036894545]& ,
                TagBoxNote->"0.003452698036894545"],
               StyleBox[
               "0.003452698036894545`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.003452698036894545, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.6, 0}, {1.8, 0.002959455460195324}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{333.41428571428577`, 350.2571428571429}, {
                   45.44320506575743, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.002959455460195324]& ,
                TagBoxNote->"0.002959455460195324"],
               StyleBox[
               "0.002959455460195324`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.002959455460195324, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{1.8, 0}, {2., 0.0024662128834961033`}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{349.7571428571429, 366.6}, {
                   45.494337554797866`, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0024662128834961033`]& ,
                TagBoxNote->"0.0024662128834961033"],
               StyleBox[
               "0.0024662128834961033`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0024662128834961033`, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2., 0}, {2.2, 0.001479727730097662}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{366.1, 382.9428571428572}, {
                   45.59660253287872, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.001479727730097662]& ,
                TagBoxNote->"0.001479727730097662"],
               StyleBox[
               "0.001479727730097662`", {FontFamily -> "Times"}, StripOnInput -> 
                False]],
              Annotation[#, 
               Style[0.001479727730097662, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.2, 0}, {2.4, 0.0004932425766992207}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{382.4428571428572, 399.28571428571433`}, {
                   45.69886751095958, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004932425766992207]& ,
                TagBoxNote->"0.0004932425766992207"],
               StyleBox[
               "0.0004932425766992207`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004932425766992207, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.4, 0}, {2.6, 0.0004932425766992207}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{398.78571428571433`, 415.6285714285715}, {
                   45.69886751095958, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004932425766992207]& ,
                TagBoxNote->"0.0004932425766992207"],
               StyleBox[
               "0.0004932425766992207`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004932425766992207, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{2.8, 0}, {3., 0.0004932425766992207}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{431.47142857142865`, 448.3142857142858}, {
                   45.69886751095958, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004932425766992207]& ,
                TagBoxNote->"0.0004932425766992207"],
               StyleBox[
               "0.0004932425766992207`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004932425766992207, {FontFamily -> "Times"}], 
               "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                TagBox[
                 DynamicBox[{
                   FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                   
                   RectangleBox[{4.2, 0}, {4.4, 0.0004932425766992207}, 
                    "RoundingRadius" -> 0]},
                  
                  ImageSizeCache->{{545.8714285714286, 562.7142857142858}, {
                   45.69886751095958, 46.25000000000001}}],
                 "DelayedMouseEffectStyle"],
                StatusArea[#, 0.0004932425766992207]& ,
                TagBoxNote->"0.0004932425766992207"],
               StyleBox[
               "0.0004932425766992207`", {FontFamily -> "Times"}, 
                StripOnInput -> False]],
              Annotation[#, 
               Style[0.0004932425766992207, {FontFamily -> "Times"}], 
               "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{-2.2840000000000003`, 0},
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"G = 10137\"", FontFamily -> "Latin Modern Math", FontSize -> 
                20, "", StripOnInput -> False], RoundingRadius -> 5, 
               FrameStyle -> None, Background -> RGBColor[0.95, 0.95, 0.95], 
               StripOnInput -> False], TraditionalForm], 
             Scaled[{0.1, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->NCache[{{
              Rational[-11, 5], 2}, {All, All}}, {{-2.2, 2}, {All, All}}],
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]},
        {
         GraphicsBox[{{
            {Opacity[0], 
             PointBox[{{0.296, 0.}, {15.799999999999999`, 
              0.}}]}, {{}, {{{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.602], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.6, 0.}, {1.6, 0.2567029744449099}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{29.62941176470588, 
                    52.265634674922595`}, {24.851662651864274`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.2567029744449099]& ,
                    TagBoxNote->"0.2567029744449099"],
                    StyleBox[
                    "0.2567029744449099`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.2567029744449099, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.602], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.6, 0.}, {2.6, 0.11610457053599284`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{51.765634674922595`, 
                    74.40185758513931}, {40.67952797191061, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.11610457053599284`]& ,
                    TagBoxNote->"0.11610457053599284"],
                    StyleBox[
                    "0.11610457053599284`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.11610457053599284`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.602], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.8000000000000003`, 0.}, {
                    3.8000000000000003`, 0.1270423125261835}, 
                    "RoundingRadius" -> 0]},
                    ImageSizeCache->{{78.32910216718267, 
                    100.96532507739937`}, {39.448211667364895`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.1270423125261835]& ,
                    TagBoxNote->"0.1270423125261835"],
                    StyleBox[
                    "0.1270423125261835`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.1270423125261835, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.602], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.8000000000000003`, 0.}, {
                    4.800000000000001, 0.1288943591483042}, "RoundingRadius" -> 
                    0]},
                    
                    ImageSizeCache->{{100.46532507739937`, 
                    123.1015479876161}, {39.23971751887966, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.1288943591483042]& ,
                    TagBoxNote->"0.1288943591483042"],
                    StyleBox[
                    "0.1288943591483042`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.1288943591483042, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.602], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{5.000000000000001, 0.}, {6.000000000000001, 
                    0.29461667364893174`}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{127.02879256965944`, 
                    149.66501547987616`}, {20.58352796397152, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.29461667364893174`]& ,
                    TagBoxNote->"0.29461667364893174"],
                    StyleBox[
                    "0.29461667364893174`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.29461667364893174`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.602], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{6.000000000000001, 0.}, {7.000000000000001, 
                    0.2937329515345084}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{149.16501547987616`, 
                    171.80123839009286`}, {20.683012981002726`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.2937329515345084]& ,
                    TagBoxNote->"0.2937329515345084"],
                    StyleBox[
                    "0.2937329515345084`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.2937329515345084, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.602], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{7.200000000000001, 0.}, {8.200000000000001, 
                    0.08975701717637201}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{175.72848297213625`, 
                    198.36470588235295`}, {43.64560379136992, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.08975701717637201]& ,
                    TagBoxNote->"0.08975701717637201"],
                    StyleBox[
                    "0.08975701717637201`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.08975701717637201, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.602], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{8.200000000000001, 0.}, {9.200000000000001, 
                    0.09304235916069957}, "RoundingRadius" -> 0]},
                    ImageSizeCache->{{197.86470588235295`, 
                    220.50092879256965`}, {43.275756417484246`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.09304235916069957]& ,
                    TagBoxNote->"0.09304235916069957"],
                    StyleBox[
                    "0.09304235916069957`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.09304235916069957, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.602], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{9.4, 0.}, {10.4, 0.0747800586510264}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{224.42817337461298`, 
                    247.06439628482968`}, {45.33163489736071, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.0747800586510264]& ,
                    TagBoxNote->"0.0747800586510264"],
                    StyleBox[
                    "0.0747800586510264`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.0747800586510264, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.602], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{10.4, 0.}, {11.4, 0.10834589457893919`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{246.56439628482968`, 
                    269.20061919504644`}, {41.55296091777592, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.10834589457893919`]& ,
                    TagBoxNote->"0.10834589457893919"],
                    StyleBox[
                    "0.10834589457893919`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.10834589457893919`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.602], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{11.6, 0.}, {12.6, 0.021051529116045246`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{273.1278637770897, 295.7640866873065}, {
                    51.380124109761205`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.021051529116045246`]& ,
                    TagBoxNote->"0.021051529116045246"],
                    StyleBox[
                    "0.021051529116045246`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.021051529116045246`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.602], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{12.6, 0.}, {13.6, 0.10833121187110381`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{295.2640866873065, 317.9003095975232}, {
                    41.554613823610495`, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.10833121187110381`]& ,
                    TagBoxNote->"0.10833121187110381"],
                    StyleBox[
                    "0.10833121187110381`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.10833121187110381`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[0.602], 
                  Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{13.799999999999999`, 0.}, {
                    14.799999999999999`, 0.1360494344365312}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{321.8275541795665, 344.4637770897832}, {
                    38.4342349183075, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.1360494344365312]& ,
                    TagBoxNote->"0.1360494344365312"],
                    StyleBox[
                    "0.1360494344365312`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.1360494344365312, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.602], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{14.799999999999999`, 0.}, {
                    15.799999999999999`, 0.15154865317045216`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{343.9637770897832, 366.5999999999999}, {
                    36.68941036933635, 54.25}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.15154865317045216`]& ,
                    TagBoxNote->"0.15154865317045216"],
                    StyleBox[
                    "0.15154865317045216`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.15154865317045216`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}}, {}, {}}, {}, {}, {}, {}, {}}, \
{{
             
             StyleBox[{{}, {
                LineBox[{{2.1, 0.046004768468205295`}, {2.1, 
                 0.11610457053599284`}}], 
                LineBox[{{2.1, 0.11610457053599284`}, {2.1, 
                 0.18620437260378037`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{4.300000000000001, 0.06775358558552069}, {
                 4.300000000000001, 0.1288943591483042}}], 
                LineBox[{{4.300000000000001, 0.1288943591483042}, {
                 4.300000000000001, 0.19003513271108768`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{6.500000000000001, 0.21148505643201837`}, {
                 6.500000000000001, 0.2937329515345084}}], 
                LineBox[{{6.500000000000001, 0.2937329515345084}, {
                 6.500000000000001, 0.37598084663699843`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{8.700000000000001, 0.04966472248967313}, {
                 8.700000000000001, 0.09304235916069957}}], 
                LineBox[{{8.700000000000001, 0.09304235916069957}, {
                 8.700000000000001, 0.136419995831726}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{10.9, 0.06239105625555928}, {10.9, 
                 0.10834589457893919`}}], 
                LineBox[{{10.9, 0.10834589457893919`}, {10.9, 
                 0.1543007329023191}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{13.1, 0.03570813885624986}, {13.1, 
                 0.10833121187110381`}}], 
                LineBox[{{13.1, 0.10833121187110381`}, {13.1, 
                 0.18095428488595777`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{15.299999999999999`, 0.08518085707926806}, {
                 15.299999999999999`, 0.15154865317045216`}}], 
                LineBox[{{15.299999999999999`, 0.15154865317045216`}, {
                 15.299999999999999`, 0.21791644926163625`}}]}},
              Antialiasing->False]}, {
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{2.1, 0.18620437260378037`}, 
                   Offset[{3, 0}, {2.1, 0.18620437260378037`}]}, {{2.1, 
                   0.18620437260378037`}, 
                   Offset[{-3, 0}, {2.1, 0.18620437260378037`}]}, {{2.1, 
                   0.046004768468205295`}, 
                   Offset[{3, 0}, {2.1, 0.046004768468205295`}]}, {{2.1, 
                   0.046004768468205295`}, 
                   Offset[{-3, 0}, {2.1, 0.046004768468205295`}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{4.300000000000001, 0.19003513271108768`}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.19003513271108768`}]}, {{4.300000000000001, 
                   0.19003513271108768`}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.19003513271108768`}]}, {{4.300000000000001, 
                   0.06775358558552069}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.06775358558552069}]}, {{4.300000000000001, 
                   0.06775358558552069}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.06775358558552069}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{6.500000000000001, 0.37598084663699843`}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.37598084663699843`}]}, {{6.500000000000001, 
                   0.37598084663699843`}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.37598084663699843`}]}, {{6.500000000000001, 
                   0.21148505643201837`}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.21148505643201837`}]}, {{6.500000000000001, 
                   0.21148505643201837`}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.21148505643201837`}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{8.700000000000001, 0.136419995831726}, 
                   Offset[{3, 0}, {8.700000000000001, 0.136419995831726}]}, {{
                   8.700000000000001, 0.136419995831726}, 
                   Offset[{-3, 0}, {8.700000000000001, 
                    0.136419995831726}]}, {{8.700000000000001, 
                   0.04966472248967313}, 
                   Offset[{3, 0}, {8.700000000000001, 
                    0.04966472248967313}]}, {{8.700000000000001, 
                   0.04966472248967313}, 
                   Offset[{-3, 0}, {8.700000000000001, 
                    0.04966472248967313}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{10.9, 0.1543007329023191}, 
                   Offset[{3, 0}, {10.9, 0.1543007329023191}]}, {{10.9, 
                   0.1543007329023191}, 
                   Offset[{-3, 0}, {10.9, 0.1543007329023191}]}, {{10.9, 
                   0.06239105625555928}, 
                   Offset[{3, 0}, {10.9, 0.06239105625555928}]}, {{10.9, 
                   0.06239105625555928}, 
                   Offset[{-3, 0}, {10.9, 0.06239105625555928}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{13.1, 0.18095428488595777`}, 
                   Offset[{3, 0}, {13.1, 0.18095428488595777`}]}, {{13.1, 
                   0.18095428488595777`}, 
                   Offset[{-3, 0}, {13.1, 0.18095428488595777`}]}, {{13.1, 
                   0.03570813885624986}, 
                   Offset[{3, 0}, {13.1, 0.03570813885624986}]}, {{13.1, 
                   0.03570813885624986}, 
                   Offset[{-3, 0}, {13.1, 0.03570813885624986}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{15.299999999999999`, 0.21791644926163625`}, 
                   Offset[{3, 0}, {15.299999999999999`, 
                    0.21791644926163625`}]}, {{15.299999999999999`, 
                   0.21791644926163625`}, 
                   Offset[{-3, 0}, {15.299999999999999`, 
                    0.21791644926163625`}]}, {{15.299999999999999`, 
                   0.08518085707926806}, 
                   Offset[{3, 0}, {15.299999999999999`, 
                    0.08518085707926806}]}, {{15.299999999999999`, 
                   0.08518085707926806}, 
                   Offset[{-3, 0}, {15.299999999999999`, 
                    0.08518085707926806}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False]}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0.296, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          DisplayFunction->Identity,
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"kidney\"", FontFamily -> "Latin Modern Math", FontSize -> 
                24, "", StripOnInput -> False], RoundingRadius -> 5, 
               Background -> GrayLevel[1], StripOnInput -> False], 
              TraditionalForm], 
             Scaled[{0.05, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {None, None}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->{{All, All}, {0, 1}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{None, Automatic}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"], 
     TagBox[GridBox[{
        {
         GraphicsBox[{
           {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.434], 
            Thickness[Small]}], {}, 
            {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.434], 
             Thickness[Small]}], 
             RectangleBox[{-8.5, 0}, {-8.4, 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{-7.5, 0}, {-7.4, 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{-6.7, 0}, {-6.6, 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{-5.7, 0}, {-5.6, 0.0017992083483267362},
              RoundingRadius->0], 
             RectangleBox[{-5.5, 0}, {-5.4, 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{-5.2, 0}, {-5.1, 0.0026988125224901042},
              RoundingRadius->0], 
             RectangleBox[{-5.1, 0}, {-5., 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{-5., 0}, {-4.9, 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{-4.8, 0}, {-4.7, 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{-4.6, 0}, {-4.5, 0.0053976250449802084},
              RoundingRadius->0], 
             RectangleBox[{-4.5, 0}, {-4.4, 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{-4.4, 0}, {-4.3, 0.0017992083483267362},
              RoundingRadius->0], 
             RectangleBox[{-4.3, 0}, {-4.2, 0.0017992083483267362},
              RoundingRadius->0], 
             RectangleBox[{-4.2, 0}, {-4.1, 0.0053976250449802084},
              RoundingRadius->0], 
             RectangleBox[{-4.1, 0}, {-4., 0.0026988125224901042},
              RoundingRadius->0], 
             RectangleBox[{-3.9, 0}, {-3.8, 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{-3.8, 0}, {-3.7, 0.004498020870816841},
              RoundingRadius->0], 
             RectangleBox[{-3.7, 0}, {-3.6, 0.0026988125224901042},
              RoundingRadius->0], 
             RectangleBox[{-3.6, 0}, {-3.5, 0.0053976250449802084},
              RoundingRadius->0], 
             RectangleBox[{-3.5, 0}, {-3.4, 0.0017992083483267362},
              RoundingRadius->0], 
             RectangleBox[{-3.4, 0}, {-3.3, 0.0026988125224901042},
              RoundingRadius->0], 
             RectangleBox[{-3.3, 0}, {-3.2, 0.004498020870816841},
              RoundingRadius->0], 
             RectangleBox[{-3.2, 0}, {-3.1, 0.0035984166966534724},
              RoundingRadius->0], 
             RectangleBox[{-3.1, 0}, {-3., 0.006297229219143577},
              RoundingRadius->0], 
             RectangleBox[{-3., 0}, {-2.9, 0.004498020870816841},
              RoundingRadius->0], 
             RectangleBox[{-2.9, 0}, {-2.8, 0.009895645915797049},
              RoundingRadius->0], 
             RectangleBox[{-2.8, 0}, {-2.7, 0.008096437567470314},
              RoundingRadius->0], 
             RectangleBox[{-2.7, 0}, {-2.6, 0.010795250089960417},
              RoundingRadius->0], 
             RectangleBox[{-2.6, 0}, {-2.5, 0.015293270960777258},
              RoundingRadius->0], 
             RectangleBox[{-2.5, 0}, {-2.4, 0.008096437567470314},
              RoundingRadius->0], 
             RectangleBox[{-2.4, 0}, {-2.3, 0.018891687657430732},
              RoundingRadius->0], 
             RectangleBox[{-2.3, 0}, {-2.2, 0.020690896005757468},
              RoundingRadius->0], 
             RectangleBox[{-2.2, 0}, {-2.1, 0.019791291831594098},
              RoundingRadius->0], 
             RectangleBox[{-2.1, 0}, {-2., 0.030586541921554515},
              RoundingRadius->0], 
             RectangleBox[{-2., 0}, {-1.9, 0.01439366678661389},
              RoundingRadius->0], 
             RectangleBox[{-1.9, 0}, {-1.8, 0.026088521050737674},
              RoundingRadius->0], 
             RectangleBox[{-1.8, 0}, {-1.7, 0.040482187837351566},
              RoundingRadius->0], 
             RectangleBox[{-1.7, 0}, {-1.6, 0.04947822957898525},
              RoundingRadius->0], 
             RectangleBox[{-1.6, 0}, {-1.5, 0.046779417056495146},
              RoundingRadius->0], 
             RectangleBox[{-1.5, 0}, {-1.4, 0.06297229219143577},
              RoundingRadius->0], 
             RectangleBox[{-1.4, 0}, {-1.3, 0.07556675062972293},
              RoundingRadius->0], 
             RectangleBox[{-1.3, 0}, {-1.2, 0.06836991723641597},
              RoundingRadius->0], 
             RectangleBox[{-1.2, 0}, {-1.1, 0.08636200071968334},
              RoundingRadius->0], 
             RectangleBox[{-1.1, 0}, {-1., 0.11694854264123786},
              RoundingRadius->0], 
             RectangleBox[{-1., 0}, {-0.9, 0.12864339690536164},
              RoundingRadius->0], 
             RectangleBox[{-0.9, 0}, {-0.8, 0.1439366678661389},
              RoundingRadius->0], 
             RectangleBox[{-0.8, 0}, {-0.7, 0.20241093918675782},
              RoundingRadius->0], 
             RectangleBox[{-0.7, 0}, {-0.6, 0.2455919395465995},
              RoundingRadius->0], 
             RectangleBox[{-0.6, 0}, {-0.5, 0.3193594818279957},
              RoundingRadius->0], 
             RectangleBox[{-0.5, 0}, {-0.4, 0.3643396905361641},
              RoundingRadius->0], 
             RectangleBox[{-0.4, 0}, {-0.3, 0.46779417056495143},
              RoundingRadius->0], 
             RectangleBox[{-0.3, 0}, {-0.2, 0.5919395465994962},
              RoundingRadius->0], 
             RectangleBox[{-0.2, 0}, {-0.1, 0.6863979848866498},
              RoundingRadius->0], 
             RectangleBox[{-0.1, 0}, {0., 0.9193954659949622},
              RoundingRadius->0], 
             RectangleBox[{0., 0}, {0.1, 1.2108672184238936},
              RoundingRadius->0], 
             RectangleBox[{0.1, 0}, {0.2, 1.0840230298668585},
              RoundingRadius->0], 
             RectangleBox[{0.2, 0}, {0.3, 0.8600215905001799},
              RoundingRadius->0], 
             RectangleBox[{0.3, 0}, {0.4, 0.5964375674703131},
              RoundingRadius->0], 
             RectangleBox[{0.4, 0}, {0.5, 0.44620367038503056},
              RoundingRadius->0], 
             RectangleBox[{0.5, 0}, {0.6, 0.3364519611370997},
              RoundingRadius->0], 
             RectangleBox[{0.6, 0}, {0.7, 0.2033105433609212},
              RoundingRadius->0], 
             RectangleBox[{0.7, 0}, {0.8, 0.12234616768621806},
              RoundingRadius->0], 
             RectangleBox[{0.8, 0}, {0.9, 0.08906081324217345},
              RoundingRadius->0], 
             RectangleBox[{0.9, 0}, {1., 0.06477150053976251},
              RoundingRadius->0], 
             RectangleBox[{1., 0}, {1.1, 0.035084562792371356},
              RoundingRadius->0], 
             RectangleBox[{1.1, 0}, {1.2, 0.022490104354084203},
              RoundingRadius->0], 
             RectangleBox[{1.2, 0}, {1.3, 0.021590500179920834},
              RoundingRadius->0], 
             RectangleBox[{1.3, 0}, {1.4, 0.007196833393306945},
              RoundingRadius->0], 
             RectangleBox[{1.4, 0}, {1.5, 0.008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{1.5, 0}, {1.6, 0.007196833393306945},
              RoundingRadius->0], 
             RectangleBox[{1.6, 0}, {1.7, 0.0017992083483267362},
              RoundingRadius->0], 
             RectangleBox[{1.7, 0}, {1.8, 0.0026988125224901042},
              RoundingRadius->0], 
             RectangleBox[{1.8, 0}, {1.9, 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{1.9, 0}, {2., 0.0017992083483267362},
              RoundingRadius->0], 
             RectangleBox[{2., 0}, {2.1, 0.0017992083483267362},
              RoundingRadius->0], 
             RectangleBox[{2.1, 0}, {2.2, 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{2.2, 0}, {2.3, 0.0035984166966534724},
              RoundingRadius->0], 
             RectangleBox[{2.3, 0}, {2.4, 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{2.5, 0}, {2.6, 0.0017992083483267362},
              RoundingRadius->0], 
             RectangleBox[{3.4, 0}, {3.5, 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{4.3, 0}, {4.4, 0.0008996041741633681},
              RoundingRadius->0], 
             RectangleBox[{5.2, 0}, {5.3, 0.0008996041741633681},
              
              RoundingRadius->
               0]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{-1.972, 0},
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"G = 11116\"", FontFamily -> "Latin Modern Math", FontSize -> 
                20, "", StripOnInput -> False], RoundingRadius -> 5, 
               FrameStyle -> None, Background -> RGBColor[0.95, 0.95, 0.95], 
               StripOnInput -> False], TraditionalForm], 
             Scaled[{0.1, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->NCache[{{
              Rational[-19, 10], 
              Rational[17, 10]}, {All, All}}, {{-1.9, 1.7}, {All, All}}],
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]},
        {
         GraphicsBox[{{
            {Opacity[0], 
             PointBox[{{0.07600000000000007, 0.}, {26.799999999999997`, 
              0.}}]}, {{}, {{{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{0.6, 0.}, {1.6, 0.07379083651975582}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{29.62941176470588, 42.97180062864841}, {
                    45.44299657878848, 54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.07379083651975582]& ,
                    TagBoxNote->"0.07379083651975582"],
                    StyleBox[
                    "0.07379083651975582`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.07379083651975582, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{1.6, 0.}, {2.6, 0.08143007257497117}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{42.47180062864841, 55.81418949259093}, {
                    44.58300957987261, 54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.08143007257497117]& ,
                    TagBoxNote->"0.08143007257497117"],
                    StyleBox[
                    "0.08143007257497117`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.08143007257497117, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{2.8000000000000003`, 0.}, {
                    3.8000000000000003`, 0.03421211511370497}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{57.88266726537944, 71.22505612932196}, {
                    49.898571141074655`, 54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.03421211511370497]& ,
                    TagBoxNote->"0.03421211511370497"],
                    StyleBox[
                    "0.03421211511370497`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.03421211511370497, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{3.8000000000000003`, 0.}, {
                    4.800000000000001, 0.018598459628345387`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{70.72505612932196, 84.06744499326449}, {
                    51.65627840733901, 54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.018598459628345387`]& ,
                    TagBoxNote->"0.018598459628345387"],
                    StyleBox[
                    "0.018598459628345387`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.018598459628345387`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{5.000000000000001, 0.}, {6.000000000000001, 
                    0.0548735493392366}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{86.135922766053, 99.47831162999552}, {
                    47.57261018313543, 54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.0548735493392366]& ,
                    TagBoxNote->"0.0548735493392366"],
                    StyleBox[
                    "0.0548735493392366`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.0548735493392366, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{6.000000000000001, 0.}, {7.000000000000001, 
                    0.10088004437338689`}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{98.97831162999552, 
                    112.32070049393803`}, {42.39342900466596, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.10088004437338689`]& ,
                    TagBoxNote->"0.10088004437338689"],
                    StyleBox[
                    "0.10088004437338689`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.10088004437338689`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{7.200000000000001, 0.}, {8.200000000000001, 
                    0.07083920305896559}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{114.38917826672655`, 
                    127.73156713066906`}, {45.77527671563694, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.07083920305896559]& ,
                    TagBoxNote->"0.07083920305896559"],
                    StyleBox[
                    "0.07083920305896559`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.07083920305896559, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{8.200000000000001, 0.}, {9.200000000000001, 
                    0.05511501092037729}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{127.23156713066906`, 
                    140.5739559946116}, {47.54542764563852, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.05511501092037729]& ,
                    TagBoxNote->"0.05511501092037729"],
                    StyleBox[
                    "0.05511501092037729`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.05511501092037729, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{9.4, 0.}, {10.4, 0.03266921580465553}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{142.6424337674001, 155.9848226313426}, {
                    50.07226303079089, 54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.03266921580465553]& ,
                    TagBoxNote->"0.03266921580465553"],
                    StyleBox[
                    "0.03266921580465553`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.03266921580465553, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{10.4, 0.}, {11.4, 0.042797775894129024`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{155.4848226313426, 
                    168.82721149528513`}, {48.93204037871842, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.042797775894129024`]& ,
                    TagBoxNote->"0.042797775894129024"],
                    StyleBox[
                    "0.042797775894129024`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.042797775894129024`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{11.6, 0.}, {12.6, 0.13483598309519018`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{170.89568926807362`, 
                    184.23807813201614`}, {38.57083920305896, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.13483598309519018`]& ,
                    TagBoxNote->"0.13483598309519018"],
                    StyleBox[
                    "0.13483598309519018`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.13483598309519018`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{12.6, 0.}, {13.6, 0.16626445823239663`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{183.73807813201614`, 
                    197.08046699595866`}, {35.03277861448794, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.16626445823239663`]& ,
                    TagBoxNote->"0.16626445823239663"],
                    StyleBox[
                    "0.16626445823239663`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.16626445823239663`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{13.799999999999999`, 0.}, {
                    14.799999999999999`, 0.39860468236399005`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{199.14894476874716`, 
                    212.49133363268967`}, {8.877077882873813, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.39860468236399005`]& ,
                    TagBoxNote->"0.39860468236399005"],
                    StyleBox[
                    "0.39860468236399005`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.39860468236399005`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{14.799999999999999`, 0.}, {
                    15.799999999999999`, 0.15909244403704867`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{211.99133363268967`, 
                    225.3337224966322}, {35.84016811252924, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.15909244403704867`]& ,
                    TagBoxNote->"0.15909244403704867"],
                    StyleBox[
                    "0.15909244403704867`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.15909244403704867`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{15.999999999999998`, 0.}, {17., 
                    0.09217146307104045}, "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{227.4022002694207, 
                    240.74458913336323`}, {43.37379754477762, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.09217146307104045]& ,
                    TagBoxNote->"0.09217146307104045"],
                    StyleBox[
                    "0.09217146307104045`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.09217146307104045, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{17., 0.}, {18., 0.061742524551051156`}, 
                    "RoundingRadius" -> 0]},
                    ImageSizeCache->{{240.24458913336323`, 
                    253.58697799730575`}, {46.79933529866541, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.061742524551051156`]& ,
                    TagBoxNote->"0.061742524551051156"],
                    StyleBox[
                    "0.061742524551051156`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.061742524551051156`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{18.2, 0.}, {19.2, 0.014624002146642516`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{255.65545577009425`, 
                    268.99784463403677`}, {52.103702958341714`, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.014624002146642516`]& ,
                    TagBoxNote->"0.014624002146642516"],
                    StyleBox[
                    "0.014624002146642516`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.014624002146642516`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{19.2, 0.}, {20.2, 0.05007344489112853}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{268.49784463403677`, 
                    281.8402334979793}, {48.1129819413812, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.05007344489112853]& ,
                    TagBoxNote->"0.05007344489112853"],
                    StyleBox[
                    "0.05007344489112853`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.05007344489112853, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{20.4, 0.}, {21.4, 0.016435231770309252`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{283.9087112707678, 297.2511001347103}, {
                    51.89980378345743, 54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.016435231770309252`]& ,
                    TagBoxNote->"0.016435231770309252"],
                    StyleBox[
                    "0.016435231770309252`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.016435231770309252`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{21.4, 0.}, {22.4, 0.08979023153669449}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{296.7511001347103, 
                    310.09348899865284`}, {43.64186468475661, 
                    54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.08979023153669449]& ,
                    TagBoxNote->"0.08979023153669449"],
                    StyleBox[
                    "0.08979023153669449`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.08979023153669449, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{22.599999999999998`, 0.}, {
                    23.599999999999998`, 0.05782518280002683}, 
                    "RoundingRadius" -> 0]},
                    ImageSizeCache->{{312.1619667714413, 325.5043556353839}, {
                    47.24033004628697, 54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.05782518280002683]& ,
                    TagBoxNote->"0.05782518280002683"],
                    StyleBox[
                    "0.05782518280002683`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.05782518280002683, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{23.599999999999998`, 0.}, {
                    24.599999999999998`, 0.15858171669847015`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{325.0043556353839, 338.3467444993264}, {
                    35.897663242669715`, 54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.15858171669847015`]& ,
                    TagBoxNote->"0.15858171669847015"],
                    StyleBox[
                    "0.15858171669847015`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.15858171669847015`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}, {{}, {{}, {
                 {RGBColor[0.9, 0.36, 0.054], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{24.799999999999997`, 0.}, {
                    25.799999999999997`, 0.01911853491648219}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{340.4152222721149, 353.7576111360574}, {
                    51.59773093177701, 54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.01911853491648219]& ,
                    TagBoxNote->"0.01911853491648219"],
                    StyleBox[
                    "0.01911853491648219`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.01911853491648219, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}, 
                 {RGBColor[0.365248, 0.427802, 0.758297], EdgeForm[{Opacity[
                  0.5319999999999999], Thickness[Small]}], 
                  TagBox[
                   TooltipBox[
                    TagBox[
                    TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{25.799999999999997`, 0.}, {
                    26.799999999999997`, 0.015633816662000644`}, 
                    "RoundingRadius" -> 0]},
                    
                    ImageSizeCache->{{353.2576111360574, 366.5999999999999}, {
                    51.99002308927527, 54.24999999999999}}],
                    "DelayedMouseEffectStyle"],
                    StatusArea[#, 0.015633816662000644`]& ,
                    TagBoxNote->"0.015633816662000644"],
                    StyleBox[
                    "0.015633816662000644`", {FontFamily -> "Times"}, 
                    StripOnInput -> False]],
                   Annotation[#, 
                    Style[0.015633816662000644`, {FontFamily -> "Times"}], 
                    "Tooltip"]& ]}}}, {}, {}}}, {}, {}}, {}, {}, {}, {}, {}}, \
{{
             
             StyleBox[{{}, {
                LineBox[{{2.1, 0.023231617468568472`}, {2.1, 
                 0.08143007257497117}}], 
                LineBox[{{2.1, 0.08143007257497117}, {2.1, 
                 0.13962852768137388`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{4.300000000000001, 0.}, {4.300000000000001, 
                 0.018598459628345387`}}], 
                LineBox[{{4.300000000000001, 0.018598459628345387`}, {
                 4.300000000000001, 0.05802994374125935}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{6.500000000000001, 0.02926151373123803}, {
                 6.500000000000001, 0.10088004437338689`}}], 
                LineBox[{{6.500000000000001, 0.10088004437338689`}, {
                 6.500000000000001, 0.17249857501553575`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{8.700000000000001, 0.}, {8.700000000000001, 
                 0.05511501092037729}}], 
                LineBox[{{8.700000000000001, 0.05511501092037729}, {
                 8.700000000000001, 0.12521403399393494`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{10.9, 0.006621734710994462}, {10.9, 
                 0.042797775894129024`}}], 
                LineBox[{{10.9, 0.042797775894129024`}, {10.9, 
                 0.07897381707726359}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{13.1, 0.08867954785735338}, {13.1, 
                 0.16626445823239663`}}], 
                LineBox[{{13.1, 0.16626445823239663`}, {13.1, 
                 0.2438493686074399}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{15.299999999999999`, 0.05473890846629553}, {
                 15.299999999999999`, 0.15909244403704867`}}], 
                LineBox[{{15.299999999999999`, 0.15909244403704867`}, {
                 15.299999999999999`, 0.2634459796078018}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{17.5, 0.008565061791606605}, {17.5, 
                 0.061742524551051156`}}], 
                LineBox[{{17.5, 0.061742524551051156`}, {17.5, 
                 0.11491998731049571`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{19.7, 0.}, {19.7, 0.05007344489112853}}], 
                LineBox[{{19.7, 0.05007344489112853}, {19.7, 
                 0.10200939013362799`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{21.9, 0.01155592306634734}, {21.9, 
                 0.08979023153669449}}], 
                LineBox[{{21.9, 0.08979023153669449}, {21.9, 
                 0.16802454000704165`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{24.099999999999998`, 0.07693319997507034}, {
                 24.099999999999998`, 0.15858171669847015`}}], 
                LineBox[{{24.099999999999998`, 0.15858171669847015`}, {
                 24.099999999999998`, 0.24023023342186997`}}]}},
              Antialiasing->False], 
             
             StyleBox[{{}, {
                LineBox[{{26.299999999999997`, 0.}, {26.299999999999997`, 
                 0.015633816662000644`}}], 
                LineBox[{{26.299999999999997`, 0.015633816662000644`}, {
                 26.299999999999997`, 0.04957553485823667}}]}},
              Antialiasing->False]}, {
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{2.1, 0.13962852768137388`}, 
                   Offset[{3, 0}, {2.1, 0.13962852768137388`}]}, {{2.1, 
                   0.13962852768137388`}, 
                   Offset[{-3, 0}, {2.1, 0.13962852768137388`}]}, {{2.1, 
                   0.023231617468568472`}, 
                   Offset[{3, 0}, {2.1, 0.023231617468568472`}]}, {{2.1, 
                   0.023231617468568472`}, 
                   Offset[{-3, 0}, {2.1, 0.023231617468568472`}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{4.300000000000001, 0.05802994374125935}, 
                   Offset[{3, 0}, {4.300000000000001, 
                    0.05802994374125935}]}, {{4.300000000000001, 
                   0.05802994374125935}, 
                   Offset[{-3, 0}, {4.300000000000001, 
                    0.05802994374125935}]}, {{4.300000000000001, 0.}, 
                   Offset[{3, 0}, {4.300000000000001, 0.}]}, {{
                   4.300000000000001, 0.}, 
                   Offset[{-3, 0}, {4.300000000000001, 0.}]}}], {{{1., 0.}, {
                 0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{6.500000000000001, 0.17249857501553575`}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.17249857501553575`}]}, {{6.500000000000001, 
                   0.17249857501553575`}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.17249857501553575`}]}, {{6.500000000000001, 
                   0.02926151373123803}, 
                   Offset[{3, 0}, {6.500000000000001, 
                    0.02926151373123803}]}, {{6.500000000000001, 
                   0.02926151373123803}, 
                   Offset[{-3, 0}, {6.500000000000001, 
                    0.02926151373123803}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{8.700000000000001, 0.12521403399393494`}, 
                   Offset[{3, 0}, {8.700000000000001, 
                    0.12521403399393494`}]}, {{8.700000000000001, 
                   0.12521403399393494`}, 
                   Offset[{-3, 0}, {8.700000000000001, 
                    0.12521403399393494`}]}, {{8.700000000000001, 0.}, 
                   Offset[{3, 0}, {8.700000000000001, 0.}]}, {{
                   8.700000000000001, 0.}, 
                   Offset[{-3, 0}, {8.700000000000001, 0.}]}}], {{{1., 0.}, {
                 0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{10.9, 0.07897381707726359}, 
                   Offset[{3, 0}, {10.9, 0.07897381707726359}]}, {{10.9, 
                   0.07897381707726359}, 
                   Offset[{-3, 0}, {10.9, 0.07897381707726359}]}, {{10.9, 
                   0.006621734710994462}, 
                   Offset[{3, 0}, {10.9, 0.006621734710994462}]}, {{10.9, 
                   0.006621734710994462}, 
                   Offset[{-3, 0}, {10.9, 0.006621734710994462}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{13.1, 0.2438493686074399}, 
                   Offset[{3, 0}, {13.1, 0.2438493686074399}]}, {{13.1, 
                   0.2438493686074399}, 
                   Offset[{-3, 0}, {13.1, 0.2438493686074399}]}, {{13.1, 
                   0.08867954785735338}, 
                   Offset[{3, 0}, {13.1, 0.08867954785735338}]}, {{13.1, 
                   0.08867954785735338}, 
                   Offset[{-3, 0}, {13.1, 0.08867954785735338}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{15.299999999999999`, 0.2634459796078018}, 
                   Offset[{3, 0}, {15.299999999999999`, 
                    0.2634459796078018}]}, {{15.299999999999999`, 
                   0.2634459796078018}, 
                   Offset[{-3, 0}, {15.299999999999999`, 
                    0.2634459796078018}]}, {{15.299999999999999`, 
                   0.05473890846629553}, 
                   Offset[{3, 0}, {15.299999999999999`, 
                    0.05473890846629553}]}, {{15.299999999999999`, 
                   0.05473890846629553}, 
                   Offset[{-3, 0}, {15.299999999999999`, 
                    0.05473890846629553}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{17.5, 0.11491998731049571`}, 
                   Offset[{3, 0}, {17.5, 0.11491998731049571`}]}, {{17.5, 
                   0.11491998731049571`}, 
                   Offset[{-3, 0}, {17.5, 0.11491998731049571`}]}, {{17.5, 
                   0.008565061791606605}, 
                   Offset[{3, 0}, {17.5, 0.008565061791606605}]}, {{17.5, 
                   0.008565061791606605}, 
                   Offset[{-3, 0}, {17.5, 0.008565061791606605}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{19.7, 0.10200939013362799`}, 
                   Offset[{3, 0}, {19.7, 0.10200939013362799`}]}, {{19.7, 
                   0.10200939013362799`}, 
                   Offset[{-3, 0}, {19.7, 0.10200939013362799`}]}, {{19.7, 
                   0.}, Offset[{3, 0}, {19.7, 0.}]}, {{19.7, 0.}, 
                   Offset[{-3, 0}, {19.7, 0.}]}}], {{{1., 0.}, {0., 1.}}, {0.,
                  0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{21.9, 0.16802454000704165`}, 
                   Offset[{3, 0}, {21.9, 0.16802454000704165`}]}, {{21.9, 
                   0.16802454000704165`}, 
                   Offset[{-3, 0}, {21.9, 0.16802454000704165`}]}, {{21.9, 
                   0.01155592306634734}, 
                   Offset[{3, 0}, {21.9, 0.01155592306634734}]}, {{21.9, 
                   0.01155592306634734}, 
                   Offset[{-3, 0}, {21.9, 0.01155592306634734}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{24.099999999999998`, 0.24023023342186997`}, 
                   Offset[{3, 0}, {24.099999999999998`, 
                    0.24023023342186997`}]}, {{24.099999999999998`, 
                   0.24023023342186997`}, 
                   Offset[{-3, 0}, {24.099999999999998`, 
                    0.24023023342186997`}]}, {{24.099999999999998`, 
                   0.07693319997507034}, 
                   Offset[{3, 0}, {24.099999999999998`, 
                    0.07693319997507034}]}, {{24.099999999999998`, 
                   0.07693319997507034}, 
                   Offset[{-3, 0}, {24.099999999999998`, 
                    0.07693319997507034}]}}], {{{1., 0.}, {0., 1.}}, {0., 
                 0.}}]},
              Antialiasing->False], 
             
             StyleBox[{
               GeometricTransformationBox[
                LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
               GeometricTransformationBox[
                LineBox[{{{26.299999999999997`, 0.04957553485823667}, 
                   Offset[{3, 0}, {26.299999999999997`, 
                    0.04957553485823667}]}, {{26.299999999999997`, 
                   0.04957553485823667}, 
                   Offset[{-3, 0}, {26.299999999999997`, 
                    0.04957553485823667}]}, {{26.299999999999997`, 0.}, 
                   Offset[{3, 0}, {26.299999999999997`, 0.}]}, {{
                   26.299999999999997`, 0.}, 
                   Offset[{-3, 0}, {26.299999999999997`, 0.}]}}], {{{1., 
                 0.}, {0., 1.}}, {0., 0.}}]},
              Antialiasing->False]}}},
          AspectRatio->Full,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0.07600000000000007, 0.},
          CoordinatesToolOptions:>{"DisplayFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& )},
          DisplayFunction->Identity,
          Epilog->{
            InsetBox[
             FormBox[
              FrameBox[
               StyleBox[
               "\"lung\"", FontFamily -> "Latin Modern Math", FontSize -> 24, 
                "", StripOnInput -> False], RoundingRadius -> 5, Background -> 
               GrayLevel[1], StripOnInput -> False], TraditionalForm], 
             Scaled[{0.05, 0.6}], 
             ImageScaled[{0, 0}]]},
          Frame->True,
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Automatic,
          FrameTicks->{{Automatic, Automatic}, {None, None}},
          GridLines->{{0}, {0}},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{375., 125.},
          LabelStyle->{FontFamily -> "Times"},
          PlotRange->{{All, All}, {0, 1}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {None, 
             Scaled[0.05]}},
          Ticks->{None, Automatic}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"]},
    {
     TagBox[GridBox[{
        {
         GraphicsBox[{
           {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.511], 
            Thickness[Small]}], {}, 
            {RGBColor[0.92, 0.488, 0.2432], EdgeForm[{Opacity[0.511], 
             Thickness[Small]}], 
             RectangleBox[{-101.4, 0}, {-101.2, 0.0004993009786299181},
              RoundingRadius->0], 
             RectangleBox[{-93., 0}, {-92.8, 0.0004993009786299181},
              RoundingRadius->0], 
             RectangleBox[{-80., 0}, {-79.8, 0.0004993009786299181},
              RoundingRadius->0], 
             RectangleBox[{-79.6, 0}, {-79.