% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationStatistics.R
\name{spatialCrossCorTorTest}
\alias{spatialCrossCorTorTest}
\title{Tests for significance of spatial cross correlation for two features using toroidal shift null model}
\usage{
spatialCrossCorTorTest(
  x,
  y,
  pos,
  k = 4,
  n = 1000,
  ncores = 1,
  plot = FALSE,
  ...
)
}
\arguments{
\item{x}{Feature 1 value}

\item{y}{Feature 2 value}

\item{pos}{Position}

\item{k}{Toroidal shift boxes}

\item{n}{Permutation iterations}

\item{ncores}{Number of cores for parallel processing}

\item{plot}{Plot permutated distribution}

\item{...}{Additional parameters to pass to histogram plotting}
}
\value{
P-value
}
\description{
Tests for significance of spatial cross correlation for two features using toroidal shift null model
}
\examples{
\dontrun{
data(mOB)
pos <- mOB$pos
gexp <- normalizeCounts(mOB$counts, log=FALSE, verbose=FALSE)
pv1 <- spatialCrossCorTorTest(gexp['Gpsm1',], gexp['Nrgn',], pos)
pv2 <- spatialCrossCorTorTest(gexp['Gpsm1',], gexp['Glul',], pos)
pv3 <- spatialCrossCorTorTest(gexp[1,], gexp[2,], pos)
}

}
