% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationStatistics.R
\name{spatialCrossCorMatrix}
\alias{spatialCrossCorMatrix}
\title{Calculates a spatial cross correlation for all pairs}
\usage{
spatialCrossCorMatrix(mat, weight)
}
\arguments{
\item{mat}{Matrix of feature values}

\item{weight}{Adjacency weight matrix}
}
\value{
Matrix of spatial cross correlationf or all pairs
}
\description{
Calculates a spatial cross correlation for all pairs
}
\examples{
data(mOB)
pos <- mOB$pos
weight <- getSpatialNeighbors(pos)
gexp <- normalizeCounts(mOB$counts, log=FALSE, verbose=FALSE)
sccMat <- spatialCrossCorMatrix(gexp[1:5,], weight)

}
