% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationStatistics.R
\name{spatialCrossCor}
\alias{spatialCrossCor}
\title{Calculates spatial cross correlation for two features}
\usage{
spatialCrossCor(x, y, weight)
}
\arguments{
\item{x}{Feature 1 value}

\item{y}{Feature 2 value}

\item{weight}{Adjacency weight matrix}
}
\value{
Spatial cross correlation statistic
}
\description{
Calculates spatial cross correlation for two features
}
\examples{
data(mOB)
pos <- mOB$pos
weight <- getSpatialNeighbors(pos)
gexp <- normalizeCounts(mOB$counts, log=FALSE, verbose=FALSE)
scc <- spatialCrossCor(gexp[1,], gexp[2,], weight)

}
