% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{signedLisaPlot}
\alias{signedLisaPlot}
\title{Signed LISA plot}
\usage{
signedLisaPlot(gexp, pos, weight, zlim = c(-2, 2), ...)
}
\arguments{
\item{gexp}{Feature value}

\item{pos}{Position matrix}

\item{weight}{Adjacency weight matrix}

\item{zlim}{Range for expression (default = c(-2,2))}

\item{...}{Additional plotting parameters}
}
\value{
signed LISA scores
}
\description{
Signed LISA plot
}
\examples{
data(mOB)
pos <- mOB$pos
gexp <- normalizeCounts(mOB$counts, log=FALSE, verbose=FALSE)['Camk4',]
W <- getSpatialNeighbors(pos)
signedLisaPlot(gexp, pos, W)

}
