% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{receptorLigandInfo}
\alias{receptorLigandInfo}
\title{Receptor ligand list}
\format{
Data frame corresponding to ncomms8866-s3.xlsx in Ramilowski et al (Nature Communications 2015)
}
\source{
\url{https://www.nature.com/articles/ncomms8866}
}
\usage{
receptorLigandInfo
}
\description{
Receptor ligand list
}
\examples{
data(receptorLigandInfo)
receptors <- unique(receptorLigandInfo$Receptor.ApprovedSymbol)
receptorLigandList <- lapply(receptors, function(rp) {
     vi <- receptorLigandInfo$Receptor.ApprovedSymbol == rp
     return(receptorLigandInfo[vi,]$Ligand.ApprovedSymbol)
})
names(receptorLigandList) <- receptors
ligands <- unique(receptorLigandInfo$Ligand.ApprovedSymbol)
ligandReceptorList <- lapply(ligands, function(rp) {
     vi <- receptorLigandInfo$Ligand.ApprovedSymbol == rp
     return(receptorLigandInfo[vi,]$Receptor.ApprovedSymbol)
})
names(ligandReceptorList) <- ligands
}
\keyword{datasets}
