% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotNetwork3D}
\alias{plotNetwork3D}
\title{Plot an adjacency weight matrix as a network in 3D}
\usage{
plotNetwork3D(
  pos,
  adj,
  col = "black",
  line.col = "grey",
  alpha = 0.5,
  line.power = 1,
  ...
)
}
\arguments{
\item{pos}{3D position information}

\item{adj}{Adjacency weight matrix}

\item{col}{Color of points}

\item{line.col}{Color of line}

\item{alpha}{Line color transparency}

\item{line.power}{Thickness of lines}

\item{...}{Additional plotting parameters}
}
\value{
None
}
\description{
Plot an adjacency weight matrix as a network in 3D
}
\examples{
\dontrun{
data(drosophila)
pos <- drosophila$pos
N <- getSpatialNeighbors(pos, filterDist = 10, verbose=TRUE)
plotNetwork3D(pos, N, size=1)
}

}
