% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{normalizeCounts}
\alias{normalizeCounts}
\title{Normalizes counts to CPM}
\usage{
normalizeCounts(
  counts,
  normFactor = NULL,
  depthScale = 1e+06,
  pseudo = 1,
  log = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{counts}{Read count matrix. The rows correspond to genes, columns
correspond to individual cells}

\item{normFactor}{Normalization factor such as cell size. If not provided
column sum as proxy for library size will be used}

\item{depthScale}{Depth scaling. Using a million for CPM (default: 1e6)}

\item{pseudo}{Pseudocount for log transform (default: 1)}

\item{log}{Whether to apply log transform}

\item{verbose}{Verbosity (default: TRUE)}
}
\value{
a normalized matrix
}
\description{
Normalizes raw counts to log10 counts per million with pseudocount
}
