% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationStatistics.R
\name{moranTest}
\alias{moranTest}
\title{Spatialy autocorrelation by Moran's I in C++}
\usage{
moranTest(x, weight, alternative = "greater")
}
\arguments{
\item{x}{Feature value}

\item{weight}{Adjacency weight matrix}

\item{alternative}{"two.sided", "less", or "greater"}
}
\value{
Observed Moran's I statistic, the expected statistic under the null hypothesis of no spatial autocorrelation, the standard deviation under the null hypothesis, and p-value
}
\description{
Spatialy autocorrelation by Moran's I in C++
}
\examples{
data(mOB)
pos <- mOB$pos
weight <- getSpatialNeighbors(pos)
gexp <- normalizeCounts(mOB$counts, log=FALSE, verbose=FALSE)['Camk4',]
moranTest(gexp, weight)

}
