% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationStatistics.R
\name{moranPermutationTest}
\alias{moranPermutationTest}
\title{Derive Moran's I p-value using permutation testing}
\usage{
moranPermutationTest(
  z,
  w,
  alternative = "greater",
  N = 10000,
  seed = 0,
  ncores = 1,
  plot = FALSE,
  ...
)
}
\arguments{
\item{z}{Feature value}

\item{w}{Adjacency weight matrix}

\item{alternative}{"two.sided", "less", or "greater"}

\item{N}{Number of permutations}

\item{seed}{Random seed}

\item{ncores}{Number of cores for parallel processing}

\item{plot}{Plot permutated distribution}

\item{...}{Additional parameters to pass to histogram plotting}
}
\value{
Observed Moran's I statistic, the expected statistic under the null hypothesis of no spatial autocorrelation, the standard deviation under the null hypothesis, permutation p-value, and number of permutations
}
\description{
Derive Moran's I p-value using permutation testing
}
\examples{
data(mOB)
pos <- mOB$pos
weight <- getSpatialNeighbors(pos)
gexp <- normalizeCounts(mOB$counts, log=FALSE, verbose=FALSE)['Camk4',]
moranPermutationTest(gexp, weight)

}
