% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{makeApp}
\alias{makeApp}
\title{Make a shiny app to interactively explore data}
\usage{
makeApp(
  pos,
  gexp,
  results,
  title,
  description = NULL,
  pal = colorRampPalette(c("blue", "grey", "red"))(100),
  scale = TRUE,
  zlim = c(-1.5, 1.5),
  ...
)
}
\arguments{
\item{pos}{Position}

\item{gexp}{Gene expression}

\item{results}{Dataframe of analysis results}

\item{title}{Page title}

\item{description}{Page description}

\item{pal}{Color ramp palette}

\item{scale}{Boolean of whether to scale and center expression values}

\item{zlim}{Color range}

\item{...}{Additional plotting parameters}
}
\value{
Shiny app
}
\description{
Make a shiny app to interactively explore data
}
\examples{
data(mOB)
pos <- mOB$pos
gexp <- as.matrix(normalizeCounts(mOB$counts, log=FALSE))
results <- mOB$results
results[, 1:3] <- round(results[, 1:3], digits=3)
makeApp(pos,
        gexp,
        results,
        title='mOB',
        description='Mouse Olfactory Bulb Spatial Transcriptomics Data')

}
