% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationStatistics.R
\name{interCellTypeSpatialCrossCor}
\alias{interCellTypeSpatialCrossCor}
\title{Tests for inter-cell-type spatial cross-correlation between gene A in group A and gene B in group B}
\usage{
interCellTypeSpatialCrossCor(gexpA, gexpB, groupA, groupB, weight)
}
\arguments{
\item{gexpA}{Expression for gene A}

\item{gexpB}{Expression for gene B}

\item{groupA}{Cells in group A}

\item{groupB}{Cells in group B}

\item{weight}{Adjacency weight matrix}
}
\value{
statistic of how well gene expression A in cells of group A are correlated in space with gene expression B in cells of group B
}
\description{
Tests for inter-cell-type spatial cross-correlation between gene A in group A and gene B in group B
}
\examples{
# Simulate data
set.seed(0)
N <- 100
pos <- cbind(rnorm(N), rnorm(N))
rownames(pos) <- paste0('cell', 1:N)
colnames(pos) <- c('x', 'y')
weight <- getSpatialNeighbors(pos)
ctA <- sample(rownames(pos), N/2)
ctB <- setdiff(rownames(pos), ctA)
gexpA <- pos[,2]
gexpA[ctB] <- 0
gexpB <- pos[,2]
gexpB[ctA] <- 0
#plotEmbedding(pos, col=gexpA)
#plotEmbedding(pos, col=gexpB)
interCellTypeSpatialCrossCor(gexpA, gexpB, ctA, ctB, weight)
cor(gexpA, gexpB) # compare

}
