% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{groupSigSpatialPatterns}
\alias{groupSigSpatialPatterns}
\title{Group significant spatial patterns}
\usage{
groupSigSpatialPatterns(
  pos,
  mat,
  scc,
  hclustMethod = "complete",
  trim = 0,
  deepSplit = 0,
  minClusterSize = 0,
  power = 1,
  plot = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{pos}{Position matrix where each row is a cell, columns are
x, y, (optionally z) coordinations}

\item{mat}{Gene expression matrix. Must be normalized such that correlations
will not be driven by technical artifacts}

\item{scc}{Spatial cross-correlation matrix}

\item{hclustMethod}{Linkage criteria for hclust()}

\item{trim}{Winsorization trim}

\item{deepSplit}{Tuning parameter for dynamic tree cutting cutreeDynamic()}

\item{minClusterSize}{Smallest gene cluster size}

\item{power}{Raise distance matrix to this power}

\item{plot}{Whether to plot}

\item{verbose}{Verbosity}

\item{...}{Additional plotting parameters}
}
\description{
Identify primary spatial patterns using hierarchical clustering and dynamic tree cutting
}
