% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{getSpatiallyInformedClusters}
\alias{getSpatiallyInformedClusters}
\title{Get spatially informed clusters by weighting graph-based clustering with spatial information}
\usage{
getSpatiallyInformedClusters(
  pcs,
  W,
  k,
  alpha = 1,
  beta = 1,
  method = igraph::cluster_louvain,
  verbose = FALSE,
  details = FALSE
)
}
\arguments{
\item{pcs}{A matrix of principal components or gene expression to assess transcriptional similarity}

\item{W}{Binary adjacency matrix}

\item{k}{Number of nearest neighbors for clustering}

\item{alpha}{Pseuodocount in edge weight 1/(alpha + as.vector(pweight)) + beta (default: 1)}

\item{beta}{Pseudocount in edge weight 1/(alpha + as.vector(pweight)) + beta (default: 1)}

\item{method}{igraph method for graph-based clustering (default: cluster_louvain)}

\item{verbose}{Verbosity}

\item{details}{Return detailed ouputs}
}
\value{
Factor of cluster annotations
}
\description{
Get spatially informed clusters by weighting graph-based clustering with spatial information
}
\examples{
# simulate 3 spatially but 2 transcriptionally distinct groups
N <- 300
M <- 30
# Three spatially distinct groups
pos1 <- cbind(rnorm(N/3), rnorm(N/3))
pos2 <- cbind(rnorm(N/3, 10), rnorm(N/3))
pos3 <- cbind(rnorm(N/3, 10), rnorm(N/3, 10))
pos <- rbind(rbind(pos1, pos2), pos3)
group <- c(rep(1, N/3), rep(2, N/3), rep(3, N/3))
names(group) <- rownames(pos) <- paste0('cell', 1:N)
# But two are transcriptionally identical
pcs12 <- matrix(rnorm(N*2/3*M), N*2/3, M)
pcs3 <- matrix(rnorm(N*1/3*M, 10), N*1/3, M)
pcs <- rbind(pcs12, pcs3)
pcs <- cbind(pcs, abs(10-pcs))
colnames(pcs) <- paste0('PC:', 1:ncol(pcs))
rownames(pcs) <- rownames(pos)
W <- getSpatialNeighbors(pos, filterDist=5)
com <- getSpatiallyInformedClusters(pcs, W, k=50, verbose=TRUE)

}
