% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getSpatialNeighbors}
\alias{getSpatialNeighbors}
\title{Adjacency weight matrix by Delaunay triangulations in 2D or 3D}
\usage{
getSpatialNeighbors(pos, filterDist = NA, binary = TRUE, verbose = FALSE)
}
\arguments{
\item{pos}{Position}

\item{filterDist}{Euclidean distance beyond which two cells cannot be considered neighbors}

\item{binary}{Boolean of whether to binarize output; otherwise Euclidean distances provided}

\item{verbose}{Verbosity}
}
\value{
Matrix where value represents distance between two spatially adjacent cells ie. neighbors
}
\description{
Adjacency weight matrix by Delaunay triangulations.
}
\examples{
data(mOB)
pos <- mOB$pos
w <- getSpatialNeighbors(pos)

}
