% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.R
\name{getOverdispersedGenes}
\alias{getOverdispersedGenes}
\title{Get overdispersed genes whose expression variance is higher than transcriptome-wide expectations
(Modified from SCDE/PAGODA2 code)}
\usage{
getOverdispersedGenes(
  counts,
  gam.k = 5,
  alpha = 0.05,
  plot = FALSE,
  use.unadjusted.pvals = FALSE,
  do.par = TRUE,
  max.adjusted.variance = 1000,
  min.adjusted.variance = 0.001,
  verbose = TRUE,
  details = FALSE
)
}
\arguments{
\item{counts}{Read count matrix. The rows correspond to genes, columns correspond to individual cells}

\item{gam.k}{Generalized additive model parameter; the dimension of the basis used to represent the smooth term (default: 5)}

\item{alpha}{Significance threshold (default: 0.05)}

\item{plot}{Whether to plot the results (default: FALSE)}

\item{use.unadjusted.pvals}{If true, will apply BH correction (default: FALSE)}

\item{do.par}{Whether to adjust par for plotting if plotting (default: TRUE)}

\item{max.adjusted.variance}{Ceiling on maximum variance after normalization to prevent infinites (default: 1e3)}

\item{min.adjusted.variance}{Floor on minimum variance after normalization (default: 1e-3)}

\item{verbose}{Verbosity (default: TRUE)}

\item{details}{If true, will return data frame of normalization parameters. Else will return normalized matrix.(default: FALSE)}
}
\value{
If details is true, will return data frame of normalization parameters. Else will return overdispersed genes.
}
\description{
Normalizes gene expression magnitudes to with respect to its ratio to the
transcriptome-wide expectation as determined by local regression on expression magnitude
}
\examples{
data(mOB)
ods <- getOverdispersedGenes(mOB$counts)

}
