% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{cleanCounts}
\alias{cleanCounts}
\title{Filter a counts matrix}
\usage{
cleanCounts(
  counts,
  min.lib.size = 1,
  max.lib.size = Inf,
  min.reads = 1,
  min.detected = 1,
  verbose = FALSE,
  plot = TRUE
)
}
\arguments{
\item{counts}{A sparse read count matrix. The rows correspond to genes,
columns correspond to individual cells}

\item{min.lib.size}{Minimum number of genes detected in a cell. Cells with
fewer genes will be removed (default: 1)}

\item{max.lib.size}{Maximum number of genes detected in a cell. Cells with
more genes will be removed (default: Inf)}

\item{min.reads}{Minimum number of reads per gene. Genes with fewer reads
will be removed (default: 1)}

\item{min.detected}{Minimum number of cells a gene must be seen in. Genes
not seen in a sufficient number of cells will be removed (default: 1)}

\item{verbose}{Verbosity (default: FALSE)}

\item{plot}{Whether to plot (default: TRUE)}
}
\value{
a filtered read count matrix
}
\description{
Filter a counts matrix based on gene (row) and cell (column)
     requirements.
}
