## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----load---------------------------------------------------------------------
suppressMessages(library(MERINGUE))

## ----sim, fig.width=6, fig.height=6-------------------------------------------
# 15x15 grid of cells
N <- 15^2
pos <- t(combn(c(1:sqrt(N), rev(1:sqrt(N))), 2))
pos <- unique(pos)
rownames(pos) <- paste0('cell', 1:N)
colnames(pos) <- c('x', 'y')
# jitter
posj <- jitter(pos, amount = 0.5)
# induce warping
posw <- 1.1^posj
# plot
par(mfrow=c(1,1), mar=rep(5,4))
plotEmbedding(posw,  main='Simulated Cells in Space')

## ----s1, fig.width=8, fig.height=4--------------------------------------------
par(mfrow=c(1,2), mar=rep(5,4))
gexp0 <- sort(abs(rnorm(N)))

set.seed(0)
gexp1 <- jitter(gexp0, amount = 0.5)
names(gexp1) <- rownames(pos)
plotEmbedding(posw, col=gexp1,  
              main='Gene1')

set.seed(1)
gexp2 <- jitter(gexp0, amount = 0.5)
names(gexp2) <- rownames(pos)
plotEmbedding(posw, col=gexp2,  
              main='Gene2')

## ----s11, fig.width=4, fig.height=4-------------------------------------------
# Plot
par(mfrow=c(1,1), mar=rep(5,4))
plot(gexp1, gexp2, 
     main='Scatterplot of\nGene1 versus Gene2')
abline(lm(gexp2~gexp1))

# Compute cross correlation
cor.test(gexp1, gexp2)

## ----s12, fig.width=4, fig.height=4-------------------------------------------
weight <- getSpatialNeighbors(posw, filterDist = 1)
plotNetwork(posw, weight)
spatialCrossCor(gexp1, gexp2, weight)
par(mfrow=c(1,1), mar=rep(5,4))
spatialCrossCorTest(gexp1, gexp2, weight, 
                    plot=TRUE)

## ----s2, fig.width=8, fig.height=4--------------------------------------------
par(mfrow=c(1,2), mar=rep(5,4))
num <- pos[,1]

vi <- (num %% 2) == 0
gexp3 <- as.numeric(vi)
gexp3 <- gexp3 * sort(abs(rnorm(length(gexp3)))+1)
names(gexp3) <- rownames(pos)
plotEmbedding(posw, col=gexp3,  
              main='Gene3')

vi <- (num %% 2) == 1
gexp4 <- as.numeric(vi)
gexp4 <- gexp4 * sort(abs(rnorm(length(gexp4)))+1)
names(gexp4) <- rownames(pos)
plotEmbedding(posw, col=gexp4,  
              main='Gene4')

## ----s21, fig.width=4, fig.height=4-------------------------------------------
# Plot
par(mfrow=c(1,1), mar=rep(5,4))
plot(gexp3, gexp4, 
     main='Scatterplot of\nGene3 versus Gene4')
abline(lm(gexp4~gexp3))

# Compute cross correlation
cor.test(gexp3, gexp4)

## ----s22, fig.width=4, fig.height=4-------------------------------------------
# Compute spatial cross correlation
spatialCrossCor(gexp3, gexp4, weight)
par(mfrow=c(1,1), mar=rep(5,4))
spatialCrossCorTest(gexp3, gexp4, weight, 
                    plot=TRUE)

## ----s23, fig.width=6, fig.height=6-------------------------------------------
ctA <- names(gexp3)[gexp3>0]
ctB <- names(gexp4)[gexp4>0]

# double check mutually exclusive
print(intersect(ctA, ctB))

# plot
par(mfrow=c(1,1), mar=rep(5,4))
cellType <- factor(rownames(posw) %in% ctA)
levels(cellType) <- c('ctB', 'ctA')
names(cellType) <- rownames(posw)
plotEmbedding(posw, groups=cellType, 
              show.legend=TRUE,  
              main='Cell Types in Space')

## ----s24, fig.width=6, fig.height=6-------------------------------------------
par(mfrow=c(1,1), mar=rep(5,4))
weightIc <- getInterCellTypeWeight(ctA, ctB, 
                                   weight, posw, 
                                   plot=TRUE, 
                                   main='Adjacency Weight Matrix\nBetween Cell-Types')
spatialCrossCor(gexp3, gexp4, weightIc)
interCellTypeSpatialCrossCor(gexp3, gexp4, ctA, ctB, weightIc)

spatialCrossCorTest(gexp3, gexp4, weightIc)

plotInterCellTypeSpatialCrossCor(gexp3, gexp4, ctA, ctB, weightIc,
                                 main='Spatial Cross Correlation')

## ----s31, fig.width=8, fig.height=4-------------------------------------------
par(mfrow=c(1,2), mar=rep(2,4))
set.seed(0)
gexp5 <- jitter(pos[,1], amount = 0.5)
names(gexp5) <- rownames(pos)
plotEmbedding(posw, col=gexp5,  
              main='Gene5')

set.seed(1)
gexp6 <- jitter(pos[,2], amount = 0.5)
names(gexp6) <- rownames(pos)
plotEmbedding(posw, col=gexp6,  
              main='Gene6')

## ----s32, fig.width=4, fig.height=4-------------------------------------------
# Plot
par(mfrow=c(1,1), mar=rep(2,4))
plot(gexp5, gexp6, main='Scatterplot of\nGene5 versus Gene6')
abline(lm(gexp5~gexp6))

# Compute cross correlation
cor.test(gexp5, gexp6)

## ----s33, fig.width=4, fig.height=4-------------------------------------------
# Compute spatial cross correlation
spatialCrossCor(gexp5, gexp6, weight)
par(mfrow=c(1,1), mar=rep(2,4))
spatialCrossCorTest(gexp5, gexp6, weight, 
                    plot=TRUE)

