## ---- options, include = FALSE------------------------------------------------
library(knitr)
opts_chunk$set(
    cache = FALSE,
    results = "hold"
)

## -----------------------------------------------------------------------------
library(MERINGUE)

## ---- drosophila-data, fig.width=8, fig.height=2------------------------------
data("drosophila")
pos <- drosophila$pos
gexp <- drosophila$mat

par(mfrow=c(1,3), mar=rep(2,4))
g <- 'apt'
plotEmbedding(pos[,c(1,2)], col=gexp[g,], main='X-Y')
plotEmbedding(pos[,c(3,2)], col=gexp[g,], main='Z-Y')
plotEmbedding(pos[,c(1,3)], col=gexp[g,], main='X-Z')

## ---- drosophila-network------------------------------------------------------
N <- getSpatialNeighbors(pos, filterDist = 10, verbose=TRUE)

## ---- drosophila-rgl, eval=FALSE----------------------------------------------
#  ## plot
#  require(rgl)
#  MERINGUE:::plotNetwork3D(pos, N, size=1)
#  ## save plot
#  rgl.snapshot(paste0(dir(), 'neighbors_3D-flat.png'))

## ---- drosophila-analyze------------------------------------------------------
## analyze
results <- getSpatialPatterns(gexp, N)
filter <- filterSpatialPatterns(mat = gexp, 
                                I = results, 
                                w = N,
                                alpha = 0.05,
                                details = TRUE, 
                                minPercentCells = 0.05)
print(head(filter))

## ---- drosophila-sub, fig.width=8, fig.height=3-------------------------------
par(mfrow=c(2,4), mar=rep(2,4))
## pair-rule genes
sub <- c('eve', 'prd', 'odd', 'run', 'ftz', 'trn', 'h', 'dpn')
invisible(lapply(sub, function(g) {
  plotEmbedding(pos[,c(1,3)], 
                col=gexp[g,], 
                main=g)
}))

## ---- drosophila-pattern, fig.width=8, fig.height=3---------------------------
scc <- spatialCrossCorMatrix(gexp[sub,], N)
method = 'ward.D'
par(mfrow=c(1,2), mar=rep(2,4))
ggroup <- groupSigSpatialPatterns(pos[,c(1,3)], gexp, scc,
                                    hclustMethod = method,
                                    deepSplit = 2,
                                    binSize = 50,
                                    power = 1)

## ---- drosophila-scc, fig.width=4, fig.height=4-------------------------------
# Look at pattern association
gcol <- rainbow(length(levels(ggroup$groups)), v=0.5)[ggroup$groups]
names(gcol) <- names(ggroup$groups)
heatmap(scc[ggroup$hc$labels, ggroup$hc$labels], scale='none', 
        Colv=as.dendrogram(ggroup$hc), 
        Rowv=as.dendrogram(ggroup$hc), 
        labCol=NA,
        RowSideColors=gcol[ggroup$hc$labels],
        ColSideColors=gcol[ggroup$hc$labels],
        col=colorRampPalette(c('white', 'black'))(100)
)

