% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmind_func.r
\name{get_prior}
\alias{get_prior}
\title{get prior CTS profile and covariance matrix from single-cell data}
\usage{
get_prior(sc, meta_sc)
}
\arguments{
\item{sc}{single-cell count matrix, gene x cell.}

\item{meta_sc}{data.frame for meta of cells (cell x features, including columns `sample` (sample ID), `cell_type`).}
}
\value{
A list containing
\item{profile}{CTS profile matrix (gene x cell type), in log2(CPM + 1) scale.}
\item{covariance}{CTS covariance matrix (gene x cell type x cell type).}
}
\description{
It calculates prior CTS profile and covariance matrix from single-cell data. The output can serve as hyper-parameters in bMIND.
Only genes with positive definite covariance matrix are outputted.
}
\references{
Wang, Jiebiao, Kathryn Roeder, and Bernie Devlin. "Bayesian estimation of cell-type-specific gene expression per bulk sample with prior derived from single-cell data." 
bioRxiv (2020).
}
