% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmind_de.r
\name{bMIND2}
\alias{bMIND2}
\title{The bMIND algorithm that considers Bayesian testing and covariates in the deconvolution model}
\usage{
bMIND2(
  bulk,
  frac = NULL,
  sample_id = NULL,
  ncore = NULL,
  profile = NULL,
  covariance = NULL,
  profile_co = NULL,
  covariance_co = NULL,
  profile_ca = NULL,
  covariance_ca = NULL,
  y = NULL,
  covariate = NULL,
  covariate_bulk = NULL,
  covariate_cts = NULL,
  noRE = T,
  np = F,
  nu = 50,
  nitt = 1300,
  burnin = 300,
  thin = 1,
  max_samp = 1e+06,
  frac_method = NULL,
  sc_count = NULL,
  sc_meta = NULL,
  signature = NULL,
  signature_case = NULL,
  case_bulk = NULL
)
}
\arguments{
\item{bulk}{bulk gene expression (gene x sample).}

\item{frac}{sample-specific cell type fraction (sample x cell type). If not specified (NULL), it will be estimated by non-negative least squares (NNLS) by 
providing signature matrix or Bisque by providing single-cell reference.}

\item{sample_id}{sample/subject ID vector. The default is that sample ID will be automatically provided for sample-level bMIND analysis, otherwise 
subject ID should be provided for subject-level bMIND analysis. Note that the subject ID will be sorted in the output and different sample_id would 
produce slightly different results in MCMCglmm.}

\item{ncore}{number of cores to run in parallel for providing sample/subject-level CTS estimates. The default is all available cores.}

\item{profile}{prior profile matrix (gene by cell type). Gene names should be in the same order of bulk, and cell type names should be in the same order
as frac.}

\item{covariance}{prior covariance array (gene by cell type by cell type). Gene names should be in the same order of bulk, and cell type names should be 
in the same order as frac. The default is 0.5 * Identity matrix for covariance of fixed effects.}

\item{profile_co}{prior profile matrix (gene by cell type) for controls.}

\item{covariance_co}{prior covariance array (gene by cell type by cell type) for controls.}

\item{profile_ca}{prior profile matrix (gene by cell type) for cases.}

\item{covariance_ca}{prior covariance array (gene by cell type by cell type) for cases.}

\item{y}{binary (0-1) outcome/phenotype vector for CTS DE analysis (0 for controls, 1 for cases). Should be the same 
length and order as sample_id or sort(unique(sample_id)) and row names of covariate.}

\item{covariate}{matrix for covariates to be adjusted in deconvolution model.}

\item{covariate_bulk}{colnames of covariate denoting variables that affect bulk expression}

\item{covariate_cts}{colnames of covariate denoting variables that affect CTS expression}

\item{noRE}{option to not calculate sample-level CTS estimates}

\item{np}{option to use non-informative prior}

\item{nu}{hyper-parameter for the prior covariance matrix. The larger the nu, the higher the certainty about the information in covariance, and the more 
informative is the distribution. The default is 50.}

\item{nitt}{number of MCMC iterations.}

\item{burnin}{burn-in iterations for MCMC.}

\item{thin}{thinning interval for MCMC.}

\item{max_samp}{max number of posterior samples to generate in testing. An adaptive procedure is used to increase nitt for those genes with p-values = 
1/number of posterior samples.}

\item{frac_method}{method to be used for estimating cell type fractions, either 'NNLS' or 'Bisque'. 
**All arguments starting from this one will be used to estimate cell-type fractions only, if those fractions are not pre-estimated.**}

\item{sc_count}{sc/snRNA-seq raw count as reference for Bisque to estimate cell type fractions.}

\item{sc_meta}{meta data frame for sc/snRNA-seq reference. A binary (0-1) column of 'case' is expected to indicate case/control status.}

\item{signature}{signature matrix for NNLS to estimate cell type fractions. Log2 transformation is recommended.}

\item{signature_case}{signature matrix from case samples for NNLS to estimate cell type fractions. Log2 transformation is recommended. If this is 
provided, signature will be treated as signature matrix for unaffected controls.}

\item{case_bulk}{case/control status vector for bulk data when using case/control reference to estimate the cell type fractions for case/control subjects
separately.}
}
\value{
A list containing the output of the bMIND algorithm (some genes with error message in MCMCglmm will not be outputted, 
e.g., with constant expression)
\item{A}{the deconvolved cell-type-specific gene expression (gene x cell type x sample).}
\item{SE}{the standard error of cell-type-specific gene expression (gene x cell type x sample).}
\item{coef}{the estimated coefficients matrix (gene x variables).}
\item{frac}{the estimated cell type fractions (sample x cell type).}
\item{pval}{the p-values of CTS-DE testing (gene x cell type).}
\item{qval}{the q-values of CTS-DE testing by BH FDR adjustment (gene x cell type).}
}
\description{
It calculates the Bayesian estimates of sample- and cell-type-specific (CTS) gene expression, via MCMC.
}
\references{
Wang, Jiebiao, Kathryn Roeder, and Bernie Devlin. "Bayesian estimation of cell-type-specific gene expression per bulk sample with prior 
derived from single-cell data." bioRxiv (2020).
}
