% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmind_func.r
\name{bMIND}
\alias{bMIND}
\title{The bMIND algorithm to estimate sample-level cell-type-specific expression and conduct CTS differential expression (DE) analysis}
\usage{
bMIND(
  bulk,
  frac = NULL,
  sample_id = NULL,
  ncore = NULL,
  profile = NULL,
  covariance = NULL,
  y = NULL,
  covariate = NULL,
  nu = 50,
  V_fe = NULL,
  nitt = 1300,
  burnin = 300,
  thin = 1,
  frac_method = NULL,
  sc_count = NULL,
  sc_meta = NULL,
  signature = NULL,
  signature_case = NULL,
  case_bulk = NULL
)
}
\arguments{
\item{bulk}{bulk gene expression (gene x sample). We recommend log2-transformed data for better performance, except when using Bisque to estimate 
cell type fractions, raw count is expected for Bisque. If the max(bulk) > 50, bulk will be transformed to log2(count per million + 1) 
before running bMIND.}

\item{frac}{sample-specific cell type fraction (sample x cell type). If not specified (NULL), it will be estimated by non-negative least squares (NNLS) by 
providing signature matrix or Bisque by providing single-cell reference.}

\item{sample_id}{sample/subject ID vector. The default is that sample ID will be automatically provided for sample-level bMIND analysis, otherwise 
subject ID should be provided for subject-level bMIND analysis. Note that the subject ID will be sorted in the output and different sample_id would 
produce slightly different results in MCMCglmm.}

\item{ncore}{number of cores to run in parallel for providing sample/subject-level CTS estimates. The default is all available cores.}

\item{profile}{prior profile matrix (gene by cell type). Gene names should be in the same order of bulk, and cell type names should be in the same order
as frac. If not specified (NULL), the bulk mean will be supplied.}

\item{covariance}{prior covariance array (gene by cell type by cell type). Gene names should be in the same order of bulk, and cell type names should be 
in the same order as frac. If not specified (NULL), bulk variance / sum(colMeans(frac)^2) will be supplied.}

\item{y}{binary (0-1) outcome/phenotype vector for CTS DE analysis (0 for controls, 1 for cases). Should be the same 
length and order as sample_id or sort(unique(sample_id)) and row names of covariate.}

\item{covariate}{matrix for covariates to be adjusted in CTS differential testing.}

\item{nu}{hyper-parameter for the prior covariance matrix. The larger the nu, the higher the certainty about the information in covariance, and the more 
informative is the distribution. The default is 50.}

\item{V_fe}{hyper-parameter for the covariance matrix of fixed-effects. The default is 0.5 * Identity matrix.}

\item{nitt}{number of MCMC iterations.}

\item{burnin}{burn-in iterations for MCMC.}

\item{thin}{thinning interval for MCMC.}

\item{frac_method}{method to be used for estimating cell type fractions, either 'NNLS' or 'Bisque'. 
**All arguments starting from this one will be used to estimate cell-type fractions only, if those fractions are not pre-estimated.**}

\item{sc_count}{sc/snRNA-seq raw count as reference for Bisque to estimate cell type fractions.}

\item{sc_meta}{meta data frame for sc/snRNA-seq reference. A binary (0-1) column of 'case' is expected to indicate case/control status.}

\item{signature}{signature matrix for NNLS to estimate cell type fractions. Log2 transformation is recommended.}

\item{signature_case}{signature matrix from case samples for NNLS to estimate cell type fractions. Log2 transformation is recommended. If this is 
provided, signature will be treated as signature matrix for unaffected controls.}

\item{case_bulk}{case/control status vector for bulk data when using case/control reference to estimate the cell type fractions for case/control subjects
separately.}
}
\value{
A list containing the output of the bMIND algorithm (some genes with error message in MCMCglmm will not be outputted, 
e.g., with constant expression)
\item{A}{the deconvolved cell-type-specific gene expression (gene x cell type x sample).}
\item{SE}{the standard error of cell-type-specific gene expression (gene x cell type x sample).}
\item{Sigma_c}{the covariance matrix for the deconvolved cell-type-specific expression (gene x cell type x cell type).}
\item{mu}{the estimated profile matrix (gene x cell type).}
\item{frac}{the estimated cell type fractions (sample x cell type).}
\item{pval}{the p-values of CTS-DE testing (cell type x gene).}
\item{qval}{the q-values of CTS-DE testing by MANOVA and BH FDR adjustment (cell type x gene).}
}
\description{
It calculates the Bayesian estimates of sample- and cell-type-specific (CTS) gene expression, via MCMC. For all input, dim names are recommended if applicable.
}
\examples{

data(example)
bulk = t(na.omit(apply(example$X, 1, as.vector)))
frac = na.omit(apply(example$W, 3, as.vector))
colnames(bulk) = rownames(frac) = 1:nrow(frac)

# with provided cell type fractions
deconv1 = bMIND(bulk, frac = frac, y = rbinom(n = nrow(frac), size = 1, prob = 0.5), 
    ncore = 2)

set.seed(1)
data(signature)
bulk = matrix(rnorm(300 * ncol(bulk), 10), ncol = ncol(bulk))
rownames(bulk) = rownames(signature)[1:nrow(bulk)]
colnames(bulk) = 1:ncol(bulk)

# without provided cell type fractions
deconv2 = bMIND(bulk, signature = signature[, -6], y = rbinom(n = nrow(frac), size = 1, 
    prob = 0.5), ncore = 2)

}
\references{
Wang, Jiebiao, Kathryn Roeder, and Bernie Devlin. "Bayesian estimation of cell-type-specific gene expression per bulk sample with prior derived from single-cell data." 
bioRxiv (2020).
}
