% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betabin.R
\name{xci_qc}
\alias{xci_qc}
\title{Plot cell fraction estimates}
\usage{
xci_qc(xci_dt, xcig = NULL, gene_names = "", color_col = NULL, xist = TRUE)
}
\arguments{
\item{xci_dt}{A \code{data.table}. The data to be used for the estimate
of skewing (i.e: limited to XCI genes).}

\item{xcig}{A \code{logical}. If \code{xci_dt} was not subset for training
genes only, setting xcig to TRUE will filter the data.}

\item{gene_names}{A \code{character}. If left blank, only genes that are
further than 20% away from the estimated skewing will be annotated, if set
to "all", all genes will be named. Set to "none" to remove all annotations.
Alternately, a \code{character} vector can be passed to annotate specific
genes of interest.}

\item{color_col}{A \code{character}. One of the columns of \code{xci_dt} can
be used to color genes.}

\item{xist}{A \code{logical}. Set to TRUE to display XIST in addition to
the training genes.}
}
\value{
The plot object in class \code{ggplot}.
}
\description{
Plot cell fraction estimates from list of known XCI genes
}
\details{
This function is mostly used in \code{betaBinomXI} to ensure that the cell
fraction is estimated properly. However, it can be used from the output
of \code{betaBinomXI} to troubleshoot estimation issues.
}
