% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sample_clean}
\alias{sample_clean}
\title{Sample estimates}
\usage{
sample_clean(bb_table)
}
\arguments{
\item{bb_table}{A \code{data.table}. The table returned by \code{betaBinomXI}.}
}
\value{
A \code{data.table} with one entry per sample and information
 regarding skewing and model fitting.
}
\description{
Return sample specific information from XCIR results
}
\examples{
library(data.table)
# Simulated data
dtf <- system.file("extdata/data2_vignette.tsv", package = "XCIR")
dt <- fread(dtf)
xcigf <- system.file("extdata/xcig_vignette.txt", package = "XCIR")
xcig <- readLines(xcigf)
# Run all models on the data
all <- betaBinomXI(dt, xciGenes = xcig)
# Simple BetaBinomial model and show histogram of skewing ~~A~~~
bb <- betaBinomXI(dt, xciGenes = xcig, model = "M0", hist = TRUE)

# Plotting fits
stoshow <- paste0("sample", c(31, 33, 35, 40)) #interesting samples
plotQC(all[sample \%in\% stoshow], xcig = xcig)

# Summarizing results
# Sample information
samps <- sample_clean(all)
# Gene-level predictions
xcistates <- getXCIstate(all)
}
