% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readXvcf.R
\name{readXVcf}
\alias{readXVcf}
\title{Read a vcf file to extract information relevant to XCI}
\usage{
readXVcf(vcf_file, haps_file = NULL, rm_homo = TRUE)
}
\arguments{
\item{vcf_file}{A \code{character}. The path to a vcf file.}

\item{haps_file}{A \code{character}. The path to a .haps file, the output of
the shapeit software.}

\item{rm_homo}{A \code{logical}. If set to TRUE, homozygous sites will be
removed from the output. Otherwise, they will be set to NA.}
}
\value{
A \code{data.table} object in long format of length sample*site.
}
\description{
Read a given vcf file and extract minimum information required for the
estimation of the expression of inactivated X chromosome.
}
\examples{
# Example workflow for documentation

vcff <- system.file("extdata/AD_example.vcf", package = "XCIR")
# Reading functions
vcf <- readRNASNPs(vcff)
vcf <- readVCF4(vcff)

# Annotation functions
# Using seqminer (requires additional annotation files)
\donttest{
anno <- addAnno(vcf)
}
# Using biomaRt
anno <- annotateX(vcf, mirror = "useast")
# Do not remove SNPs with 0 count on minor allele
anno0 <- annotateX(vcf, het_cutoff = 0, mirror = "useast")

# Summarise read counts per gene
# Assuming data is phased, reads can be summed across genes.
genic <- getGenicDP(anno, highest_expr = FALSE)
# Unphased data, select SNP with highest overall expression.
genic <- getGenicDP(anno, highest_expr = TRUE)
}
\references{
O. Delaneau, B. Howie, A. Cox, J-F. Zagury, J. Marchini (2013) Haplotype
estimation using sequence reads. American Journal of Human Genetics 93 (4)
 787-696.
}
