% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{readXCI}
\alias{readXCI}
\title{Read a list of known inactivated genes}
\usage{
readXCI(xciGenes = NULL)
}
\arguments{
\item{xciGenes}{A \code{character} or code{NULL}. By defaults, return a
vector of 177 genes. Other available choices include "cotton" and "intersect".
If a file path is given, the genes will be read from the file.}
}
\value{
A \code{character} vector of gene names.
}
\description{
Read a list of gene symbols of known inactivated genes
to be used as training set in \code{betaBinomXI}.
}
\details{
Both gene lists are extracted from Cotton et al. Genome
Biology (2013). doi:10.1186/gb-2013-14-11-r122. 
By default, the function returns a list that was used as training set in
the paper. This training set was generated as the intersection of the 
silenced genes identified by both expression (Carrel & Willard, 2005) and 
DNA methylation analysis (Cotton et al, 2011).
Setting it to "cotton" will instead return a list of 294 genes that were 
classified as inactivated by Cotton et al.
"intersect" is the most stringent list which returns the intersection of 
training and predicted set.
}
\examples{
xcig <- readXCI()
xcig <- readXCI("cotton")

}
\seealso{
\code{betaBinomXI}
}
