% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nophase.R
\name{readVCF4}
\alias{readVCF4}
\title{Read VCF file}
\usage{
readVCF4(vcf_file)
}
\arguments{
\item{vcf_file}{A \code{character}. The path to a vcf file.
The file must have the REF, ALT and AD fields.}
}
\value{
A \code{data.table} of allele specific read counts.
}
\description{
Read ASE from a VCF file
}
\examples{
# Example workflow for documentation

vcff <- system.file("extdata/AD_example.vcf", package = "XCIR")
# Reading functions
vcf <- readRNASNPs(vcff)
vcf <- readVCF4(vcff)

# Annotation functions
# Using seqminer (requires additional annotation files)
\donttest{
anno <- addAnno(vcf)
}
# Using biomaRt
anno <- annotateX(vcf, mirror = "useast")
# Do not remove SNPs with 0 count on minor allele
anno0 <- annotateX(vcf, het_cutoff = 0, mirror = "useast")

# Summarise read counts per gene
# Assuming data is phased, reads can be summed across genes.
genic <- getGenicDP(anno, highest_expr = FALSE)
# Unphased data, select SNP with highest overall expression.
genic <- getGenicDP(anno, highest_expr = TRUE)
}
