% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nophase.R
\name{readRNASNPs}
\alias{readRNASNPs}
\title{Read SNPs from RNA-Seq}
\usage{
readRNASNPs(vcf_file)
}
\arguments{
\item{vcf_file}{A \code{character}. The path to a vcf file.}
}
\value{
A \code{data.table} of allele specific read counts.
}
\description{
Read SNPs from RNA-Seq that have not been phased.
}
\details{
For phased samples, use \code{readXVcf}.
}
\examples{
# Example workflow for documentation

vcff <- system.file("extdata/AD_example.vcf", package = "XCIR")
# Reading functions
vcf <- readRNASNPs(vcff)
vcf <- readVCF4(vcff)

# Annotation functions
# Using seqminer (requires additional annotation files)
\donttest{
anno <- addAnno(vcf)
}
# Using biomaRt
anno <- annotateX(vcf, mirror = "useast")
# Do not remove SNPs with 0 count on minor allele
anno0 <- annotateX(vcf, het_cutoff = 0, mirror = "useast")

# Summarise read counts per gene
# Assuming data is phased, reads can be summed across genes.
genic <- getGenicDP(anno, highest_expr = FALSE)
# Unphased data, select SNP with highest overall expression.
genic <- getGenicDP(anno, highest_expr = TRUE)
}
