% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betabin.R
\name{plotQC}
\alias{plotQC}
\title{Plot QC}
\usage{
plotQC(xci_table, xcig = NULL, gene_names = "", showsd = TRUE, mean = TRUE)
}
\arguments{
\item{xci_table}{A \code{data.table}. Data to plot. Should be the results of
\code{betaBinomXI}, \code{getGenicDP} or one of the annotation functions.}

\item{xcig}{A \code{character} vector. The names of the genes in the
inactivated training set.}

\item{gene_names}{A \code{character}. If left blank, only genes that are
further than 20% away from the estimated skewing will be annotated, if set
to "all", all genes will be named. Set to "none" to remove all annotations.
Alternately, a \code{character} vector can be passed to annotate specific
genes of interest.}
}
\value{
An invisible plot object.
}
\description{
This plot shows QC for skewing estimates
}
\examples{
library(data.table)
# Simulated data
dtf <- system.file("extdata/data2_vignette.tsv", package = "XCIR")
dt <- fread(dtf)
xcigf <- system.file("extdata/xcig_vignette.txt", package = "XCIR")
xcig <- readLines(xcigf)
# Run all models on the data
all <- betaBinomXI(dt, xciGenes = xcig)
# Simple BetaBinomial model and show histogram of skewing ~~A~~~
bb <- betaBinomXI(dt, xciGenes = xcig, model = "M0", hist = TRUE)

# Plotting fits
stoshow <- paste0("sample", c(31, 33, 35, 40)) #interesting samples
plotQC(all[sample \%in\% stoshow], xcig = xcig)

# Summarizing results
# Sample information
samps <- sample_clean(all)
# Gene-level predictions
xcistates <- getXCIstate(all)
}
