% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.R
\name{mart_genes}
\alias{mart_genes}
\title{biomaRt genes}
\usage{
mart_genes(release = "hg38", chr = "X", mirror = NULL)
}
\arguments{
\item{release}{A \code{character}. Genome release name. Valid releases are
"hg19", "hg38".}

\item{chr}{A \code{character} or \code{NULL}. If specified, only the genes
from the specified chromosomes will be returned.}

\item{mirror}{A \code{character}. Passed to \code{useEnsembl}.}
}
\value{
A \code{data.table} with the gene symbol, start and end position
 and matching ensembl transcripts.
}
\description{
Extract gene informations from biomaRt
}
\examples{
#Chromosome X, hg19
egX <- mart_genes("hg19", mirror = "useast")
#Full genome, latest release
eg <- mart_genes("hg38", mirror = "useast")

}
