% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGenic.R
\name{getGenicDP}
\alias{getGenicDP}
\title{Get expression at the gene level}
\usage{
getGenicDP(dt_anno, highest_expr = TRUE, pool = FALSE, sex_file = NULL)
}
\arguments{
\item{dt_anno}{A \code{data.table}. An annotated table of read counts for
each SNP, as outputted by \code{addAnno}}

\item{highest_expr}{A \code{logical}. If FALSE, all SNPs will be
summed within each gene. This should only be set to FALSE when high quality
phasing information is available. If set to TRUE, the highest expressed SNP
(across both alleles) will be used instead.}

\item{pool}{A \code{logical}. Only works when \code{highest_expr} is set to
TRUE. If set to TRUE, the read counts are pooled accross all samples for
each SNP. Only use this if the samples come from the same subject}

\item{sex_file}{A \code{character} or NULL. Leave NULL if \code{dt_anno}
already contains a sex column. The file must contain at least a "sample"
and "sex" column with samples matching the samples in \code{dt_anno}.}
}
\value{
A \code{data.table}. That should be used as input for
 \code{betaBinomXI}.
}
\description{
Calculate allele specific expression for each gene in each sample, either
using only the most expressed SNP or using all SNPs (when phasing has been
performed).
}
\examples{
# Example workflow for documentation

vcff <- system.file("extdata/AD_example.vcf", package = "XCIR")
# Reading functions
vcf <- readRNASNPs(vcff)
vcf <- readVCF4(vcff)

# Annotation functions
# Using seqminer (requires additional annotation files)
\donttest{
anno <- addAnno(vcf)
}
# Using biomaRt
anno <- annotateX(vcf, mirror = "useast")
# Do not remove SNPs with 0 count on minor allele
anno0 <- annotateX(vcf, het_cutoff = 0, mirror = "useast")

# Summarise read counts per gene
# Assuming data is phased, reads can be summed across genes.
genic <- getGenicDP(anno, highest_expr = FALSE)
# Unphased data, select SNP with highest overall expression.
genic <- getGenicDP(anno, highest_expr = TRUE)
}
\seealso{
betaBinomXI, addAnno
}
