% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.R
\name{annotateX}
\alias{annotateX}
\title{Annotate}
\usage{
annotateX(
  xciObj,
  read_count_cutoff = 20,
  het_cutoff = 3,
  release = "hg38",
  mirror = NULL,
  verbose = FALSE
)
}
\arguments{
\item{xciObj}{A \code{data.table}. The data to be annotated must contain
at least the 4 columns 'GENE', 'POS', 'AD_hap1', 'AD_hap2'. Additional
columns will be preserved.}

\item{read_count_cutoff}{A \code{numeric}. Keep only SNPs that have at least
that many reads.}

\item{het_cutoff}{A \code{numeric}. Keep only SNPs that have at least that
many reads on each allele.}

\item{release}{A \code{character}. Genome release name. Valid releases are
"hg19", "hg38".}

\item{verbose}{A \code{logical}. If set to TRUE, print additional information.}
}
\value{
A \code{data.table}. The input table annotated with gene symbols
 and filtered for read counts.
}
\description{
Map positions of SNPs to genes extracted from biomaRt
}
\examples{
# Example workflow for documentation

vcff <- system.file("extdata/AD_example.vcf", package = "XCIR")
# Reading functions
vcf <- readRNASNPs(vcff)
vcf <- readVCF4(vcff)

# Annotation functions
# Using seqminer (requires additional annotation files)
\donttest{
anno <- addAnno(vcf)
}
# Using biomaRt
anno <- annotateX(vcf, mirror = "useast")
# Do not remove SNPs with 0 count on minor allele
anno0 <- annotateX(vcf, het_cutoff = 0, mirror = "useast")

# Summarise read counts per gene
# Assuming data is phased, reads can be summed across genes.
genic <- getGenicDP(anno, highest_expr = FALSE)
# Unphased data, select SNP with highest overall expression.
genic <- getGenicDP(anno, highest_expr = TRUE)
}
