% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.R
\name{addAnno}
\alias{addAnno}
\title{Read annotation file}
\usage{
addAnno(
  dt,
  seqm_annotate = TRUE,
  read_count_cutoff = 20,
  het_cutoff = 3,
  filter_pool_cutoff = 3,
  anno_file = NULL
)
}
\arguments{
\item{dt}{A \code{data.table} object.}

\item{seqm_annotate}{A \code{logical}. If set to TRUE, the \code{seqminer}
package will be used to annotate \code{dt}. If set to FALSE, this function
is a simple read count filtering step.}

\item{read_count_cutoff}{A \code{numeric}. Keep only SNPs that have at least
that many reads.}

\item{het_cutoff}{A \code{numeric}. Keep only SNPs that have at least that
many reads on each allele.}

\item{filter_pool_cutoff}{A \code{numeric}. Keep only SNPs that have at
least that many reads on each allele across all samples. See details for
more information.}

\item{anno_file}{A \code{character}. The name of a file containing annotations.}
}
\value{
A \code{data.table} object that contains allelic coverage, genotype
and annotations at the covered SNPs.
}
\description{
Read a given annotation file and merge it with a data.table containing the
relevant information to estimate inactivated X chromosome expression and
filter out SNPs with low coverage.
}
\details{
If the samples all have the same genotype (e.g: technical replicates),
\code{filter_pool_cutoff} will sum counts across samples and preserve SNPs
that pass the cutoff on both the reference and alternate alleles. This
may lead to samples with 0 counts on either allele but will prevent removing
heterozygous sites with lower coverage (especialliy in skewed samples).
\code{seqm_anno} will call \code{annotatePlain} from the \code{seqminer}
package. For convenience, \code{seqminer}'s necessary annotation sources can
be copied into \code{XCIR}'s extdata folder. See ?annotatePlain for more
information.
}
\examples{
# Example workflow for documentation

vcff <- system.file("extdata/AD_example.vcf", package = "XCIR")
# Reading functions
vcf <- readRNASNPs(vcff)
vcf <- readVCF4(vcff)

# Annotation functions
# Using seqminer (requires additional annotation files)
\donttest{
anno <- addAnno(vcf)
}
# Using biomaRt
anno <- annotateX(vcf, mirror = "useast")
# Do not remove SNPs with 0 count on minor allele
anno0 <- annotateX(vcf, het_cutoff = 0, mirror = "useast")

# Summarise read counts per gene
# Assuming data is phased, reads can be summed across genes.
genic <- getGenicDP(anno, highest_expr = FALSE)
# Unphased data, select SNP with highest overall expression.
genic <- getGenicDP(anno, highest_expr = TRUE)
}
\seealso{
\code{annotatePlain}
}
