% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{betaParam}
\alias{betaParam}
\title{Converting beta distribution parameters}
\usage{
betaParam(
  alpha = NULL,
  beta = NULL,
  m = NULL,
  theta = NULL,
  mu = NULL,
  sigma2 = NULL
)
}
\arguments{
\item{alpha}{A \code{numeric}. First shape parameter}

\item{beta}{A \code{numeric}. Second shape parameter}

\item{m}{A \code{numeric}. Mode}

\item{theta}{A \code{numeric}. Concentration}

\item{mu}{A \code{numeric}. Mean}

\item{sigma2}{A \code{numeric}. Variance}
}
\value{
A named \code{numeric} with all equivalent formulations of the distribution.
}
\description{
Convert parameter values between different beta distribution parametrization
}
\details{
This function needs two parameters that caracterise the beta distribution
(alpha and beta, mode and concentration or mean and variance) and returns
all parametrizations.
}
\examples{

betaParam(alpha = 5, beta = 5)
betaParam(m = 0.5, theta = 10)
betaParam(mu = 0.5, sigma2 = 0.02272727)

}
