# A ChIP-exo screen of 887 PCRP transcription factor antibodies in human cells


## William K. M. Lai<sup>1,2</sup>, Luca Mariani<sup>3</sup>, Gerson Rothschild<sup>5</sup>, Edwin R. Smith<sup>6</sup>, Bryan J. Venters<sup>7</sup>, Thomas R. Blanda<sup>1</sup>, Prashant K. Kuntala<sup>1</sup>, Kylie Bocklund<sup>1</sup>, Joshua Mairose<sup>1</sup>, Sarah N Dweikat<sup>1</sup>, Katelyn Mistretta<sup>1</sup>, Matthew J. Rossi<sup>1</sup>, Daniela Jame<sup>1</sup>, James T. Anderson<sup>3</sup>, Sabrina K. Phanor<sup>3</sup>, Wanwei Zhang<sup>5</sup>, Zibo Zhao<sup>6</sup>, Avani P. Shah<sup>6</sup>, Katherine Novitzky<sup>7</sup>, Eileen McAnarney<sup>7</sup>, Michael-C. Keogh<sup>7*</sup>, Ali Shilatifard<sup>6*</sup>, Uttiya Basu<sup>5*</sup>, Martha L. Bulyk<sup>3,4*</sup>, B. Franklin Pugh<sup>1,2*</sup>

1 Center for Eukaryotic Gene Regulation, Department of Biochemistry and Molecular Biology, The Pennsylvania State University, University Park, Pennsylvania 16802, USA

2 Department of Molecular Biology and Genetics, Cornell University, Ithaca, NY 14853

3 Division of Genetics, Department of Medicine; Brigham and Women’s Hospital and Harvard Medical School, Boston, MA 02115.

4 Department of Pathology; Brigham and Women’s Hospital and Harvard Medical School, Boston, MA 02115.

5 Department of Microbiology and Immunology, Vagelos College of Physicians and Surgeons, Columbia University, New York.

6 Simpson Querrey Center for Epigenetics and the Department of Biochemistry and Molecular Genetics, Northwestern University Feinberg School of Medicine, 303 East Superior Street, Chicago, IL 60611, USA

7 EpiCypher Inc., Durham NC 27709


### Correspondence:
### B. Franklin Pugh <fp265@cornell.edu>

### Martha L. Bulyk <mlbulyk@genetics.med.harvard.edu>

### Michael-C. Keogh <mkeogh@epicypher.com>

### Ali Shilatifard <ash@northwestern.edu>

### Uttiya Basu <ub2121@cumc.columbia.edu>


### [www.PCRPvalidation.org](http://www.PCRPvalidation.org/)
### ChIP-exo GEO ID : [GSE151287](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE151287)
### ChIP-seq GEO ID : [GSE152144](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE152144)
### CUT&RUN GEO ID : [GSE151326](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE151326)
### PBM data : UniPROBE database (accession ID: LAI20A)

## Overview
Antibodies offer a powerful means to interrogate specific proteins in a complex milieu. However, antibody availability and reliability are problematic and epitope tagging can be impractical in many cases. In an effort to improve this situation, the Protein Capture Reagents Program (PCRP) generated over a thousand renewable monoclonal antibodies (mAbs) against human-presumptive chromatin proteins. However, these reagents have not been widely field-tested. We therefore performed a screen to test their ability to enrich genomic regions via chromatin immunoprecipitation (ChIP) and a variety of orthogonal assays. 887 unique antibodies against 681 unique chromatin proteins, of which 605 are putative sequence-specific transcription factors (ssTFs), were assayed by ultra-high resolution ChIP-exo/seq, primarily in a single pass in one cell type (K562). Deep systematic analyses of the resulting ~1,200 ChIP-exo datasets can be found at www.PCRPvalidation.org. Subsets of PCRP mAbs were further tested in ChIP-seq, CUT&RUN, STORM super-resolution microscopy, immunoblots, and protein binding microarray (PBM) experiments. About 5% of the tested antibodies displayed target (i.e., cognate antigen) enrichment across at least one assay and are strong candidates for additional validation. An additional 34% produced ChIP-exo data that was distinct from background and thus warrant further testing. The remaining 61% were not substantially different from background, and likely require consideration of a much broader survey of cell types and/or assay optimizations. We demonstrate and discuss the metrics and challenges to antibody validation in chromatin-based assays.
