/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GraphUtils {

    public static class Graph<Node extends Comparable<Node>> {
        private final List<Node> nodes = new ArrayList<Node>();
        private final List<List<Integer>> neighbors = new ArrayList<List<Integer>>();

        public List<Node> getNodes() {
            return Collections.unmodifiableList(this.nodes);
        }

        public Map<Node, Integer> cluster() {
            int[] cluster = IntStream.range(0, this.nodes.size()).toArray();
            IntStream.range(0, this.neighbors.size()).forEach(i -> this.neighbors.get(i).stream().forEach(j -> Graph.joinNodes(cluster, j, i)));
            return this.nodes.stream().collect(Collectors.toMap(n -> n, n -> Graph.findRepNode(cluster, this.nodes.indexOf(n))));
        }

        private void addNeighbor(Integer fromNode, Integer toNode) {
            List<Integer> fromNodesNeighbors = this.neighbors.get(fromNode);
            if (!fromNodesNeighbors.contains(toNode)) {
                fromNodesNeighbors.add(toNode);
            }
        }

        public Integer addNode(Node singleton) {
            if (!this.nodes.contains(singleton)) {
                this.nodes.add(singleton);
                this.neighbors.add(new ArrayList());
            }
            return this.nodes.indexOf(singleton);
        }

        public void addEdge(Node left, Node right) {
            int leftIndex = this.addNode(left);
            if (left == right) {
                return;
            }
            int rightIndex = this.addNode(right);
            this.addNeighbor(leftIndex, rightIndex);
            this.addNeighbor(rightIndex, leftIndex);
        }

        private static void joinNodes(int[] grouping, int nodeId1, int nodeId2) {
            int repNode2;
            int repNode1 = Graph.findRepNode(grouping, nodeId1);
            if (repNode1 == (repNode2 = Graph.findRepNode(grouping, nodeId2))) {
                return;
            }
            grouping[repNode1] = repNode2;
        }

        private static int findRepNode(int[] grouping, int nodeId) {
            int representativeUmi = nodeId;
            while (representativeUmi != grouping[representativeUmi]) {
                representativeUmi = grouping[representativeUmi];
            }
            while (nodeId != representativeUmi) {
                int newUmiID = grouping[nodeId];
                grouping[nodeId] = representativeUmi;
                nodeId = newUmiID;
            }
            return representativeUmi;
        }
    }
}

