/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import picard.util.AdapterPair;
import picard.util.ClippingUtility;

public class AdapterMarker {
    public static final int DEFAULT_ADAPTER_LENGTH = 30;
    public static final int DEFAULT_PRUNE_ADAPTER_LIST_AFTER_THIS_MANY_ADAPTERS_SEEN = 100;
    public static final int DEFAULT_NUM_ADAPTERS_TO_KEEP = 1;
    private int thresholdForSelectingAdaptersToKeep = 100;
    private int numAdaptersToKeep = 1;
    private int minSingleEndMatchBases = 12;
    private int minPairMatchBases = 6;
    private double maxSingleEndErrorRate = 0.1;
    private double maxPairErrorRate = 0.1;
    private final AtomicReference<AdapterPair[]> adapters = new AtomicReference();
    private boolean thresholdReached = false;
    private int numAdaptersSeen = 0;
    private final CollectionUtil.DefaultingMap<AdapterPair, Integer> seenCounts = new CollectionUtil.DefaultingMap(Integer.valueOf(0));
    private Map<AdapterPair, List<SAMRecord>> preAdapterPrunedRecords = new HashMap<AdapterPair, List<SAMRecord>>();

    public AdapterMarker(AdapterPair ... originalAdapters) {
        this(30, originalAdapters);
    }

    public AdapterMarker(int adapterLength, AdapterPair ... originalAdapters) {
        ArrayList<TruncatedAdapterPair> truncatedAdapters = new ArrayList<TruncatedAdapterPair>();
        for (AdapterPair adapter : originalAdapters) {
            TruncatedAdapterPair truncatedAdapter = this.makeTruncatedAdapterPair(adapter, adapterLength);
            int matchingIndex = truncatedAdapters.indexOf(truncatedAdapter);
            if (matchingIndex == -1) {
                truncatedAdapters.add(truncatedAdapter);
                continue;
            }
            TruncatedAdapterPair matchingAdapter = (TruncatedAdapterPair)truncatedAdapters.get(matchingIndex);
            matchingAdapter.setName(matchingAdapter.getName() + "|" + adapter.getName());
        }
        this.adapters.set(truncatedAdapters.toArray(new AdapterPair[truncatedAdapters.size()]));
    }

    public int getNumAdaptersToKeep() {
        return this.numAdaptersToKeep;
    }

    public synchronized AdapterMarker setNumAdaptersToKeep(int numAdaptersToKeep) {
        if (numAdaptersToKeep <= 0) {
            throw new IllegalArgumentException(String.format("numAdaptersToKeep should be positive: %d", numAdaptersToKeep));
        }
        this.numAdaptersToKeep = numAdaptersToKeep;
        return this;
    }

    public int getThresholdForSelectingAdaptersToKeep() {
        return this.thresholdForSelectingAdaptersToKeep;
    }

    public synchronized AdapterMarker setThresholdForSelectingAdaptersToKeep(int thresholdForSelectingAdaptersToKeep) {
        this.thresholdForSelectingAdaptersToKeep = thresholdForSelectingAdaptersToKeep;
        return this;
    }

    public int getMinSingleEndMatchBases() {
        return this.minSingleEndMatchBases;
    }

    public synchronized AdapterMarker setMinSingleEndMatchBases(int minSingleEndMatchBases) {
        this.minSingleEndMatchBases = minSingleEndMatchBases;
        return this;
    }

    public int getMinPairMatchBases() {
        return this.minPairMatchBases;
    }

    public synchronized AdapterMarker setMinPairMatchBases(int minPairMatchBases) {
        this.minPairMatchBases = minPairMatchBases;
        return this;
    }

    public double getMaxSingleEndErrorRate() {
        return this.maxSingleEndErrorRate;
    }

    public synchronized AdapterMarker setMaxSingleEndErrorRate(double maxSingleEndErrorRate) {
        this.maxSingleEndErrorRate = maxSingleEndErrorRate;
        return this;
    }

    public double getMaxPairErrorRate() {
        return this.maxPairErrorRate;
    }

    public synchronized AdapterMarker setMaxPairErrorRate(double maxPairErrorRate) {
        this.maxPairErrorRate = maxPairErrorRate;
        return this;
    }

    public AdapterPair adapterTrimIlluminaSingleRead(SAMRecord read) {
        return this.adapterTrimIlluminaSingleRead(read, this.minSingleEndMatchBases, this.maxSingleEndErrorRate);
    }

    public AdapterPair adapterTrimIlluminaPairedReads(SAMRecord read1, SAMRecord read2) {
        return this.adapterTrimIlluminaPairedReads(read1, read2, this.minPairMatchBases, this.maxPairErrorRate);
    }

    public AdapterPair adapterTrimIlluminaSingleRead(SAMRecord read, int minMatchBases, double maxErrorRate) {
        AdapterPair ret = ClippingUtility.adapterTrimIlluminaSingleRead(read, minMatchBases, maxErrorRate, this.adapters.get());
        this.tallyAndFixAdapters(ret, read);
        return ret;
    }

    private void tallyAndFixAdapters(AdapterPair ret, SAMRecord ... reads) {
        if (ret != null && !this.thresholdReached) {
            if (!this.preAdapterPrunedRecords.containsKey(ret)) {
                this.preAdapterPrunedRecords.put(ret, new ArrayList());
            }
            Arrays.stream(reads).forEach(read -> this.preAdapterPrunedRecords.get(ret).add((SAMRecord)read));
            this.tallyFoundAdapter(ret);
        }
    }

    public AdapterPair adapterTrimIlluminaPairedReads(SAMRecord read1, SAMRecord read2, int minMatchBases, double maxErrorRate) {
        AdapterPair ret = ClippingUtility.adapterTrimIlluminaPairedReads(read1, read2, minMatchBases, maxErrorRate, this.adapters.get());
        this.tallyAndFixAdapters(ret, read1, read2);
        return ret;
    }

    AdapterPair[] getAdapters() {
        return this.adapters.get();
    }

    private TruncatedAdapterPair makeTruncatedAdapterPair(AdapterPair adapterPair, int adapterLength) {
        return new TruncatedAdapterPair("truncated " + adapterPair.getName(), this.substringAndRemoveTrailingNs(adapterPair.get3PrimeAdapterInReadOrder(), adapterLength), this.substringAndRemoveTrailingNs(adapterPair.get5PrimeAdapterInReadOrder(), adapterLength));
    }

    private String substringAndRemoveTrailingNs(String s, int length) {
        byte[] bytes = StringUtil.stringToBytes(s);
        for (length = Math.min(length, s.length()); length > 0 && SequenceUtil.isNoCall(bytes[length - 1]); --length) {
        }
        return s.substring(0, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tallyFoundAdapter(AdapterPair foundAdapter) {
        if (this.thresholdForSelectingAdaptersToKeep < 1) {
            return;
        }
        AdapterMarker adapterMarker = this;
        synchronized (adapterMarker) {
            this.seenCounts.put(foundAdapter, this.seenCounts.get(foundAdapter) + 1);
            ++this.numAdaptersSeen;
            if (this.numAdaptersSeen >= this.thresholdForSelectingAdaptersToKeep) {
                TreeMap sortedAdapters = new TreeMap(new Comparator<Integer>(){

                    @Override
                    public int compare(Integer integer, Integer integer2) {
                        return integer2.compareTo(integer);
                    }
                });
                for (Map.Entry entry : this.seenCounts.entrySet()) {
                    sortedAdapters.put((Integer)entry.getValue(), entry.getKey());
                }
                ArrayList bestAdapters = new ArrayList(this.numAdaptersToKeep);
                int countOfLastAdapter = Integer.MAX_VALUE;
                for (Map.Entry entry : sortedAdapters.entrySet()) {
                    if (bestAdapters.size() >= this.numAdaptersToKeep) {
                        if (entry.getKey() != countOfLastAdapter) break;
                        bestAdapters.add(entry.getValue());
                        continue;
                    }
                    countOfLastAdapter = entry.getKey();
                    bestAdapters.add(entry.getValue());
                }
                this.thresholdReached = true;
                this.adapters.set(bestAdapters.toArray(new AdapterPair[bestAdapters.size()]));
                this.fixAlreadySeenReads();
            }
        }
    }

    private void fixAlreadySeenReads() {
        Arrays.stream((Object[])this.adapters.get()).forEach(adapter -> this.preAdapterPrunedRecords.remove(adapter));
        this.preAdapterPrunedRecords.values().forEach(readList -> readList.parallelStream().forEach(read -> {
            Stream<SAMRecord.SAMTagAndValue> filterAttributes = read.getAttributes().stream().filter(tag -> !tag.tag.equals("XT"));
            read.clearAttributes();
            filterAttributes.forEach(tag -> read.setAttribute(tag.tag, tag.value));
        }));
        this.preAdapterPrunedRecords.clear();
    }

    private static final class TruncatedAdapterPair
    implements AdapterPair {
        String name;
        final String fivePrime;
        final String threePrime;
        final String fivePrimeReadOrder;
        final byte[] fivePrimeBytes;
        final byte[] threePrimeBytes;
        final byte[] fivePrimeReadOrderBytes;

        private TruncatedAdapterPair(String name, String threePrimeReadOrder, String fivePrimeReadOrder) {
            this.name = name;
            this.threePrime = threePrimeReadOrder;
            this.threePrimeBytes = StringUtil.stringToBytes(threePrimeReadOrder);
            this.fivePrimeReadOrder = fivePrimeReadOrder;
            this.fivePrimeReadOrderBytes = StringUtil.stringToBytes(fivePrimeReadOrder);
            this.fivePrime = SequenceUtil.reverseComplement(fivePrimeReadOrder);
            this.fivePrimeBytes = StringUtil.stringToBytes(this.fivePrime);
        }

        @Override
        public String get3PrimeAdapter() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapter() {
            return this.fivePrime;
        }

        @Override
        public String get3PrimeAdapterInReadOrder() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapterInReadOrder() {
            return this.fivePrimeReadOrder;
        }

        @Override
        public byte[] get3PrimeAdapterBytes() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytes() {
            return this.fivePrimeBytes;
        }

        @Override
        public byte[] get3PrimeAdapterBytesInReadOrder() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytesInReadOrder() {
            return this.fivePrimeReadOrderBytes;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TruncatedAdapterPair that = (TruncatedAdapterPair)o;
            if (!this.fivePrime.equals(that.fivePrime)) {
                return false;
            }
            return this.threePrime.equals(that.threePrime);
        }

        public int hashCode() {
            int result = this.fivePrime.hashCode();
            result = 31 * result + this.threePrime.hashCode();
            return result;
        }

        public String toString() {
            return "TruncatedAdapterPair{fivePrimeReadOrder='" + this.fivePrimeReadOrder + '\'' + ", threePrime='" + this.threePrime + '\'' + ", name='" + this.name + '\'' + '}';
        }
    }
}

