/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.util;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.DuplicateSet;
import htsjdk.samtools.DuplicateSetIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordDuplicateComparator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SecondaryOrSupplementarySkippingIterator;
import htsjdk.samtools.metrics.Header;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IterableAdapter;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import picard.PicardException;
import picard.sam.SamComparisonMetric;
import picard.sam.util.PrimaryAlignmentKey;
import picard.sam.util.SAMComparisonArgumentCollection;

public final class SamComparison {
    private final SamReader leftReader;
    private final SamReader rightReader;
    private boolean sequenceDictionariesDiffer;
    private final SamComparisonMetric comparisonMetric = new SamComparisonMetric();
    private final SAMComparisonArgumentCollection samComparisonArgumentCollection;
    private SortingCollection<SAMRecord> markDuplicatesCheckLeft;
    private SortingCollection<SAMRecord> markDuplicatesCheckRight;

    public SamComparison(SamReader leftReader, SamReader rightReader) {
        this(leftReader, rightReader, null, null, new SAMComparisonArgumentCollection());
    }

    public SamComparison(SamReader leftReader, SamReader rightReader, String leftName, String rightName, SAMComparisonArgumentCollection samComparisonArgumentCollection) {
        this.leftReader = leftReader;
        this.rightReader = rightReader;
        this.samComparisonArgumentCollection = samComparisonArgumentCollection;
        this.comparisonMetric.LEFT_FILE = leftName;
        this.comparisonMetric.RIGHT_FILE = rightName;
        if (samComparisonArgumentCollection.LENIENT_DUP) {
            this.setupLenientDuplicateChecking();
        }
        this.comparisonMetric.ARE_EQUAL = this.compareHeaders();
        this.comparisonMetric.ARE_EQUAL &= this.compareAlignmentsAndCatalogDuplicateMarkingDifferences();
        if (samComparisonArgumentCollection.LENIENT_DUP) {
            this.countLenientDuplicateMarkingDifferences();
        }
        this.comparisonMetric.ARE_EQUAL = this.comparisonMetric.ARE_EQUAL & this.comparisonMetric.DUPLICATE_MARKINGS_DIFFER == 0;
    }

    public void writeReport(File output) {
        this.writeReport(output, Collections.EMPTY_LIST);
    }

    public void writeReport(File output, List<Header> headers) {
        MetricsFile comparisonMetricFile = new MetricsFile();
        headers.forEach(comparisonMetricFile::addHeader);
        comparisonMetricFile.addAllMetrics(Collections.singletonList(this.comparisonMetric));
        comparisonMetricFile.write(output);
    }

    private void setupLenientDuplicateChecking() {
        SAMFileHeader leftHeader = this.leftReader.getFileHeader();
        SAMFileHeader rightHeader = this.rightReader.getFileHeader();
        SAMRecordDuplicateComparator leftDupComparator = new SAMRecordDuplicateComparator(Collections.singletonList(leftHeader));
        SAMRecordDuplicateComparator rightDupComparator = new SAMRecordDuplicateComparator(Collections.singletonList(rightHeader));
        this.markDuplicatesCheckLeft = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(leftHeader), leftDupComparator, SAMFileWriterImpl.getDefaultMaxRecordsInRam());
        this.markDuplicatesCheckRight = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(rightHeader), rightDupComparator, SAMFileWriterImpl.getDefaultMaxRecordsInRam());
    }

    private void countLenientDuplicateMarkingDifferences() {
        if (!this.samComparisonArgumentCollection.LENIENT_DUP) {
            throw new PicardException("Should only use countLenientDuplicateMarkingDifferences when in lenient duplicate marking mode.");
        }
        DuplicateSetIterator duplicateSetLeftIterator = new DuplicateSetIterator((CloseableIterator<SAMRecord>)this.markDuplicatesCheckLeft.iterator(), this.leftReader.getFileHeader(), true);
        DuplicateSetIterator duplicateSetRightIterator = new DuplicateSetIterator((CloseableIterator<SAMRecord>)this.markDuplicatesCheckRight.iterator(), this.rightReader.getFileHeader(), true);
        HashMap swapTargetsForLeftReps = new HashMap();
        for (DuplicateSet duplicateSet : new IterableAdapter<DuplicateSet>(duplicateSetLeftIterator)) {
            List<SAMRecord> allRecords = duplicateSet.getRecords(false);
            if (allRecords.size() <= 1) continue;
            Set nonRepReads = allRecords.stream().filter(SAMRecord::getDuplicateReadFlag).map(SAMRecord::getReadName).collect(Collectors.toSet());
            allRecords.stream().filter(r -> !r.getDuplicateReadFlag()).forEach(leftRep -> swapTargetsForLeftReps.put(leftRep.getReadName(), nonRepReads));
        }
        HashSet matchedSwaps = new HashSet();
        for (DuplicateSet duplicateSet : new IterableAdapter<DuplicateSet>(duplicateSetRightIterator)) {
            List<SAMRecord> records = duplicateSet.getRecords(false);
            if (records.size() > 1) {
                List nonRepSwapCandidates = records.stream().filter(SAMRecord::getDuplicateReadFlag).map(SAMRecord::getReadName).filter(swapTargetsForLeftReps::containsKey).collect(Collectors.toList());
                records.stream().filter(r -> !r.getDuplicateReadFlag()).map(SAMRecord::getReadName).filter(repRead -> !matchedSwaps.contains(repRead)).forEach(unMatchedRep -> nonRepSwapCandidates.stream().filter(nonRep -> !matchedSwaps.contains(nonRep) && ((Set)swapTargetsForLeftReps.get(nonRep)).contains(unMatchedRep)).findFirst().ifPresent(matchedRep -> matchedSwaps.addAll(Arrays.asList(matchedRep, unMatchedRep))));
            }
            this.comparisonMetric.DUPLICATE_MARKINGS_DIFFER = (int)((long)this.comparisonMetric.DUPLICATE_MARKINGS_DIFFER + records.stream().filter(n -> !matchedSwaps.contains(n.getReadName())).count());
        }
    }

    private boolean compareAlignmentsAndCatalogDuplicateMarkingDifferences() {
        if (!SamComparison.compareValues(this.leftReader.getFileHeader().getSortOrder(), this.rightReader.getFileHeader().getSortOrder(), "Sort Order")) {
            System.out.println("Cannot compare alignments if sort orders differ.");
            return false;
        }
        switch (this.leftReader.getFileHeader().getSortOrder()) {
            case coordinate: {
                if (this.sequenceDictionariesDiffer) {
                    System.out.println("Cannot compare coordinate-sorted SAM files because sequence dictionaries differ.");
                    return false;
                }
                return this.compareCoordinateSortedAlignments();
            }
            case queryname: {
                return this.compareQueryNameSortedAlignments();
            }
            case duplicate: 
            case unsorted: {
                return this.compareUnsortedAlignments();
            }
        }
        throw new PicardException(String.format("Unrecognized sort order (%s) found.", new Object[]{this.leftReader.getFileHeader().getSortOrder()}));
    }

    private boolean compareCoordinateSortedAlignments() {
        PrimaryAlignmentKey leftKey;
        SecondaryOrSupplementarySkippingIterator itLeft = new SecondaryOrSupplementarySkippingIterator(this.leftReader.iterator());
        SecondaryOrSupplementarySkippingIterator itRight = new SecondaryOrSupplementarySkippingIterator(this.rightReader.iterator());
        LinkedHashMap<PrimaryAlignmentKey, SAMRecord> leftUnmatched = new LinkedHashMap<PrimaryAlignmentKey, SAMRecord>();
        LinkedHashMap<PrimaryAlignmentKey, Object> rightUnmatched = new LinkedHashMap<PrimaryAlignmentKey, Object>();
        while (itLeft.hasCurrent()) {
            PrimaryAlignmentKey rightKey;
            Object right;
            SAMRecord nextLeft;
            SAMRecord left;
            if (!itRight.hasCurrent()) {
                while (itLeft.hasCurrent()) {
                    left = itLeft.getCurrent();
                    PrimaryAlignmentKey leftKey2 = new PrimaryAlignmentKey(left);
                    SAMRecord right2 = (SAMRecord)rightUnmatched.remove(leftKey2);
                    if (right2 == null) {
                        ++this.comparisonMetric.MISSING_RIGHT;
                    } else {
                        this.tallyAlignmentRecords(left, right2);
                    }
                    itLeft.advance();
                }
                break;
            }
            left = itLeft.getCurrent();
            LinkedHashMap<PrimaryAlignmentKey, SAMRecord> leftCurrentCoordinate = new LinkedHashMap<PrimaryAlignmentKey, SAMRecord>();
            leftKey = new PrimaryAlignmentKey(left);
            leftCurrentCoordinate.put(leftKey, left);
            while (itLeft.advance() && this.compareAlignmentCoordinates(left, nextLeft = itLeft.getCurrent()) == 0) {
                PrimaryAlignmentKey nextLeftKey = new PrimaryAlignmentKey(nextLeft);
                leftCurrentCoordinate.put(nextLeftKey, nextLeft);
            }
            while (itRight.hasCurrent() && this.compareAlignmentCoordinates(left, itRight.getCurrent()) > 0) {
                right = itRight.getCurrent();
                rightKey = new PrimaryAlignmentKey((SAMRecord)right);
                rightUnmatched.put(rightKey, right);
                itRight.advance();
            }
            while (itRight.hasCurrent() && this.compareAlignmentCoordinates(left, itRight.getCurrent()) == 0) {
                right = itRight.getCurrent();
                rightKey = new PrimaryAlignmentKey((SAMRecord)right);
                SAMRecord matchingLeft = (SAMRecord)leftCurrentCoordinate.remove(rightKey);
                if (matchingLeft != null) {
                    this.tallyAlignmentRecords(matchingLeft, (SAMRecord)right);
                } else {
                    rightUnmatched.put(rightKey, right);
                }
                itRight.advance();
            }
            for (SAMRecord samRecord : leftCurrentCoordinate.values()) {
                PrimaryAlignmentKey recordKey = new PrimaryAlignmentKey(samRecord);
                leftUnmatched.put(recordKey, samRecord);
            }
        }
        this.consumeUnmatchedRights(itRight, leftUnmatched);
        for (Map.Entry leftEntry : leftUnmatched.entrySet()) {
            leftKey = (PrimaryAlignmentKey)leftEntry.getKey();
            SAMRecord left = (SAMRecord)leftEntry.getValue();
            SAMRecord right = (SAMRecord)rightUnmatched.remove(leftKey);
            if (right == null) {
                ++this.comparisonMetric.MISSING_RIGHT;
                continue;
            }
            this.tallyAlignmentRecords(left, right);
        }
        this.comparisonMetric.MISSING_LEFT += rightUnmatched.size();
        return this.comparisonMetric.allVisitedAlignmentsEqual();
    }

    private int compareAlignmentCoordinates(SAMRecord left, SAMRecord right) {
        int rightReferenceIndex;
        String leftReferenceName = left.getReferenceName();
        String rightReferenceName = right.getReferenceName();
        if (leftReferenceName == null && rightReferenceName == null) {
            return 0;
        }
        if (leftReferenceName == null) {
            return 1;
        }
        if (rightReferenceName == null) {
            return -1;
        }
        int leftReferenceIndex = this.leftReader.getFileHeader().getSequenceIndex(leftReferenceName);
        if (leftReferenceIndex != (rightReferenceIndex = this.rightReader.getFileHeader().getSequenceIndex(rightReferenceName))) {
            return leftReferenceIndex - rightReferenceIndex;
        }
        return left.getAlignmentStart() - right.getAlignmentStart();
    }

    private boolean compareQueryNameSortedAlignments() {
        SecondaryOrSupplementarySkippingIterator it1 = new SecondaryOrSupplementarySkippingIterator(this.leftReader.iterator());
        SecondaryOrSupplementarySkippingIterator it2 = new SecondaryOrSupplementarySkippingIterator(this.rightReader.iterator());
        while (it1.hasCurrent()) {
            PrimaryAlignmentKey rightKey;
            PrimaryAlignmentKey leftKey;
            int cmp;
            if (!it2.hasCurrent()) {
                this.comparisonMetric.MISSING_RIGHT += this.countRemaining(it1);
            }
            if ((cmp = (leftKey = new PrimaryAlignmentKey(it1.getCurrent())).compareTo(rightKey = new PrimaryAlignmentKey(it2.getCurrent()))) < 0) {
                ++this.comparisonMetric.MISSING_RIGHT;
                it1.advance();
                continue;
            }
            if (cmp > 0) {
                ++this.comparisonMetric.MISSING_LEFT;
                it2.advance();
                continue;
            }
            this.tallyAlignmentRecords(it1.getCurrent(), it2.getCurrent());
            it1.advance();
            it2.advance();
        }
        if (it2.hasCurrent()) {
            this.comparisonMetric.MISSING_LEFT += this.countRemaining(it2);
        }
        return this.comparisonMetric.allVisitedAlignmentsEqual();
    }

    private boolean compareUnsortedAlignments() {
        SecondaryOrSupplementarySkippingIterator it1 = new SecondaryOrSupplementarySkippingIterator(this.leftReader.iterator());
        SecondaryOrSupplementarySkippingIterator it2 = new SecondaryOrSupplementarySkippingIterator(this.rightReader.iterator());
        LinkedHashMap<PrimaryAlignmentKey, SAMRecord> leftUnmatched = new LinkedHashMap<PrimaryAlignmentKey, SAMRecord>();
        this.consumeAll(it1, (alignmentRecord, primaryKey) -> leftUnmatched.put((PrimaryAlignmentKey)primaryKey, (SAMRecord)alignmentRecord));
        this.consumeUnmatchedRights(it2, leftUnmatched);
        this.comparisonMetric.MISSING_RIGHT += leftUnmatched.size();
        return this.comparisonMetric.allVisitedAlignmentsEqual();
    }

    private void consumeUnmatchedRights(SecondaryOrSupplementarySkippingIterator rightIt, Map<PrimaryAlignmentKey, SAMRecord> leftUnmatched) {
        this.consumeAll(rightIt, (alignmentRecord, primaryKey) -> {
            SAMRecord left = (SAMRecord)leftUnmatched.remove(primaryKey);
            if (left != null) {
                this.tallyAlignmentRecords(left, (SAMRecord)alignmentRecord);
            } else {
                ++this.comparisonMetric.MISSING_LEFT;
            }
        });
    }

    private void consumeAll(SecondaryOrSupplementarySkippingIterator it, BiConsumer<SAMRecord, PrimaryAlignmentKey> recordKeyHandler) {
        while (it.hasCurrent()) {
            SAMRecord record = it.getCurrent();
            recordKeyHandler.accept(record, new PrimaryAlignmentKey(record));
            it.advance();
        }
    }

    private int countRemaining(SecondaryOrSupplementarySkippingIterator it) {
        int i = 0;
        while (it.hasCurrent()) {
            it.advance();
            ++i;
        }
        return i;
    }

    private AlignmentComparison compareAlignmentRecords(SAMRecord s1, SAMRecord s2) {
        if (s1.getReadUnmappedFlag() && s2.getReadUnmappedFlag()) {
            return AlignmentComparison.UNMAPPED_BOTH;
        }
        if (s1.getReadUnmappedFlag()) {
            return AlignmentComparison.UNMAPPED_LEFT;
        }
        if (s2.getReadUnmappedFlag()) {
            return AlignmentComparison.UNMAPPED_RIGHT;
        }
        if (this.alignmentsMatch(s1, s2)) {
            return AlignmentComparison.MAPPINGS_MATCH;
        }
        return AlignmentComparison.MAPPINGS_DIFFER;
    }

    private boolean alignmentsMatch(SAMRecord s1, SAMRecord s2) {
        return s1.getReferenceName().equals(s2.getReferenceName()) && s1.getAlignmentStart() == s2.getAlignmentStart() && s1.getReadNegativeStrandFlag() == s1.getReadNegativeStrandFlag() || this.samComparisonArgumentCollection.LENIENT_LOW_MQ_ALIGNMENT && s1.getMappingQuality() <= this.samComparisonArgumentCollection.LOW_MQ_THRESHOLD && s2.getMappingQuality() <= this.samComparisonArgumentCollection.LOW_MQ_THRESHOLD || this.samComparisonArgumentCollection.LENIENT_UNKNOWN_MQ_ALIGNMENT && s1.getMappingQuality() == 255 && s2.getMappingQuality() == 255;
    }

    private void tallyAlignmentRecords(SAMRecord s1, SAMRecord s2) {
        if (!s1.getReadName().equals(s2.getReadName())) {
            throw new PicardException("Read names do not match: " + s1.getReadName() + " : " + s2.getReadName());
        }
        this.catalogDuplicateDifferences(s1, s2);
        AlignmentComparison comp = this.compareAlignmentRecords(s1, s2);
        this.comparisonMetric.updateMetric(comp);
    }

    private void catalogDuplicateDifferences(SAMRecord s1, SAMRecord s2) {
        if (s1.getDuplicateReadFlag() != s2.getDuplicateReadFlag()) {
            if (this.samComparisonArgumentCollection.LENIENT_DUP) {
                this.markDuplicatesCheckLeft.add(s1);
                this.markDuplicatesCheckRight.add(s2);
            } else {
                ++this.comparisonMetric.DUPLICATE_MARKINGS_DIFFER;
            }
        }
    }

    private boolean compareHeaders() {
        SAMFileHeader h1 = this.leftReader.getFileHeader();
        SAMFileHeader h2 = this.rightReader.getFileHeader();
        boolean ret = SamComparison.compareValues(h1.getVersion(), h2.getVersion(), "File format version");
        ret = SamComparison.compareValues(h1.getCreator(), h2.getCreator(), "File creator") && ret;
        boolean bl = ret = SamComparison.compareValues(h1.getAttribute("SO"), h2.getAttribute("SO"), "Sort order") && ret;
        if (!this.compareSequenceDictionaries(h1, h2)) {
            ret = false;
            this.sequenceDictionariesDiffer = true;
        }
        boolean bl2 = ret = SamComparison.compareReadGroups(h1, h2) && ret;
        if (!this.samComparisonArgumentCollection.LENIENT_HEADER) {
            ret = this.compareProgramRecords(h1, h2) && ret;
        }
        return ret;
    }

    private boolean compareProgramRecords(SAMFileHeader h1, SAMFileHeader h2) {
        List<SAMProgramRecord> l1 = h1.getProgramRecords();
        List<SAMProgramRecord> l2 = h2.getProgramRecords();
        if (!SamComparison.compareValues(l1.size(), l2.size(), "Number of program records")) {
            return false;
        }
        boolean ret = true;
        for (int i = 0; i < l1.size(); ++i) {
            ret = SamComparison.compareProgramRecord(l1.get(i), l2.get(i)) && ret;
        }
        return ret;
    }

    private static boolean compareProgramRecord(SAMProgramRecord programRecord1, SAMProgramRecord programRecord2) {
        String[] attributes;
        if (programRecord1 == null && programRecord2 == null) {
            return true;
        }
        if (programRecord1 == null) {
            SamComparison.reportDifference("null", programRecord2.getProgramGroupId(), "Program Record");
            return false;
        }
        if (programRecord2 == null) {
            SamComparison.reportDifference(programRecord1.getProgramGroupId(), "null", "Program Record");
            return false;
        }
        boolean ret = SamComparison.compareValues(programRecord1.getProgramGroupId(), programRecord2.getProgramGroupId(), "Program Name");
        for (String attribute : attributes = new String[]{"VN", "CL"}) {
            ret = SamComparison.compareValues(programRecord1.getAttribute(attribute), programRecord2.getAttribute(attribute), attribute + " Program Record attribute") && ret;
        }
        return ret;
    }

    private static boolean compareReadGroups(SAMFileHeader h1, SAMFileHeader h2) {
        List<SAMReadGroupRecord> l1 = h1.getReadGroups();
        List<SAMReadGroupRecord> l2 = h2.getReadGroups();
        if (!SamComparison.compareValues(l1.size(), l2.size(), "Number of read groups")) {
            return false;
        }
        boolean ret = true;
        for (int i = 0; i < l1.size(); ++i) {
            ret = SamComparison.compareReadGroup(l1.get(i), l2.get(i)) && ret;
        }
        return ret;
    }

    private static boolean compareReadGroup(SAMReadGroupRecord samReadGroupRecord1, SAMReadGroupRecord samReadGroupRecord2) {
        String[] attributes;
        boolean ret = SamComparison.compareValues(samReadGroupRecord1.getReadGroupId(), samReadGroupRecord2.getReadGroupId(), "Read Group ID");
        ret = SamComparison.compareValues(samReadGroupRecord1.getSample(), samReadGroupRecord2.getSample(), "Sample for read group " + samReadGroupRecord1.getReadGroupId()) && ret;
        ret = SamComparison.compareValues(samReadGroupRecord1.getLibrary(), samReadGroupRecord2.getLibrary(), "Library for read group " + samReadGroupRecord1.getReadGroupId()) && ret;
        for (String attribute : attributes = new String[]{"DS", "PU", "PI", "CN", "DT", "PL"}) {
            ret = SamComparison.compareValues(samReadGroupRecord1.getAttribute(attribute), samReadGroupRecord2.getAttribute(attribute), attribute + " for read group " + samReadGroupRecord1.getReadGroupId()) && ret;
        }
        return ret;
    }

    private boolean compareSequenceDictionaries(SAMFileHeader h1, SAMFileHeader h2) {
        List<SAMSequenceRecord> s1 = h1.getSequenceDictionary().getSequences();
        List<SAMSequenceRecord> s2 = h2.getSequenceDictionary().getSequences();
        if (s1.size() != s2.size()) {
            SamComparison.reportDifference(s1.size(), s2.size(), "Length of sequence dictionaries");
            return false;
        }
        boolean ret = true;
        for (int i = 0; i < s1.size(); ++i) {
            ret = this.compareSequenceRecord(s1.get(i), s2.get(i), i + 1) && ret;
        }
        return ret;
    }

    private boolean compareSequenceRecord(SAMSequenceRecord sequenceRecord1, SAMSequenceRecord sequenceRecord2, int which) {
        if (!sequenceRecord1.getSequenceName().equals(sequenceRecord2.getSequenceName())) {
            SamComparison.reportDifference(sequenceRecord1.getSequenceName(), sequenceRecord2.getSequenceName(), "Name of sequence record " + which);
            return false;
        }
        boolean ret = SamComparison.compareValues(sequenceRecord1.getSequenceLength(), sequenceRecord2.getSequenceLength(), "Length of sequence " + sequenceRecord1.getSequenceName());
        if (!this.samComparisonArgumentCollection.LENIENT_HEADER) {
            ret = SamComparison.compareValues(sequenceRecord1.getSpecies(), sequenceRecord2.getSpecies(), "Species of sequence " + sequenceRecord1.getSequenceName()) && ret;
            ret = SamComparison.compareValues(sequenceRecord1.getAssembly(), sequenceRecord2.getAssembly(), "Assembly of sequence " + sequenceRecord1.getSequenceName()) && ret;
            ret = SamComparison.compareValues(sequenceRecord1.getAttribute("M5"), sequenceRecord2.getAttribute("M5"), "MD5 of sequence " + sequenceRecord1.getSequenceName()) && ret;
            ret = SamComparison.compareValues(sequenceRecord1.getAttribute("UR"), sequenceRecord2.getAttribute("UR"), "URI of sequence " + sequenceRecord1.getSequenceName()) && ret;
        }
        return ret;
    }

    private static <T> boolean compareValues(T v1, T v2, String label) {
        boolean eq = Objects.equals(v1, v2);
        if (eq) {
            return true;
        }
        SamComparison.reportDifference(v1, v2, label);
        return false;
    }

    private static void reportDifference(String s1, String s2, String label) {
        System.out.println(label + " differs.");
        System.out.println("File 1: " + s1);
        System.out.println("File 2: " + s2);
    }

    private static void reportDifference(Object o1, Object o2, String label) {
        if (o1 == null) {
            o1 = "null";
        }
        if (o2 == null) {
            o2 = "null";
        }
        SamComparison.reportDifference(o1.toString(), o2.toString(), label);
    }

    public int getMappingsMatch() {
        return this.comparisonMetric.MAPPINGS_MATCH;
    }

    public int getUnmappedBoth() {
        return this.comparisonMetric.UNMAPPED_BOTH;
    }

    public int getUnmappedLeft() {
        return this.comparisonMetric.UNMAPPED_LEFT;
    }

    public int getUnmappedRight() {
        return this.comparisonMetric.UNMAPPED_RIGHT;
    }

    public int getMappingsDiffer() {
        return this.comparisonMetric.MAPPINGS_DIFFER;
    }

    public int getMissingLeft() {
        return this.comparisonMetric.MISSING_LEFT;
    }

    public int getMissingRight() {
        return this.comparisonMetric.MISSING_RIGHT;
    }

    public int getDuplicateMarkingsDiffer() {
        return this.comparisonMetric.DUPLICATE_MARKINGS_DIFFER;
    }

    public boolean areEqual() {
        return this.comparisonMetric.ARE_EQUAL;
    }

    public static enum AlignmentComparison {
        UNMAPPED_BOTH,
        UNMAPPED_LEFT,
        UNMAPPED_RIGHT,
        MAPPINGS_DIFFER,
        MAPPINGS_MATCH;

    }
}

