/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.DuplicateSet;
import htsjdk.samtools.DuplicateSetIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordDuplicateComparator;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IterableAdapter;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.MarkDuplicates;
import picard.sam.markduplicates.MarkDuplicatesWithMateCigar;
import picard.sam.markduplicates.util.AbstractMarkDuplicatesCommandLineProgram;
import picard.sam.markduplicates.util.LibraryIdGenerator;
import picard.sam.markduplicates.util.ReadEnds;

@DocumentedFeature
@ExperimentalFeature
@CommandLineProgramProperties(summary="Examines aligned records in the supplied SAM or BAM file to locate duplicate molecules. All records are then written to the output file with the duplicate records flagged.", oneLineSummary="Examines aligned records in the supplied SAM or BAM file to locate duplicate molecules.", programGroup=ReadDataManipulationProgramGroup.class)
public class SimpleMarkDuplicatesWithMateCigar
extends MarkDuplicates {
    private final Log log = Log.getInstance(MarkDuplicatesWithMateCigar.class);

    private static boolean isPairedAndBothMapped(SAMRecord record) {
        return record.getReadPairedFlag() && !record.getReadUnmappedFlag() && !record.getMateUnmappedFlag();
    }

    @Override
    protected int doWork() {
        IOUtil.assertInputsAreValid(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        IOUtil.assertFileIsWritable(this.METRICS_FILE);
        AbstractMarkDuplicatesCommandLineProgram.SamHeaderAndIterator headerAndIterator = this.openInputs(true);
        SAMFileHeader header = headerAndIterator.header;
        SAMFileHeader outputHeader = header.clone();
        if (outputHeader.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException("This program requires inputs in coordinate SortOrder");
        }
        this.COMMENT.forEach(outputHeader::addComment);
        Map<String, String> chainedPgIds = this.getChainedPgIds(outputHeader);
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(outputHeader, false, this.OUTPUT);
        SAMRecordDuplicateComparator comparator = new SAMRecordDuplicateComparator(Collections.singletonList(headerAndIterator.header));
        comparator.setScoringStrategy(this.DUPLICATE_SCORING_STRATEGY);
        CloseableIterator<DuplicateSet> iterator = this.getDuplicateSetIterator(headerAndIterator, comparator);
        ProgressLogger progress = new ProgressLogger(this.log, 1000000, "Read");
        int numDuplicates = 0;
        this.libraryIdGenerator = new LibraryIdGenerator(headerAndIterator.header);
        for (DuplicateSet duplicateSet : new IterableAdapter<DuplicateSet>(iterator)) {
            SAMRecord representative = duplicateSet.getRepresentative();
            boolean doOpticalDuplicateTracking = this.READ_NAME_REGEX != null && SimpleMarkDuplicatesWithMateCigar.isPairedAndBothMapped(representative) && representative.getFirstOfPairFlag();
            HashSet<String> duplicateReadEndsSeen = new HashSet<String>();
            ArrayList<ReadEndsForSimpleMarkDuplicatesWithMateCigar> duplicateReadEnds = new ArrayList<ReadEndsForSimpleMarkDuplicatesWithMateCigar>();
            for (SAMRecord record : duplicateSet.getRecords()) {
                String library = LibraryIdGenerator.getLibraryName(header, record);
                DuplicationMetrics metrics = this.libraryIdGenerator.getMetricsByLibrary(library);
                if (metrics == null) {
                    metrics = new DuplicationMetrics();
                    metrics.LIBRARY = library;
                    this.libraryIdGenerator.addMetricsByLibrary(library, metrics);
                }
                if (record.isSecondaryOrSupplementary()) {
                    ++metrics.SECONDARY_OR_SUPPLEMENTARY_RDS;
                } else {
                    if (record.getReadUnmappedFlag()) {
                        ++metrics.UNMAPPED_READS;
                    } else if (!record.getReadPairedFlag() || record.getMateUnmappedFlag()) {
                        ++metrics.UNPAIRED_READS_EXAMINED;
                    } else {
                        ++metrics.READ_PAIRS_EXAMINED;
                    }
                    if (record.getDuplicateReadFlag()) {
                        if (!record.getReadPairedFlag() || record.getMateUnmappedFlag()) {
                            ++metrics.UNPAIRED_READ_DUPLICATES;
                        } else {
                            ++metrics.READ_PAIR_DUPLICATES;
                        }
                        ++numDuplicates;
                    }
                    if (doOpticalDuplicateTracking && SimpleMarkDuplicatesWithMateCigar.isPairedAndBothMapped(record) && !duplicateReadEndsSeen.contains(record.getReadName())) {
                        ReadEndsForSimpleMarkDuplicatesWithMateCigar readEnd = new ReadEndsForSimpleMarkDuplicatesWithMateCigar();
                        readEnd.orientationForOpticalDuplicates = record.getFirstOfPairFlag() ? ReadEnds.getOrientationByte(record.getReadNegativeStrandFlag(), record.getMateNegativeStrandFlag()) : ReadEnds.getOrientationByte(record.getMateNegativeStrandFlag(), record.getReadNegativeStrandFlag());
                        if (this.opticalDuplicateFinder.addLocationInformation(record.getReadName(), readEnd) && null != record.getReadGroup()) {
                            short index = this.libraryIdGenerator.getLibraryId(record);
                            readEnd.setLibraryId(index);
                        }
                        duplicateReadEnds.add(readEnd);
                        duplicateReadEndsSeen.add(record.getReadName());
                    }
                }
                if (this.REMOVE_DUPLICATES && record.getDuplicateReadFlag()) continue;
                if (this.PROGRAM_RECORD_ID != null) {
                    record.setAttribute(SAMTag.PG.name(), (Object)chainedPgIds.get(record.getStringAttribute(SAMTag.PG.name())));
                }
                out.addAlignment(record);
                progress.record(record);
            }
            if (this.READ_NAME_REGEX == null || 1 >= duplicateReadEnds.size()) continue;
            AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(duplicateReadEnds, (ReadEnds)duplicateReadEnds.get(0), this.opticalDuplicateFinder, this.libraryIdGenerator);
        }
        iterator.close();
        out.close();
        if (this.READ_NAME_REGEX == null) {
            this.log.warn("Skipped optical duplicate cluster discovery; library size estimation may be inaccurate!");
        } else {
            this.log.info("Found " + this.libraryIdGenerator.getNumberOfOpticalDuplicateClusters() + " optical duplicate clusters.");
        }
        this.log.info("Processed " + progress.getCount() + " records");
        this.log.info("Marking " + numDuplicates + " records as duplicates.");
        this.finalizeAndWriteMetrics(this.libraryIdGenerator);
        return 0;
    }

    protected CloseableIterator<DuplicateSet> getDuplicateSetIterator(AbstractMarkDuplicatesCommandLineProgram.SamHeaderAndIterator headerAndIterator, SAMRecordDuplicateComparator comparator) {
        return new DuplicateSetIterator(headerAndIterator.iterator, headerAndIterator.header, false, comparator);
    }

    private class ReadEndsForSimpleMarkDuplicatesWithMateCigar
    extends ReadEnds {
        private ReadEndsForSimpleMarkDuplicatesWithMateCigar() {
        }
    }
}

