/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.SamErrorMetric;

import htsjdk.samtools.reference.SamLocusAndReferenceIterator;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.SamLocusIterator;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Supplier;
import picard.sam.SamErrorMetric.BaseCalculator;
import picard.sam.SamErrorMetric.ErrorMetric;
import picard.sam.SamErrorMetric.ReadBaseStratification;

public class BaseErrorAggregation<CALCULATOR extends BaseCalculator> {
    private final Supplier<CALCULATOR> simpleAggregatorGenerator;
    private final ReadBaseStratification.RecordAndOffsetStratifier stratifier;
    private final Map<Object, CALCULATOR> strataAggregatorMap;

    public BaseErrorAggregation(Supplier<CALCULATOR> simpleAggregatorGenerator, ReadBaseStratification.RecordAndOffsetStratifier stratifier) {
        this.stratifier = stratifier;
        this.simpleAggregatorGenerator = simpleAggregatorGenerator;
        this.strataAggregatorMap = new CollectionUtil.DefaultingMap<Object, BaseCalculator>(ignored -> (BaseCalculator)simpleAggregatorGenerator.get(), true);
    }

    public void addBase(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo) {
        Object stratus = this.stratifier.stratify(recordAndOffset, locusInfo);
        if (stratus != null) {
            ((BaseCalculator)this.strataAggregatorMap.get(stratus)).addBase(recordAndOffset, locusInfo);
        }
    }

    public String getSuffix() {
        return ((BaseCalculator)this.simpleAggregatorGenerator.get()).getSuffix() + "_by_" + this.stratifier.getSuffix();
    }

    public ErrorMetric[] getMetrics() {
        ArrayList<ErrorMetric> metrics = new ArrayList<ErrorMetric>();
        TreeSet<Object> strata = new TreeSet<Object>(this.strataAggregatorMap.keySet());
        for (Object stratum : strata) {
            ErrorMetric metric = ((BaseCalculator)this.strataAggregatorMap.get(stratum)).getMetric();
            metric.COVARIATE = stratum.toString();
            metrics.add(metric);
        }
        return metrics.toArray(new ErrorMetric[0]);
    }
}

