/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Generates a BAM index \".bai\" file.  This tool creates an index file for the input BAM that allows fast look-up of data in a BAM file, lke an index on a database. Note that this tool cannot be run on SAM files, and that the input BAM file must be sorted in coordinate order.<h4>Usage example:</h4><pre>java -jar picard.jar BuildBamIndex \\<br />      I=input.bam</pre><hr />", oneLineSummary="Generates a BAM index \".bai\" file.  ", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class BuildBamIndex
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Generates a BAM index \".bai\" file.  ";
    static final String USAGE_DETAILS = "This tool creates an index file for the input BAM that allows fast look-up of data in a BAM file, lke an index on a database. Note that this tool cannot be run on SAM files, and that the input BAM file must be sorted in coordinate order.<h4>Usage example:</h4><pre>java -jar picard.jar BuildBamIndex \\<br />      I=input.bam</pre><hr />";
    private static final Log log = Log.getInstance(BuildBamIndex.class);
    @Argument(shortName="I", doc="A BAM file or GA4GH URL to process. Must be sorted in coordinate order.")
    public String INPUT;
    URL inputUrl = null;
    File inputFile = null;
    @Argument(shortName="O", doc="The BAM index file. Defaults to x.bai if INPUT is x.bam, otherwise INPUT.bai.\nIf INPUT is a URL and OUTPUT is unspecified, defaults to a file in the current directory.", optional=true)
    public File OUTPUT;

    @Override
    protected int doWork() {
        SamReader bam;
        try {
            this.inputUrl = new URL(this.INPUT);
        }
        catch (MalformedURLException e) {
            this.inputFile = new File(this.INPUT);
        }
        if (this.OUTPUT == null) {
            String baseFileName;
            if (this.inputUrl != null) {
                String path = this.inputUrl.getPath();
                int lastSlash = path.lastIndexOf(47);
                baseFileName = path.substring(lastSlash + 1, path.length());
            } else {
                baseFileName = this.inputFile.getAbsolutePath();
            }
            if (baseFileName.endsWith(".bam")) {
                int index = baseFileName.lastIndexOf(46);
                this.OUTPUT = new File(baseFileName.substring(0, index) + ".bai");
            } else {
                this.OUTPUT = new File(baseFileName + ".bai");
            }
        }
        IOUtil.assertFileIsWritable(this.OUTPUT);
        if (this.inputUrl != null) {
            bam = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).disable(SamReaderFactory.Option.EAGERLY_DECODE).enable(SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS).open(SamInputResource.of(this.inputUrl));
        } else {
            IOUtil.assertFileIsReadable(this.inputFile);
            bam = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).enable(SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS).open(this.inputFile);
        }
        if (bam.type() != SamReader.Type.BAM_TYPE) {
            throw new SAMException("Input file must be bam file, not sam file.");
        }
        if (!bam.getFileHeader().getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            throw new SAMException("Input bam file must be sorted by coordinate");
        }
        BAMIndexer.createIndex(bam, this.OUTPUT);
        log.info("Successfully wrote bam index file " + this.OUTPUT);
        CloserUtil.close(bam);
        return 0;
    }
}

