/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BamFileIoUtils;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Adds comments to the header of a BAM file.This tool makes a copy of the input bam file, with a modified header that includes the comments specified at the command line (prefixed by @CO). Use double quotes to wrap comments that include whitespace or special characters. <br /><br />Note that this tool cannot be run on SAM files.<br /><h4>Usage example:</h4><pre>java -jar picard.jar AddCommentsToBam \\<br />      I=input.bam \\<br />      O=modified_bam.bam \\<br />      C=comment_1 \\<br />      C=\"comment 2\"</pre><hr />", oneLineSummary="Adds comments to the header of a BAM file.", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class AddCommentsToBam
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Adds comments to the header of a BAM file.";
    static final String USAGE_DETAILS = "This tool makes a copy of the input bam file, with a modified header that includes the comments specified at the command line (prefixed by @CO). Use double quotes to wrap comments that include whitespace or special characters. <br /><br />Note that this tool cannot be run on SAM files.<br /><h4>Usage example:</h4><pre>java -jar picard.jar AddCommentsToBam \\<br />      I=input.bam \\<br />      O=modified_bam.bam \\<br />      C=comment_1 \\<br />      C=\"comment 2\"</pre><hr />";
    @Argument(shortName="I", doc="Input BAM file to add a comment to the header")
    public File INPUT;
    @Argument(shortName="O", doc="Output BAM file to write results")
    public File OUTPUT;
    @Argument(shortName="C", doc="Comments to add to the BAM file")
    public List<String> COMMENT;

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        if (this.INPUT.getAbsolutePath().endsWith(".sam")) {
            throw new PicardException("SAM files are not supported");
        }
        SAMFileHeader samFileHeader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).getFileHeader(this.INPUT);
        for (String comment : this.COMMENT) {
            if (comment.contains("\n")) {
                throw new PicardException("Comments can not contain a new line");
            }
            samFileHeader.addComment(comment);
        }
        BamFileIoUtils.reheaderBamFile(samFileHeader, this.INPUT, this.OUTPUT, this.CREATE_MD5_FILE, this.CREATE_INDEX);
        return 0;
    }
}

