/*
 * Decompiled with CFR 0.152.
 */
package picard.reference;

import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.SequenceUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReferenceProgramGroup;

@CommandLineProgramProperties(summary="Subsets intervals from a reference sequence to a new FASTA file.This tool takes a list of intervals, reads the corresponding subsquences from a reference FASTA file and writes them to a new FASTA file as separate records. Note that the reference FASTA file must be accompanied by an index file and the interval list must be provided in Picard list format. The names provided for the intervals will be used to name the corresponding records in the output file.<br /><h4>Usage example:</h4><pre>java -jar picard.jar ExtractSequences \\<br />      INTERVAL_LIST=regions_of_interest.interval_list \\<br />      R=reference.fasta \\<br />      O=extracted_IL_sequences.fasta</pre><hr />", oneLineSummary="Subsets intervals from a reference sequence to a new FASTA file.", programGroup=ReferenceProgramGroup.class)
@DocumentedFeature
public class ExtractSequences
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Subsets intervals from a reference sequence to a new FASTA file.";
    static final String USAGE_DETAILS = "This tool takes a list of intervals, reads the corresponding subsquences from a reference FASTA file and writes them to a new FASTA file as separate records. Note that the reference FASTA file must be accompanied by an index file and the interval list must be provided in Picard list format. The names provided for the intervals will be used to name the corresponding records in the output file.<br /><h4>Usage example:</h4><pre>java -jar picard.jar ExtractSequences \\<br />      INTERVAL_LIST=regions_of_interest.interval_list \\<br />      R=reference.fasta \\<br />      O=extracted_IL_sequences.fasta</pre><hr />";
    @Argument(doc="Interval list describing intervals to be extracted from the reference sequence.")
    public File INTERVAL_LIST;
    @Argument(shortName="O", doc="Output FASTA file.")
    public File OUTPUT;
    @Argument(doc="Maximum line length for sequence data.")
    public int LINE_LENGTH = 80;

    @Override
    protected boolean requiresReference() {
        return true;
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INTERVAL_LIST);
        IOUtil.assertFileIsReadable(this.REFERENCE_SEQUENCE);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        IntervalList intervals = IntervalList.fromFile(this.INTERVAL_LIST);
        ReferenceSequenceFile ref = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE_SEQUENCE);
        SequenceUtil.assertSequenceDictionariesEqual(intervals.getHeader().getSequenceDictionary(), ref.getSequenceDictionary());
        BufferedWriter out = IOUtil.openFileForBufferedWriting(this.OUTPUT);
        for (Interval interval : intervals) {
            ReferenceSequence seq = ref.getSubsequenceAt(interval.getContig(), interval.getStart(), interval.getEnd());
            byte[] bases = seq.getBases();
            if (interval.isNegativeStrand()) {
                SequenceUtil.reverseComplement(bases);
            }
            try {
                out.write(">");
                out.write(interval.getName());
                out.write("\n");
                for (int i = 0; i < bases.length; ++i) {
                    if (i > 0 && i % this.LINE_LENGTH == 0) {
                        out.write("\n");
                    }
                    out.write(bases[i]);
                }
                out.write("\n");
            }
            catch (IOException ioe) {
                throw new PicardException("Error writing to file " + this.OUTPUT.getAbsolutePath(), ioe);
            }
        }
        CloserUtil.close(out);
        return 0;
    }
}

