/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import picard.illumina.parser.readers.BinaryFileIterator;
import picard.illumina.parser.readers.MMapBackedIteratorFactory;
import picard.illumina.parser.readers.TileMetricsOutReader;
import picard.util.UnsignedTypeUtil;

public class EmpiricalPhasingMetricsOutReader
implements Iterator<IlluminaPhasingMetrics> {
    private static final int HEADER_SIZE = 2;
    private static final int RECORD_SIZE = 16;
    private final BinaryFileIterator<ByteBuffer> bbIterator;

    public EmpiricalPhasingMetricsOutReader(File phasingMetricsOutFile) {
        this.bbIterator = MMapBackedIteratorFactory.getByteBufferIterator(2, 16, phasingMetricsOutFile);
        this.bbIterator.getHeaderBytes();
    }

    @Override
    public boolean hasNext() {
        return this.bbIterator.hasNext();
    }

    @Override
    public IlluminaPhasingMetrics next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return new IlluminaPhasingMetrics(this.bbIterator.next());
    }

    public static class IlluminaPhasingMetrics {
        public final TileMetricsOutReader.IlluminaLaneTileCode laneTileCode;
        public final int cycle;
        public final float phasingWeight;
        public final float prephasingWeight;

        IlluminaPhasingMetrics(ByteBuffer bb) {
            this.laneTileCode = new TileMetricsOutReader.IlluminaLaneTileCode(UnsignedTypeUtil.uShortToInt(bb.getShort()), bb.getInt(), 0);
            this.cycle = UnsignedTypeUtil.uShortToInt(bb.getShort());
            this.phasingWeight = bb.getFloat();
            this.prephasingWeight = bb.getFloat();
        }
    }
}

