/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.Snp;
import picard.util.MathUtil;

abstract class HaplotypeProbabilitiesUsingLogLikelihoods
extends HaplotypeProbabilities {
    private final double[] loglikelihoods = new double[HaplotypeProbabilities.Genotype.values().length];
    private boolean likelihoodsNeedUpdating = true;
    private double[] likelihoods = new double[HaplotypeProbabilities.Genotype.values().length];
    private double[] posteriorProbabilities = new double[HaplotypeProbabilities.Genotype.values().length];
    private double[] shiftedLogPosteriors = new double[HaplotypeProbabilities.Genotype.values().length];

    public HaplotypeProbabilitiesUsingLogLikelihoods(HaplotypeBlock haplotypeBlock) {
        super(haplotypeBlock);
    }

    @Override
    public Snp getRepresentativeSnp() {
        return this.getHaplotype().getFirstSnp();
    }

    @Override
    public boolean hasEvidence() {
        double[] ll = this.getLogLikelihoods();
        return ll[HaplotypeProbabilities.Genotype.HOM_ALLELE1.v] != 0.0 || ll[HaplotypeProbabilities.Genotype.HET_ALLELE12.v] != 0.0 || ll[HaplotypeProbabilities.Genotype.HOM_ALLELE2.v] != 0.0;
    }

    @Override
    public void merge(HaplotypeProbabilities other) {
        if (!this.getHaplotype().equals(other.getHaplotype())) {
            throw new IllegalArgumentException("Mismatched haplotypes in call to HaplotypeProbabilities.merge(): " + this.getHaplotype() + ", " + other.getHaplotype());
        }
        if (!(other instanceof HaplotypeProbabilitiesUsingLogLikelihoods)) {
            throw new IllegalArgumentException("Can only merge HaplotypeProbabilities of same class.");
        }
        HaplotypeProbabilitiesUsingLogLikelihoods o = (HaplotypeProbabilitiesUsingLogLikelihoods)other;
        this.setLogLikelihoods(MathUtil.sum(this.getLogLikelihoods(), o.getLogLikelihoods()));
    }

    private double[] getPosteriorProbabilities0() {
        return MathUtil.pNormalizeLogProbability(this.getShiftedLogPosterior0());
    }

    @Override
    public double[] getPosteriorProbabilities() {
        this.updateDependentValues();
        return this.posteriorProbabilities;
    }

    private double[] getShiftedLogPosterior0() {
        double[] ll = this.getLogLikelihoods();
        double[] shiftedLogPosterior = new double[HaplotypeProbabilities.Genotype.values().length];
        double[] haplotypeFrequencies = this.getPriorProbablities();
        for (HaplotypeProbabilities.Genotype g : HaplotypeProbabilities.Genotype.values()) {
            shiftedLogPosterior[g.v] = ll[g.v] + Math.log10(haplotypeFrequencies[g.v]);
        }
        return shiftedLogPosterior;
    }

    private double[] getShiftedLogPosterior() {
        this.updateDependentValues();
        return this.shiftedLogPosteriors;
    }

    private double[] getLikelihoods0() {
        return MathUtil.pNormalizeLogProbability(this.getLogLikelihoods());
    }

    @Override
    public double[] getLikelihoods() {
        this.updateDependentValues();
        return this.likelihoods;
    }

    @Override
    public double[] getLogLikelihoods() {
        return this.loglikelihoods;
    }

    public void setLogLikelihoods(double[] ll) {
        assert (ll.length == HaplotypeProbabilities.Genotype.values().length);
        System.arraycopy(ll, 0, this.loglikelihoods, 0, ll.length);
        this.likelihoodsNeedUpdating = true;
    }

    @Override
    public double getLodMostProbableGenotype() {
        double biggest;
        double[] logs = this.getShiftedLogPosterior();
        double secondBiggest = biggest = -1.7976931348623157E308;
        for (double prob : logs) {
            if (prob > biggest) {
                secondBiggest = biggest;
                biggest = prob;
                continue;
            }
            if (!(prob > secondBiggest)) continue;
            secondBiggest = prob;
        }
        return biggest - secondBiggest;
    }

    private void updateDependentValues() {
        if (this.likelihoodsNeedUpdating) {
            this.likelihoods = this.getLikelihoods0();
            this.posteriorProbabilities = this.getPosteriorProbabilities0();
            this.shiftedLogPosteriors = this.getShiftedLogPosterior0();
            this.likelihoodsNeedUpdating = false;
        }
    }
}

