/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import picard.fingerprint.DiploidGenotype;
import picard.fingerprint.DiploidHaplotype;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.Snp;
import picard.util.MathUtil;

public abstract class HaplotypeProbabilities {
    private final HaplotypeBlock haplotypeBlock;

    protected HaplotypeProbabilities(HaplotypeBlock haplotypeBlock) {
        this.haplotypeBlock = haplotypeBlock;
    }

    public HaplotypeBlock getHaplotype() {
        return this.haplotypeBlock;
    }

    public double[] getPriorProbablities() {
        return this.getHaplotype().getHaplotypeFrequencies();
    }

    public double[] getPosteriorProbabilities() {
        return MathUtil.pNormalizeVector(MathUtil.multiply(this.getLikelihoods(), this.getPriorProbablities()));
    }

    public abstract double[] getLikelihoods();

    public double[] getLogLikelihoods() {
        double[] likelihoods = this.getLikelihoods();
        double[] lLikelihoods = new double[likelihoods.length];
        for (int i = 0; i < likelihoods.length; ++i) {
            lLikelihoods[i] = Math.log10(likelihoods[i]);
        }
        return lLikelihoods;
    }

    public abstract Snp getRepresentativeSnp();

    public int getObsAllele1() {
        return 0;
    }

    public int getObsAllele2() {
        return 0;
    }

    public int getTotalObs() {
        return 0;
    }

    public boolean hasEvidence() {
        return true;
    }

    public abstract void merge(HaplotypeProbabilities var1);

    int getMostLikelyIndex() {
        double[] probs = this.getPosteriorProbabilities();
        if (probs[0] > probs[1] && probs[0] > probs[2]) {
            return 0;
        }
        if (probs[1] > probs[2]) {
            return 1;
        }
        return 2;
    }

    public DiploidHaplotype getMostLikelyHaplotype() {
        return DiploidHaplotype.values()[this.getMostLikelyIndex()];
    }

    public DiploidGenotype getMostLikelyGenotype(Snp snp) {
        this.assertSnpPartOfHaplotype(snp);
        return snp.getGenotype(this.getMostLikelyHaplotype());
    }

    void assertSnpPartOfHaplotype(Snp snp) {
        if (!this.haplotypeBlock.contains(snp)) {
            throw new IllegalArgumentException("Snp " + snp + " does not belong to haplotype " + this.haplotypeBlock);
        }
    }

    public double scaledEvidenceProbabilityUsingGenotypeFrequencies(double[] genotypeFrequencies) {
        double[] likelihoods = this.getLikelihoods();
        assert (genotypeFrequencies.length == likelihoods.length);
        double result = 0.0;
        for (int i = 0; i < likelihoods.length; ++i) {
            result += likelihoods[i] * genotypeFrequencies[i];
        }
        return result;
    }

    public double shiftedLogEvidenceProbabilityUsingGenotypeFrequencies(double[] genotypeFrequencies) {
        return Math.log10(this.scaledEvidenceProbabilityUsingGenotypeFrequencies(genotypeFrequencies));
    }

    public double shiftedLogEvidenceProbabilityGivenOtherEvidence(HaplotypeProbabilities otherHp) {
        if (!this.haplotypeBlock.equals(otherHp.getHaplotype())) {
            throw new IllegalArgumentException("Haplotypes are from different HaplotypeBlocks!");
        }
        return this.shiftedLogEvidenceProbabilityUsingGenotypeFrequencies(otherHp.getPosteriorProbabilities());
    }

    public double shiftedLogEvidenceProbability() {
        return this.shiftedLogEvidenceProbabilityUsingGenotypeFrequencies(this.getPriorProbablities());
    }

    public double getLodMostProbableGenotype() {
        double[] probs = this.getPosteriorProbabilities();
        double biggest = 0.0;
        double secondBiggest = 0.0;
        for (double prob : probs) {
            if (prob > biggest) {
                secondBiggest = biggest;
                biggest = prob;
                continue;
            }
            if (!(prob > secondBiggest)) continue;
            secondBiggest = prob;
        }
        return Math.log10(biggest) - Math.log10(secondBiggest);
    }

    protected static enum Genotype {
        HOM_ALLELE1(0),
        HET_ALLELE12(1),
        HOM_ALLELE2(2);

        int v;

        private Genotype(int v) {
            this.v = v;
        }
    }
}

