/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import picard.PicardException;
import picard.fingerprint.CrosscheckMetric;
import picard.fingerprint.FingerprintIdDetails;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesFromSequence;

public class Fingerprint
extends TreeMap<HaplotypeBlock, HaplotypeProbabilities> {
    private final String sample;
    private final Path source;
    private final String info;

    public Fingerprint(String sample, Path source, String info) {
        this.sample = sample;
        this.source = source;
        this.info = info;
    }

    public String getSample() {
        return this.sample;
    }

    public Path getSource() {
        return this.source;
    }

    public String getInfo() {
        return this.info;
    }

    public String getPrintableId() {
        return this.getSample() + "@" + (this.source == null ? "" : this.source.toUri().toString()) + (this.info == null ? "" : ":" + this.info);
    }

    public void add(HaplotypeProbabilities h) {
        this.put(h.getHaplotype(), h);
    }

    public void merge(Fingerprint other) {
        HashSet haps = new HashSet();
        haps.addAll(this.keySet());
        haps.addAll(other.keySet());
        for (HaplotypeBlock haplotype : haps) {
            HaplotypeProbabilities probabilities = (HaplotypeProbabilities)this.get(haplotype);
            HaplotypeProbabilities otherProbabilities = (HaplotypeProbabilities)other.get(haplotype);
            if (probabilities == null) {
                probabilities = otherProbabilities;
                this.put(haplotype, probabilities);
                continue;
            }
            if (otherProbabilities == null) continue;
            probabilities.merge(otherProbabilities);
        }
    }

    public void filterSuspectSites() {
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            HaplotypeProbabilitiesFromSequence probs;
            Map.Entry entry = iterator.next();
            HaplotypeProbabilities p = (HaplotypeProbabilities)entry.getValue();
            if (!(p instanceof HaplotypeProbabilitiesFromSequence) || !((probs = (HaplotypeProbabilitiesFromSequence)p).getLodMostProbableGenotype() >= 3.0) || !(probs.getFractionUnexpectedAlleleObs() > 0.1)) continue;
            iterator.remove();
        }
    }

    public static Function<FingerprintIdDetails, String> getFingerprintIdDetailsStringFunction(CrosscheckMetric.DataType CROSSCHECK_BY) {
        Function<FingerprintIdDetails, String> groupByTemp;
        switch (CROSSCHECK_BY) {
            case READGROUP: {
                groupByTemp = details -> details.platformUnit;
                break;
            }
            case LIBRARY: {
                groupByTemp = details -> details.sample + "::" + details.library;
                break;
            }
            case FILE: {
                groupByTemp = details -> details.file + "::" + details.sample;
                break;
            }
            case SAMPLE: {
                groupByTemp = details -> details.sample;
                break;
            }
            default: {
                throw new PicardException("unpossible");
            }
        }
        return key -> {
            String temp = (String)groupByTemp.apply((FingerprintIdDetails)key);
            return temp == null ? Integer.toString(key.hashCode()) : temp;
        };
    }

    public static Map<FingerprintIdDetails, Fingerprint> mergeFingerprintsBy(Map<FingerprintIdDetails, Fingerprint> fingerprints, Function<FingerprintIdDetails, String> by) {
        Map<String, List<Map.Entry>> collection = fingerprints.entrySet().stream().collect(Collectors.groupingBy(entry -> (String)by.apply((FingerprintIdDetails)entry.getKey())));
        return collection.entrySet().stream().collect(Collectors.toMap(entry -> {
            FingerprintIdDetails finalId = new FingerprintIdDetails();
            ((List)entry.getValue()).forEach((? super T id) -> finalId.merge((FingerprintIdDetails)id.getKey()));
            finalId.group = (String)entry.getKey();
            return finalId;
        }, entry -> {
            FingerprintIdDetails firstDetail = (FingerprintIdDetails)((Map.Entry)((List)entry.getValue()).get(0)).getKey();
            Fingerprint sampleFp = new Fingerprint(firstDetail.sample, null, (String)by.apply(firstDetail));
            ((List)entry.getValue()).stream().map(Map.Entry::getValue).collect(Collectors.toSet()).forEach(sampleFp::merge);
            return sampleFp;
        }));
    }

    static enum CrosscheckMode implements CommandLineParser.ClpEnum
    {
        CHECK_SAME_SAMPLE{

            @Override
            public String getHelpDoc() {
                return "In this mode, each sample in INPUT will only be checked against a single corresponding sample in SECOND_INPUT. If a corresponding sample cannot be found, the program will proceed, but report the missing samples and return the value specified in EXIT_CODE_WHEN_MISMATCH. The corresponding samples are those that equal each other, after possible renaming via INPUT_SAMPLE_MAP and SECOND_INPUT_SAMPLE_MAP. In this mode CROSSCHECK_BY must be SAMPLE.";
            }
        }
        ,
        CHECK_ALL_OTHERS{

            @Override
            public String getHelpDoc() {
                return "In this mode, each sample in INPUT will be checked against all the samples in SECOND_INPUT.";
            }
        };

    }
}

