/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import picard.arrays.illumina.InfiniumFileTOC;

public abstract class InfiniumDataFile {
    private String identifier;
    private int numberOfEntries;
    private int fileVersion;
    final DataInputStream stream;
    private static final int SHORT_BYTES_LENGTH = 2;
    private static final int FLOAT_BYTES_LENGTH = 4;

    InfiniumDataFile(DataInputStream stream, boolean cacheStream) throws IOException {
        if (cacheStream) {
            byte[] data = this.readStreamIntoByteArray(stream);
            this.stream = new DataInputStream(new ByteArrayInputStream(data));
        } else {
            this.stream = stream;
        }
    }

    String parseString() throws IOException {
        String dataString;
        byte strLen = this.stream.readByte();
        if (strLen != 0) {
            byte[] stringBytes = new byte[strLen];
            int bytesRead = this.stream.read(stringBytes);
            if (bytesRead != stringBytes.length) {
                throw new IOException("Did not fully read string. Read " + bytesRead + " out of " + stringBytes.length + ".");
            }
            dataString = new String(InfiniumDataFile.byteArrayToCharArray(stringBytes));
        } else {
            dataString = "";
        }
        return dataString;
    }

    public static char[] byteArrayToCharArray(byte[] stringBytes) {
        char[] chars = new char[stringBytes.length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)stringBytes[i];
        }
        return chars;
    }

    byte[] parseByteArray(InfiniumFileTOC toc) throws IOException {
        this.stream.skipBytes(toc.getOffset());
        int arrayLen = Integer.reverseBytes(this.stream.readInt());
        byte[] byteArray = new byte[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            byteArray[i] = this.stream.readByte();
        }
        return byteArray;
    }

    public static int byteArrayToInt(byte[] bytes) {
        int integer = 0;
        integer |= bytes[1] & 0xFF;
        integer <<= 8;
        return integer |= bytes[0] & 0xFF;
    }

    public static byte[] shortToByteArray(short value) {
        byte[] bytes = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
        return bytes;
    }

    public static float byteArrayToFloat(byte[] bytes) {
        int tempInt = 0xFF & bytes[0] | (0xFF & bytes[1]) << 8 | (0xFF & bytes[2]) << 16 | (0xFF & bytes[3]) << 24;
        return Float.intBitsToFloat(tempInt);
    }

    public static byte[] floatToByteArray(float floatValue) {
        byte[] bytes = new byte[4];
        int floatBits = Float.floatToIntBits(floatValue);
        bytes[0] = (byte)(floatBits & 0xFF);
        bytes[1] = (byte)(floatBits >> 8 & 0xFF);
        bytes[2] = (byte)(floatBits >> 16 & 0xFF);
        bytes[3] = (byte)(floatBits >> 24 & 0xFF);
        return bytes;
    }

    float parseFloat() throws IOException {
        byte[] floatBytes = new byte[4];
        this.stream.readFully(floatBytes);
        return InfiniumDataFile.byteArrayToFloat(floatBytes);
    }

    static void writeShort(DataOutputStream outputStream, short value) throws IOException {
        byte[] byteArray = InfiniumDataFile.shortToByteArray(value);
        outputStream.write(byteArray);
    }

    static void writeFloat(DataOutputStream outputStream, float value) throws IOException {
        byte[] byteArray = InfiniumDataFile.floatToByteArray(value);
        outputStream.write(byteArray);
    }

    float parseFloat(InfiniumFileTOC toc) throws IOException {
        byte[] floatBytes = new byte[4];
        this.stream.skipBytes(toc.getOffset());
        this.stream.readFully(floatBytes);
        return InfiniumDataFile.byteArrayToFloat(floatBytes);
    }

    int[] parseUnsignedShortArray(InfiniumFileTOC toc) throws IOException {
        byte[] shortBytes = new byte[2];
        this.stream.skipBytes(toc.getOffset());
        int arrayLen = Integer.reverseBytes(this.stream.readInt());
        int[] unsignedShortArray = new int[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            this.stream.readFully(shortBytes);
            unsignedShortArray[i] = InfiniumDataFile.byteArrayToInt(shortBytes);
        }
        return unsignedShortArray;
    }

    int parseShort(InfiniumFileTOC toc) throws IOException {
        this.stream.skipBytes(toc.getOffset());
        return this.readShort();
    }

    int readShort() throws IOException {
        byte[] shortBytes = new byte[2];
        this.stream.readFully(shortBytes);
        return InfiniumDataFile.byteArrayToInt(shortBytes);
    }

    int parseInt(InfiniumFileTOC toc) throws IOException {
        this.stream.skipBytes(toc.getOffset());
        return Integer.reverseBytes(this.stream.readInt());
    }

    String parseString(InfiniumFileTOC toc) throws IOException {
        this.stream.skipBytes(toc.getOffset());
        return this.parseString();
    }

    float[] parseFloatArray(InfiniumFileTOC toc) throws IOException {
        this.stream.skipBytes(toc.getOffset());
        int arrayLen = Integer.reverseBytes(this.stream.readInt());
        float[] floatArray = new float[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            floatArray[i] = this.parseFloat();
        }
        return floatArray;
    }

    private byte[] readStreamIntoByteArray(InputStream streamToCache) throws IOException {
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            IOUtils.copy(streamToCache, (OutputStream)outStream);
            byte[] byArray = outStream.toByteArray();
            return byArray;
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    private int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    void setNumberOfEntries(int numberOfEntries) {
        this.numberOfEntries = numberOfEntries;
    }

    int getFileVersion() {
        return this.fileVersion;
    }

    void setFileVersion(int fileVersion) {
        this.fileVersion = fileVersion;
    }

    InfiniumFileTOC[] getTableOfContents() throws IOException {
        InfiniumFileTOC[] tableOfContents = new InfiniumFileTOC[this.getNumberOfEntries()];
        for (int i = 0; i < this.getNumberOfEntries(); ++i) {
            InfiniumFileTOC toc = new InfiniumFileTOC();
            toc.setTableOfContentsId(Short.reverseBytes(this.stream.readShort()));
            toc.setOffset(Integer.reverseBytes(this.stream.readInt()));
            tableOfContents[i] = toc;
        }
        return tableOfContents;
    }

    int parseInt() throws IOException {
        return Integer.reverseBytes(this.stream.readInt());
    }

    void skipFloats(int numFloats) throws IOException {
        this.stream.skipBytes(numFloats * 4);
    }

    void skipFloat() throws IOException {
        this.skipFloats(1);
    }

    void skipBoolean() throws IOException {
        this.stream.skipBytes(1);
    }

    void skipString() throws IOException {
        byte strLen = this.stream.readByte();
        this.stream.skipBytes(strLen);
    }
}

